/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DataSourceInfoTool;
import com.intellij.database.console.DatabaseServiceViewDeleteElementProvider;
import com.intellij.database.console.SessionProgressListener;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManagerListener;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.SessionsUiUtil;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewComponentWrapper;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewItemState;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewNonActivatingDescriptor;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.Gray;
import com.intellij.ui.TextIcon;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DatabaseServiceViewContributor
implements ServiceViewGroupingContributor<SessionContributor, PsiElement>,
Comparator<SessionContributor> {
    private final ServiceViewDescriptor myContributorDescriptor = new DatabaseContributorDescriptor();

    public static void listenSessions() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(DatabaseSessionManager.getTopic(), (Object)new SessionsListener());
        connection.subscribe(DatabaseSession.getTopic(), (Object)new SessionStateListener());
        connection.subscribe(DatabaseSession.getTopic(), (Object)new SessionProgressListener(){

            public void updateProgress(@NotNull DatabaseSessionStateListener.ChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SessionStateListener.changed(event.getSession());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/DatabaseServiceViewContributor$1", "updateProgress"));
            }
        });
    }

    public static void refreshView(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(0);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            ServiceEventListener listener2 = DatabaseServiceViewContributor.listener(project);
            listener2.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.RESET, (Object)ObjectUtils.NULL, DatabaseServiceViewContributor.class));
        });
    }

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(1);
        }
        ServiceViewDescriptor serviceViewDescriptor = this.myContributorDescriptor;
        if (serviceViewDescriptor == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(2);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<SessionContributor> getServices(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.map((Collection)DatabaseSessionManager.getSessions((Project)project), SessionContributor::new);
        if (list == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull SessionContributor service) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(5);
        }
        if (service == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(6);
        }
        return DatabaseServiceViewContributor.resolveDescriptorForNode(service.asService());
    }

    @Override
    public int compare(SessionContributor o1, SessionContributor o2) {
        DatabaseSession session1 = o1.asService();
        DatabaseSession session2 = o2.asService();
        List sessions = DatabaseSessionManager.getSessions((Project)session1.getProject());
        return sessions.indexOf(session1) - sessions.indexOf(session2);
    }

    @NotNull
    public List<PsiElement> getGroups(@NotNull SessionContributor service) {
        if (service == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(7);
        }
        DatabaseSession session = service.asService();
        Project project = session.getProject();
        ArrayList<DbDataSource> result2 = new ArrayList<DbDataSource>();
        DbDataSource group = DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)((DatabaseConnectionPoint)session.getTarget()).getDataSource());
        while (group != null) {
            result2.add(group);
            group = DatabaseServiceViewContributor.getParentImpl((PsiElement)group);
        }
        List list = ContainerUtil.reverse(result2);
        if (list == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o) {
        if (o == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(9);
        }
        if (!o.isValid()) {
            return null;
        }
        Project project = o.getProject();
        DatabaseNodeWrappingService ws = (DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class);
        DvTreeStructureService structure = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
        BasicNode delegate = ws.unwrap(o);
        BasicNode parent = delegate == null ? null : structure.parentOf(delegate);
        return parent == null ? null : ws.wrap(parent);
    }

    @NotNull
    public synchronized ServiceViewDescriptor getGroupDescriptor(@NotNull PsiElement group) {
        if (group == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(10);
        }
        return group instanceof DbDataSource ? new DbDataSourceViewDescriptor((DbDataSource)group) : new GroupViewDescriptor(group);
    }

    @NotNull
    private static String getServicesToolWindowId(@NotNull Project project) {
        String toolWindowId;
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(11);
        }
        String string = (toolWindowId = ServiceViewManager.getInstance((Project)project).getToolWindowId(DatabaseServiceViewContributor.class)) == null ? "Services" : toolWindowId;
        if (string == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static ToolWindow getServicesToolWindow(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(13);
        }
        return ToolWindowManagerEx.getInstanceEx((Project)project).getToolWindow(DatabaseServiceViewContributor.getServicesToolWindowId(project));
    }

    private static void showServicesStripeButton(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow servicesToolWindow = DatabaseServiceViewContributor.getServicesToolWindow(project);
            if (servicesToolWindow != null) {
                servicesToolWindow.setShowStripeButton(true);
            }
        });
    }

    private static boolean allowActivation(@Nullable LogView.OutputType outputType) {
        if (outputType == null) {
            return true;
        }
        DatabaseSettings.ShowServicesMode showServicesMode = DatabaseSettings.getSettings().showServicesMode;
        switch (showServicesMode) {
            case ALL: {
                if (outputType == LogView.OutputType.LOG || outputType == LogView.OutputType.INFO) {
                    return true;
                }
            }
            case QUERYOUTPUT_ERRORS_RESULTSETS: {
                if (outputType == LogView.OutputType.QUERY_OUTPUT) {
                    return true;
                }
            }
            case ERRORS_RESULTSETS: {
                if (outputType == LogView.OutputType.ERROR) {
                    return true;
                }
            }
            case RESULTSETS: {
                if (outputType != LogView.OutputType.RESULT_SET) break;
                return true;
            }
        }
        return false;
    }

    private static boolean updateActivateAccordingToSettings(boolean activate, @NotNull Project project, @Nullable LogView.OutputType outputType) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(15);
        }
        boolean allowActivation = DatabaseServiceViewContributor.allowActivation(outputType);
        if (activate && !allowActivation) {
            DatabaseServiceViewContributor.showServicesStripeButton(project);
        }
        return activate && allowActivation;
    }

    private static boolean requireRequestFocusing(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(16);
        }
        if (!DatabaseSettings.getSettings().focusOnServicesInWindowMode) {
            return false;
        }
        ToolWindow servicesToolWindow = DatabaseServiceViewContributor.getServicesToolWindow(project);
        return servicesToolWindow != null && servicesToolWindow.getType() == ToolWindowType.WINDOWED && !servicesToolWindow.getComponent().hasFocus();
    }

    private static boolean updateRequestFocusAccordingToSettings(boolean requestFocus, @NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(17);
        }
        return requestFocus || DatabaseServiceViewContributor.requireRequestFocusing(project);
    }

    @NotNull
    public static Promise<Void> selectNode(@NotNull Project project, @NotNull VisibleDatabaseSessionClient client, boolean activate, boolean requestFocus, @Nullable LogView.OutputType outputType) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(18);
        }
        if (client == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(19);
        }
        if (project.getServiceIfCreated(ServiceViewManager.class) == null) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                DatabaseServiceViewContributor.$$$reportNull$$$0(20);
            }
            return promise;
        }
        activate = DatabaseServiceViewContributor.updateActivateAccordingToSettings(activate, project, outputType);
        requestFocus = DatabaseServiceViewContributor.updateRequestFocusAccordingToSettings(requestFocus, project);
        DatabaseSession session = (DatabaseSession)client.getSession();
        VisibleDatabaseSessionClient service = session.getClientsWithFile().length == 1 && Registry.is((String)"database.services.hide.session.node") ? session : client;
        Promise promise = ServiceViewManager.getInstance((Project)project).select((Object)service, DatabaseServiceViewContributor.class, activate, requestFocus);
        if (promise == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(21);
        }
        return promise;
    }

    @NotNull
    public static Promise<Void> selectNode(@NotNull Project project, @NotNull VisibleSession<?> session, boolean activate, boolean requestFocus, @Nullable LogView.OutputType outputType) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(22);
        }
        if (session == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(23);
        }
        if (project.getServiceIfCreated(ServiceViewManager.class) == null) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                DatabaseServiceViewContributor.$$$reportNull$$$0(24);
            }
            return promise;
        }
        activate = DatabaseServiceViewContributor.updateActivateAccordingToSettings(activate, project, outputType);
        requestFocus = DatabaseServiceViewContributor.updateRequestFocusAccordingToSettings(requestFocus, project);
        Promise promise = ServiceViewManager.getInstance((Project)project).select(session, DatabaseServiceViewContributor.class, activate, requestFocus);
        if (promise == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(25);
        }
        return promise;
    }

    public static void extractNode(@NotNull Project project, @NotNull VisibleDatabaseSessionClient client) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(26);
        }
        if (client == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(27);
        }
        if (project.getServiceIfCreated(ServiceViewManager.class) == null) {
            Promises.rejectedPromise();
            return;
        }
        ServiceViewManager.getInstance((Project)project).extract((Object)client, DatabaseServiceViewContributor.class);
    }

    @NotNull
    private static ServiceEventListener listener(@NotNull DatabaseSession session) {
        if (session == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(28);
        }
        return DatabaseServiceViewContributor.listener(session.getProject());
    }

    @NotNull
    private static ServiceEventListener listener(@NotNull Project project) {
        if (project == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(29);
        }
        ServiceEventListener serviceEventListener = project.isDisposed() ? InactiveListener.INSTANCE : (ServiceEventListener)project.getMessageBus().syncPublisher(ServiceEventListener.TOPIC);
        if (serviceEventListener == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(30);
        }
        return serviceEventListener;
    }

    @NotNull
    private static ServiceViewDescriptor resolveDescriptorForNode(DatabaseSession session) {
        DatabaseSessionClientWithFile[] clients = session.getClientsWithFile();
        return clients.length == 1 && Registry.is((String)"database.services.hide.session.node") ? new ClientViewDescriptor(clients[0], session, false) : new SessionViewDescriptor(session);
    }

    private static void sessionOpened(@NotNull DatabaseSession session) {
        if (session == null) {
            DatabaseServiceViewContributor.$$$reportNull$$$0(31);
        }
        if (session.isInternal()) {
            return;
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            SessionContributor target = new SessionContributor(session);
            ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createServiceAddedEvent((Object)target, DatabaseServiceViewContributor.class, null);
            DatabaseServiceViewContributor.listener(session).handle(event);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 12, 20, 21, 24, 25, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 23: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getServicesToolWindowId";
                break;
            }
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "selectNode";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshView";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getServicesToolWindowId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getServicesToolWindow";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showServicesStripeButton";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateActivateAccordingToSettings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requireRequestFocusing";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateRequestFocusAccordingToSettings";
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "extractNode";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "listener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sessionOpened";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 12, 20, 21, 24, 25, 30 -> new IllegalStateException(string);
        };
    }

    private static class DatabaseContributorDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewNonActivatingDescriptor,
    ServiceViewToolWindowDescriptor,
    UiDataProvider {
        DatabaseContributorDescriptor() {
            super(DatabaseBundle.message((String)"sessions.services.tool.window.title", (Object[])new Object[0]), DatabaseIcons.Dbms, "Database Sessions");
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                DatabaseContributorDescriptor.$$$reportNull$$$0(0);
            }
            sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)DatabaseServiceViewDeleteElementProvider.INSTANCE);
        }

        @NotNull
        public String getToolWindowId() {
            String string = this.getId();
            if (string == null) {
                DatabaseContributorDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = DatabaseIcons.ToolWindowConsole;
            if (icon == null) {
                DatabaseContributorDescriptor.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @NotNull
        public String getStripeTitle() {
            String string = Objects.requireNonNull(this.getPresentation().getPresentableText());
            if (string == null) {
                DatabaseContributorDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$DatabaseContributorDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$DatabaseContributorDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStripeTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class SessionsListener
    implements DatabaseSessionManagerListener {
        private SessionsListener() {
        }

        public void sessionOpened(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionsListener.$$$reportNull$$$0(0);
            }
            DatabaseServiceViewContributor.sessionOpened(session);
        }

        public void sessionClosed(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionsListener.$$$reportNull$$$0(1);
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, (Object)session, DatabaseServiceViewContributor.class);
                DatabaseServiceViewContributor.listener(session).handle(event);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "session";
            objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sessionOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sessionClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SessionStateListener
    implements DatabaseSessionStateListener {
        private SessionStateListener() {
        }

        public void renamed(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionStateListener.$$$reportNull$$$0(0);
            }
            SessionStateListener.changed(session);
        }

        public void connected(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionStateListener.$$$reportNull$$$0(1);
            }
            SessionStateListener.changed(session);
        }

        public void disconnected(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionStateListener.$$$reportNull$$$0(2);
            }
            SessionStateListener.changed(session);
        }

        public void stateChanged(@NotNull DatabaseSessionStateListener.ChangeEvent event) {
            if (event == null) {
                SessionStateListener.$$$reportNull$$$0(3);
            }
            if (event.getType() == DatabaseSessionStateListener.ChangeEvent.EventType.PUBLISHED) {
                DatabaseServiceViewContributor.sessionOpened(event.getSession());
                return;
            }
            SessionStateListener.changed(event.getSession());
        }

        private static void changed(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionStateListener.$$$reportNull$$$0(4);
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)session, DatabaseServiceViewContributor.class);
                DatabaseServiceViewContributor.listener(session).handle(event);
            });
        }

        public void clientAttached(@NotNull VisibleDatabaseSessionClient client) {
            if (client == null) {
                SessionStateListener.$$$reportNull$$$0(5);
            }
            if (!(client instanceof DatabaseSessionClientWithFile)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                DatabaseSession session = (DatabaseSession)client.getSession();
                ServiceEventListener l = DatabaseServiceViewContributor.listener(session);
                if (l == InactiveListener.INSTANCE) {
                    return;
                }
                if (Registry.is((String)"database.services.hide.session.node")) {
                    DatabaseSessionClientWithFile[] clients = session.getClientsWithFile();
                    int count = clients.length;
                    if (count == 1) {
                        l.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)session, DatabaseServiceViewContributor.class));
                    } else if (count == 2) {
                        l.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)session, DatabaseServiceViewContributor.class));
                        for (DatabaseSessionClientWithFile c2 : clients) {
                            l.handle(ServiceEventListener.ServiceEvent.createServiceAddedEvent((Object)c2, DatabaseServiceViewContributor.class, (Object)session));
                        }
                    } else {
                        l.handle(ServiceEventListener.ServiceEvent.createServiceAddedEvent((Object)client, DatabaseServiceViewContributor.class, (Object)session));
                    }
                } else {
                    l.handle(ServiceEventListener.ServiceEvent.createServiceAddedEvent((Object)client, DatabaseServiceViewContributor.class, (Object)session));
                }
                if (DatabaseSettings.getSettings().showOutputInTab) {
                    DatabaseServiceViewContributor.extractNode(session.getProject(), client);
                }
                DatabaseServiceViewContributor.selectNode(session.getProject(), client, false, true, null);
            });
        }

        public void clientDetached(@NotNull VisibleDatabaseSessionClient client) {
            if (client == null) {
                SessionStateListener.$$$reportNull$$$0(6);
            }
            if (!(client instanceof DatabaseSessionClientWithFile)) {
                return;
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                DatabaseSessionClientWithFile[] clients;
                ServiceEventListener listener2 = DatabaseServiceViewContributor.listener((DatabaseSession)client.getSession());
                listener2.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, (Object)client, DatabaseServiceViewContributor.class));
                if (Registry.is((String)"database.services.hide.session.node") && (clients = ((DatabaseSession)client.getSession()).getClientsWithFile()).length == 1) {
                    listener2.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)client.getSession(), DatabaseServiceViewContributor.class));
                    listener2.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, (Object)clients[0], DatabaseServiceViewContributor.class));
                }
            });
        }

        public void clientReattached(@NotNull VisibleDatabaseSessionClient client, @NotNull DatabaseSession from, @NotNull DatabaseSession to) {
            if (client == null) {
                SessionStateListener.$$$reportNull$$$0(7);
            }
            if (from == null) {
                SessionStateListener.$$$reportNull$$$0(8);
            }
            if (to == null) {
                SessionStateListener.$$$reportNull$$$0(9);
            }
            if (!(client instanceof DatabaseSessionClientWithFile)) {
                return;
            }
            DatabaseSessionClientWithFile fileClient = (DatabaseSessionClientWithFile)client;
            if (Registry.is((String)"database.services.hide.session.node")) {
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    ServiceEventListener listener2 = DatabaseServiceViewContributor.listener(from);
                    listener2.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)from, DatabaseServiceViewContributor.class));
                    listener2.handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)to, DatabaseServiceViewContributor.class));
                    DatabaseServiceViewContributor.selectNode(to.getProject(), (VisibleDatabaseSessionClient)fileClient, false, true, null);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionStateListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renamed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "connected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disconnected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stateChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clientAttached";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clientDetached";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clientReattached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class SessionContributor
    implements ServiceViewProvidingContributor<DatabaseSessionClientWithFile, DatabaseSession>,
    Comparator<DatabaseSessionClientWithFile> {
        private final DatabaseSession mySession;

        SessionContributor(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionContributor.$$$reportNull$$$0(0);
            }
            this.mySession = session;
        }

        @NotNull
        public DatabaseSession asService() {
            DatabaseSession databaseSession = this.mySession;
            if (databaseSession == null) {
                SessionContributor.$$$reportNull$$$0(1);
            }
            return databaseSession;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            if (project == null) {
                SessionContributor.$$$reportNull$$$0(2);
            }
            ServiceViewDescriptor serviceViewDescriptor = DatabaseServiceViewContributor.resolveDescriptorForNode(this.mySession);
            if (serviceViewDescriptor == null) {
                SessionContributor.$$$reportNull$$$0(3);
            }
            return serviceViewDescriptor;
        }

        @NotNull
        public List<DatabaseSessionClientWithFile> getServices(@NotNull Project project) {
            DatabaseSessionClientWithFile[] clients;
            if (project == null) {
                SessionContributor.$$$reportNull$$$0(4);
            }
            List<Object> list = (clients = this.mySession.getClientsWithFile()).length == 1 ? Collections.emptyList() : Arrays.asList(clients);
            if (list == null) {
                SessionContributor.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull DatabaseSessionClientWithFile service) {
            if (project == null) {
                SessionContributor.$$$reportNull$$$0(6);
            }
            if (service == null) {
                SessionContributor.$$$reportNull$$$0(7);
            }
            return new ClientViewDescriptor(service, this.mySession, true);
        }

        @Override
        public int compare(DatabaseSessionClientWithFile o1, DatabaseSessionClientWithFile o2) {
            Object[] clients = this.mySession.getClientsWithFile();
            return ArrayUtil.indexOf((Object[])clients, (Object)o1) - ArrayUtil.indexOf((Object[])clients, (Object)o2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.mySession.equals((Object)((SessionContributor)o).mySession);
        }

        public int hashCode() {
            return this.mySession.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionContributor";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionContributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asService";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getViewDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getServices";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getServiceDescriptor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class DbDataSourceViewDescriptor
    implements ServiceViewDescriptor,
    ColoredItem,
    UiDataProvider {
        private final DbDataSource myDataSource;
        private ServiceViewComponentWrapper myContentComponent;

        DbDataSourceViewDescriptor(@NotNull DbDataSource dataSource) {
            if (dataSource == null) {
                DbDataSourceViewDescriptor.$$$reportNull$$$0(0);
            }
            this.myDataSource = dataSource;
        }

        @Nullable
        public Color getColor() {
            return DatabaseColorManager.getColor((DbElement)this.myDataSource);
        }

        @Nullable
        public Runnable getRemover() {
            return DatabaseServiceViewDeleteElementProvider.RemoveHelper.DATA_SOURCE.canRemove(this.myDataSource.getProject(), this.myDataSource) ? () -> {
                if (DatabaseServiceViewDeleteElementProvider.RemoveHelper.DATA_SOURCE.canRemove(this.myDataSource.getProject(), this.myDataSource)) {
                    DatabaseServiceViewDeleteElementProvider.RemoveHelper.DATA_SOURCE.remove(this.myDataSource.getProject(), this.myDataSource);
                }
            } : null;
        }

        public JComponent getContentComponent() {
            if (!(this.myDataSource instanceof DbDataSourceImpl)) {
                return null;
            }
            if (this.myContentComponent == null) {
                DbDataSourceImpl dataSource = (DbDataSourceImpl)this.myDataSource;
                DataSourceInfoTool infoTool = new DataSourceInfoTool(dataSource, (ActionGroup)this.getToolbarActions());
                this.myContentComponent = new ServiceViewComponentWrapper(infoTool.getComponent());
            }
            return this.myContentComponent;
        }

        @NotNull
        public DefaultActionGroup getToolbarActions() {
            DefaultActionGroup group = new DefaultActionGroup();
            ActionManager manager = ActionManager.getInstance();
            group.add(manager.getAction("Jdbc.OpenConsole.Any"));
            group.add(manager.getAction("DatabaseView.PropertiesAction"));
            group.add(manager.getAction("DatabaseView.DeactivateAction"));
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                DbDataSourceViewDescriptor.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        @Nullable
        public ActionGroup getPopupActions() {
            DefaultActionGroup actions = this.getToolbarActions();
            actions.addSeparator();
            actions.add(ActionManager.getInstance().getAction("Session.CloseAll"));
            return actions;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData data = new PresentationData();
            data.setIcon((Icon)ReadAction.compute(() -> this.myDataSource.getIcon()));
            data.setPresentableText(this.myDataSource.getName());
            PresentationData presentationData = data;
            if (presentationData == null) {
                DbDataSourceViewDescriptor.$$$reportNull$$$0(2);
            }
            return presentationData;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                DbDataSourceViewDescriptor.$$$reportNull$$$0(3);
            }
            sink.set(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY, (Object)new PsiElement[]{this.myDataSource});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$DbDataSourceViewDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$DbDataSourceViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolbarActions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class GroupViewDescriptor
    implements ServiceViewDescriptor,
    UiDataProvider {
        private final PsiElement myElement;
        private final ItemPresentation myPresentation;

        GroupViewDescriptor(@NotNull PsiElement element) {
            if (element == null) {
                GroupViewDescriptor.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myPresentation = (ItemPresentation)ReadAction.compute(() -> {
                String presentableText = this.myElement instanceof DbElement ? DbPresentationCore.getPresentableName((DasObject)((DbElement)this.myElement), (boolean)true) : (this.myElement instanceof PsiNamedElement ? ((PsiNamedElement)this.myElement).getName() : null);
                return new PresentationData(presentableText, null, this.myElement.getIcon(0), null);
            });
        }

        @NotNull
        public ItemPresentation getPresentation() {
            ItemPresentation itemPresentation = this.myPresentation;
            if (itemPresentation == null) {
                GroupViewDescriptor.$$$reportNull$$$0(1);
            }
            return itemPresentation;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                GroupViewDescriptor.$$$reportNull$$$0(2);
            }
            sink.set(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY, (Object)new PsiElement[]{this.myElement});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$GroupViewDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$GroupViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class InactiveListener
    implements ServiceEventListener {
        static final ServiceEventListener INSTANCE = new InactiveListener();

        private InactiveListener() {
        }

        public void handle(@NotNull ServiceEventListener.ServiceEvent event) {
            if (event == null) {
                InactiveListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/DatabaseServiceViewContributor$InactiveListener", "handle"));
        }
    }

    private static class ClientViewDescriptor
    extends BaseViewDescriptor
    implements Navigatable {
        private final DatabaseSessionClientWithFile myClient;
        private final DatabaseSession mySession;
        private final boolean hasSessionParentNode;

        ClientViewDescriptor(@NotNull DatabaseSessionClientWithFile client, @NotNull DatabaseSession session, boolean hasSessionParentNode) {
            if (client == null) {
                ClientViewDescriptor.$$$reportNull$$$0(0);
            }
            if (session == null) {
                ClientViewDescriptor.$$$reportNull$$$0(1);
            }
            this.myClient = client;
            this.mySession = session;
            this.hasSessionParentNode = hasSessionParentNode;
        }

        @Override
        @Nullable
        protected Icon getIcon() {
            DatabaseSession session = (DatabaseSession)this.myClient.getSession();
            DatabaseSession.State state = session.getState();
            DatabaseSession.State.Work work = state.getWorkFor((DataRequest.Owner)this.myClient);
            Icon progressIcon = work == null ? null : SessionsUtil.getProgressIcon((DatabaseSession.State.Work)work, (DatabaseSession)session, (boolean)false, (boolean)false);
            try (AccessToken ignore = SlowOperations.knownIssue((String)"DBE-23679");){
                Icon iconWithoutConnectivity = (Icon)ObjectUtils.chooseNotNull((Object)progressIcon, (Object)((Icon)ReadAction.compute(() -> this.myClient.getIcon())));
                Icon icon = SessionsUiUtil.getIconForConsole((DatabaseSession)session, (Icon)iconWithoutConnectivity, (boolean)this.hasSessionParentNode);
                return icon;
            }
        }

        @Override
        protected boolean isValid() {
            return this.myClient.isValid();
        }

        @Override
        @Nullable
        protected LogView<?> getViewIfAny() {
            return DatabaseSessionViewService.getInstance().getClientViewIfAny(this.myClient);
        }

        @Override
        @NotNull
        protected String getName() {
            String string = this.shouldShowSessionName() ? DatabaseBundle.message((String)"sessions.services.client.name", (Object[])new Object[]{this.myClient.getTitle(), this.mySession.getTitle()}) : this.myClient.getTitle();
            if (string == null) {
                ClientViewDescriptor.$$$reportNull$$$0(2);
            }
            return string;
        }

        private boolean shouldShowSessionName() {
            String fileName = this.myClient.getVirtualFile().getNameWithoutExtension();
            return !this.hasSessionParentNode && !fileName.equals(this.mySession.getTitle());
        }

        @Override
        @Nullable
        protected String getDescriptionText() {
            DatabaseSession session = (DatabaseSession)this.myClient.getSession();
            DatabaseSession.State state = session.getState();
            DatabaseSession.State.Work work = state.getWorkFor((DataRequest.Owner)this.myClient);
            return work == null ? null : SessionsUtil.getTimeSpent((DatabaseSession.State.Work)work, (DatabaseSession)session);
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            PresentationData result2 = new PresentationData();
            result2.setPresentableText(SessionsUtil.getQualifiedClientTitle((DatabaseSessionClientWithFile)this.myClient));
            result2.setIcon(this.getIcon());
            PresentationData presentationData = result2;
            if (presentationData == null) {
                ClientViewDescriptor.$$$reportNull$$$0(3);
            }
            return presentationData;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile virtualFile = this.getVirtualFile();
            DatabaseSession session = this.getSession();
            Project project = session.getProject();
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            TransactionGuard.submitTransaction((Disposable)session, () -> manager.openFile(virtualFile, requestFocus, true));
        }

        public boolean canNavigateToSource() {
            return this.getVirtualFile().isValid();
        }

        public boolean canNavigate() {
            return this.canNavigateToSource();
        }

        @Nullable
        public Navigatable getNavigatable() {
            return this;
        }

        @Override
        @NotNull
        DatabaseSession getSession() {
            DatabaseSession databaseSession = (DatabaseSession)this.myClient.getSession();
            if (databaseSession == null) {
                ClientViewDescriptor.$$$reportNull$$$0(4);
            }
            return databaseSession;
        }

        @Nullable
        public Runnable getRemover() {
            Project project = ((DatabaseSession)this.myClient.getSession()).getProject();
            return DatabaseServiceViewDeleteElementProvider.RemoveHelper.CLIENT.canRemove(project, this.myClient) ? () -> {
                if (DatabaseServiceViewDeleteElementProvider.RemoveHelper.CLIENT.canRemove(project, this.myClient)) {
                    DatabaseServiceViewDeleteElementProvider.RemoveHelper.CLIENT.remove(project, this.myClient);
                }
            } : null;
        }

        @Nullable
        public ActionGroup getPopupActions() {
            DefaultActionGroup actions = this.getToolbarActions();
            actions.addSeparator();
            ActionManager actionManager = ActionManager.getInstance();
            actions.add(actionManager.getAction("Console.Jdbc.ChooseSession"));
            actions.add(actionManager.getAction("Console.Jdbc.ChooseDataSource"));
            return actions;
        }

        @Override
        @NotNull
        protected LogView<?> getView() {
            LogView logView = DatabaseSessionViewService.getInstance().getClientViewIfAny(this.myClient);
            if (logView == null) {
                ClientViewDescriptor.$$$reportNull$$$0(5);
            }
            return logView;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myClient.getVirtualFile();
            if (virtualFile == null) {
                ClientViewDescriptor.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }

        @Override
        @Nullable
        public Color getColor() {
            Project project = ((DatabaseSession)this.myClient.getSession()).getProject();
            return DatabaseColorManager.getColor(project, this.myClient.getVirtualFile());
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ClientViewDescriptor.$$$reportNull$$$0(7);
            }
            sink.set(SessionClientHolder.CLIENT_KEY, (Object)this.myClient);
            sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)this.getVirtualFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$ClientViewDescriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$ClientViewDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getView";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class SessionViewDescriptor
    extends BaseViewDescriptor {
        private final DatabaseSession mySession;

        SessionViewDescriptor(@NotNull DatabaseSession session) {
            if (session == null) {
                SessionViewDescriptor.$$$reportNull$$$0(0);
            }
            this.mySession = session;
        }

        @Override
        @NotNull
        DatabaseSession getSession() {
            DatabaseSession databaseSession = this.mySession;
            if (databaseSession == null) {
                SessionViewDescriptor.$$$reportNull$$$0(1);
            }
            return databaseSession;
        }

        @Nullable
        public ActionGroup getPopupActions() {
            DefaultActionGroup actions = this.getToolbarActions();
            actions.addSeparator();
            actions.add(ActionManager.getInstance().getAction("Session.Rename"));
            actions.add(ActionManager.getInstance().getAction("Session.Close"));
            return actions;
        }

        @Override
        protected boolean isValid() {
            return this.mySession.isValid();
        }

        @Override
        @NotNull
        protected Icon getIcon() {
            Icon icon = SessionsUiUtil.getIcon((DatabaseSession)this.mySession);
            if (icon == null) {
                SessionViewDescriptor.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @Override
        @NotNull
        protected String getName() {
            String string = this.mySession.getTitle();
            if (string == null) {
                SessionViewDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getDescriptionText() {
            return SessionsUtil.getTimeSpent((DatabaseSession)this.mySession);
        }

        @NotNull
        public ItemPresentation getCustomPresentation(@NotNull ServiceViewOptions options, @NotNull ServiceViewItemState state) {
            if (options == null) {
                SessionViewDescriptor.$$$reportNull$$$0(4);
            }
            if (state == null) {
                SessionViewDescriptor.$$$reportNull$$$0(5);
            }
            PresentationData presentationData = this.getPresentation();
            if (presentationData == null) {
                SessionViewDescriptor.$$$reportNull$$$0(6);
            }
            return presentationData;
        }

        @Nullable
        public Runnable getRemover() {
            Project project = this.mySession.getProject();
            return DatabaseServiceViewDeleteElementProvider.RemoveHelper.SESSION.canRemove(project, this.mySession) ? () -> {
                if (DatabaseServiceViewDeleteElementProvider.RemoveHelper.SESSION.canRemove(project, this.mySession)) {
                    DatabaseServiceViewDeleteElementProvider.RemoveHelper.SESSION.remove(project, this.mySession);
                }
            } : null;
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            PresentationData result2 = new PresentationData();
            result2.setPresentableText(SessionsUtil.getQualifiedSessionTitle((DatabaseSession)this.mySession));
            result2.setIcon(this.getIcon());
            PresentationData presentationData = result2;
            if (presentationData == null) {
                SessionViewDescriptor.$$$reportNull$$$0(7);
            }
            return presentationData;
        }

        @Override
        @Nullable
        protected LogView<?> getViewIfAny() {
            return DatabaseSessionViewService.getInstance().getViewIfAny(this.mySession);
        }

        @NotNull
        protected LogView<DatabaseSession> getView() {
            LogView logView = DatabaseSessionViewService.getInstance().getView(this.mySession);
            if (logView == null) {
                SessionViewDescriptor.$$$reportNull$$$0(8);
            }
            return logView;
        }

        @Override
        @Nullable
        public Color getColor() {
            return super.getColor();
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                SessionViewDescriptor.$$$reportNull$$$0(9);
            }
            sink.set(Session.SESSION_KEY, (Object)this.mySession);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionViewDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$SessionViewDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomPresentation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentPresentation";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCustomPresentation";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class TransactionControlAction
    extends DefaultActionGroup {
        private static AnAction ourInstance;
        private final AnAction myDelegate;
        private final TextIcon myIcon;

        TransactionControlAction() {
            this.setPopup(true);
            this.myDelegate = ActionManager.getInstance().getAction("Console.Transaction.TxSettings");
            this.myIcon = new TextIcon("Tx", UIUtil.getLabelForeground(), Gray.TRANSPARENT, 0);
            this.myIcon.setFont(UIUtil.getToolbarFont());
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon((Icon)this.myIcon);
            presentation.setDescription(this.myDelegate.getTemplatePresentation().getDescription());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = this.myDelegate.getActionUpdateThread();
            if (actionUpdateThread == null) {
                TransactionControlAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TransactionControlAction.$$$reportNull$$$0(1);
            }
            this.myDelegate.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setPerformGroup(presentation.isEnabled());
            presentation.setIcon((Icon)(e.isFromContextMenu() ? null : this.myIcon));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TransactionControlAction.$$$reportNull$$$0(2);
            }
            this.myDelegate.actionPerformed(e);
        }

        @NotNull
        private static AnAction getInstance() {
            if (ourInstance == null) {
                ourInstance = new TransactionControlAction();
            }
            AnAction anAction = ourInstance;
            if (anAction == null) {
                TransactionControlAction.$$$reportNull$$$0(3);
            }
            return anAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseServiceViewContributor$TransactionControlAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseServiceViewContributor$TransactionControlAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static abstract class BaseViewDescriptor
    implements ServiceViewDescriptor,
    ColoredItem,
    UiDataProvider {
        private ServiceViewComponentWrapper myContentComponent;
        private DefaultActionGroup toolbarActions;

        private BaseViewDescriptor() {
        }

        @Nullable
        public JComponent getContentComponent() {
            if (!this.isValid()) {
                return null;
            }
            if (this.myContentComponent == null) {
                LogView<?> view = this.getView();
                if (ServiceViewUIUtils.isNewServicesUIEnabled()) {
                    view.getUi().getOptions().setTopLeftToolbar((ActionGroup)this.getToolbarActions(), "ServicesToolbar");
                }
                this.myContentComponent = new ServiceViewComponentWrapper(view.getContent().getComponent());
            }
            return this.myContentComponent;
        }

        @NotNull
        public DefaultActionGroup getToolbarActions() {
            if (this.toolbarActions != null) {
                DefaultActionGroup defaultActionGroup = this.toolbarActions;
                if (defaultActionGroup == null) {
                    BaseViewDescriptor.$$$reportNull$$$0(0);
                }
                return defaultActionGroup;
            }
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(ActionManager.getInstance().getAction("Console.DbmsOutput"));
            group.add(TransactionControlAction.getInstance());
            group.add(ActionManager.getInstance().getAction("Console.Jdbc.Common"));
            LogView<?> view = this.getViewIfAny();
            if (view == null) {
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    BaseViewDescriptor.$$$reportNull$$$0(1);
                }
                return defaultActionGroup;
            }
            if (view instanceof DatabaseLogView) {
                group.addSeparator();
                List<AnAction> leftToolbarActions = ((DatabaseLogView)view).getActions();
                for (AnAction action : leftToolbarActions) {
                    group.add(action);
                }
            }
            this.toolbarActions = group;
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                BaseViewDescriptor.$$$reportNull$$$0(2);
            }
            return defaultActionGroup;
        }

        @NotNull
        public PresentationData getPresentation() {
            PresentationData pData = new PresentationData();
            pData.setPresentableText(this.getName());
            pData.setLocationString(this.getDescriptionText());
            pData.setIcon(this.getIcon());
            PresentationData presentationData = pData;
            if (presentationData == null) {
                BaseViewDescriptor.$$$reportNull$$$0(3);
            }
            return presentationData;
        }

        @Nullable
        public DataProvider getDataProvider() {
            LogView<?> any = this.getViewIfAny();
            if (any == null) {
                return null;
            }
            Content content = any.getContent();
            return DataManagerImpl.getDataProviderEx((Object)content.getComponent());
        }

        @Nullable
        public Color getColor() {
            return DatabaseColorManager.getColor((DbElement)this.getDataSource());
        }

        @Nullable
        protected final DbDataSource getDataSource() {
            DatabaseSession session = this.getSession();
            return DbImplUtilCore.getDbDataSource((Project)session.getProject(), (DasDataSource)((DatabaseConnectionPoint)session.getTarget()).getDataSource());
        }

        protected abstract boolean isValid();

        @Nls
        @NotNull
        protected abstract String getName();

        @NlsContexts.DetailedDescription
        @Nullable
        protected abstract String getDescriptionText();

        @Nullable
        protected abstract LogView<?> getViewIfAny();

        @NotNull
        protected abstract LogView<?> getView();

        @Nullable
        protected abstract Icon getIcon();

        @NotNull
        abstract DatabaseSession getSession();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/console/DatabaseServiceViewContributor$BaseViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolbarActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

