/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/console/IgnoredQueryFilesProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "<init>", "()V", "shouldIgnoreQueryFolder", "", "isIgnoredFile", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getIgnoredFiles", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "getIgnoredGroupDescription", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "intellij.database.impl"})
public final class IgnoredQueryFilesProvider
implements IgnoredFileProvider {
    private final boolean shouldIgnoreQueryFolder() {
        return !PlatformUtils.isDataGrip();
    }

    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!this.shouldIgnoreQueryFolder()) {
            return false;
        }
        Path path = QueryFileSettings.Companion.getDefaultScriptsPath(project);
        if (path == null) {
            return false;
        }
        Path defaultDirectoryPath = path;
        Object object = filePath.getVirtualFile();
        if (object == null || (object = object.toNioPath()) == null) {
            return false;
        }
        Object nioFilePath = object;
        return nioFilePath.startsWith(defaultDirectoryPath);
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        Set ignored;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!this.shouldIgnoreQueryFolder()) {
                return SetsKt.emptySet();
            }
            ignored = new LinkedHashSet();
            Path path = QueryFileSettings.Companion.getDefaultScriptsPath(project);
            if (path == null) break block1;
            Path defaultDir = path;
            boolean bl = false;
            IgnoredFileBean ignoredFileBean = IgnoredBeanFactory.ignoreUnderDirectory((String)PathsKt.getInvariantSeparatorsPathString((Path)defaultDir), (Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)ignoredFileBean, (String)"ignoreUnderDirectory(...)");
            ignored.add(ignoredFileBean);
        }
        return ignored;
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        String string = DatabaseBundle.message((String)"query.files.gitignore.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

