/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.SearchPathSender;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridTablesModelBuilder;
import com.intellij.database.datagrid.JpaGridDataHookUp;
import com.intellij.database.datagrid.SqlDocumentDataHookUp;
import com.intellij.database.datagrid.objects.DasGridDataHookUp;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.ui.grid.editors.DbGridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbGridDataHookUpUtil {
    @NotNull
    public static GridDataHookUp<GridRow, GridColumn> getFamilyHookUp(@NotNull Project project, @NotNull VirtualFile file, @NotNull Disposable parent) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(2);
        }
        GridDataHookUp gridDataHookUp = GridDataHookUpManager.getInstance((Project)project).getOrCreateHookUp(file, f -> {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            Supplier provider = DasGridDataHookUp.createProvider((Project)project, (String)dbFile.getDataSourceId(), (ObjectPath)dbFile.getObjectPath(), (ObjectKind)dbFile.getFamily());
            return new DasGridDataHookUp(project, dbFile.getDataSourceId(), provider, (v1, v2, hookUp) -> GridCellEditorHelper.areValuesEqual((Object)v1, (Object)v2));
        }, parent);
        if (gridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(3);
        }
        return gridDataHookUp;
    }

    @NotNull
    public static DatabaseTableGridDataHookUp getOrCreateLightweight(@NotNull Project project, @NotNull VirtualFile file, @NotNull Disposable parent, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(6);
        }
        if (department == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(7);
        }
        HookUpFactory<VirtualFile, DatabaseTableGridDataHookUp, DatabaseSession> hookUpFactory = (tableFile, session) -> {
            DatabaseTableGridDataHookUp hookUp = new DatabaseTableGridDataHookUp(project, (DatabaseSession)session, (VirtualFile)tableFile, department);
            DatabaseConnectionPoint target = (DatabaseConnectionPoint)session.getTarget();
            VisibleDatabaseSessionClient client = DatabaseSessionManager.getFacade((Project)project, (DatabaseConnectionPoint)target, null, null, (boolean)true, null, (DatabaseDepartment)department).client(session);
            Disposer.register((Disposable)parent, (Disposable)hookUp);
            Disposer.register((Disposable)hookUp, (Disposable)client);
            return hookUp;
        };
        SessionFactory<DatabaseSession> sessionFactory = (dataSource, title) -> DatabaseSessionManager.getSession((Project)project, (DatabaseConnectionPoint)dataSource, (String)title);
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = (DatabaseTableGridDataHookUp)((Object)DbGridDataHookUpUtil.generator(project, hookUpFactory, sessionFactory).fun((Object)file));
        if (databaseTableGridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(8);
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    static <F extends VirtualFile, H extends DatabaseGridDataHookUp, S extends DatabaseSession> Function<F, H> generator(@NotNull Project project, @NotNull HookUpFactory<F, H, S> factory, @NotNull SessionFactory<S> sessionFactory) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(9);
        }
        if (factory == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(10);
        }
        if (sessionFactory == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(11);
        }
        Function function = file -> {
            DbDataSource dataSource = Objects.requireNonNull(DbImplUtilCore.findDataSource((Project)project, (VirtualFile)file));
            Object session = sessionFactory.create(DbImplUtilCore.getLocalDataSource((DbDataSource)dataSource), SessionsUtil.getSessionTitle((VirtualFile)file));
            return (DatabaseGridDataHookUp)factory.construct(file, session);
        };
        if (function == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(12);
        }
        return function;
    }

    @NotNull
    public static SqlDocumentDataHookUp getHookUp(@NotNull Project project, @NotNull SqlTableDataFragmentFile file, @NotNull Disposable parent) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(13);
        }
        if (file == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(14);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(15);
        }
        SqlDocumentDataHookUp sqlDocumentDataHookUp = (SqlDocumentDataHookUp)GridDataHookUpManager.getInstance((Project)project).getOrCreateHookUp((VirtualFile)file, file1 -> new SqlDocumentDataHookUp(project, file1.getDialect(), GridDataHookUpManager.getDocument((VirtualFile)file1.getOriginalFile()), file1.getRange()), parent);
        if (sqlDocumentDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(16);
        }
        return sqlDocumentDataHookUp;
    }

    @NotNull
    public static ConsoleGridDataHookUp createDatabaseHookUp(@NotNull Project project, @NotNull Disposable parent, @NotNull DatabaseSession session, @NotNull SearchPathSender sender, @NotNull DatabaseDepartment department, @Nullable DataRequest.OwnerEx parentOwner) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(18);
        }
        if (session == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(19);
        }
        if (sender == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(20);
        }
        if (department == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(21);
        }
        ConsoleGridDataHookUp consoleGridDataHookUp = (ConsoleGridDataHookUp)GridDataHookUpManager.getInstance((Project)project).registerHookUp((GridDataHookUp)new ConsoleGridDataHookUp(project, session, department, sender, parentOwner, DbGridCellEditorHelper::areValuesEqual, DatabaseTableGridDataHookUp::createDatabaseMutationsStorage), parent);
        if (consoleGridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(22);
        }
        return consoleGridDataHookUp;
    }

    @NotNull
    public static DatabaseTableGridDataHookUp createDatabaseTableHookUp(@NotNull Project project, @NotNull Disposable parent, @NotNull DatabaseSession session, @NotNull DatabaseDepartment department, @NotNull VirtualFile file) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(23);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(24);
        }
        if (session == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(25);
        }
        if (department == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(26);
        }
        if (file == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(27);
        }
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = (DatabaseTableGridDataHookUp)GridDataHookUpManager.getInstance((Project)project).registerHookUp((GridDataHookUp)new DatabaseTableGridDataHookUp(project, session, file, department), parent);
        if (databaseTableGridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(28);
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    public static DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Disposable parent, @NotNull String query, @Nullable DasObject table, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(29);
        }
        if (dataSource == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(30);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(31);
        }
        if (query == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(32);
        }
        if (department == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(33);
        }
        DatabaseSession session = DatabaseSessionManager.getSession((Project)project, (DatabaseConnectionPoint)dataSource);
        DatabaseGridDataHookUp hookUp = DbGridDataHookUpUtil.createReadOnlyDatabaseHookUp(project, session, parent, query, department);
        if (table instanceof DasTable) {
            DasTable dasTable = (DasTable)table;
            GridTablesModelBuilder gridTablesModelBuilder = new GridTablesModelBuilder();
            hookUp.setGridTablesModel(gridTablesModelBuilder.buildForSingleTable((DasObject)dasTable));
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = hookUp;
        if (databaseGridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(34);
        }
        return databaseGridDataHookUp;
    }

    @NotNull
    public static DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull Project project, @NotNull DatabaseSession session, @NotNull Disposable parent, @NotNull String query, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(35);
        }
        if (session == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(36);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(37);
        }
        if (query == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(38);
        }
        if (department == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(39);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = (DatabaseGridDataHookUp)GridDataHookUpManager.getInstance((Project)project).registerHookUp((GridDataHookUp)new ReadOnlyClientDatabaseGridDataHookUp(project, session, query, department), parent);
        if (databaseGridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(40);
        }
        return databaseGridDataHookUp;
    }

    @NotNull
    public static DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull Project project, @NotNull Disposable parent, @NotNull String query, @NotNull DatabaseDepartment department, @NotNull DatabaseSession session) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(41);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(42);
        }
        if (query == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(43);
        }
        if (department == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(44);
        }
        if (session == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(45);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = (DatabaseGridDataHookUp)GridDataHookUpManager.getInstance((Project)project).registerHookUp((GridDataHookUp)new ReadOnlyDatabaseGridDataHookUp(project, session, query, department), parent);
        if (databaseGridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(46);
        }
        return databaseGridDataHookUp;
    }

    public static JpaGridDataHookUp createJpaHookUp(@NotNull Project project, @NotNull Session session, @NotNull Disposable parent) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(47);
        }
        if (session == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(48);
        }
        if (parent == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(49);
        }
        return (JpaGridDataHookUp)GridDataHookUpManager.getInstance((Project)project).registerHookUp((GridDataHookUp)new JpaGridDataHookUp(project, session), parent);
    }

    @TestOnly
    @NotNull
    public static DatabaseGridDataHookUp createMockHookUp(@NotNull Project project, final @NotNull DbDataSource dataSource, @NotNull DatabaseSession session, @NotNull SearchPathSender sender, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(50);
        }
        if (dataSource == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(51);
        }
        if (session == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(52);
        }
        if (sender == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(53);
        }
        if (department == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(54);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = (DatabaseGridDataHookUp)GridDataHookUpManager.getInstance((Project)project).registerHookUp((GridDataHookUp)new ConsoleGridDataHookUp(project, session, department, sender, null, DbGridCellEditorHelper::areValuesEqual, DatabaseTableGridDataHookUp::createDatabaseMutationsStorage){

            @NotNull
            public DbDataSource getDataSource() {
                DbDataSource dbDataSource = dataSource;
                if (dbDataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dbDataSource;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DbGridDataHookUpUtil$1", "getDataSource"));
            }
        }, (Disposable)session);
        if (databaseGridDataHookUp == null) {
            DbGridDataHookUpUtil.$$$reportNull$$$0(55);
        }
        return databaseGridDataHookUp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 12, 16, 22, 28, 34, 40, 46, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 15: 
            case 18: 
            case 24: 
            case 31: 
            case 37: 
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 16: 
            case 22: 
            case 28: 
            case 34: 
            case 40: 
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DbGridDataHookUpUtil";
                break;
            }
            case 7: 
            case 21: 
            case 26: 
            case 33: 
            case 39: 
            case 44: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionFactory";
                break;
            }
            case 19: 
            case 25: 
            case 36: 
            case 45: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 20: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 30: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 32: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DbGridDataHookUpUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyHookUp";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLightweight";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookUp";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseHookUp";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseTableHookUp";
                break;
            }
            case 34: 
            case 40: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyHookUp";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 16: 
            case 22: 
            case 28: 
            case 34: 
            case 40: 
            case 46: 
            case 55: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLightweight";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generator";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHookUp";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseHookUp";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseTableHookUp";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createJpaHookUp";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createMockHookUp";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 12, 16, 22, 28, 34, 40, 46, 55 -> new IllegalStateException(string);
        };
    }

    public static interface HookUpFactory<F, H, S> {
        @NotNull
        public H construct(@NotNull F var1, @NotNull S var2);
    }

    public static interface SessionFactory<S extends DatabaseSession> {
        @NotNull
        public S create(@NotNull LocalDataSource var1, @Nls @NotNull String var2);
    }

    public static final class ReadOnlyClientDatabaseGridDataHookUp
    extends ReadOnlyDatabaseGridDataHookUp
    implements DatabaseSessionClient {
        private ReadOnlyClientDatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session, @NotNull String query, @NotNull DatabaseDepartment department) {
            if (project == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(0);
            }
            if (session == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(1);
            }
            if (query == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(2);
            }
            if (department == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(3);
            }
            super(project, session, query, department);
            session.attach((DatabaseSessionClient)this);
        }

        @Override
        @NotNull
        protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
            return new DatabaseGridDataHookUp.DatabaseLoader(){

                protected boolean canUpdateQueryText() {
                    return true;
                }

                protected String createQueryText(@NotNull DataBusGridDataHookUp.QueryAttributes attributes, @Nullable GridRequestSource source) {
                    if (attributes == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return myQuery;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/datagrid/DbGridDataHookUpUtil$ReadOnlyClientDatabaseGridDataHookUp$1", "createQueryText"));
                }
            };
        }

        @NotNull
        public String getTitle() {
            String string = this.myQuery;
            if (string == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isActive() {
            return true;
        }

        public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger) {
            if (trigger == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "department";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DbGridDataHookUpUtil$ReadOnlyClientDatabaseGridDataHookUp";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DbGridDataHookUpUtil$ReadOnlyClientDatabaseGridDataHookUp";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "detached";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class ReadOnlyDatabaseGridDataHookUp
    extends DatabaseGridDataHookUp {
        @NlsSafe
        protected final String myQuery;

        protected ReadOnlyDatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session, @NotNull String query, @NotNull DatabaseDepartment department) {
            if (project == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(0);
            }
            if (session == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(1);
            }
            if (query == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(2);
            }
            if (department == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(3);
            }
            super(project, session, department, DbGridCellEditorHelper::areValuesEqual, DatabaseTableGridDataHookUp::createDatabaseMutationsStorage);
            this.myQuery = query;
        }

        public boolean isReadOnly() {
            return true;
        }

        @NotNull
        protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
            return new DatabaseGridDataHookUp.DatabaseLoader(this){

                protected boolean canUpdateQueryText() {
                    return false;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "department";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DbGridDataHookUpUtil$ReadOnlyDatabaseGridDataHookUp";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

