/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridStartupActivity;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.DbGridDataHookUpManager;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditorProvider;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.editor.TableFileEditorLightState;
import com.intellij.database.editor.TableFileEditorState;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.NumberDisplayType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.settings.CsvSettings;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseTableFileEditor
extends TableEditorBase
implements NavigatableFileEditor,
DocumentReferenceProvider {
    private final VirtualFile myFile;
    private final EditorTableResultPanel myResultPanel;
    private final JComponent myComponent;
    private final LoadingManager myLoadingManager;
    private boolean stateWasSet;
    private final long lastOpenedTimestamp;
    @NotNull
    private final JComponent headerComponent;

    public DatabaseTableFileEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull DatabaseTableFileEditorProvider provider) {
        if (project == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(2);
        }
        super(project);
        this.stateWasSet = false;
        this.lastOpenedTimestamp = System.currentTimeMillis();
        this.myFile = file;
        FileEditorState obj = EditorHistoryManager.getInstance((Project)project).getState(file, (FileEditorProvider)provider);
        TableFileEditorState state = obj instanceof TableFileEditorState ? (TableFileEditorState)obj : null;
        String sessionName = state == null ? null : state.sessionName;
        BiConsumer<DataGrid, DataGridAppearance> configure = ((BiConsumer<DataGrid, DataGridAppearance>)DataGridUtil::configure).andThen(GridUtil::configureFullSizeTable).andThen(GridUtil::withFloatingPaging);
        this.myResultPanel = new EditorTableResultPanel(project, (GridDataHookUp)DbGridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this, sessionName), configure){

            @NotNull
            public String getDisplayName() {
                String string = DatabaseBundle.message((String)"editor.0", (Object[])new Object[]{DatabaseTableFileEditor.this.getFile().getPresentableName()});
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor$1", "getDisplayName"));
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myResultPanel);
        DataGridUtil.setupProgressIndicatingAuditor((DataGrid)this.myResultPanel);
        this.myLoadingManager = DataGridStartupActivity.DataEditorConfigurator.isSafeToLoadData((Project)project) ? new MyInstantLoadingManager() : new MyDelayedLoadingManager();
        this.myLoadingManager.onInit();
        this.headerComponent = DataGridUtil.addGridHeaderComponent((DataGrid)this.myResultPanel, this.myFile);
        this.myComponent = UiDataProvider.wrapComponent((JComponent)this.myResultPanel.getPanel(), sink -> sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"reference.table.editor"));
    }

    protected void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(3);
        }
        super.uiDataSnapshot(sink);
        DataGridUtil.uiDataSnapshot(sink, (DataGrid)this.myResultPanel);
    }

    @NotNull
    public JComponent getHeaderComponent() {
        JComponent jComponent = this.headerComponent;
        if (jComponent == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public DataGrid getDataGrid() {
        EditorTableResultPanel editorTableResultPanel = this.myResultPanel;
        if (editorTableResultPanel == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(6);
        }
        return editorTableResultPanel;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    public void dispose() {
        super.dispose();
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(8);
        }
        return navigatable instanceof OpenDataFileDescriptor;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(9);
        }
        if (!(navigatable instanceof OpenDataFileDescriptor)) {
            return;
        }
        OpenDataFileDescriptor descriptor2 = (OpenDataFileDescriptor)navigatable;
        descriptor2.setFilterAndLoadData(this.myLoadingManager, this.myResultPanel);
        DeferredLoader.doWhenLoaded((DataGrid)this.myResultPanel, () -> descriptor2.navigateTo((DataGrid)this.myResultPanel));
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(10);
        }
        if (level == FileEditorStateLevel.FULL) {
            TableFileEditorState state = new TableFileEditorState();
            this.updateColumnAttributes(state.columnAttributes);
            this.updateFilterState(state.filter);
            this.updateSortingState(state.mySorting);
            state.presentationMode = this.myResultPanel.getPresentationMode().name();
            this.updateExtractorFactoryState(state);
            state.transposed = this.getTransposedState();
            state.projectRestartId = DataGridStartupActivity.DataEditorConfigurator.getLaunchId((Project)this.getProject());
            GridPagingModel pageModel = this.myResultPanel.getDataHookup().getPageModel();
            state.pageSize = pageModel.pageSizeSet() ? pageModel.getPageSize() : -2;
            DataGridSessionClient client = DataGridUtil.getDataGridClient((DataGrid)this.myResultPanel);
            state.sessionName = client != null && SessionsUtil.needToSaveSessionName((DatabaseSession)client.getSession(), (DatabaseSessionClientWithFile)client) ? client.getSession().getTitle() : null;
            state.lastOpenedTimestamp = this.lastOpenedTimestamp;
            TableFileEditorState tableFileEditorState = state;
            if (tableFileEditorState == null) {
                DatabaseTableFileEditor.$$$reportNull$$$0(11);
            }
            return tableFileEditorState;
        }
        if (level == FileEditorStateLevel.NAVIGATION) {
            TableFileEditorLightState state = new TableFileEditorLightState();
            state.transposed = this.getTransposedState();
            TableFileEditorLightState tableFileEditorLightState = state;
            if (tableFileEditorLightState == null) {
                DatabaseTableFileEditor.$$$reportNull$$$0(12);
            }
            return tableFileEditorLightState;
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(13);
        }
        return fileEditorState;
    }

    private boolean getTransposedState() {
        return DatabaseSettings.getSettings().getAutoTransposeMode() == DataGridSettings.AutoTransposeMode.NEVER && this.myResultPanel.getResultView().isTransposed();
    }

    private void updateExtractorFactoryState(@NotNull TableFileEditorState state) {
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(14);
        }
        DataExtractorFactory globalFactory = DataExtractorProperties.getCurrentExtractorFactory((Project)this.myResultPanel.getProject(), GridUtil::suggestPlugin, (CsvFormatsSettings)CsvSettings.getSettings());
        DataExtractorFactory fileFactory = DataExtractorFactories.getExtractorFactory((CoreGrid)this.myResultPanel, GridUtil::suggestPlugin);
        state.extractorFactoryId = DataGridUtil.getDbms((DataGrid)this.myResultPanel).isMongo() && fileFactory.getId().equals("JSON-Groovy.json.groovy") || globalFactory.getId().equals(fileFactory.getId()) ? "" : fileFactory.getId();
    }

    private void updateSortingState(@NotNull TableFileEditorState.Sorting sortingState) {
        if (sortingState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(15);
        }
        sortingState.history.clear();
        GridSortingModel sortingModel = this.myResultPanel.getDataHookup().getSortingModel();
        if (sortingModel != null) {
            sortingState.history.addAll(sortingModel.getHistory());
            String sortingText = StringUtil.nullize((String)sortingModel.getAppliedSortingText(), (boolean)true);
            RowSortOrder.Type ordering = DatabaseSettings.getSettings().getDefaultTableOrdering();
            String generatedSortingText = DatabaseTableFileEditor.generateSortingText((DataGrid)this.myResultPanel, ordering);
            sortingState.text = !generatedSortingText.equals(sortingText) && !this.myResultPanel.getDataHookup().getSortingEmptyText().equals(sortingText) ? sortingText : null;
        }
    }

    private void updateFilterState(@NotNull TableFileEditorState.Filter filterState) {
        if (filterState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(16);
        }
        filterState.enabled = this.myResultPanel.isFilteringComponentShown();
        GridFilteringModel model = this.myResultPanel.getDataHookup().getFilteringModel();
        filterState.text = model == null ? "" : model.getFilterText();
        filterState.history.clear();
        if (model != null) {
            filterState.history.addAll(model.getHistory());
        }
    }

    private void updateColumnAttributes(@NotNull List<TableFileEditorState.Column> columnAttributes) {
        if (columnAttributes == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(17);
        }
        columnAttributes.clear();
        GridModel model = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        IntUnaryOperator column2View = this.myResultPanel.getRawIndexConverter().column2View();
        for (ModelIndex columnIdx : model.getColumnIndices().asIterable()) {
            GridColumn column = (GridColumn)model.getColumn(columnIdx);
            DataConsumer.Column c2 = (DataConsumer.Column)ObjectUtils.tryCast((Object)column, DataConsumer.Column.class);
            String columnName = column != null ? column.getName() : null;
            boolean enabled = this.myResultPanel.isColumnEnabled(columnIdx) || c2 == null || c2.getAttributes().contains(ColumnDescriptor.Attribute.HIDDEN) || c2.getAttributes().contains(ColumnDescriptor.Attribute.ROW_ID);
            Language contentLanguage = this.myResultPanel.getContentLanguage(columnIdx);
            int position = column2View.applyAsInt(columnIdx.value);
            DisplayType displayType = this.myResultPanel.getPureDisplayType(columnIdx);
            if (columnName == null || enabled && contentLanguage == Language.ANY && position == columnIdx.value && (displayType == BinaryDisplayType.DETECT || displayType == NumberDisplayType.NUMBER)) continue;
            TableFileEditorState.Column attributes = new TableFileEditorState.Column();
            attributes.name = columnName;
            attributes.enabled = enabled;
            attributes.languageId = contentLanguage.getID();
            attributes.position = TableFileEditorState.toSerializedPosition((int)position);
            attributes.binaryDisplayType = (BinaryDisplayType)ObjectUtils.tryCast((Object)displayType, BinaryDisplayType.class);
            attributes.numberDisplayType = (NumberDisplayType)ObjectUtils.tryCast((Object)displayType, NumberDisplayType.class);
            columnAttributes.add(attributes);
        }
    }

    public void setState(@NotNull FileEditorState state) {
        boolean transpose;
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(18);
        }
        TableFileEditorState s = (TableFileEditorState)ObjectUtils.tryCast((Object)state, TableFileEditorState.class);
        TableFileEditorLightState lightState = (TableFileEditorLightState)ObjectUtils.tryCast((Object)state, TableFileEditorLightState.class);
        DatabaseSettings settings = DatabaseSettings.getSettings();
        boolean bl = transpose = settings.getAutoTransposeMode() == DataGridSettings.AutoTransposeMode.ALWAYS;
        if (s != null) {
            int pageSize = s.lastOpenedTimestamp >= settings.getPageSizeUpdatedTimestamp() ? s.pageSize : DbImplUtil.getPageSize((Dbms)DataGridUtil.getDbms(this.getDataGrid()));
            this.myResultPanel.getDataHookup().getPageModel().setPageSize(pageSize);
            this.applyColumnAttributes(s.columnAttributes);
            this.applyFilterState(s);
            this.applySortingState(s);
            this.applyExtractorFactory(s.extractorFactoryId);
            this.applyPresentationMode(s.presentationMode);
            transpose |= s.transposed;
        } else if (lightState != null) {
            transpose |= lightState.transposed;
        }
        this.myResultPanel.getResultView().setTransposed(transpose);
        if (!this.stateWasSet && !OpenDataFileDescriptor.isDataLoadedByDescriptor(this.myFile)) {
            if (!DatabaseTableFileEditor.shouldRestoreOrderingText(s, this.getProject())) {
                this.setSortingText(DatabaseSettings.getSettings().getDefaultTableOrdering());
            }
            this.myLoadingManager.onEditorStateApplied();
        }
        this.stateWasSet = true;
    }

    private static boolean shouldRestoreOrderingText(@Nullable TableFileEditorState s, @NotNull Project project) {
        if (project == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(19);
        }
        return s != null && DatabaseTableFileEditor.shouldRestoreFilter(s, project) && s.mySorting != null && s.mySorting.text != null;
    }

    public static void setSortingText(@NotNull DataGrid grid, @NotNull String ordering) {
        GridSortingModel sortingModel;
        Document document;
        if (grid == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(20);
        }
        if (ordering == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(21);
        }
        Document document2 = document = (sortingModel = grid.getDataHookup().getSortingModel()) == null ? null : sortingModel.getDocument();
        if (document != null) {
            ApplicationManager.getApplication().runWriteAction(() -> document.setText((CharSequence)ordering));
        }
    }

    private void setSortingText(@NotNull RowSortOrder.Type ordering) {
        DasObject table;
        if (ordering == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(22);
        }
        if ((table = DataGridUtilCore.getDatabaseTable((CoreGrid)this.myResultPanel)) != null) {
            DatabaseTableFileEditor.setSortingText((DataGrid)this.myResultPanel, ordering);
            return;
        }
        DataGridUtil.doWhenDataSourceIsLoaded((CoreGrid<GridRow, GridColumn>)this.myResultPanel, () -> DatabaseTableFileEditor.setSortingText((DataGrid)this.myResultPanel, ordering));
    }

    public static void setSortingText(@NotNull DataGrid grid, @NotNull RowSortOrder.Type ordering) {
        if (grid == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(23);
        }
        if (ordering == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(24);
        }
        DatabaseTableFileEditor.setSortingText(grid, DatabaseTableFileEditor.generateSortingText(grid, ordering));
    }

    @NotNull
    private static String generateSortingText(@NotNull DataGrid grid, @NotNull RowSortOrder.Type ordering) {
        if (grid == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(25);
        }
        if (ordering == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(26);
        }
        if (ordering == RowSortOrder.Type.UNSORTED) {
            return "";
        }
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid)grid);
        return table == null ? "" : DatabaseTableFileEditor.generateSortingText(grid, ordering, DatabaseTableFileEditor.getColumnsForOrdering(table));
    }

    @NotNull
    public static String generateSortingText(@NotNull DataGrid grid, @NotNull RowSortOrder.Type ordering, @Nullable JBIterable<String> columnNames) {
        Document sortingDocument;
        if (grid == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(27);
        }
        if (ordering == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(28);
        }
        if (columnNames == null || columnNames.isEmpty()) {
            return "";
        }
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid)grid);
        if (table == null) {
            return "";
        }
        GridSortingModel sortingModel = grid.getDataHookup().getSortingModel();
        Document document = sortingDocument = sortingModel == null ? null : sortingModel.getDocument();
        if (sortingDocument == null) {
            return "";
        }
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)DataGridUtil.getDatabaseDialect(grid), (DasObject)table);
        List order = columnNames.map(name -> new Pair(name, (Object)ordering)).toList();
        DmlUtilKt.dmlGenerator((Dbms)DataGridUtil.getDbms(grid)).generate((DmlTask)DmlTaskKt.orderBy((ColumnsOrderBy)new ColumnsOrderBy(order)).build(builder));
        String statement2 = builder.getStatement();
        String string = StringUtil.isEmptyOrSpaces((String)statement2) ? "" : statement2;
        if (string == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    private static JBIterable<String> getColumnsForOrdering(@NotNull DasObject table) {
        JBIterable columns;
        Dbms dbms;
        if (table == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(30);
        }
        if ((dbms = DbImplUtilCore.getDbms((DasObject)table)).is(Dbms.MONGO)) {
            DasTypedObject idColumn = (DasTypedObject)table.getDasChildren(ObjectKind.COLUMN).find(column -> column instanceof DasTypedObject && "_id".equals(column.getName()));
            if (idColumn == null) {
                return null;
            }
            columns = JBIterable.of((Object)idColumn);
        } else {
            DasTableKey primaryKey = (DasTableKey)table.getDasChildren(ObjectKind.KEY).find(key -> key instanceof DasTableKey && ((DasTableKey)key).isPrimary());
            if (primaryKey == null) {
                return null;
            }
            columns = JBIterable.from((Iterable)primaryKey.getColumnsRef().resolveObjects());
        }
        if (columns.size() != 1) {
            return null;
        }
        boolean allColumnsAreNumbers = columns.find(column -> {
            Domain domain = DbImplUtil.getDomain((DasTypedObject)column);
            return domain == null || (!dbms.is(Dbms.MONGO) || !"ObjectId".equals(domain.simpleName())) && domain.getLogicType() != LogicalType.UNSIGNED_NUMBER && domain.getLogicType() != LogicalType.NUMBER && (domain.getLogicType() != LogicalType.FIXED_POINT_NUMBER || column.getDasType().toDataType().getScale() != 0);
        }) == null;
        return allColumnsAreNumbers ? JBIterable.from((Iterable)columns).map(column -> column.getName()) : null;
    }

    private void applyExtractorFactory(String extractorFactoryId) {
        if (extractorFactoryId == null || extractorFactoryId.isEmpty()) {
            return;
        }
        DataExtractorFactory extractorFactory = DataExtractorFactories.findById((String)extractorFactoryId, GridUtil::suggestPlugin, (CsvFormatsSettings)CsvSettings.getSettings());
        if (extractorFactory != null && extractorFactory.supportsText()) {
            DataExtractorFactories.setExtractorFactory((CoreGrid)this.myResultPanel, (DataExtractorFactory)extractorFactory);
        }
    }

    private void applyPresentationMode(String presentationMode) {
        if (presentationMode == null) {
            return;
        }
        try {
            GridPresentationMode mode = GridPresentationMode.valueOf((String)presentationMode);
            this.myResultPanel.setPresentationMode(mode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void applyColumnAttributes(@Nullable List<TableFileEditorState.Column> columnAttributes) {
        if (ContainerUtil.isEmpty(columnAttributes)) {
            return;
        }
        HashMap<String, EditorTableResultPanel.InitialColumnProperties> props = new HashMap<String, EditorTableResultPanel.InitialColumnProperties>(columnAttributes.size());
        for (TableFileEditorState.Column attributes : columnAttributes) {
            Language contentLanguage = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)attributes.languageId), (Object)Language.ANY);
            props.put(attributes.name, new EditorTableResultPanel.InitialColumnProperties(attributes.enabled, contentLanguage, attributes.position, (DisplayType)ObjectUtils.chooseNotNull((Object)attributes.binaryDisplayType, (Object)attributes.numberDisplayType)));
        }
        if (!props.isEmpty()) {
            this.myResultPanel.setInitialColumnProperties(props);
        }
    }

    private static boolean shouldRestoreFilter(@NotNull TableFileEditorState state, @NotNull Project project) {
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(31);
        }
        if (project == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(32);
        }
        return StringUtil.equals((CharSequence)state.projectRestartId, (CharSequence)DataGridStartupActivity.DataEditorConfigurator.getLaunchId((Project)project));
    }

    private void applySortingState(@NotNull TableFileEditorState state) {
        TableFileEditorState.Sorting sortingState;
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(33);
        }
        if ((sortingState = state.mySorting) == null) {
            return;
        }
        List history = sortingState.history != null ? sortingState.history : new ArrayList();
        GridSortingModel model = this.myResultPanel.getDataHookup().getSortingModel();
        if (model != null) {
            model.setHistory(history);
            if (DatabaseTableFileEditor.shouldRestoreOrderingText(state, this.getProject())) {
                DatabaseTableFileEditor.setSortingText((DataGrid)this.myResultPanel, sortingState.text);
            }
        }
    }

    private void applyFilterState(@NotNull TableFileEditorState state) {
        TableFileEditorState.Filter filterState;
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(34);
        }
        if ((filterState = state.filter) == null) {
            return;
        }
        List filterHistory = filterState.history != null ? filterState.history : new ArrayList();
        GridFilteringModel model = this.myResultPanel.getDataHookup().getFilteringModel();
        if (model != null) {
            model.setHistory(filterHistory);
        }
        if (!DatabaseTableFileEditor.shouldRestoreFilter(state, this.getProject())) {
            this.myResultPanel.setFilterText(this.getDataGrid().getDataHookup().getFilterEmptyText(), -1);
            return;
        }
        if (this.myResultPanel.isFilteringComponentShown() != filterState.enabled) {
            this.myResultPanel.toggleFilteringComponent();
        }
        this.myResultPanel.setFilterText(filterState.text, -1);
        if (StringUtil.isNotEmpty((String)filterState.text)) {
            this.myResultPanel.setIgnoreCurrentFilterText(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11, 12, 13, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 14: 
            case 18: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterState";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnAttributes";
                break;
            }
            case 20: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSortingText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateExtractorFactoryState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateSortingState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateFilterState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateColumnAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreOrderingText";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setSortingText";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generateSortingText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getColumnsForOrdering";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreFilter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "applySortingState";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "applyFilterState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11, 12, 13, 29 -> new IllegalStateException(string);
        };
    }

    private class MyInstantLoadingManager
    implements LoadingManager {
        private MyInstantLoadingManager() {
        }

        @Override
        public void onInit() {
        }

        @Override
        public void onEditorStateApplied() {
            DeferredLoader.installOn((DataGrid)DatabaseTableFileEditor.this.myResultPanel);
        }

        @Override
        public void reload() {
            DeferredLoader.installOn((DataGrid)DatabaseTableFileEditor.this.myResultPanel);
        }
    }

    static interface LoadingManager {
        public void onInit();

        public void onEditorStateApplied();

        public void reload();
    }

    private final class MyDelayedLoadingManager
    implements LoadingManager {
        private MyDelayedLoadingManager() {
        }

        @Override
        public void onInit() {
            DataGridStartupActivity.DataEditorConfigurator.delayLoading((DataGrid)DatabaseTableFileEditor.this.myResultPanel);
        }

        @Override
        public void onEditorStateApplied() {
        }

        @Override
        public void reload() {
            DataGridStartupActivity.DataEditorConfigurator.disableLoadingDelay((DataGrid)DatabaseTableFileEditor.this.myResultPanel);
            DeferredLoader.installOn((DataGrid)DatabaseTableFileEditor.this.myResultPanel);
        }
    }

    private static final class DeferredLoader
    implements Disposable,
    Activatable {
        private static final Map<DatabaseTableGridDataHookUp, DeferredLoader> LOADERS = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        @NotNull
        private final DataGridSessionClient mySession;
        private final DataGrid myGrid;
        private final ActionCallback myInitialLoadCallback;
        private LoadingState myState;

        private DeferredLoader(@NotNull DataGridSessionClient session, @NotNull DataGrid grid) {
            if (session == null) {
                DeferredLoader.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(1);
            }
            this.myInitialLoadCallback = new ActionCallback();
            this.myState = LoadingState.NONE;
            this.mySession = session;
            this.myGrid = grid;
            Disposer.register((Disposable)this.mySession, (Disposable)this);
            Disposer.register((Disposable)grid, (Disposable)UiNotifyConnector.Once.installOn((Component)grid.getPanel().getComponent(), (Activatable)this));
        }

        public static void installOn(@NotNull DataGrid grid) {
            DataGridSessionClient client;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(2);
            }
            if (!LOADERS.containsKey((Object)(client = DeferredLoader.getTableHookUp(grid)))) {
                LOADERS.put(client, new DeferredLoader(client, grid));
            }
        }

        public static void doWhenLoaded(@NotNull DataGrid grid, @NotNull Runnable action) {
            DeferredLoader loader;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(3);
            }
            if (action == null) {
                DeferredLoader.$$$reportNull$$$0(4);
            }
            ActionCallback callback = (loader = LOADERS.get((Object)DeferredLoader.getTableHookUp(grid))) == null ? ActionCallback.DONE : loader.myInitialLoadCallback;
            callback.doWhenDone((Runnable)new DoWhenLoadedActionWrapper(grid, action));
        }

        @NotNull
        private static DataGridSessionClient getTableHookUp(@NotNull DataGrid grid) {
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(5);
            }
            DataGridSessionClient dataGridSessionClient = (DataGridSessionClient)grid.getDataHookup();
            if (dataGridSessionClient == null) {
                DeferredLoader.$$$reportNull$$$0(6);
            }
            return dataGridSessionClient;
        }

        public void showNotify() {
            if (this.myState != LoadingState.NONE) {
                return;
            }
            this.myState = LoadingState.INITIATED;
            DataGridUtil.setProgressMessage(this.myGrid, DatabaseBundle.message((String)"DataView.connecting", (Object[])new Object[0]));
            this.mySession.getProject().getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, o -> this.update());
            this.update();
        }

        private void update() {
            DbElement element;
            VirtualFile file = this.mySession.getVirtualFile();
            DbElement dbElement = element = file.isValid() ? DbImplUtilCore.findElement((Project)this.mySession.getProject(), (VirtualFile)file) : null;
            if (element == null) {
                return;
            }
            if (this.myState != LoadingState.COMPLETED && DatabaseEditorHelper.isTableDataAvailable(element)) {
                this.myState = LoadingState.COMPLETED;
                this.loadTable();
            }
        }

        private void loadTable() {
            final GridRequestSource initialLoadSource = new GridRequestSource((GridRequestSource.RequestPlace)(this.myGrid == null ? null : new DataGridRequestPlace((CoreGrid)this.myGrid)));
            Disposable initialLoadDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)initialLoadDisposable);
            this.mySession.addRequestListener((GridDataHookUp.RequestListener)new GridDataHookUp.RequestListener<GridRow, GridColumn>(){
                private String myErrorMessage;

                public void error(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (errorInfo == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (initialLoadSource == source) {
                        this.myErrorMessage = errorInfo.getMessage();
                    }
                }

                public void updateCountReceived(@NotNull GridRequestSource source, int updateCount) {
                    if (source == null) {
                        1.$$$reportNull$$$0(2);
                    }
                }

                public void requestFinished(@NotNull GridRequestSource source, boolean success) {
                    if (source == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (initialLoadSource == source) {
                        if (!success) {
                            myInitialLoadCallback.reject(this.myErrorMessage);
                        } else {
                            myInitialLoadCallback.setDone();
                        }
                        Disposer.dispose((Disposable)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "source";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorInfo";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "error";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateCountReceived";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "requestFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, initialLoadDisposable);
            this.mySession.getLoader().loadFirstPage(initialLoadSource);
        }

        public void dispose() {
            LOADERS.remove((Object)this.mySession);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableHookUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "installOn";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doWhenLoaded";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableHookUp";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }

        static enum LoadingState {
            NONE,
            INITIATED,
            COMPLETED;

        }

        private static class DoWhenLoadedActionWrapper
        implements Runnable,
        Disposable {
            private Runnable myAction;

            DoWhenLoadedActionWrapper(@NotNull DataGrid grid, @NotNull Runnable action) {
                if (grid == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(0);
                }
                if (action == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(1);
                }
                this.myAction = action;
                Disposer.register((Disposable)grid, (Disposable)this);
            }

            public void dispose() {
                this.myAction = null;
            }

            @Override
            public void run() {
                try {
                    if (this.myAction != null) {
                        this.myAction.run();
                    }
                }
                finally {
                    this.myAction = null;
                    Disposer.dispose((Disposable)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "grid";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$DoWhenLoadedActionWrapper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

