/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbeTierUtilCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.RenameQueryGenerator;
import com.intellij.database.view.structure.DvHandlers;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DbRenameHandler.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = PsiElementRenameHandler.getElement((DataContext)dataContext);
        DbElement dbElement = DbRenamePsiElementProcessor.getDbElement(psiElement);
        BasicNode node = DatabaseContextFun.getSelectedSingleNode(dataContext);
        return node instanceof DvSimpleDsGroup || dbElement != null && !DbRenameHandler.isVetoedElement(dbElement);
    }

    public static boolean isVetoedElement(@NotNull DbElement dbElement) {
        if (dbElement == null) {
            DbRenameHandler.$$$reportNull$$$0(1);
        }
        if (dbElement instanceof DbDataSource) {
            return false;
        }
        if (DataImporter.isBusy(dbElement)) {
            return true;
        }
        if (DbSqlUtil.isSqlElement((DbElement)dbElement)) {
            return false;
        }
        if (DbeTierUtilCore.isFreeTier()) {
            return true;
        }
        BasicNamedElement element = (BasicNamedElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicNamedElement.class);
        BasicModel model = element == null ? null : element.getModel();
        return model == null || !RenameQueryGenerator.canRename(model, element);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        DvSimpleDsGroup group;
        String initialName;
        String newName;
        PsiElement psiElement;
        BasicElement element;
        BasicNode node;
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            return;
        }
        if (DatabaseContextFun.fromDatabaseTree(dataContext)) {
            BasicElement e;
            node = DatabaseContextFun.getSelectedSingleNode(dataContext);
            element = node instanceof BasicElement ? (e = (BasicElement)node) : null;
            DatabaseNodeWrappingService wrappingService = (DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class);
            psiElement = wrappingService.wrap(node);
        } else {
            BasicElement e;
            psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            DbElement dbElement = DbRenamePsiElementProcessor.getDbElement(psiElement);
            Object delegate = dbElement != null ? dbElement.getDelegate() : null;
            element = delegate instanceof BasicElement ? (e = (BasicElement)delegate) : null;
            node = DatabaseContextFun.getSelectedSingleNode(dataContext);
        }
        if (element != null && psiElement != null) {
            RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{psiElement}, dataContext);
        } else if (node instanceof DataSourceNode) {
            String newName2;
            DataSourceNode dsn = (DataSourceNode)node;
            RawDataSource ds = dsn.dataSource;
            String initialName2 = ds.getName();
            String newText = Messages.showInputDialog((Project)project, (String)DatabaseBundle.message((String)"dialog.message.rename.data.source.to", (Object[])new Object[]{initialName2}), (String)DatabaseBundle.message((String)"dialog.title.rename", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)initialName2, null);
            int idx = newText == null ? -1 : newText.lastIndexOf("/");
            String groupName = idx < 0 ? null : newText.substring(0, idx);
            String string = newName2 = idx < 0 ? newText : newText.substring(idx + 1);
            if (StringUtil.isNotEmpty((String)newName2)) {
                DbRenameHandler.renameDataSource(project, dsn, groupName, newName2);
            }
        } else if (node instanceof DvSimpleDsGroup && StringUtil.isNotEmpty((String)(newName = DbRenameHandler.askForNewName(project, initialName = (group = (DvSimpleDsGroup)node).getName())))) {
            DvHandlers.renameDsGroup(project, group, newName, this.getClass());
        }
    }

    private static void renameDataSource(@NotNull Project project, @NotNull DataSourceNode dsn, @Nullable String groupName, @NotNull String newName) {
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(3);
        }
        if (dsn == null) {
            DbRenameHandler.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            DbRenameHandler.$$$reportNull$$$0(5);
        }
        DbModelRegistry registry = (DbModelRegistry)project.getService(DbModelRegistry.class);
        DbDataSource dbDataSource = registry.findDbDataSource(dsn);
        if (groupName != null && dbDataSource instanceof DbDataSourceImpl) {
            DbDataSourceImpl dbDataSourceImpl = (DbDataSourceImpl)dbDataSource;
            dbDataSourceImpl.getDbManager().setGroupName(dsn.dataSource, groupName);
        }
        dbDataSource.setName(newName);
        DatabaseView.refreshViewAndSelect(project, Collections.singleton(dsn));
    }

    @Nullable
    private static String askForNewName(@NotNull Project project, String initialName) {
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(6);
        }
        String newName = Messages.showInputDialog((Project)project, (String)DatabaseBundle.message((String)"dialog.message.rename.group.to", (Object[])new Object[]{initialName}), (String)DatabaseBundle.message((String)"dialog.title.rename", (Object[])new Object[0]), null, (String)initialName, null);
        return newName;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(7);
        }
        if (elements == null) {
            DbRenameHandler.$$$reportNull$$$0(8);
        }
        this.invoke(project, null, null, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isVetoedElement";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renameDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "askForNewName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class DatabaseVetoRenameCondition
    implements Condition<PsiElement> {
        public boolean value(PsiElement element) {
            return element instanceof DbElement && DbRenameHandler.isVetoedElement((DbElement)element);
        }
    }
}

