/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.fus.NodeInterpreterAndPackageManagerStateUsagesCollectorKt;
import com.intellij.javascript.nodejs.interpreter.fus.NodeInterpreterTypeValidator;
import com.intellij.javascript.nodejs.interpreter.fus.NvmrcStatus;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.util.text.SemVer;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/fus/NodeInterpreterAndPackageManagerStateUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "interpreterTypeField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "interpreterEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "Lcom/intellij/openapi/util/Version;", "nvmrcEvent", "packageManagerNameField", "packageManagerResolvedField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "packageManagerVersionField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "yarnPnpField", "packageManagerEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.backend"})
public final class NodeInterpreterAndPackageManagerStateUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("node.js.interpreter.and.package.manager.state", 3, null, 4, null);
    @NotNull
    private final StringEventField interpreterTypeField = EventFields.StringValidatedByCustomRule((String)"type", NodeInterpreterTypeValidator.class);
    @NotNull
    private final EventId3<Boolean, String, Version> interpreterEvent = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"interpreter", (EventField)((EventField)EventFields.Boolean((String)"is_node_from_path")), (EventField)((EventField)this.interpreterTypeField), (EventField)((EventField)EventFields.VersionByObject), null, (int)16, null);
    @NotNull
    private final EventId3<Boolean, Boolean, Boolean> nvmrcEvent = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"nvmrc", (EventField)((EventField)EventFields.Boolean((String)"project_interpreter_uses_node_from_path")), (EventField)((EventField)EventFields.Boolean((String)"project_interpreter_and_nvmrc_have_same_version")), (EventField)((EventField)EventFields.Boolean((String)"nvmrc_version_installed")), null, (int)16, null);
    @NotNull
    private final StringEventField packageManagerNameField = EventFields.String((String)"name", NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPACKAGE_MANAGERS());
    @NotNull
    private final BooleanEventField packageManagerResolvedField = EventFields.Boolean((String)"resolved");
    @NotNull
    private final PrimitiveEventField<Version> packageManagerVersionField = EventFields.VersionByObject;
    @NotNull
    private final BooleanEventField yarnPnpField = EventFields.Boolean((String)"yarn_pnp");
    @NotNull
    private final VarargEventId packageManagerEvent;

    public NodeInterpreterAndPackageManagerStateUsagesCollector() {
        EventField[] eventFieldArray = new EventField[]{this.packageManagerNameField, this.packageManagerResolvedField, this.packageManagerVersionField, this.yarnPnpField};
        this.packageManagerEvent = this.GROUP.registerVarargEvent("package.manager", eventFieldArray);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        NodeJsInterpreter interpreter2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set result2 = new HashSet();
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterManager.getInstance(project).getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        NodeJsInterpreterRef interpreterRef = nodeJsInterpreterRef;
        NodeJsInterpreter nodeJsInterpreter = interpreter2 = interpreterRef.resolve(project);
        SemVer interpreterVersion = nodeJsInterpreter != null ? NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getVersionSync(nodeJsInterpreter, project) : null;
        result2.add(this.interpreterEvent.metric((Object)NodeJsLocalInterpreterType.isNodeFromPathRef(interpreterRef), (Object)NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getTypeId(interpreter2), (Object)NodeInterpreterAndPackageManagerStateUsagesCollectorKt.toVersion(interpreterVersion)));
        NodeJsLocalInterpreterManager.NodeVersionFileInfo nvmrcFileInfo = NodeJsLocalInterpreterManager.findNodeVersionFileInfo(project);
        if (nvmrcFileInfo != null) {
            NvmrcStatus status = NodeInterpreterAndPackageManagerStateUsagesCollectorKt.access$getNvmrcStatus(nvmrcFileInfo, interpreterVersion, project);
            result2.add(this.nvmrcEvent.metric((Object)NodeJsLocalInterpreterType.isNodeFromPathRef(interpreterRef), (Object)status.getMatched(), (Object)status.getInstalled()));
        }
        NpmManager npmManager = NpmManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)npmManager, (String)"getInstance(...)");
        NpmManager npmManager2 = npmManager;
        NodePackageRef nodePackageRef = npmManager2.getPackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
        String packageManagerName = NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerName(nodePackageRef);
        NodePackage packageManagerPkg = npmManager2.getPackage(interpreter2);
        SemVer packageManagerVersion = NodeInterpreterAndPackageManagerStateUsagesCollectorKt.access$getPackageManagerVersion(interpreter2, packageManagerPkg, project);
        boolean yarnPnP = YarnPnpManager.getInstance(project).hasPnpFiles();
        EventPair[] eventPairArray = new EventPair[]{new EventPair((EventField)this.packageManagerNameField, (Object)packageManagerName), new EventPair((EventField)this.packageManagerResolvedField, (Object)(packageManagerPkg != null ? 1 : 0)), new EventPair((EventField)this.packageManagerVersionField, (Object)NodeInterpreterAndPackageManagerStateUsagesCollectorKt.toVersion(packageManagerVersion)), new EventPair((EventField)this.yarnPnpField, (Object)yarnPnP)};
        result2.add(this.packageManagerEvent.metric(eventPairArray));
        return result2;
    }
}

