/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.codeInsight;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsGeneratorUtils {
    private JsGeneratorUtils() {
    }

    public static void generateProperty(@NotNull JSObjectLiteralExpression objectLiteralExpression, @NotNull GenerateActionContext context2, @NotNull String markedPropertyStr) {
        boolean generateCommaAfter;
        PsiElement precedingAnchor;
        if (objectLiteralExpression == null) {
            JsGeneratorUtils.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JsGeneratorUtils.$$$reportNull$$$0(1);
        }
        if (markedPropertyStr == null) {
            JsGeneratorUtils.$$$reportNull$$$0(2);
        }
        if ((precedingAnchor = objectLiteralExpression.getFirstChild()) == null) {
            return;
        }
        int caretOffset = context2.getDocumentCaretOffset();
        JSProperty precedingProperty = JsGeneratorUtils.findPrecedingProperty(objectLiteralExpression, caretOffset);
        JSProperty followingProperty = JsGeneratorUtils.findFollowingProperty(objectLiteralExpression, caretOffset);
        boolean generateCommaBefore = false;
        boolean bl = generateCommaAfter = followingProperty != null;
        if (precedingProperty != null) {
            precedingAnchor = precedingProperty;
            PsiElement comma = JsGeneratorUtils.findNextSiblingComma((PsiElement)precedingProperty);
            boolean bl2 = generateCommaBefore = comma == null;
            if (comma != null) {
                precedingAnchor = comma;
            }
        }
        TextRange whitespaceTextRange = JsGeneratorUtils.unionFollowingWhitespaceTextRanges(precedingAnchor);
        JsGeneratorUtils.generateProperty(context2, markedPropertyStr, whitespaceTextRange, generateCommaBefore, generateCommaAfter);
    }

    private static void generateProperty(@NotNull GenerateActionContext context2, @NotNull String markedPropertyStr, @NotNull TextRange whitespaceTextRange, boolean commaBeforeRequired, boolean commaAfterRequired) {
        int caretOffset;
        boolean insideWhitespaceArea;
        int moveCaretToOffset;
        if (context2 == null) {
            JsGeneratorUtils.$$$reportNull$$$0(3);
        }
        if (markedPropertyStr == null) {
            JsGeneratorUtils.$$$reportNull$$$0(4);
        }
        if (whitespaceTextRange == null) {
            JsGeneratorUtils.$$$reportNull$$$0(5);
        }
        int n = moveCaretToOffset = (insideWhitespaceArea = whitespaceTextRange.contains(caretOffset = context2.getDocumentCaretOffset())) ? caretOffset : whitespaceTextRange.getStartOffset();
        if (commaBeforeRequired) {
            JsGeneratorUtils.generateCommaAt(context2, whitespaceTextRange.getStartOffset());
            ++moveCaretToOffset;
        }
        context2.getCaretModel().moveToOffset(moveCaretToOffset);
        LineRange whitespaceLineRange = JsGeneratorUtils.createLineRangeByTextRange(context2, whitespaceTextRange);
        int caretLineNumber = JsGeneratorUtils.getLineNumberAtOffset(context2, moveCaretToOffset);
        String leadingNewLine = "";
        if (caretLineNumber == whitespaceLineRange.getStartLine()) {
            leadingNewLine = "\n";
        }
        Template template = JsGeneratorUtils.createDefaultTemplate(leadingNewLine + markedPropertyStr);
        if (commaAfterRequired) {
            template.addTextSegment(",");
        }
        if (whitespaceLineRange.getStartLine() == whitespaceLineRange.getEndLine()) {
            template.addTextSegment("\n");
        }
        context2.startTemplate(template);
    }

    private static void generateCommaAt(@NotNull GenerateActionContext context2, int offset) {
        if (context2 == null) {
            JsGeneratorUtils.$$$reportNull$$$0(6);
        }
        context2.getCaretModel().moveToOffset(offset);
        Template template = JsGeneratorUtils.createDefaultTemplate(",");
        context2.startTemplate(template);
    }

    @Nullable
    private static JSProperty findPrecedingProperty(@NotNull JSObjectLiteralExpression objectLiteralExpression, int caretOffset) {
        if (objectLiteralExpression == null) {
            JsGeneratorUtils.$$$reportNull$$$0(7);
        }
        JSProperty[] properties2 = JsPsiUtils.getProperties(objectLiteralExpression);
        JSProperty preceding = null;
        for (JSProperty currentProperty : properties2) {
            int currentPropertyStartOffset = currentProperty.getTextRange().getStartOffset();
            int currentPropertyEndOffset = currentProperty.getTextRange().getEndOffset();
            if (currentPropertyStartOffset < caretOffset && caretOffset < currentPropertyEndOffset) {
                return currentProperty;
            }
            if (currentPropertyEndOffset > caretOffset || preceding != null && preceding.getTextRange().getEndOffset() >= currentPropertyEndOffset) continue;
            preceding = currentProperty;
        }
        return preceding;
    }

    @Nullable
    private static JSProperty findFollowingProperty(@NotNull JSObjectLiteralExpression objectLiteralExpression, int caretOffset) {
        if (objectLiteralExpression == null) {
            JsGeneratorUtils.$$$reportNull$$$0(8);
        }
        JSProperty[] properties2 = JsPsiUtils.getProperties(objectLiteralExpression);
        JSProperty following = null;
        for (JSProperty property : properties2) {
            int startOffset = property.getTextRange().getStartOffset();
            if (caretOffset > startOffset || following != null && startOffset >= following.getTextRange().getStartOffset()) continue;
            following = property;
        }
        return following;
    }

    @Nullable
    public static PsiElement findNextSiblingComma(@NotNull PsiElement precedingAnchor) {
        if (precedingAnchor == null) {
            JsGeneratorUtils.$$$reportNull$$$0(9);
        }
        PsiElement next = precedingAnchor.getNextSibling();
        while (next instanceof ASTNode) {
            ASTNode node = (ASTNode)next;
            IElementType elementType = node.getElementType();
            if (elementType == JSTokenTypes.COMMA) {
                return next;
            }
            if (elementType != JSTokenTypes.WHITE_SPACE) break;
            next = next.getNextSibling();
        }
        return null;
    }

    @NotNull
    private static TextRange unionFollowingWhitespaceTextRanges(@NotNull PsiElement element2) {
        int startOffset;
        if (element2 == null) {
            JsGeneratorUtils.$$$reportNull$$$0(10);
        }
        int endOffset = startOffset = element2.getTextRange().getEndOffset();
        for (PsiElement e = element2.getNextSibling(); e != null && JsPsiUtils.isElementOfType(e, JSTokenTypes.WHITE_SPACE); e = e.getNextSibling()) {
            endOffset = e.getTextRange().getEndOffset();
        }
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            JsGeneratorUtils.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    public static void generateObjectLiteralWithPropertyAsArgument(@NotNull GenerateActionContext context2, @NotNull String markedPropertyStr, @NotNull JSArgumentList argumentList, int addAtPosition) {
        PsiElement precedingElement;
        JSExpression[] expressions;
        if (context2 == null) {
            JsGeneratorUtils.$$$reportNull$$$0(12);
        }
        if (markedPropertyStr == null) {
            JsGeneratorUtils.$$$reportNull$$$0(13);
        }
        if (argumentList == null) {
            JsGeneratorUtils.$$$reportNull$$$0(14);
        }
        if ((expressions = JsPsiUtils.getArguments(argumentList)).length < addAtPosition) {
            return;
        }
        Object object = precedingElement = addAtPosition == 0 ? argumentList.getFirstChild() : expressions[addAtPosition - 1];
        if (precedingElement == null) {
            return;
        }
        PsiElement comma = JsGeneratorUtils.findNextSiblingComma(precedingElement);
        if (comma != null) {
            precedingElement = comma;
        }
        context2.getCaretModel().moveToOffset(precedingElement.getTextRange().getEndOffset());
        String leadingPrefix = comma == null && addAtPosition != 0 ? "," : "";
        Template template = JsGeneratorUtils.createDefaultTemplate(leadingPrefix + markedPropertyStr);
        context2.startTemplate(template);
    }

    public static int findSuitableOffsetForNewStatement(@NotNull PsiElement psiElement, int caretOffset) {
        if (psiElement == null) {
            JsGeneratorUtils.$$$reportNull$$$0(15);
        }
        for (PsiElement parent = psiElement.getParent(); parent != null && !(parent instanceof JSBlockStatement) && !(parent instanceof PsiFile); parent = parent.getParent()) {
            psiElement = parent;
        }
        if (JsPsiUtils.isElementOfType(psiElement, JSTokenTypes.RBRACE)) {
            return psiElement.getTextRange().getStartOffset();
        }
        TextRange whitespaceTextRange = JsPsiUtils.isElementOfType(psiElement, JSTokenTypes.WHITE_SPACE) ? psiElement.getTextRange() : JsGeneratorUtils.unionFollowingWhitespaceTextRanges(psiElement);
        if (whitespaceTextRange.containsOffset(caretOffset)) {
            return caretOffset;
        }
        return whitespaceTextRange.getStartOffset();
    }

    @NotNull
    public static Template createDefaultTemplate(@Nullable String markedText) {
        TemplateImpl template = new TemplateImpl("", "");
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        template.setInline(false);
        JsGeneratorUtils.fillTemplateWithMarkedText((Template)template, markedText);
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            JsGeneratorUtils.$$$reportNull$$$0(16);
        }
        return templateImpl;
    }

    public static void fillTemplateWithMarkedText(@NotNull Template template, @Nullable String markedText) {
        if (template == null) {
            JsGeneratorUtils.$$$reportNull$$$0(17);
        }
        if (markedText == null) {
            return;
        }
        Pattern p = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher m = p.matcher(markedText);
        int startInd = 0;
        do {
            boolean variableFound;
            String plainText = (variableFound = m.find()) ? markedText.substring(startInd, m.start()) : markedText.substring(startInd);
            JsGeneratorUtils.fillTemplateWithPlainText(template, plainText);
            if (variableFound) {
                String variableName = m.group(1);
                template.addVariable(variableName.replaceAll(" ", "_"), (Expression)new ConstantNode(variableName), (Expression)new ConstantNode(variableName), true);
                startInd = m.end();
                continue;
            }
            startInd = markedText.length();
        } while (startInd < markedText.length());
    }

    private static void fillTemplateWithPlainText(Template template, String plaintText) {
        int endInd;
        int startInd = 0;
        do {
            int caretIndex;
            String txt;
            if (!(txt = plaintText.substring(startInd, endInd = (caretIndex = plaintText.indexOf(124, startInd)) >= 0 ? caretIndex : plaintText.length())).isEmpty()) {
                template.addTextSegment(txt);
            }
            if (caretIndex < 0) continue;
            template.addEndVariable();
        } while ((startInd = endInd + 1) < plaintText.length());
    }

    private static int getLineNumberAtOffset(GenerateActionContext context2, int offset) {
        return context2.getDocument().getLineNumber(offset);
    }

    private static LineRange createLineRangeByTextRange(GenerateActionContext context2, TextRange textRange) {
        return new LineRange(JsGeneratorUtils.getLineNumberAtOffset(context2, textRange.getStartOffset()), JsGeneratorUtils.getLineNumberAtOffset(context2, textRange.getEndOffset()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteralExpression";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markedPropertyStr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whitespaceTextRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "precedingAnchor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/codeInsight/JsGeneratorUtils";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unionFollowingWhitespaceTextRanges";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateCommaAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPrecedingProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFollowingProperty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findNextSiblingComma";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unionFollowingWhitespaceTextRanges";
                break;
            }
            case 11: 
            case 16: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateObjectLiteralWithPropertyAsArgument";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableOffsetForNewStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillTemplateWithMarkedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 16 -> new IllegalStateException(string);
        };
    }

    private static final class LineRange {
        private final int myStartLine;
        private final int myEndLine;

        private LineRange(int startLine, int endLine) {
            this.myStartLine = startLine;
            this.myEndLine = endLine;
        }

        public int getStartLine() {
            return this.myStartLine;
        }

        public int getEndLine() {
            return this.myEndLine;
        }
    }
}

