/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ReferenceExpressionsInfo {
    public static final ES6ReferenceExpressionsInfo EMPTY = new ES6ReferenceExpressionsInfo(ContainerUtil.emptyList(), ContainerUtil.emptyList(), new HashMap<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement>(), Collections.emptyMap());
    @NotNull
    private final Collection<PsiElement> myLocals;
    @NotNull
    private final Collection<PsiElement> myExportedLocals;
    @NotNull
    private final Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> myImports;
    @NotNull
    private final Map<PsiElement, String> myUnresolvedImports;

    private ES6ReferenceExpressionsInfo(@NotNull Collection<PsiElement> locals, @NotNull Collection<PsiElement> exportedLocals, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Map<PsiElement, String> unresolvedImports) {
        if (locals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(0);
        }
        if (exportedLocals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(1);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(2);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(3);
        }
        this.myLocals = locals;
        this.myExportedLocals = exportedLocals;
        this.myImports = imports;
        this.myUnresolvedImports = unresolvedImports;
    }

    @NotNull
    public Collection<PsiElement> getLocalReferencedElements() {
        Collection<PsiElement> collection = this.myLocals;
        if (collection == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> getReferencedImports() {
        Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> map2 = this.myImports;
        if (map2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    public Collection<PsiElement> getExportedLocalReferencedElements() {
        Collection<PsiElement> collection = this.myExportedLocals;
        if (collection == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public static void addValidations(@NotNull ES6ReferenceExpressionsInfo info, @NotNull JSPsiElementBase element2, @NotNull Condition<? super PsiElement> excludedFilter, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (info == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(8);
        }
        if (excludedFilter == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(9);
        }
        if (conflicts == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(10);
        }
        String elementDescription = RefactoringUIUtil.getDescription((PsiElement)element2, (boolean)false);
        for (Map.Entry<PsiElement, String> unresolvedImport : info.myUnresolvedImports.entrySet()) {
            String message = JavaScriptBundle.message((String)"es6.move.module.members.references.unresolved.import.message", (Object[])new Object[]{elementDescription, unresolvedImport.getValue()});
            conflicts.putValue((Object)unresolvedImport.getKey(), (Object)message);
        }
        for (PsiElement referencedElement : info.getLocalReferencedElements()) {
            if (excludedFilter.value((Object)referencedElement)) continue;
            String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)false);
            String message = JavaScriptBundle.message((String)"es6.move.module.members.references.local.message", (Object[])new Object[]{elementDescription, referencedDescription});
            conflicts.putValue((Object)referencedElement, (Object)message);
        }
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(11);
        }
        return ES6ReferenceExpressionsInfo.getInfo(element2, (TextRange)null);
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element2, @Nullable TextRange range) {
        if (element2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(12);
        }
        return ES6ReferenceExpressionsInfo.getInfo(element2, range, ES6ReferenceExpressionsInfo.findExternalModule(element2, false));
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element2, @Nullable PsiElement module) {
        if (element2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(13);
        }
        return ES6ReferenceExpressionsInfo.getInfo(element2, null, module);
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(@NotNull PsiElement element2, @Nullable TextRange textRange, @Nullable PsiElement module) {
        if (element2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(14);
        }
        return ES6ReferenceExpressionsInfo.getInfoForRange(element2, element2, textRange, module);
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfoForRange(@NotNull PsiElement first, @NotNull PsiElement last) {
        if (first == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(15);
        }
        if (last == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(16);
        }
        return ES6ReferenceExpressionsInfo.getInfoForRange(first, last, null, ES6ReferenceExpressionsInfo.findExternalModule(first, false));
    }

    @NotNull
    private static ES6ReferenceExpressionsInfo getInfoForRange(final @NotNull PsiElement first, final @NotNull PsiElement last, final @Nullable TextRange textRange, final @Nullable PsiElement module) {
        if (first == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(17);
        }
        if (last == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(18);
        }
        if (module == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                ES6ReferenceExpressionsInfo.$$$reportNull$$$0(19);
            }
            return eS6ReferenceExpressionsInfo;
        }
        final LinkedHashSet<PsiElement> locals = new LinkedHashSet<PsiElement>();
        final LinkedHashSet<PsiElement> exportedLocals = new LinkedHashSet<PsiElement>();
        final Ref containsJsx = new Ref((Object)Boolean.FALSE);
        final LinkedHashMap<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports = new LinkedHashMap<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement>();
        final LinkedHashMap<PsiElement, String> unresolvedImports = new LinkedHashMap<PsiElement, String>();
        JSRecursiveWalkingElementVisitor visitor = new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSReferenceExpression(node);
                if (node.getQualifier() != null) {
                    return;
                }
                if (textRange != null && !textRange.contains(node.getTextRange())) {
                    return;
                }
                String referenceName = node.getCanonicalText();
                if (StringUtil.isEmpty((String)referenceName)) {
                    return;
                }
                this.processReference((PsiPolyVariantReference)node, referenceName);
            }

            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitJSLiteralExpression(node);
                if (!(node instanceof JSXXmlLiteralExpressionImpl)) {
                    return;
                }
                JSXXmlLiteralExpressionImpl xmlLiteral = (JSXXmlLiteralExpressionImpl)node;
                if (textRange != null && !textRange.contains(node.getTextRange())) {
                    return;
                }
                containsJsx.set((Object)Boolean.TRUE);
                PsiPolyVariantReference topLevelReference = JSXResolveUtil.getTopLevelReference((JSXmlLiteralExpression)xmlLiteral);
                if (topLevelReference == null) {
                    return;
                }
                String referenceName = topLevelReference.getCanonicalText();
                if (StringUtil.isEmpty((String)referenceName)) {
                    return;
                }
                this.processReference(topLevelReference, referenceName);
            }

            private void processReference(@NotNull PsiPolyVariantReference reference, @NotNull String referenceName) {
                PsiElement localElement;
                if (reference == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (referenceName == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((localElement = JSDialectSpecificHandlersFactory.forElement((PsiElement)reference.getElement()).resolveLimited(reference, referenceName)) == null) {
                    return;
                }
                this.processResolvedElement(referenceName, localElement);
            }

            private void processResolvedElement(@NotNull String referenceName, @NotNull PsiElement resultElement) {
                PsiElement resultModule;
                if (referenceName == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (resultElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (module.isEquivalentTo(resultModule = ES6ReferenceExpressionsInfo.findExternalModule(resultElement, true))) {
                    if (resultElement instanceof ES6ImportedBinding || resultElement instanceof ES6ImportSpecifierAlias || resultElement instanceof ES6ImportSpecifier || 1.isVariableWithRequireCall(resultElement)) {
                        ES6ReferenceExpressionsInfo.addImportInfo(referenceName, resultElement, imports, unresolvedImports);
                    } else if (!this.isContainedInRange(resultElement)) {
                        Set toProcess = ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)resultElement) ? exportedLocals : locals;
                        toProcess.add(resultElement);
                    }
                } else {
                    ES6ReferenceExpressionsInfo.addImportInfo(referenceName, resultElement, imports, unresolvedImports);
                }
            }

            private static boolean isVariableWithRequireCall(@NotNull PsiElement resultElement) {
                if (resultElement == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (!(resultElement instanceof JSVariable)) {
                    return false;
                }
                JSExpression initializer = ((JSVariable)resultElement).getInitializer();
                if (initializer == null) {
                    PsiElement destructuringElement;
                    PsiElement destructuringProperty = resultElement.getParent();
                    if (destructuringProperty instanceof JSDestructuringProperty && (destructuringElement = destructuringProperty.getParent().getParent()) instanceof JSDestructuringElement) {
                        initializer = ((JSDestructuringElement)destructuringElement).getInitializer();
                    }
                } else if (initializer instanceof JSReferenceExpression) {
                    initializer = ((JSReferenceExpression)initializer).getQualifier();
                }
                return initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall();
            }

            private boolean isContainedInRange(@NotNull PsiElement resultElement) {
                TextRange resultElementRange;
                if (resultElement == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((resultElementRange = resultElement.getTextRange()) == null || textRange != null && !textRange.contains(resultElementRange)) {
                    return false;
                }
                for (PsiElement element2 : JSPsiImplUtils.getSiblingsForward((PsiElement)first, (PsiElement)last)) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)element2, (PsiElement)resultElement, (boolean)false)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceName";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resultElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processReference";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processResolvedElement";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVariableWithRequireCall";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isContainedInRange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PsiElement element2 : JSPsiImplUtils.getSiblingsForward((PsiElement)first, (PsiElement)last)) {
            element2.accept((PsiElementVisitor)visitor);
        }
        if (Boolean.TRUE.equals(containsJsx.get())) {
            ES6ReferenceExpressionsInfo.addReactImport(first, imports, unresolvedImports);
        }
        return new ES6ReferenceExpressionsInfo(locals, exportedLocals, imports, unresolvedImports);
    }

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfoForNamedElement(@NotNull JSNamedElement namedElement) {
        PsiElement module;
        if (namedElement == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(20);
        }
        if ((module = ES6ReferenceExpressionsInfo.findExternalModule((PsiElement)namedElement, false)) == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                ES6ReferenceExpressionsInfo.$$$reportNull$$$0(21);
            }
            return eS6ReferenceExpressionsInfo;
        }
        boolean exported = ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)namedElement);
        return new ES6ReferenceExpressionsInfo(!exported ? Collections.singleton(namedElement) : Collections.emptySet(), exported ? Collections.singleton(namedElement) : Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap());
    }

    public static ES6ReferenceExpressionsInfo getInfoForImportDeclarations(@NotNull @NotNull List<Pair<String, @NotNull ES6ImportExportDeclarationPart>> referenceNamesWithDeclarations) {
        if (referenceNamesWithDeclarations == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(22);
        }
        @NotNull HashMap<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports = new HashMap<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement>();
        @NotNull HashMap<PsiElement, String> unresolvedImports = new HashMap<PsiElement, String>();
        referenceNamesWithDeclarations.forEach(it -> ES6ReferenceExpressionsInfo.addImportInfo((String)it.first, (PsiElement)it.second, imports, unresolvedImports));
        return new ES6ReferenceExpressionsInfo(Collections.emptyList(), Collections.emptyList(), imports, unresolvedImports);
    }

    private static void addReactImport(@NotNull PsiElement context2, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Map<PsiElement, String> unresolvedImports) {
        String namespace;
        if (context2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(23);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(24);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(25);
        }
        if (StringUtil.isEmpty((String)(namespace = JSXNamespaceProvider.getDefaultNamespace(context2).getJSXFactoryOrDefault()))) {
            return;
        }
        PsiElement result2 = JSStubBasedPsiTreeUtil.resolveLocally((String)namespace, (PsiElement)context2);
        if (result2 == null) {
            return;
        }
        ES6ReferenceExpressionsInfo.addImportInfo(namespace, result2, imports, unresolvedImports);
    }

    private static void addImportInfo(@NotNull String referenceName, @NotNull PsiElement resultElement, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Map<PsiElement, String> unresolvedImports) {
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(26);
        }
        if (resultElement == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(27);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(28);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(29);
        }
        if (resultElement instanceof ES6ImportSpecifier) {
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)resultElement;
            PsiElement resolvedCandidate = (PsiElement)ContainerUtil.getFirstItem((Collection)JSResolveResult.resolveReference((PsiPolyVariantReference)specifier));
            ES6ImportPsiUtil.CreateImportExportInfo info = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, specifier);
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)specifier, ES6ReferenceExpressionsInfo.toNullForLibraries(resolvedCandidate), info, imports, unresolvedImports);
            return;
        }
        if (resultElement instanceof ES6ImportedBinding) {
            ES6ImportedBinding binding = (ES6ImportedBinding)resultElement;
            PsiElement resolvedCandidate = (PsiElement)ContainerUtil.getFirstItem((Collection)binding.findReferencedElements());
            ES6ImportPsiUtil.CreateImportExportInfo info = ES6ReferenceExpressionsInfo.createImportInfoForBinding(referenceName, binding);
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)binding, ES6ReferenceExpressionsInfo.toNullForLibraries(resolvedCandidate), info, imports, unresolvedImports);
            return;
        }
        if (resultElement instanceof ES6ImportSpecifierAlias) {
            ES6ImportSpecifierAlias alias = (ES6ImportSpecifierAlias)resultElement;
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)alias.findSpecifierElement();
            if (specifier == null) {
                return;
            }
            ES6ReferenceExpressionsInfo.addImportInfo((ES6ImportExportDeclarationPart)specifier, alias.findAliasedElement(), ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, specifier), imports, unresolvedImports);
        }
        if (resultElement instanceof JSVariable) {
            String exportedName = null;
            JSExpression initializer = ((JSVariable)resultElement).getInitializer();
            if (initializer == null) {
                PsiElement destructuringProperty = resultElement.getParent();
                if (destructuringProperty instanceof JSDestructuringProperty) {
                    exportedName = ((JSDestructuringProperty)destructuringProperty).getName();
                    PsiElement destructuringElement = destructuringProperty.getParent().getParent();
                    if (destructuringElement instanceof JSDestructuringElement) {
                        initializer = ((JSDestructuringElement)destructuringElement).getInitializer();
                    }
                }
            } else if (initializer instanceof JSReferenceExpression) {
                exportedName = ((JSReferenceExpression)initializer).getReferenceName();
                initializer = ((JSReferenceExpression)initializer).getQualifier();
            }
            if (!(initializer instanceof JSCallExpression)) {
                return;
            }
            String modulePath = CommonJSUtil.getModulePathIfRequireCall((JSCallExpression)((JSCallExpression)initializer));
            if (modulePath == null) {
                return;
            }
            PsiElement referencedModule = CommonJSUtil.findReferencedModuleIfRequireCall((JSCallExpression)((JSCallExpression)initializer));
            if (referencedModule == null) {
                unresolvedImports.put(resultElement, modulePath);
                return;
            }
            CommonJSImportCandidateDescriptor importInfo = new CommonJSImportCandidateDescriptor(modulePath, referenceName, exportedName);
            imports.put(importInfo, referencedModule);
        }
    }

    @Nullable
    public static PsiElement toNullForLibraries(@Nullable PsiElement resolvedCandidate) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)resolvedCandidate);
        return file != null && JSLibraryUtil.isProbableLibraryFile((VirtualFile)file) ? null : resolvedCandidate;
    }

    private static void addImportInfo(@NotNull ES6ImportExportDeclarationPart importPart, @Nullable PsiElement resolvedElement, @NotNull ES6ImportPsiUtil.CreateImportExportInfo info, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports, @NotNull Map<PsiElement, String> unresolvedImports) {
        ES6ImportExportDeclaration declaration;
        ES6FromClause fromClause;
        if (importPart == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(30);
        }
        if (info == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(31);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(32);
        }
        if (unresolvedImports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(33);
        }
        ES6FromClause eS6FromClause = fromClause = (declaration = importPart.getDeclaration()) != null ? declaration.getFromClause() : null;
        if (fromClause == null) {
            return;
        }
        PsiElement fromClauseReferencedModule = (PsiElement)ContainerUtil.getFirstItem((Collection)fromClause.resolveReferencedElements());
        if (fromClauseReferencedModule == null) {
            unresolvedImports.put((PsiElement)declaration, JSStringUtil.unquoteStringLiteralValue((String)StringUtil.notNullize((String)fromClause.getReferenceText())));
            return;
        }
        PsiElement element2 = (PsiElement)ObjectUtils.coalesce((Object)resolvedElement, (Object)fromClauseReferencedModule);
        if (ES6ReferenceExpressionsInfo.isAvailableForES6Import(element2)) {
            imports.put(info, element2);
        }
    }

    private static boolean isAvailableForES6Import(@NotNull PsiElement element2) {
        if (element2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(34);
        }
        return !TypeScriptPsiUtil.isAugmentationModule((PsiElement)ES6ReferenceExpressionsInfo.findExternalModule(element2, false));
    }

    @Nullable
    private static PsiElement findExternalModule(@NotNull PsiElement context2, boolean strict) {
        PsiElement module;
        if (context2 == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(35);
        }
        if ((module = ES6PsiUtil.findExternalModule((PsiElement)context2, (boolean)strict)) != null) {
            return module;
        }
        PsiFile file = context2.getContainingFile();
        return file instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)file).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.COMMONJS ? file : null;
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForBinding(@NotNull String referenceName, @NotNull ES6ImportedBinding binding) {
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(36);
        }
        if (binding == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(37);
        }
        ES6ImportPsiUtil.ImportExportType importType = binding.isNamespaceImport() ? ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL : ES6ImportPsiUtil.ImportExportType.DEFAULT;
        return new ES6ImportPsiUtil.CreateImportExportInfo(referenceName, null, importType, ES6ReferenceExpressionsInfo.isTsOrFlowTypeContext((ES6ImportExportDeclarationPart)binding) ? ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE : ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForSpecifier(@NotNull String referenceName, @NotNull ES6ImportSpecifier specifier) {
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(38);
        }
        if (specifier == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(39);
        }
        return new ES6ImportPsiUtil.CreateImportExportInfo(specifier.getCanonicalText(), referenceName, ES6ImportPsiUtil.ImportExportType.SPECIFIER, ES6ReferenceExpressionsInfo.isTsOrFlowTypeContext((ES6ImportExportDeclarationPart)specifier) ? ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE : ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
    }

    private static boolean isTsOrFlowTypeContext(@NotNull ES6ImportExportDeclarationPart part) {
        ES6ImportExportDeclaration declaration;
        if (part == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(40);
        }
        if ((declaration = part.getDeclaration()) == null || !DialectDetector.isFlow((PsiElement)part) && !DialectDetector.isTypeScript((PsiElement)part)) {
            return false;
        }
        ASTNode node = declaration.getNode();
        ASTNode keyword = node.findChildByType(JSTokenTypes.IMPORT_KEYWORD);
        if (keyword != null) {
            if (ES6ReferenceExpressionsInfo.isTypeImport(keyword.getPsi())) {
                return true;
            }
            if (part instanceof ES6ImportSpecifier) {
                PsiElement firstChild = part.getFirstChild();
                return firstChild != null && firstChild.getNode().getElementType() == JSTokenTypes.TYPE_KEYWORD;
            }
        }
        return false;
    }

    public static boolean isTypeImport(@NotNull PsiElement importKeyWord) {
        PsiElement next;
        if (importKeyWord == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(41);
        }
        if ((next = importKeyWord.getNextSibling()) != null) {
            PsiElement typeElement;
            PsiElement psiElement = typeElement = next instanceof PsiWhiteSpace ? next.getNextSibling() : next;
            if (typeElement != null && typeElement.getNode().getElementType() == JSTokenTypes.TYPE_KEYWORD) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedLocals";
                break;
            }
            case 2: 
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 3: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedImports";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 7: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFilter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceNamesWithDeclarations";
                break;
            }
            case 23: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPart";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importKeyWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferencedElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedLocalReferencedElements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForRange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForNamedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: 
            case 21: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addValidations";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForRange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForNamedElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForImportDeclarations";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addReactImport";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addImportInfo";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForES6Import";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createImportInfoForBinding";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createImportInfoForSpecifier";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isTsOrFlowTypeContext";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isTypeImport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 19, 21 -> new IllegalStateException(string);
        };
    }

    public static class CommonJSImportCandidateDescriptor
    extends JSImportCandidateDescriptor {
        public CommonJSImportCandidateDescriptor(String modulePath, @NotNull String referenceName, String exportedName) {
            if (referenceName == null) {
                CommonJSImportCandidateDescriptor.$$$reportNull$$$0(0);
            }
            super(modulePath, referenceName, exportedName, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)(exportedName != null ? ES6ImportPsiUtil.ImportExportType.SPECIFIER : ES6ImportPsiUtil.ImportExportType.DEFAULT));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$CommonJSImportCandidateDescriptor", "<init>"));
        }
    }
}

