/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.beforeRun;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmBeforeRunTaskDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NpmRunConfigurationEditor myEditor;

    public NpmBeforeRunTaskDialog(@NotNull Project project, @NotNull NpmRunSettings settings) {
        List<VirtualFile> packageJsonFiles;
        if (project == null) {
            NpmBeforeRunTaskDialog.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            NpmBeforeRunTaskDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myEditor = new NpmRunConfigurationEditor(project);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myEditor);
        this.setTitle(JavaScriptBundle.message((String)"npm.task.title", (Object[])new Object[0]));
        this.init();
        if (settings.getPackageJsonSystemIndependentPath().isEmpty() && (packageJsonFiles = NpmScriptsService.getInstance(project).detectAllBuildfilesInContentRoots(false)).size() == 1) {
            VirtualFile packageJson = packageJsonFiles.get(0);
            settings = settings.toBuilder().setPackageJsonPath(packageJson.getPath()).build();
        }
        this.myEditor.resetEditorFrom(settings);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myEditor.createEditor();
    }

    public NpmRunSettings getSettings() {
        return this.myEditor.getCurrentSettings();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        try {
            NpmRunConfigurationUtil.check(this.myProject, this.getSettings());
        }
        catch (RuntimeConfigurationError error) {
            return new ValidationInfo(error.getMessage());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

