/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementType;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JSHighlightExitPointsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull PsiElement target2) {
        ASTNode node;
        if (editor == null) {
            JSHighlightExitPointsHandlerFactory.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            JSHighlightExitPointsHandlerFactory.$$$reportNull$$$0(1);
        }
        if (target2 == null) {
            JSHighlightExitPointsHandlerFactory.$$$reportNull$$$0(2);
        }
        if ((node = target2.getNode()) != null) {
            IElementType elementType = node.getElementType();
            if (!(elementType instanceof JSElementType)) {
                return null;
            }
            if (elementType == JSTokenTypes.RETURN_KEYWORD || elementType == JSTokenTypes.THROW_KEYWORD || elementType == JSTokenTypes.YIELD_KEYWORD || elementType == JSTokenTypes.FUNCTION_KEYWORD || elementType == JSTokenTypes.EQGT) {
                return new JSHighlightExitPointsHandler(editor, psiFile, target2);
            }
            if (elementType == JSTokenTypes.ASYNC_KEYWORD || elementType == JSTokenTypes.AWAIT_KEYWORD) {
                return new JSHighlightAsyncAwaitHandler(editor, psiFile, target2);
            }
            if (elementType == JSTokenTypes.CONTINUE_KEYWORD || elementType == JSTokenTypes.BREAK_KEYWORD || elementType == JSTokenTypes.WHILE_KEYWORD || elementType == JSTokenTypes.FOR_KEYWORD || elementType == JSTokenTypes.DO_KEYWORD || elementType == JSTokenTypes.SWITCH_KEYWORD) {
                return new JSHighlightBreakOutsHandler(editor, psiFile, target2);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/highlighting/JSHighlightExitPointsHandlerFactory";
        objectArray[2] = "createHighlightUsagesHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JSHighlightExitPointsHandler
    extends JSHighlightHandlerBase {
        private JSHighlightExitPointsHandler(Editor editor, PsiFile file, PsiElement target2) {
            super(editor, file, target2);
        }

        public void computeUsages(@NotNull List<? extends PsiElement> targets) {
            JSFunction fun;
            JSExpression arrowFunctionReturnExpression;
            if (targets == null) {
                JSHighlightExitPointsHandler.$$$reportNull$$$0(0);
            }
            if ((arrowFunctionReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)(fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)targets.get(0), JSFunction.class)))) != null) {
                this.myReadUsages.add(arrowFunctionReturnExpression.getTextRange());
                return;
            }
            if (fun != null) {
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)fun).forceIgnore(e -> e instanceof JSFunction)).filter(JSFunctionExitPoint.class).filter(ep -> ep.isValidFunctionExit()).map(ep -> ep.getTextRange()).addAllTo((Collection)this.myReadUsages);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/lang/javascript/highlighting/JSHighlightExitPointsHandlerFactory$JSHighlightExitPointsHandler", "computeUsages"));
        }
    }

    private static final class JSHighlightAsyncAwaitHandler
    extends JSHighlightHandlerBase {
        private JSHighlightAsyncAwaitHandler(Editor editor, PsiFile file, PsiElement target2) {
            super(editor, file, target2);
        }

        public void computeUsages(@NotNull List<? extends PsiElement> targets) {
            JSFunction fun;
            if (targets == null) {
                JSHighlightAsyncAwaitHandler.$$$reportNull$$$0(0);
            }
            if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)targets.get(0), JSFunction.class)) != null) {
                ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)fun).forceIgnore(e -> e instanceof JSFunction)).filter(JSPrefixExpression.class).filter(e -> e.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD).map(ep -> Objects.requireNonNull(ep.getOperationNode()).getTextRange()).addAllTo((Collection)this.myReadUsages);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/lang/javascript/highlighting/JSHighlightExitPointsHandlerFactory$JSHighlightAsyncAwaitHandler", "computeUsages"));
        }
    }

    private static class JSHighlightBreakOutsHandler
    extends JSHighlightHandlerBase {
        private JSHighlightBreakOutsHandler(Editor editor, PsiFile file, PsiElement target2) {
            super(editor, file, target2);
        }

        public void computeUsages(@NotNull List<? extends PsiElement> targets) {
            PsiElement parent;
            JSStatement breakOrContinueTarget;
            if (targets == null) {
                JSHighlightBreakOutsHandler.$$$reportNull$$$0(0);
            }
            JSStatement jSStatement = breakOrContinueTarget = (parent = this.myTarget.getParent()) instanceof JSLoopStatement || parent instanceof JSSwitchStatement ? (JSStatement)parent : JSPsiImplUtils.getBreakOrContinueTarget((PsiElement)parent);
            if (breakOrContinueTarget != null) {
                this.addKeyword((PsiElement)breakOrContinueTarget);
                ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)breakOrContinueTarget).forceIgnore(e -> e instanceof JSFunction)).filter(e -> e instanceof JSFunctionExitPoint || JSPsiImplUtils.getBreakOrContinueTarget((PsiElement)e) == breakOrContinueTarget)).forEach(this::addKeyword);
            }
        }

        private void addKeyword(@NotNull PsiElement statement) {
            ASTNode keyword;
            if (statement == null) {
                JSHighlightBreakOutsHandler.$$$reportNull$$$0(1);
            }
            if ((keyword = statement.getNode().findChildByType(JSKeywordSets.JS_RESERVED_AND_STRICT_KEYWORDS)) != null) {
                this.addOccurrence(keyword.getPsi());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSHighlightExitPointsHandlerFactory$JSHighlightBreakOutsHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKeyword";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class JSHighlightHandlerBase
    extends HighlightUsagesHandlerBase<PsiElement> {
        protected final PsiElement myTarget;

        private JSHighlightHandlerBase(Editor editor, PsiFile file, PsiElement target2) {
            super(editor, file);
            this.myTarget = target2;
        }

        @NotNull
        public List<PsiElement> getTargets() {
            return new SmartList((Object)this.myTarget);
        }

        @NotNull
        public String getFeatureId() {
            return "codeassists.highlight.return";
        }

        protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
            if (targets == null) {
                JSHighlightHandlerBase.$$$reportNull$$$0(0);
            }
            if (selectionConsumer == null) {
                JSHighlightHandlerBase.$$$reportNull$$$0(1);
            }
            selectionConsumer.consume(targets);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targets";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectionConsumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/highlighting/JSHighlightExitPointsHandlerFactory$JSHighlightHandlerBase";
            objectArray[2] = "selectTargets";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

