/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.javascript.advancedSettings.JSAdvancedSettingsKt;
import com.intellij.javascript.advancedSettings.JSSemanticHighlightingAccuracy;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.highlighting.JSHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingVisitorKt;
import com.intellij.lang.javascript.highlighting.JavaScriptHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 X2\u00020\u0001:\u0002WXB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u001b\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\"\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\"\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\"\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u00100\u001a\u00020\t2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\t2\u0006\u00104\u001a\u0002052\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u00106\u001a\u00020\t2\u0006\u0010\r\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\t2\u0006\u0010\r\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\t2\u0006\u0010\r\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\t2\u0006\u0010I\u001a\u00020OH\u0016J \u0010P\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0002J \u0010U\u001a\u00020\t2\u0006\u0010V\u001a\u00020\u000b2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor;", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "highlighter", "Lcom/intellij/lang/javascript/highlighting/JSHighlighter;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/javascript/highlighting/JSHighlighter;Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "highlightReference", "node", "Lcom/intellij/lang/javascript/psi/JSPsiReferenceElement;", "identifierToHighlight", "doHighlightReference", "isActionScriptClass", "", "results", "", "Lcom/intellij/psi/ResolveResult;", "([Lcom/intellij/psi/ResolveResult;)Z", "highlight", "place", "resolve", "highlightProperty", "Lcom/intellij/lang/javascript/psi/JSProperty;", "highlightDestructuringProperty", "Lcom/intellij/lang/javascript/psi/JSDestructuringProperty;", "highlightVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "highlightKeyword", "visitTypeScriptPropertySignature", "signature", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;", "visitTypeScriptFunctionSignature", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptFunctionSignature;", "visitFunctionSignature", "Lcom/intellij/lang/javascript/psi/ecma6/JSFunctionSignature;", "highlightTypeParameter", "parameter", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptGenericOrMappedTypeParameter;", "visitTypeScriptIndexSignature", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptIndexSignature;", "highlightModule", "module", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptModule;", "visitES6MetaProperty", "property", "Lcom/intellij/lang/ecmascript6/psi/Es6MetaProperty;", "highlightClass", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "visitImportSpecifier", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportSpecifier;", "visitES6ExportSpecifier", "Lcom/intellij/lang/ecmascript6/psi/ES6ExportSpecifier;", "visitJSFunctionExpression", "Lcom/intellij/lang/javascript/psi/JSFunctionExpression;", "visitJSFunctionProperty", "functionProperty", "Lcom/intellij/lang/javascript/psi/JSFunctionProperty;", "visitES6ImportedBinding", "importedBinding", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "visitTypeScriptImportStatement", "importStatement", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptImportStatement;", "visitTypeScriptEntityName", "entityName", "Lcom/intellij/lang/typescript/psi/TypeScriptEntityName;", "visitTypeScriptTypeParameter", "typeParameter", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptTypeParameter;", "visitTypeScriptInferType", "inferType", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptInferType;", "visitTypeScriptMappedTypeParameter", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptMappedTypeParameter;", "lineMarker", "attrKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "debugName", "", "rangeLineMarker", "exactElement", "JSSemanticHighlightingBuilder", "Companion", "intellij.javascript.analysis.impl"})
public final class JSSemanticHighlightingVisitor
extends JSElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSHighlighter highlighter;
    @NotNull
    private final AnnotationHolder holder;
    @NotNull
    private static final ThreadLocal<Boolean> IS_FROM_SEMANTIC_HIGHLIGHTING;
    @NotNull
    private static final Set<String> PREDEFINED_LOCAL_VARS;
    private static final boolean debug;

    public JSSemanticHighlightingVisitor(@NotNull JSHighlighter highlighter, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.highlighter = highlighter;
        this.holder = holder;
    }

    public void visitElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        IElementType iElementType = element2.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(elementType)) {
            JSNamedElement namedElement;
            PsiElement parent = element2.getParent();
            if (parent instanceof JSReferenceExpression) {
                this.highlightReference((JSPsiReferenceElement)parent, element2);
            }
            if ((namedElement = JSPsiImplUtils.findElementFromNameIdentifier((PsiElement)element2)) instanceof JSVariable) {
                this.highlightVariable((JSVariable)namedElement);
            } else if (namedElement instanceof JSProperty) {
                this.highlightProperty((JSProperty)namedElement);
            } else if (namedElement instanceof JSDestructuringProperty) {
                this.highlightDestructuringProperty((JSDestructuringProperty)namedElement);
            } else if (namedElement instanceof JSFunction) {
                IElementType iElementType2 = ((JSFunction)namedElement).getNode().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getElementType(...)");
                IElementType namedElementType = iElementType2;
                PsiElement nameIdentifier = ((JSFunction)namedElement).getNameIdentifier();
                if (nameIdentifier != null && JSSemanticHighlightingVisitorKt.isConstructorIdentifier((JSFunction)namedElement, nameIdentifier)) {
                    this.highlightKeyword(nameIdentifier);
                } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(namedElementType)) {
                    this.highlight((PsiElement)namedElement, (PsiElement)namedElement);
                }
            } else if (namedElement instanceof TypeScriptModule && !(parent instanceof JSReferenceExpression)) {
                this.highlightModule((TypeScriptModule)namedElement, element2);
            } else if (namedElement instanceof JSClass) {
                this.highlightClass((JSClass)namedElement, element2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void highlightReference(JSPsiReferenceElement node, PsiElement identifierToHighlight) {
        if (identifierToHighlight == null) {
            return;
        }
        try {
            IS_FROM_SEMANTIC_HIGHLIGHTING.set(true);
            this.doHighlightReference(node, identifierToHighlight);
        }
        finally {
            IS_FROM_SEMANTIC_HIGHLIGHTING.set(false);
        }
    }

    private final void doHighlightReference(JSPsiReferenceElement node, PsiElement identifierToHighlight) {
        if (!JSSemanticHighlightingVisitor.Companion.isAcceptableReferenceForHighlighting(node)) {
            return;
        }
        ResolveResult[] results = null;
        if (JSAdvancedSettingsKt.getHighlightingAccuracy().getLevel() >= JSSemanticHighlightingAccuracy.Basic.getLevel()) {
            ResolveResult[] resolveResultArray = node.multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            results = resolveResultArray;
        } else {
            ResolveResult[] resolveResultArray;
            PsiElement localResolved = JSStubBasedPsiTreeUtil.resolveReferenceLocally((PsiPolyVariantReference)((PsiPolyVariantReference)node), (String)node.getReferenceName());
            if (localResolved != null) {
                ResolveResult[] resolveResultArray2 = new ResolveResult[]{new JSResolveResult(localResolved)};
                resolveResultArray = resolveResultArray2;
            } else {
                resolveResultArray = ResolveResult.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            results = resolveResultArray;
        }
        if (results.length == 0) {
            return;
        }
        if (JSResolveResult.isTooManyCandidatesResult((ResolveResult[])results) && node instanceof JSReferenceExpression) {
            JSHighlightDescriptor descriptor = JSSemanticHighlightingVisitor.Companion.guessHighlightingForReference((JSReferenceExpression)node);
            this.rangeLineMarker(identifierToHighlight, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
            return;
        }
        if (JSSemanticHighlightingVisitor.Companion.isGlobalUndefined(node)) {
            this.highlightKeyword((PsiElement)node);
            return;
        }
        if (this.isActionScriptClass(results)) {
            PsiElement psiElement = results[0].getElement();
            Intrinsics.checkNotNull((Object)psiElement);
            JSHighlightDescriptor info = Companion.buildHighlightForResolveResult(psiElement, (PsiElement)node);
            if (info != null) {
                PsiElement element2;
                ASTNode genericSignature = node.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
                PsiElement psiElement2 = element2 = genericSignature == null ? (PsiElement)node : node.getReferenceNameElement();
                if (element2 != null) {
                    this.rangeLineMarker(identifierToHighlight, info.getAttributesKey(this.highlighter), info.getDebugName());
                    return;
                }
            }
        }
        Object2IntMap countByTypes = (Object2IntMap)new Object2IntOpenHashMap();
        boolean tsdOccurred = false;
        for (ResolveResult r : results) {
            JSHighlightDescriptor descriptor;
            PsiElement resolve2 = r.getElement();
            if (resolve2 == null) continue;
            PsiFile file = resolve2.getContainingFile();
            boolean isFromTsd = TypeScriptUtil.isDefinitionFile((PsiFile)file);
            if (isFromTsd && !tsdOccurred) {
                tsdOccurred = true;
                countByTypes = (Object2IntMap)new Object2IntOpenHashMap();
            }
            if (tsdOccurred && !isFromTsd || (descriptor = Companion.buildHighlightForResolveResult(resolve2, (PsiElement)node)) == null) continue;
            countByTypes.put((Object)descriptor, countByTypes.getInt((Object)descriptor) + 1);
        }
        IntRef maxCount = new IntRef(0);
        JSHighlightDescriptor descriptor = null;
        ObjectIterator objectIterator = countByTypes.object2IntEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator2.next();
            Object object = entry.getKey();
            Intrinsics.checkNotNull((Object)object);
            JSHighlightDescriptor key = (JSHighlightDescriptor)object;
            int count = entry.getIntValue();
            if (count > maxCount.get()) {
                maxCount.set(count);
                descriptor = key;
                continue;
            }
            if (count != maxCount.get() || descriptor == null || descriptor.getDebugName().compareTo(key.getDebugName()) <= 0) continue;
            descriptor = key;
        }
        if (descriptor != null) {
            this.rangeLineMarker(identifierToHighlight, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
        }
    }

    private final boolean isActionScriptClass(ResolveResult[] results) {
        return results.length == 1 && this.highlighter.getDialectOptionsHolder() == DialectOptionHolder.ECMA_4 && results[0].getElement() instanceof JSClass;
    }

    private final void highlight(PsiElement place, PsiElement resolve2) {
        JSHighlightDescriptor descriptor = Companion.buildHighlightForResolveResult(resolve2, place);
        if (descriptor != null) {
            this.lineMarker(place, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
        }
    }

    private final void highlightProperty(JSProperty node) {
        boolean isStatic;
        if (node.isShorthanded()) {
            return;
        }
        if (node instanceof JSFunction) {
            return;
        }
        JSHighlightDescriptor resolveResultDescriptor = Companion.buildHighlightForResolveResult((PsiElement)node, (PsiElement)node);
        boolean isFunction = resolveResultDescriptor != null && JSSemanticHighlightingVisitor.Companion.isFunctionDescriptor(resolveResultDescriptor);
        boolean bl = isStatic = resolveResultDescriptor == JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION || resolveResultDescriptor == JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE;
        JSHighlightDescriptor descriptor = isStatic ? (JSHighlightDescriptor)(isFunction ? JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION : JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE) : (isFunction ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE);
        this.lineMarker((PsiElement)node, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
    }

    private final void highlightDestructuringProperty(JSDestructuringProperty node) {
        if (node instanceof JSDestructuringShorthandedProperty || node.isRest()) {
            return;
        }
        JSHighlightDescriptor descriptor = (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE;
        this.lineMarker((PsiElement)node, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
    }

    private final void highlightVariable(JSVariable node) {
        PsiElement nameIdentifier;
        if (!(node instanceof JSParameter) && ((nameIdentifier = node.getNameIdentifier()) == null || nameIdentifier instanceof JSReferenceExpression)) {
            return;
        }
        JSHighlightDescriptor descriptor = Companion.buildHighlightForResolveResult((PsiElement)node, (PsiElement)node);
        if (descriptor != null) {
            this.lineMarker((PsiElement)node, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
        }
    }

    private final void highlightKeyword(PsiElement element2) {
        this.rangeLineMarker(element2, JavaScriptHighlightDescriptor.KEYWORD.getAttributesKey(this.highlighter), JavaScriptHighlightDescriptor.KEYWORD.getDebugName());
    }

    public void visitTypeScriptPropertySignature(@NotNull TypeScriptPropertySignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.lineMarker((PsiElement)signature, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript property signature");
    }

    public void visitTypeScriptFunctionSignature(@NotNull TypeScriptFunctionSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.lineMarker((PsiElement)signature, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "TypeScript function signature");
    }

    public void visitFunctionSignature(@NotNull JSFunctionSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.lineMarker((PsiElement)signature, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "function signature");
    }

    public final void highlightTypeParameter(@NotNull TypeScriptGenericOrMappedTypeParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        TypeScriptHighlightDescriptor descriptor = TypeScriptHighlightDescriptor.TYPE_PARAMETER;
        this.lineMarker((PsiElement)parameter, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
    }

    public void visitTypeScriptIndexSignature(@NotNull TypeScriptIndexSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        PsiElement element2 = signature.getParameterNameElement();
        if (element2 != null) {
            this.lineMarker(element2, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript index signature");
        }
    }

    private final void highlightModule(TypeScriptModule module, PsiElement identifierToHighlight) {
        TextAttributesKey attrKey = DialectDetector.isTypeScript((PsiElement)((PsiElement)module)) ? this.highlighter.getMappedKey(TypeScriptHighlighter.TS_MODULE_NAME) : this.highlighter.getMappedKey(JSHighlighter.JS_MODULE_NAME);
        this.rangeLineMarker(identifierToHighlight, attrKey, "moduleName");
    }

    public void visitES6MetaProperty(@NotNull Es6MetaProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        PsiElement nameIdentifier = property.getNameIdentifier();
        if (nameIdentifier != null) {
            this.lineMarker(nameIdentifier, this.highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "meta property");
        }
    }

    private final void highlightClass(JSClass jsClass, PsiElement identifierToHighlight) {
        if (Intrinsics.areEqual((Object)"CoffeeScriptClassImpl", (Object)jsClass.getClass().getSimpleName())) {
            return;
        }
        JSHighlightDescriptor descriptor = JSSemanticHighlightingVisitor.Companion.buildHighlightForElement((PsiElement)jsClass, (PsiElement)jsClass);
        if (descriptor != null) {
            this.rangeLineMarker(identifierToHighlight, descriptor.getAttributesKey(this.highlighter), descriptor.getDebugName());
        }
    }

    public void visitImportSpecifier(@NotNull ES6ImportSpecifier node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.highlightReference((JSPsiReferenceElement)node, node.getReferenceNameElement());
    }

    public void visitES6ExportSpecifier(@NotNull ES6ExportSpecifier node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.highlightReference((JSPsiReferenceElement)node, node.getReferenceNameElement());
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement ownNameIdentifier = node.getOwnNameIdentifier();
        if (ownNameIdentifier != null) {
            this.highlight(ownNameIdentifier, (PsiElement)node);
        }
    }

    public void visitJSFunctionProperty(@NotNull JSFunctionProperty functionProperty) {
        Intrinsics.checkNotNullParameter((Object)functionProperty, (String)"functionProperty");
        this.highlight((PsiElement)functionProperty, (PsiElement)functionProperty);
    }

    public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
        Intrinsics.checkNotNullParameter((Object)importedBinding, (String)"importedBinding");
        Collection collection = importedBinding.findReferencedElements();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findReferencedElements(...)");
        Collection referencedElements = collection;
        PsiElement resolveResult = (PsiElement)CollectionsKt.firstOrNull((Iterable)referencedElements);
        if (resolveResult != null) {
            resolveResult = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)resolveResult);
            this.highlight((PsiElement)importedBinding, resolveResult);
        }
    }

    public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
        Intrinsics.checkNotNullParameter((Object)importStatement, (String)"importStatement");
        PsiElement identifier = importStatement.getNameIdentifier();
        if (identifier != null) {
            PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)((PsiElement)importStatement));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"calculateMeaningfulElement(...)");
            PsiElement meaningfulElement = psiElement;
            this.highlight(identifier, meaningfulElement);
        }
    }

    public void visitTypeScriptEntityName(@NotNull TypeScriptEntityName entityName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
    }

    public void visitTypeScriptTypeParameter(@NotNull TypeScriptTypeParameter typeParameter) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        this.highlightTypeParameter((TypeScriptGenericOrMappedTypeParameter)typeParameter);
    }

    public void visitTypeScriptInferType(@NotNull TypeScriptInferType inferType) {
        Intrinsics.checkNotNullParameter((Object)inferType, (String)"inferType");
        this.highlightTypeParameter((TypeScriptGenericOrMappedTypeParameter)inferType);
    }

    public void visitTypeScriptMappedTypeParameter(@NotNull TypeScriptMappedTypeParameter typeParameter) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        this.highlightTypeParameter((TypeScriptGenericOrMappedTypeParameter)typeParameter);
    }

    private final void lineMarker(PsiElement element2, TextAttributesKey attrKey, String debugName) {
        PsiElement markedNode = JSSemanticHighlightingVisitor.Companion.findLeafToHighlight(element2);
        if (markedNode == null) {
            return;
        }
        this.rangeLineMarker(markedNode, attrKey, debugName);
    }

    private final void rangeLineMarker(PsiElement exactElement, TextAttributesKey attrKey, String debugName) {
        AnnotationBuilder annotationBuilder;
        if (debug) {
            AnnotationBuilder annotationBuilder2 = this.holder.newAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY, debugName);
            annotationBuilder = annotationBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder2, (String)"newAnnotation(...)");
        } else {
            AnnotationBuilder annotationBuilder3 = this.holder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY);
            annotationBuilder = annotationBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder3, (String)"newSilentAnnotation(...)");
        }
        AnnotationBuilder builder2 = annotationBuilder;
        builder2.range(exactElement).textAttributes(attrKey).create();
    }

    private static final Boolean IS_FROM_SEMANTIC_HIGHLIGHTING$lambda$0() {
        return false;
    }

    @JvmStatic
    @Nullable
    public static final JSHighlightDescriptor buildHighlightForResolveResult(@NotNull PsiElement resolve2, @NotNull PsiElement place) {
        return Companion.buildHighlightForResolveResult(resolve2, place);
    }

    @JvmStatic
    public static final boolean isArgumentsVariable(@NotNull PsiElement element2) {
        return Companion.isArgumentsVariable(element2);
    }

    @JvmStatic
    public static final boolean isLocalVariable(@NotNull JSFieldVariable element2) {
        return Companion.isLocalVariable(element2);
    }

    @JvmStatic
    @Nullable
    public static final HighlightInfo justLineMarker(@NotNull PsiElement markedNode, @NotNull TextAttributesKey attrKey, @Nullable String debugName) {
        return Companion.justLineMarker(markedNode, attrKey, debugName);
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(JSSemanticHighlightingVisitor::IS_FROM_SEMANTIC_HIGHLIGHTING$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        IS_FROM_SEMANTIC_HIGHLIGHTING = threadLocal;
        Object[] objectArray = new String[]{"exports", "require", "module", "__filename", "__dirname"};
        HashSet hashSet = ContainerUtil.newHashSet((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        PREDEFINED_LOCAL_VARS = hashSet;
        debug = ApplicationManager.getApplication().isUnitTestMode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0007J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020+H\u0002J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0006H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020'H\u0007J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020'H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0015H\u0002J\u0018\u0010<\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020=2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010?\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor$Companion;", "", "<init>", "()V", "IS_FROM_SEMANTIC_HIGHLIGHTING", "Ljava/lang/ThreadLocal;", "", "getIS_FROM_SEMANTIC_HIGHLIGHTING", "()Ljava/lang/ThreadLocal;", "PREDEFINED_LOCAL_VARS", "", "", "isClassContext", "element", "Lcom/intellij/psi/PsiElement;", "isTypeScriptInterfaceReference", "isAcceptableReferenceForHighlighting", "node", "Lcom/intellij/lang/javascript/psi/JSPsiReferenceElement;", "isGlobalUndefined", "guessHighlightingForReference", "Lcom/intellij/lang/javascript/highlighting/JSHighlightDescriptor;", "referenceExpression", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "buildHighlightForResolveResult", "resolve", "place", "buildHighlightForElement", "hasDeclaredFunctionType", "typeOwner", "Lcom/intellij/lang/javascript/psi/JSTypeOwner;", "isFunctionTypeElementOrReference", "typeElement", "hasFunctionType", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "isFunctionTypeElement", "buildHighlightForVariable", "", "Lcom/intellij/lang/javascript/psi/JSFieldVariable;", "builder", "Lcom/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor$JSSemanticHighlightingBuilder;", "buildHighlightForClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "isInterface", "isArgumentsVariable", "isLocalVariable", "isFromEmbeddedModule", "isPredefinedLocalVariable", "resolvedElement", "debug", "findLeafToHighlight", "justLineMarker", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "markedNode", "attrKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "debugName", "isFunctionDescriptor", "descriptor", "buildHighlightForInitializerOwner", "Lcom/intellij/lang/javascript/psi/JSInitializerOwner;", "calculateMeaningfulElementForHighlighting", "isExported", "intellij.javascript.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nJSSemanticHighlightingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSSemanticHighlightingVisitor.kt\ncom/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,841:1\n1617#2,9:842\n1869#2:851\n1870#2:853\n1626#2:854\n1761#2,3:855\n1761#2,3:858\n1761#2,3:861\n1#3:852\n12970#4,2:864\n*S KotlinDebug\n*F\n+ 1 JSSemanticHighlightingVisitor.kt\ncom/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor$Companion\n*L\n621#1:842,9\n621#1:851\n621#1:853\n621#1:854\n628#1:855,3\n642#1:858,3\n643#1:861,3\n621#1:852\n649#1:864,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadLocal<Boolean> getIS_FROM_SEMANTIC_HIGHLIGHTING() {
            return IS_FROM_SEMANTIC_HIGHLIGHTING;
        }

        private final boolean isClassContext(PsiElement element2) {
            if (element2 == null) {
                return false;
            }
            PsiElement context2 = element2.getContext();
            if (context2 instanceof JSClass) {
                return true;
            }
            return context2 instanceof JSFile && ((JSFile)context2).getContext() != null;
        }

        private final boolean isTypeScriptInterfaceReference(PsiElement element2) {
            return element2 instanceof TypeScriptObjectType && this.isClassContext(element2);
        }

        private final boolean isAcceptableReferenceForHighlighting(JSPsiReferenceElement node) {
            if (!(node instanceof JSReferenceExpression)) {
                return true;
            }
            PsiElement parent = ((JSReferenceExpression)node).getParent();
            if (parent instanceof ES6Decorator || parent instanceof JSCallExpression && ((JSCallExpression)parent).getParent() instanceof ES6Decorator) {
                return false;
            }
            if (((JSReferenceExpression)node).getQualifier() != null) {
                return true;
            }
            return ((JSReferenceExpression)node).getNode().findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter) == null || !JSResolveUtil.isExprInTypeContext((JSReferenceExpression)((JSReferenceExpression)node));
        }

        private final boolean isGlobalUndefined(JSPsiReferenceElement node) {
            return Intrinsics.areEqual((Object)"undefined", (Object)node.getReferenceName()) && node instanceof JSQualifiedExpression && ((JSQualifiedExpression)node).getQualifier() == null;
        }

        private final JSHighlightDescriptor guessHighlightingForReference(JSReferenceExpression referenceExpression) {
            boolean isGlobal;
            PsiElement parent = referenceExpression.getParent();
            boolean isMethod = parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == referenceExpression;
            boolean bl = isGlobal = referenceExpression.getQualifier() == null;
            if (isMethod) {
                return isGlobal ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.GLOBAL_FUNCTION : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION;
            }
            return isGlobal ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.GLOBAL_VARIABLE : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE;
        }

        @JvmStatic
        @Nullable
        public final JSHighlightDescriptor buildHighlightForResolveResult(@NotNull PsiElement resolve2, @NotNull PsiElement place) {
            Intrinsics.checkNotNullParameter((Object)resolve2, (String)"resolve");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            PsiElement targetElement = this.calculateMeaningfulElementForHighlighting(resolve2);
            JSHighlightDescriptor targetElementInfo = this.buildHighlightForElement(targetElement, place);
            JSHighlightDescriptor jSHighlightDescriptor = targetElementInfo;
            if (jSHighlightDescriptor == null) {
                jSHighlightDescriptor = this.buildHighlightForElement(resolve2, place);
            }
            return jSHighlightDescriptor;
        }

        private final JSHighlightDescriptor buildHighlightForElement(PsiElement resolve2, PsiElement place) {
            JSImplicitElement.Type type2;
            JSSemanticHighlightingBuilder builder2;
            block29: {
                block28: {
                    PsiElement provider;
                    JSImplicitElement.Type kind;
                    List list = JSFrameworkSpecificHandler.EP_NAME.allForLanguageOrAny(resolve2.getLanguage());
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allForLanguageOrAny(...)");
                    List handlers = list;
                    for (JSFrameworkSpecificHandler handler : handlers) {
                        JSHighlightDescriptor descriptor = handler.buildHighlightForElement(resolve2, place);
                        if (descriptor == null) continue;
                        return descriptor;
                    }
                    builder2 = new JSSemanticHighlightingBuilder();
                    if (!(resolve2 instanceof JSImplicitElement)) break block28;
                    if (resolve2 instanceof JSLocalImplicitElementImpl && (kind = ((JSLocalImplicitElementImpl)resolve2).getExplicitKind()) == null && (provider = ((JSLocalImplicitElementImpl)resolve2).getParent()) != null && !(provider instanceof JSImplicitElement)) {
                        return this.buildHighlightForElement(provider, place);
                    }
                    JSImplicitElement.Type type3 = ((JSImplicitElement)resolve2).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getType(...)");
                    type2 = type3;
                    switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                        case 1: {
                            return this.buildHighlightForClass(resolve2, false);
                        }
                        case 2: {
                            return this.buildHighlightForClass(resolve2, true);
                        }
                        case 3: {
                            builder2.setFunction(true);
                            builder2.setProperty(((JSImplicitElement)resolve2).getNamespace() != null);
                            builder2.setStatic(((JSImplicitElement)resolve2).getJSContext() == JSContext.STATIC);
                            break block29;
                        }
                        case 4: {
                            builder2.setFunction(true);
                            builder2.setProperty(true);
                            builder2.setStatic(((JSImplicitElement)resolve2).getJSContext() == JSContext.STATIC);
                            break block29;
                        }
                        case 5: {
                            return (JSHighlightDescriptor)JavaScriptHighlightDescriptor.GLOBAL_VARIABLE;
                        }
                        case 6: {
                            if (((JSImplicitElement)resolve2).getNamespace() == null && ((JSImplicitElement)resolve2).isNamespaceExplicitlyDeclared()) {
                                return (JSHighlightDescriptor)JavaScriptHighlightDescriptor.GLOBAL_VARIABLE;
                            }
                            builder2.setProperty(true);
                            builder2.setStatic(((JSImplicitElement)resolve2).getJSContext() == JSContext.STATIC);
                            break block29;
                        }
                        case 7: 
                        case 8: {
                            builder2.setProperty(true);
                            builder2.setStatic(((JSImplicitElement)resolve2).getJSContext() == JSContext.STATIC);
                            break block29;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (resolve2 instanceof JSClass) {
                    return this.buildHighlightForClass((JSClass)resolve2);
                }
                if (resolve2 instanceof TypeScriptModule) {
                    return (JSHighlightDescriptor)TypeScriptHighlightDescriptor.MODULE_NAME;
                }
                if (resolve2 instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)((JSParameter)resolve2)) || this.isArgumentsVariable(resolve2)) {
                    if (resolve2 instanceof JSParameter && TypeScriptPsiUtil.isThisParameter((JSParameterItem)((JSParameterItem)resolve2))) {
                        return null;
                    }
                    return (JSHighlightDescriptor)JavaScriptHighlightDescriptor.PARAMETER;
                }
                if (resolve2 instanceof TypeScriptEnumField) {
                    return (JSHighlightDescriptor)TypeScriptHighlightDescriptor.ENUM_MEMBER;
                }
                if (resolve2 instanceof JSFieldVariable) {
                    this.buildHighlightForVariable((JSFieldVariable)resolve2, builder2);
                } else {
                    if (resolve2 instanceof TypeScriptGenericOrMappedTypeParameter) {
                        return (JSHighlightDescriptor)TypeScriptHighlightDescriptor.TYPE_PARAMETER;
                    }
                    if (resolve2 instanceof JSAttributeListOwner) {
                        JSAttributeList attributeList = ((JSAttributeListOwner)resolve2).getAttributeList();
                        if (attributeList != null) {
                            builder2.setStatic(attributeList.hasModifier(JSAttributeList.ModifierType.STATIC));
                        }
                        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)resolve2);
                        builder2.setFunction(resolve2 instanceof JSFunction && (!((JSFunction)resolve2).isConstructor() || dialect != null && dialect.isJavaScript()));
                        if (builder2.isFunction()) {
                            builder2.setProperty(this.isClassContext(resolve2) || this.isTypeScriptInterfaceReference(resolve2.getContext()));
                        }
                        if (JSResolveUtil.isConstructorFunction((PsiElement)resolve2)) {
                            PsiElement context2 = resolve2.getContext();
                            JSClass jSClass = context2 instanceof JSClass ? (JSClass)context2 : null;
                            return this.buildHighlightForClass((PsiElement)(jSClass != null ? (JSAttributeListOwner)jSClass : (JSAttributeListOwner)resolve2), false);
                        }
                    }
                }
            }
            if (!builder2.isProperty() && resolve2 instanceof JSElementBase) {
                builder2.setProperty(resolve2 instanceof JSProperty || resolve2 instanceof JSDefinitionExpression || resolve2 instanceof JSField || ((JSElementBase)resolve2).getJSNamespace().hasQualifiedName());
            }
            if (resolve2 instanceof JSInitializerOwner) {
                this.buildHighlightForInitializerOwner((JSInitializerOwner)resolve2, builder2);
            }
            builder2.setExported(this.isExported(resolve2));
            if (!builder2.isFunction() && resolve2 instanceof JSTypeOwner) {
                builder2.setFunction(this.hasDeclaredFunctionType((JSTypeOwner)resolve2));
                if (!builder2.isFunction() && !(resolve2 instanceof JSDefinitionExpression) && !(resolve2 instanceof JSProperty) && Intrinsics.areEqual((Object)place.getContainingFile(), (Object)resolve2.getContainingFile())) {
                    type2 = JSResolveUtil.getElementJSType((PsiElement)resolve2);
                    builder2.setFunction(type2 != null && this.hasFunctionType((JSType)type2));
                }
            }
            return builder2.toDescriptor(resolve2);
        }

        private final boolean hasDeclaredFunctionType(JSTypeOwner typeOwner) {
            if (typeOwner instanceof JSTypeDeclarationOwner && DialectDetector.isTypeScript((PsiElement)((PsiElement)typeOwner))) {
                PsiElement typeElement = ((JSTypeDeclarationOwner)typeOwner).getTypeElement();
                return this.isFunctionTypeElementOrReference(typeElement);
            }
            return typeOwner.getJSType() instanceof JSFunctionType;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isFunctionTypeElementOrReference(PsiElement typeElement) {
            String qualifiedTypeName;
            if (typeElement instanceof TypeScriptSingleType && (qualifiedTypeName = ((TypeScriptSingleType)typeElement).getQualifiedTypeName()) != null) {
                boolean bl;
                block5: {
                    void $this$any$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Collection collection = new ES6QualifiedNameResolver(typeElement, false, false, false).resolveQualifiedName(qualifiedTypeName);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveQualifiedName(...)");
                    Collection resolveResults = collection;
                    Iterable iterable = resolveResults;
                    boolean $i$f$mapNotNull = false;
                    Iterator iterator = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        TypeScriptType it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        PsiElement it = (PsiElement)element$iv$iv;
                        boolean bl3 = false;
                        PsiElement psiElement = it;
                        if ((psiElement instanceof TypeScriptInterface ? (TypeScriptType)((TypeScriptInterface)it).getBody() : (psiElement instanceof TypeScriptTypeAlias ? ((TypeScriptTypeAlias)it).getTypeDeclaration() : null)) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            TypeScriptType it = (TypeScriptType)element$iv;
                            boolean bl5 = false;
                            if (!Companion.isFunctionTypeElement((PsiElement)it)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            return this.isFunctionTypeElement(typeElement);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasFunctionType(JSType type2) {
            Iterable $this$any$iv;
            if (type2 instanceof JSFunctionType) return true;
            if (type2 instanceof JSGenericTypeImpl) {
                JSType jSType = ((JSGenericTypeImpl)type2).getType();
                Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"getType(...)");
                if (this.hasFunctionType(jSType)) return true;
            }
            if (type2 instanceof JSUnionOrIntersectionType) {
                boolean bl;
                List list = ((JSUnionOrIntersectionType)type2).getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                Iterable iterable = list;
                Companion companion = Companion;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JSType p0 = (JSType)element$iv;
                        boolean bl2 = false;
                        if (!companion.hasFunctionType(p0)) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) return true;
            }
            if (type2 instanceof JSRecordType) {
                boolean bl;
                List list = ((JSRecordType)type2).getCallSignatures();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCallSignatures(...)");
                $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JSRecordType.CallSignature it = (JSRecordType.CallSignature)element$iv;
                        boolean bl3 = false;
                        if (!it.hasNew()) {
                            return true;
                        }
                        boolean bl4 = false;
                        if (!bl4) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) return true;
            }
            if (type2 instanceof JSAliasTypeImpl) {
                JSType jSType = ((JSAliasTypeImpl)type2).getAlias();
                Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"getAlias(...)");
                if (this.hasFunctionType(jSType)) return true;
                JSType jSType2 = ((JSAliasTypeImpl)type2).getOriginalType();
                Intrinsics.checkNotNullExpressionValue((Object)jSType2, (String)"getOriginalType(...)");
                if (this.hasFunctionType(jSType2)) return true;
            }
            if (!(type2 instanceof JSTypeImpl)) return false;
            if (!this.isFunctionTypeElementOrReference(((JSTypeImpl)type2).getSourceElement())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isFunctionTypeElement(PsiElement typeElement) {
            if (typeElement instanceof TypeScriptFunctionType) return true;
            if (!(typeElement instanceof TypeScriptObjectType)) return false;
            TypeScriptTypeMember[] typeScriptTypeMemberArray = ((TypeScriptObjectType)typeElement).getTypeMembers();
            Intrinsics.checkNotNullExpressionValue((Object)typeScriptTypeMemberArray, (String)"getTypeMembers(...)");
            Object[] $this$any$iv = typeScriptTypeMemberArray;
            boolean $i$f$any = false;
            int n = 0;
            int n2 = $this$any$iv.length;
            while (n < n2) {
                Object element$iv = $this$any$iv[n];
                TypeScriptTypeMember it = (TypeScriptTypeMember)element$iv;
                boolean bl = false;
                if (it instanceof TypeScriptCallSignature) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private final void buildHighlightForVariable(JSFieldVariable resolve2, JSSemanticHighlightingBuilder builder2) {
            if (JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)((JSInitializerOwner)resolve2)) instanceof JSFunctionItem) {
                builder2.setFunction(true);
            }
            if (this.isClassContext(resolve2.getContext()) || resolve2.getNamespace() != null || resolve2 instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)((JSParameter)resolve2))) {
                builder2.setProperty(true);
                builder2.setStatic(resolve2.getJSContext() == JSContext.STATIC);
            } else if (this.isLocalVariable(resolve2)) {
                builder2.setLocal(true);
            } else {
                builder2.setGlobal(true);
            }
        }

        private final JSHighlightDescriptor buildHighlightForClass(JSClass resolve2) {
            if (resolve2 instanceof TypeScriptTypeAlias) {
                return (JSHighlightDescriptor)JavaScriptHighlightDescriptor.TYPE_ALIAS;
            }
            if (resolve2 instanceof TypeScriptEnum) {
                return (JSHighlightDescriptor)TypeScriptHighlightDescriptor.ENUM;
            }
            return this.buildHighlightForClass((PsiElement)resolve2, resolve2.isInterface());
        }

        private final JSHighlightDescriptor buildHighlightForClass(PsiElement resolve2, boolean isInterface) {
            if (!isInterface && this.isExported(resolve2)) {
                return (JSHighlightDescriptor)JavaScriptHighlightDescriptor.EXPORTED_CLASS;
            }
            return isInterface ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INTERFACE : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.CLASS;
        }

        @JvmStatic
        public final boolean isArgumentsVariable(@NotNull PsiElement element2) {
            JSType type2;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return element2 instanceof ImplicitJSVariableImpl && JSNamedType.isNamedTypeWithName((JSType)(type2 = ((ImplicitJSVariableImpl)element2).getJSType()), (String)"IArguments");
        }

        @JvmStatic
        public final boolean isLocalVariable(@NotNull JSFieldVariable element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            PsiElement node = JSUseScopeProvider.getUseScopeElement((JSNamedElement)((JSNamedElement)element2));
            return node != null && (!(node instanceof JSFile) || !DialectDetector.isActionScript((PsiElement)node)) || this.isPredefinedLocalVariable(element2) || this.isFromEmbeddedModule((PsiElement)element2);
        }

        private final boolean isFromEmbeddedModule(PsiElement element2) {
            PsiElement node = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)element2);
            return ES6PsiUtil.isEmbeddedModule((PsiElement)node);
        }

        private final boolean isPredefinedLocalVariable(JSFieldVariable resolvedElement) {
            if (!PREDEFINED_LOCAL_VARS.contains(resolvedElement.getName())) {
                return false;
            }
            VirtualFile virtualFile = resolvedElement.getContainingFile().getViewProvider().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            VirtualFile file = virtualFile;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String path2 = string;
            return StringsKt.endsWith$default((String)path2, (String)"/@types/node/index.d.ts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)"/@types/node/globals.d.ts", (boolean)false, (int)2, null);
        }

        private final PsiElement findLeafToHighlight(PsiElement element2) {
            PsiElement markedNode;
            if (element2 instanceof JSAttribute) {
                return element2;
            }
            if (element2 instanceof JSNamedElement) {
                PsiElement nameElement = ((JSNamedElement)element2).getNameIdentifier();
                if (nameElement != null) {
                    return nameElement;
                }
                if (element2 instanceof JSProperty) {
                    return null;
                }
            }
            if ((markedNode = element2.getLastChild()) == null) {
                markedNode = element2;
            }
            while (true) {
                PsiElement psiElement = markedNode;
                Intrinsics.checkNotNull((Object)psiElement);
                if (psiElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER || markedNode.getNode().getElementType() == JSTokenTypes.PRIVATE_IDENTIFIER || markedNode instanceof ES6ComputedName || markedNode.getPrevSibling() == null) break;
                markedNode = markedNode.getPrevSibling();
            }
            return markedNode;
        }

        @JvmStatic
        @Nullable
        public final HighlightInfo justLineMarker(@NotNull PsiElement markedNode, @NotNull TextAttributesKey attrKey, @Nullable String debugName) {
            Intrinsics.checkNotNullParameter((Object)markedNode, (String)"markedNode");
            Intrinsics.checkNotNullParameter((Object)attrKey, (String)"attrKey");
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(markedNode).textAttributes(attrKey);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"textAttributes(...)");
            HighlightInfo.Builder builder3 = builder2;
            if (debug && debugName != null) {
                builder3.descriptionAndTooltip(debugName);
            }
            return builder3.create();
        }

        private final boolean isFunctionDescriptor(JSHighlightDescriptor descriptor) {
            if (descriptor instanceof JavaScriptHighlightDescriptor) {
                return switch (WhenMappings.$EnumSwitchMapping$1[((JavaScriptHighlightDescriptor)descriptor).ordinal()]) {
                    case 1, 2, 3, 4, 5 -> true;
                    default -> false;
                };
            }
            return false;
        }

        private final void buildHighlightForInitializerOwner(JSInitializerOwner node, JSSemanticHighlightingBuilder builder2) {
            if (builder2.isClass() || builder2.isFunction()) {
                return;
            }
            PsiElement furthestElement = (PsiElement)node.getInitializerOrStub();
            if (node instanceof JSDefinitionExpression) {
                PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)((PsiElement)node));
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"calculateMeaningfulElement(...)");
                PsiElement meaningfulElement = psiElement;
                if (!Intrinsics.areEqual((Object)meaningfulElement, (Object)node)) {
                    JSExpression secondInitializer;
                    furthestElement = meaningfulElement;
                    if (meaningfulElement instanceof JSInitializerOwner && (secondInitializer = ((JSInitializerOwner)meaningfulElement).getInitializerOrStub()) != null) {
                        furthestElement = (PsiElement)secondInitializer;
                    }
                }
            }
            if (furthestElement instanceof JSClass) {
                builder2.setClass(true);
            } else if (furthestElement instanceof JSFunctionItem) {
                builder2.setFunction(true);
            }
        }

        private final PsiElement calculateMeaningfulElementForHighlighting(PsiElement element2) {
            PsiElement psiElement;
            PsiFile psiFile = element2.getContainingFile();
            if (psiFile == null) {
                return element2;
            }
            VirtualFile file = psiFile.getVirtualFile();
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex index = projectFileIndex;
            if (file != null && (index.isInContent(file) || index.isInLibrarySource(file))) {
                PsiElement psiElement2 = JSStubBasedPsiTreeUtil.calculateTargetElementForHighlighting((PsiElement)element2);
                psiElement = psiElement2;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"calculateTargetElementForHighlighting(...)");
            } else {
                psiElement = element2;
            }
            return psiElement;
        }

        private final boolean isExported(PsiElement element2) {
            if (ES6ImportHandler.isExportedWithNameOrDefaultOrAssignment((PsiElement)element2)) {
                return true;
            }
            if (!(element2 instanceof JSElementBase)) {
                return false;
            }
            if (CommonJSUtil.isExportNamespace((JSQualifiedName)((JSElementBase)element2).getNamespace()) || CommonJSUtil.isModuleExportsAssigmentTarget((JSElementBase)((JSElementBase)element2))) {
                return true;
            }
            if (((JSElementBase)element2).getJSNamespace().getQualifiedName() != null || !((JSElementBase)element2).getJSNamespace().isSourceStrict()) {
                return false;
            }
            PsiFile file = element2.getContainingFile();
            if (file instanceof JSFile && (((JSFile)file).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.COMMONJS || ((JSFile)file).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS)) {
                List list = JSResolveUtil.getExportedElements((JSExecutionScope)((JSExecutionScope)file));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExportedElements(...)");
                Collection exportedElements = list;
                if (exportedElements.size() == 1) {
                    PsiElement exportedElement = (PsiElement)CollectionsKt.first((Iterable)exportedElements);
                    return this.calculateMeaningfulElementForHighlighting(exportedElement) == element2;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[JSImplicitElement.Type.values().length];
                try {
                    nArray[JSImplicitElement.Type.Class.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JSImplicitElement.Type.Interface.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JSImplicitElement.Type.Function.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JSImplicitElement.Type.Method.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JSImplicitElement.Type.Namespace.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JSImplicitElement.Type.Variable.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JSImplicitElement.Type.Property.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JSImplicitElement.Type.Tag.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[JavaScriptHighlightDescriptor.values().length];
                try {
                    nArray[JavaScriptHighlightDescriptor.GLOBAL_FUNCTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JavaScriptHighlightDescriptor.EXPORTED_FUNCTION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JavaScriptHighlightDescriptor.LOCAL_FUNCTION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0006\"\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\bR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSSemanticHighlightingVisitor$JSSemanticHighlightingBuilder;", "", "<init>", "()V", "isStatic", "", "()Z", "setStatic", "(Z)V", "isFunction", "setFunction", "isExported", "setExported", "isLocal", "setLocal", "isGlobal", "setGlobal", "isClass", "setClass", "isProperty", "setProperty", "toDescriptor", "Lcom/intellij/lang/javascript/highlighting/JSHighlightDescriptor;", "resolve", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.analysis.impl"})
    private static final class JSSemanticHighlightingBuilder {
        private boolean isStatic;
        private boolean isFunction;
        private boolean isExported;
        private boolean isLocal;
        private boolean isGlobal;
        private boolean isClass;
        private boolean isProperty;

        public final boolean isStatic() {
            return this.isStatic;
        }

        public final void setStatic(boolean bl) {
            this.isStatic = bl;
        }

        public final boolean isFunction() {
            return this.isFunction;
        }

        public final void setFunction(boolean bl) {
            this.isFunction = bl;
        }

        public final boolean isExported() {
            return this.isExported;
        }

        public final void setExported(boolean bl) {
            this.isExported = bl;
        }

        public final boolean isLocal() {
            return this.isLocal;
        }

        public final void setLocal(boolean bl) {
            this.isLocal = bl;
        }

        public final boolean isGlobal() {
            return this.isGlobal;
        }

        public final void setGlobal(boolean bl) {
            this.isGlobal = bl;
        }

        public final boolean isClass() {
            return this.isClass;
        }

        public final void setClass(boolean bl) {
            this.isClass = bl;
        }

        public final boolean isProperty() {
            return this.isProperty;
        }

        public final void setProperty(boolean bl) {
            this.isProperty = bl;
        }

        @Nullable
        public final JSHighlightDescriptor toDescriptor(@NotNull PsiElement resolve2) {
            Intrinsics.checkNotNullParameter((Object)resolve2, (String)"resolve");
            if (this.isExported) {
                return this.isFunction ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.EXPORTED_FUNCTION : (this.isClass ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.EXPORTED_CLASS : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.EXPORTED_VARIABLE);
            }
            if (this.isLocal) {
                return this.isFunction ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.LOCAL_FUNCTION : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.LOCAL_VARIABLE;
            }
            if (this.isGlobal) {
                return this.isFunction ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.GLOBAL_FUNCTION : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.GLOBAL_VARIABLE;
            }
            if (this.isProperty) {
                if (this.isFunction) {
                    return this.isStatic ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.STATIC_MEMBER_FUNCTION : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INSTANCE_MEMBER_FUNCTION;
                }
                return this.isStatic ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.STATIC_MEMBER_VARIABLE : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.INSTANCE_MEMBER_VARIABLE;
            }
            if (this.isFunction) {
                return Companion.isExported(resolve2) ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.EXPORTED_FUNCTION : (resolve2.getUseScope() instanceof LocalSearchScope || Companion.isFromEmbeddedModule(resolve2) ? (JSHighlightDescriptor)JavaScriptHighlightDescriptor.LOCAL_FUNCTION : (JSHighlightDescriptor)JavaScriptHighlightDescriptor.GLOBAL_FUNCTION);
            }
            return null;
        }
    }
}

