/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.version;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionDescriptor;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintVersionView
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JSHintVersionView.class);
    private final Project myProject;
    private final LabeledComponent<JComboBox<JSHintVersionDescriptor>> myComponent;
    private boolean myUpdatingVersionDescriptors;
    private String myPreservedVersion;
    @Nullable
    private Balloon myActiveErrorBalloon;

    public JSHintVersionView(@NotNull Project project) {
        if (project == null) {
            JSHintVersionView.$$$reportNull$$$0(0);
        }
        this.myUpdatingVersionDescriptors = false;
        this.myProject = project;
        final JComboBox<JSHintVersionDescriptor> comboBox = JSHintVersionView.createComboBox();
        this.myComponent = LabeledComponent.create(comboBox, (String)JavaScriptBundle.message((String)"jshint.version.label", (Object[])new Object[0]));
        this.myComponent.setLabelLocation("West");
        comboBox.addActionListener(e -> {
            if (!this.myUpdatingVersionDescriptors) {
                this.checkSelectedVersion();
            }
        });
        comboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JSHintVersionView.this.myPreservedVersion != null) {
                    JSHintVersionView.asyncDownloadVersions(() -> JSHintVersionView.this.fillVersions(JSHintVersionView.this.myPreservedVersion), null);
                }
                comboBox.removeFocusListener(this);
            }
        });
    }

    private void checkSelectedVersion() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.hideActiveErrorBalloon();
            JSHintVersionDescriptor selected = this.getSelectedVersionDescriptor();
            this.obtainSource(selected);
        });
    }

    private void obtainSource(final @NotNull JSHintVersionDescriptor descriptor) {
        if (descriptor == null) {
            JSHintVersionView.$$$reportNull$$$0(1);
        }
        if (JSHintVersionUtil.isSourceLocallyAvailable(descriptor.getVersion())) {
            return;
        }
        final CompletableFuture future = new CompletableFuture();
        ModalityState modalityState = ModalityState.current();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, this.myProject, JavaScriptBundle.message((String)"jshint.progress.title", (Object[])new Object[]{descriptor.getVersion()}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(JavaScriptBundle.message((String)"jshint.progress.title.downloading", (Object[])new Object[]{JSHintVersionUtil.getJSHintSourceFileBaseName(descriptor.getVersion())}));
                try {
                    JSHintVersionUtil.downloadSourceVersionOnce(indicator, descriptor);
                    future.complete(Unit.INSTANCE);
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView$2", "run"));
            }
        });
        future.whenComplete((completed, throwable) -> {
            if (throwable != null) {
                LOG.info("Can't obtain source of JSHint " + descriptor.getVersion());
                ApplicationManager.getApplication().invokeLater(() -> this.reportDownloadError(descriptor, throwable instanceof CancellationException), modalityState);
            }
        });
    }

    private void reportDownloadError(@NotNull JSHintVersionDescriptor descriptor, boolean cancelled) {
        if (descriptor == null) {
            JSHintVersionView.$$$reportNull$$$0(2);
        }
        Runnable retryAction = () -> {
            this.hideActiveErrorBalloon();
            this.checkSelectedVersion();
        };
        String title = "<b>JSHint " + descriptor.getVersion() + " is not available</b>";
        JComponent errorMessageBalloonContent = !cancelled ? JSHintUtil.createIOExceptionBalloonComponent(title + "<br/>Can not download " + descriptor.getUrl(), retryAction, true) : JSHintUtil.createIOExceptionBalloonComponent(title + "<br/>" + descriptor.getUrl() + " download was cancelled", retryAction, false);
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(errorMessageBalloonContent).setDialogMode(true).setCloseButtonEnabled(true).setDisposable((Disposable)this).setFillColor(MessageType.ERROR.getPopupBackground()).setContentInsets((Insets)JBUI.insets((int)10)).createBalloon();
        this.hideActiveErrorBalloon();
        balloon.show(this.findRelativePoint(), Balloon.Position.below);
        this.myActiveErrorBalloon = balloon;
    }

    @NotNull
    private RelativePoint findRelativePoint() {
        JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
        return new RelativePoint((Component)comboBox, new Point(comboBox.getWidth() / 2, (int)((double)comboBox.getHeight() / 1.2)));
    }

    private void hideActiveErrorBalloon() {
        if (this.myActiveErrorBalloon != null) {
            this.myActiveErrorBalloon.hide();
            this.myActiveErrorBalloon = null;
        }
    }

    @NotNull
    public JSHintVersionDescriptor getSelectedVersionDescriptor() {
        JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
        JSHintVersionDescriptor jSHintVersionDescriptor = (JSHintVersionDescriptor)Objects.requireNonNull(comboBox.getSelectedItem());
        if (jSHintVersionDescriptor == null) {
            JSHintVersionView.$$$reportNull$$$0(3);
        }
        return jSHintVersionDescriptor;
    }

    @NotNull
    private static JComboBox<JSHintVersionDescriptor> createComboBox() {
        ComboBox comboBox = new ComboBox();
        comboBox.setRenderer(BuilderKt.textListCellRenderer((String)JavaScriptBundle.message((String)"jshint.label.no.version", (Object[])new Object[0]), value -> value.getVersion() + (String)(value.isBundled() ? " " + JavaScriptBundle.message((String)"jshint.label.bundled.suffix", (Object[])new Object[0]) : "")));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            JSHintVersionView.$$$reportNull$$$0(4);
        }
        return comboBox2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillVersions(@Nullable String selectedVersion) {
        this.myUpdatingVersionDescriptors = true;
        try {
            ImmutableList<JSHintVersionDescriptor> descriptors;
            ImmutableList<JSHintVersionDescriptor> fixedDescriptors = descriptors = JSHintVersionUtil.getVersions();
            JSHintVersionDescriptor selectedDescriptor = null;
            if (selectedVersion != null) {
                fixedDescriptors = JSHintVersionUtil.addGuessableVersionDescriptorFirstIfMissing(descriptors, selectedVersion);
                selectedDescriptor = JSHintVersionUtil.find(fixedDescriptors, selectedVersion);
            }
            JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
            SwingHelper.updateItems((JComboBox)comboBox, fixedDescriptors, (Object)selectedDescriptor);
        }
        finally {
            this.myUpdatingVersionDescriptors = false;
        }
    }

    @NotNull
    public Component getComponent() {
        LabeledComponent<JComboBox<JSHintVersionDescriptor>> labeledComponent = this.myComponent;
        if (labeledComponent == null) {
            JSHintVersionView.$$$reportNull$$$0(5);
        }
        return labeledComponent;
    }

    public void setVersion(@NotNull String version2) {
        if (version2 == null) {
            JSHintVersionView.$$$reportNull$$$0(6);
        }
        this.myPreservedVersion = version2;
        this.fillVersions(version2);
        ImmutableList<JSHintVersionDescriptor> descriptors = JSHintVersionUtil.getVersions();
        if (JSHintVersionUtil.find(descriptors, version2) != null) {
            this.checkSelectedVersion();
        } else {
            JSHintVersionView.asyncDownloadVersions(() -> {
                this.fillVersions(version2);
                this.checkSelectedVersion();
            }, this::checkSelectedVersion);
        }
    }

    private static void asyncDownloadVersions(@Nullable Runnable onSuccess, @Nullable Runnable onFailure) {
        ModalityState modalityState = ModalityState.any();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            block3: {
                try {
                    JSHintVersionUtil.downloadVersions(null);
                    if (onSuccess != null) {
                        application.invokeLater(onSuccess, modalityState);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Can't update jshint version list", (Throwable)e);
                    if (onFailure == null) break block3;
                    application.invokeLater(onFailure, modalityState);
                }
            }
        });
    }

    @NotNull
    public String getVersion() {
        JSHintVersionDescriptor selected = this.getSelectedVersionDescriptor();
        String string = selected.getVersion();
        if (string == null) {
            JSHintVersionView.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVersionDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createComboBox";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "obtainSource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportDownloadError";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

