/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.index.JSIndexKeys;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public final class BackendJSResolveUtil {
    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope2) {
        return BackendJSResolveUtil.findElementsByName(name, project, scope2, true);
    }

    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope2, boolean resultAsNavigationElements) {
        HashSet<JSQualifiedNamedElement> result2 = new HashSet<JSQualifiedNamedElement>();
        Collection jsQualifiedNamedElements = StubIndex.getElements((StubIndexKey)JSIndexKeys.JS_NAME_INDEX_KEY, (Object)name, (Project)project, (GlobalSearchScope)scope2, JSQualifiedNamedElement.class);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (JSQualifiedNamedElement e : jsQualifiedNamedElements) {
            VirtualFile fileOrDir = e.getContainingFile().getVirtualFile();
            if (!projectFileIndex.isInLibrarySource(fileOrDir) ? !projectFileIndex.isInSource(fileOrDir) && !projectFileIndex.isInLibraryClasses(fileOrDir) && e.getContainingFile().getLanguage() == FlexSupportLoader.ECMA_SCRIPT_L4 : ApplicationManager.getApplication().isUnitTestMode() && !projectFileIndex.isInLibraryClasses(fileOrDir)) continue;
            if (resultAsNavigationElements) {
                PsiElement navElement = e.getNavigationElement();
                if (navElement instanceof JSQualifiedNamedElement) {
                    result2.add((JSQualifiedNamedElement)navElement);
                    continue;
                }
                result2.add(e);
                continue;
            }
            result2.add(e);
        }
        ArrayList files = new ArrayList(FilenameIndex.getVirtualFilesByName((String)(name + ".mxml"), (GlobalSearchScope)scope2));
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (!file.isValid() || !projectFileIndex.isInSource(file) || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile)) continue;
            result2.add((JSQualifiedNamedElement)XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)psiFile)));
        }
        return result2;
    }
}

