/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.InheritanceBuilder;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassDataProcessor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassInheritanceNode {
    public static final String INHERITS = "inherits";
    @NotNull
    private final JSFunction myFunction;
    private PsiElement mySearchTarget;
    private UsageInfo[] myInfos;
    private final List<JSReferenceExpression> myUsedAsError;
    private JSItemToClassDataProcessor myDataProcessor;
    @Nullable
    private ClassInheritanceNode myParent;
    private final List<ClassInheritanceNode> myDescendants;
    private MultiMap<PsiElement, String> myConflicts;
    private final List<PsiElement> myConflictShowOrder;
    private final Map<String, Integer> myConflictDescriptions;

    ClassInheritanceNode(@NotNull JSFunction function) {
        if (function == null) {
            ClassInheritanceNode.$$$reportNull$$$0(0);
        }
        this.myConflictShowOrder = new ArrayList<PsiElement>();
        this.myConflictDescriptions = new HashMap<String, Integer>();
        this.myFunction = function;
        this.myUsedAsError = new ArrayList<JSReferenceExpression>();
        this.myDescendants = new ArrayList<ClassInheritanceNode>();
    }

    public void process(@NotNull SearchScope searchScope, @Nullable JSFunction causeChild, boolean goUp, @NotNull Set<JSFunction> controlSet) {
        if (searchScope == null) {
            ClassInheritanceNode.$$$reportNull$$$0(1);
        }
        if (controlSet == null) {
            ClassInheritanceNode.$$$reportNull$$$0(2);
        }
        if (controlSet.contains(this.myFunction)) {
            return;
        }
        controlSet.add(this.myFunction);
        this.myConflicts = new MultiMap();
        this.findUsages(searchScope);
        this.parseUsages();
        InheritanceBuilder inheritanceBuilder = this.myDataProcessor.getInheritanceBuilder();
        if (goUp && inheritanceBuilder.getAncestor() != null) {
            this.myParent = new ClassInheritanceNode(inheritanceBuilder.getAncestor());
            this.myParent.process(searchScope, this.myFunction, true, controlSet);
        }
        Set<JSFunction> descendants = inheritanceBuilder.getDescendants();
        for (JSFunction descendant : descendants) {
            if (descendant.equals((Object)causeChild)) continue;
            ClassInheritanceNode node = new ClassInheritanceNode(descendant);
            this.myDescendants.add(node);
            node.process(searchScope, null, false, controlSet);
        }
    }

    public JSItemToClassDataProcessor getDataProcessor() {
        return this.myDataProcessor;
    }

    public MultiMap<PsiElement, String> getConflicts() {
        return this.myConflicts;
    }

    public List<PsiElement> getConflictShowOrder() {
        return this.myConflictShowOrder;
    }

    @NotNull
    public JSFunction getFunction() {
        JSFunction jSFunction = this.myFunction;
        if (jSFunction == null) {
            ClassInheritanceNode.$$$reportNull$$$0(3);
        }
        return jSFunction;
    }

    @Nullable
    public ClassInheritanceNode getParent() {
        return this.myParent;
    }

    public List<ClassInheritanceNode> getDescendants() {
        return this.myDescendants;
    }

    public UsageInfo[] getInfos() {
        return this.myInfos;
    }

    private void parseUsages() {
        List<UsageInfo> usagesList = ClassInheritanceNode.sortUsages(this.myInfos);
        String name = this.mySearchTarget instanceof JSNamedElement ? ((JSNamedElement)this.mySearchTarget).getName() : this.myFunction.getName();
        this.myDataProcessor = new JSItemToClassDataProcessor(this.myFunction, null, name);
        List conflictUsages = ContainerUtil.sorted(this.myDataProcessor.prepareAndFindConflicts(usagesList, this.myUsedAsError), (o1, o2) -> {
            int namesResult = ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            if (namesResult != 0) {
                return namesResult;
            }
            if (((UsageInfo)o1.getSecond()).getElement() == null || ((UsageInfo)o2.getSecond()).getElement() == null) {
                return 0;
            }
            return Integer.compare(((UsageInfo)o1.getSecond()).getElement().getTextRange().getStartOffset(), ((UsageInfo)o2.getSecond()).getElement().getTextRange().getStartOffset());
        });
        for (Pair pair : conflictUsages) {
            PsiReference topReference;
            UsageInfo usage = (UsageInfo)pair.getSecond();
            PsiElement element2 = usage.getElement();
            if (element2 == null) continue;
            PsiElement target2 = element2;
            if (element2 instanceof JSReferenceExpression && (topReference = ClassInheritanceNode.getTopReference((PsiReference)element2)) instanceof PsiElement) {
                target2 = (PsiElement)topReference;
            }
            this.addConflict(element2, ClassInheritanceNode.getDuplicateElementDescription(target2, (String)pair.getFirst()));
        }
        Map<JSExpression, JSNamedElementBase> allAncestors = this.myDataProcessor.getInheritanceBuilder().getAllAncestors();
        if (allAncestors.size() > 1) {
            ArrayList<JSExpression> list = new ArrayList<JSExpression>(allAncestors.keySet());
            list.sort((o1, o2) -> {
                JSNamedElementBase v1 = (JSNamedElementBase)allAncestors.get(o1);
                JSNamedElementBase v2 = (JSNamedElementBase)allAncestors.get(o2);
                int result2 = Comparing.compare((Comparable)((Object)v1.getName()), (Comparable)((Object)v2.getName()));
                if (result2 != 0) {
                    return result2;
                }
                return Integer.compare(o1.getTextRange().getStartOffset(), o2.getTextRange().getStartOffset());
            });
            for (JSExpression key : list) {
                this.addConflict((PsiElement)key, this.myDataProcessor.getConstructorFunction().getFunctionName() + " has conflicting ancestor declarations: from " + allAncestors.get(key).getName() + " in " + key.getText());
            }
        }
    }

    private void addConflict(@NotNull PsiElement key, @NotNull String description) {
        if (key == null) {
            ClassInheritanceNode.$$$reportNull$$$0(4);
        }
        if (description == null) {
            ClassInheritanceNode.$$$reportNull$$$0(5);
        }
        this.myConflictShowOrder.add(key);
        if (this.myConflictDescriptions.containsKey(description)) {
            Integer integer = this.myConflictDescriptions.get(description);
            description = (String)description + " (" + integer + ")";
            this.myConflictDescriptions.put((String)description, integer + 1);
        } else {
            this.myConflictDescriptions.put((String)description, 1);
        }
        this.myConflicts.putValue((Object)key, description);
    }

    private boolean nonRecursiveHasInheritanceConflicts() {
        return this.myDataProcessor.getInheritanceBuilder().getAllAncestors().size() > 1;
    }

    public boolean hasInheritanceConflicts() {
        ClassInheritanceNode parent;
        if (this.nonRecursiveHasInheritanceConflicts()) {
            return true;
        }
        for (parent = this; parent != null && parent.getParent() != null; parent = parent.getParent()) {
        }
        ArrayDeque<ClassInheritanceNode> queue = new ArrayDeque<ClassInheritanceNode>();
        queue.add(parent);
        while (!queue.isEmpty()) {
            List<ClassInheritanceNode> descendants = ((ClassInheritanceNode)queue.removeFirst()).getDescendants();
            for (ClassInheritanceNode descendant : descendants) {
                if (descendant.nonRecursiveHasInheritanceConflicts()) {
                    return true;
                }
                queue.add(descendant);
            }
        }
        return false;
    }

    private static String getDuplicateElementDescription(PsiElement target2, String name) {
        JSCallExpression call;
        PsiElement psiElement;
        String targetText = target2.getText();
        if (target2 instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)target2).getReferenceName()) && target2.getParent() instanceof JSArgumentList && (psiElement = target2.getParent().getParent()) instanceof JSCallExpression && ClassInheritanceNode.checkForObjectMethod((call = (JSCallExpression)psiElement).getMethodExpression(), Set.of("defineProperties", "defineProperty", "create"))) {
            return targetText + "." + name + " inside " + call.getMethodExpression().getText() + " has duplicate definition";
        }
        return targetText + " has duplicate definition";
    }

    public void findUsages(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            ClassInheritanceNode.$$$reportNull$$$0(6);
        }
        this.mySearchTarget = this.myFunction;
        boolean wasReference = false;
        if (this.myFunction instanceof JSFunctionExpression) {
            if (this.myFunction.getParent() instanceof JSVariable) {
                this.mySearchTarget = this.myFunction.getParent();
            } else if (this.myFunction.getParent() instanceof JSAssignmentExpression && ((JSAssignmentExpression)this.myFunction.getParent()).getDefinitionExpression() != null) {
                this.mySearchTarget = ((JSAssignmentExpression)this.myFunction.getParent()).getDefinitionExpression().getExpression();
                this.mySearchTarget = this.mySearchTarget instanceof JSReferenceExpression ? ((JSReferenceExpression)this.mySearchTarget).resolve() : this.mySearchTarget;
                wasReference = this.mySearchTarget != null;
                this.mySearchTarget = this.mySearchTarget == null ? this.myFunction : this.mySearchTarget;
            }
        }
        List references = JSDefaultRenameProcessor.getReferences(this.mySearchTarget, searchScope, false, JSDefaultRenameProcessor.ReferencesType.JS);
        if (wasReference) {
            references = ContainerUtil.filter(references, reference -> this.myFunction.getContainingFile().equals((Object)reference.getElement().getContainingFile()));
        }
        references = ContainerUtil.filter(references, reference -> ClassInheritanceNode.isAssignmentStatement(reference) || ClassInheritanceNode.checkForProcessedObjectMethods(reference) || ClassInheritanceNode.checkForOtherUtilityMethods(reference) || this.checkForThrows((PsiReference)reference));
        List usages = ContainerUtil.map((Collection)references, reference -> new UsageInfo(reference));
        this.myInfos = usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    @NotNull
    private static List<UsageInfo> sortUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ClassInheritanceNode.$$$reportNull$$$0(7);
        }
        ArrayList<UsageInfo> usagesList = new ArrayList<UsageInfo>(Arrays.asList(usages));
        usagesList.sort((o1, o2) -> {
            PsiElement e1 = o1.getElement();
            PsiElement e2 = o2.getElement();
            if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
                PsiReference ref1 = ClassInheritanceNode.getTopReference((PsiReference)e1);
                PsiReference ref2 = ClassInheritanceNode.getTopReference((PsiReference)e2);
                if (ref1 instanceof PsiElement && ref2 instanceof PsiElement) {
                    return ((PsiElement)ref1).getText().compareTo(((PsiElement)ref2).getText());
                }
            }
            if (e1 != null && e2 != null) {
                return e1.getText().compareTo(e2.getText());
            }
            return 0;
        });
        ArrayList<UsageInfo> arrayList = usagesList;
        if (arrayList == null) {
            ClassInheritanceNode.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean checkForOtherUtilityMethods(@NotNull PsiReference reference) {
        if (reference == null) {
            ClassInheritanceNode.$$$reportNull$$$0(9);
        }
        if (!(reference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiReference topReference = ClassInheritanceNode.getTopReference(reference);
        if (!(topReference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement parent = ((JSReferenceExpression)topReference).getParent();
        return parent instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression && ClassInheritanceNode.isNodeJSInheritsCall((JSCallExpression)parent.getParent());
    }

    static boolean isNodeJSInheritsCall(@NotNull JSCallExpression call) {
        if (call == null) {
            ClassInheritanceNode.$$$reportNull$$$0(10);
        }
        NodeCoreLibraryManager coreLibraryManager = NodeCoreLibraryManager.getInstance(call.getProject());
        JSExpression methodExpression = call.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            PsiElement resolve2;
            JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
            if (INHERITS.equals(((JSReferenceExpression)methodExpression).getReferenceName()) && qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null && ((resolve2 = JSChangeUtil.deepResolve((JSReferenceExpression)((JSReferenceExpression)qualifier))) != null && coreLibraryManager.isCoreModuleLibraryFile(resolve2.getContainingFile().getVirtualFile()) || "util".equals(((JSReferenceExpression)qualifier).getReferenceName()))) {
                return true;
            }
        }
        return false;
    }

    private boolean checkForThrows(@NotNull PsiReference reference) {
        PsiElement newParent;
        if (reference == null) {
            ClassInheritanceNode.$$$reportNull$$$0(11);
        }
        if (!(reference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiReference topReference = ClassInheritanceNode.getTopReference(reference);
        if (!(topReference instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement parent = ((JSReferenceExpression)topReference).getParent();
        if (parent instanceof JSNewExpression && ((JSNewExpression)parent).getMethodExpression().equals((Object)topReference) && ((newParent = parent.getParent()) instanceof JSThrowStatement || newParent instanceof JSThrowExpression)) {
            this.myUsedAsError.add((JSReferenceExpression)reference);
        }
        return false;
    }

    static PsiReference getTopReference(@NotNull PsiReference reference) {
        PsiElement current;
        if (reference == null) {
            ClassInheritanceNode.$$$reportNull$$$0(12);
        }
        if (reference instanceof PsiElement) {
            current = (PsiElement)reference;
        } else {
            return null;
        }
        while (current instanceof JSReferenceExpression) {
            if (!(current.getParent() instanceof PsiReference)) {
                return (PsiReference)current;
            }
            current = current.getParent();
        }
        return null;
    }

    private static boolean checkForProcessedObjectMethods(@NotNull PsiReference reference) {
        JSCallExpression call;
        JSExpression methodExpression;
        PsiElement psiElement;
        PsiReference topReference;
        if (reference == null) {
            ClassInheritanceNode.$$$reportNull$$$0(13);
        }
        if (!((topReference = ClassInheritanceNode.getTopReference(reference)) instanceof PsiElement)) {
            return false;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        return parent instanceof JSArgumentList && (psiElement = parent.getParent()) instanceof JSCallExpression && ClassInheritanceNode.checkForObjectMethod(methodExpression = (call = (JSCallExpression)psiElement).getMethodExpression(), JSConvertToClassProcessor.OBJECT_METHODS);
    }

    static boolean checkForObjectMethod(@NotNull JSExpression methodExpression, @NotNull Set<String> names) {
        JSReferenceExpression jsRef;
        if (methodExpression == null) {
            ClassInheritanceNode.$$$reportNull$$$0(14);
        }
        if (names == null) {
            ClassInheritanceNode.$$$reportNull$$$0(15);
        }
        return methodExpression instanceof JSReferenceExpression && (jsRef = (JSReferenceExpression)methodExpression).getReferenceName() != null && names.contains(jsRef.getReferenceName()) && jsRef.getQualifier() != null && "Object".equals(jsRef.getQualifier().getText());
    }

    @Nullable
    static JSAssignmentExpression findParentAssignment(@NotNull PsiReference reference) {
        PsiReference topReference;
        if (reference == null) {
            ClassInheritanceNode.$$$reportNull$$$0(16);
        }
        if (!((topReference = ClassInheritanceNode.getTopReference(reference)) instanceof PsiElement)) {
            return null;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        if (parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression) {
            return (JSAssignmentExpression)parent.getParent();
        }
        return null;
    }

    private static boolean isAssignmentStatement(@NotNull PsiReference reference) {
        PsiReference topReference;
        if (reference == null) {
            ClassInheritanceNode.$$$reportNull$$$0(17);
        }
        if (!((topReference = ClassInheritanceNode.getTopReference(reference)) instanceof PsiElement)) {
            return false;
        }
        PsiElement parent = ((PsiElement)topReference).getParent();
        return parent instanceof JSDefinitionExpression && parent.getParent() instanceof JSAssignmentExpression || parent instanceof JSNewExpression && parent.getParent() instanceof JSAssignmentExpression || parent instanceof JSAssignmentExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlSet";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/ClassInheritanceNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sortUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addConflict";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sortUsages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkForOtherUtilityMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNodeJSInheritsCall";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForThrows";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTopReference";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkForProcessedObjectMethods";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkForObjectMethod";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findParentAssignment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAssignmentStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }
}

