/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection
extends JSInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                PsiElement nameIdentifier;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!node.isConstructor()) {
                    return;
                }
                if (!DialectDetector.isTypeScript((PsiElement)node)) {
                    return;
                }
                JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)node);
                if (containingClass == null) {
                    return;
                }
                JSAttributeList list = node.getAttributeList();
                if (list != null && list.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
                    return;
                }
                if (TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)containingClass) && (nameIdentifier = node.getNameIdentifier()) != null) {
                    for (JSClass subClass : JSInheritanceUtil.findDirectSubClasses((JSClass)containingClass, (boolean)true)) {
                        if (subClass.getConstructor() != null) continue;
                        return;
                    }
                    holder.registerProblem(nameIdentifier, TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.this.getDisplayName(), new LocalQuickFix[]{JSFixFactory.getInstance().changeConstructorAccessRightsFix(node, JSAttributeList.AccessType.PROTECTED)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspections/TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection$1", "visitJSFunctionDeclaration"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

