/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementInDerivedTypesIntention
extends JavaScriptIntention {
    @Nullable
    private static PsiElement findClassMember(@NotNull PsiElement element2) {
        PsiElement parent;
        if (element2 == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(0);
        }
        return (parent = element2.getParent()) instanceof TypeScriptTypeMember || parent instanceof TypeScriptField || parent instanceof TypeScriptFunction ? parent : null;
    }

    private static JSClass[] getDerivedTypes(JSClass jsClass) {
        Query classes = jsClass.isInterface() ? JSClassSearch.searchInterfaceImplementations((JSClass)jsClass, (boolean)true) : JSClassSearch.searchClassInheritors((JSClass)jsClass, (boolean)true);
        return (JSClass[])classes.toArray((Object[])JSClass.EMPTY_ARRAY);
    }

    private static boolean hasMissingMember(JSClass jsClass, @Nullable String name) {
        if (name == null) {
            return false;
        }
        return TypeScriptUtil.getUnimplementedMembers((JSClass)jsClass, (boolean)false).keySet().stream().anyMatch(e -> name.equals(e.getElement().getName()));
    }

    @Contract(value="null -> false")
    private static boolean isAbstractClassOrInterface(@Nullable JSClass jsClass) {
        if (jsClass == null) {
            return false;
        }
        if (jsClass.isInterface()) {
            return true;
        }
        JSAttributeList attributeList = jsClass.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(2);
        }
        PsiElement classMember = TypeScriptImplementInDerivedTypesIntention.findClassMember(element2);
        assert (classMember instanceof PsiNamedElement);
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)classMember);
        assert (TypeScriptImplementInDerivedTypesIntention.isAbstractClassOrInterface(jsClass));
        JSClass[] derivedTypes = TypeScriptImplementInDerivedTypesIntention.getDerivedTypes(jsClass);
        String name = ((PsiNamedElement)classMember).getName();
        List filtered = Arrays.stream(derivedTypes).filter(c -> TypeScriptImplementInDerivedTypesIntention.hasMissingMember(c, name)).map(c -> new Item((JSClass)c)).collect(Collectors.toList());
        assert (!filtered.isEmpty());
        if (filtered.size() == 1) {
            TypeScriptImplementInDerivedTypesIntention.implementMember(classMember, ((Item)filtered.get((int)0)).clazz, project);
            return;
        }
        final ES6QualifiedNamedElementRenderer elementListCellRenderer = new ES6QualifiedNamedElementRenderer();
        ListCellRenderer<Item> renderer = new ListCellRenderer<Item>(this){

            @Override
            public Component getListCellRendererComponent(JList<? extends Item> list, Item value, int index, boolean isSelected, boolean cellHasFocus) {
                return value == Item.ALL ? new DefaultListCellRenderer().getListCellRendererComponent(list, JavaScriptBundle.message((String)"javascript.fix.implement.chooser.all", (Object[])new Object[0]), index, isSelected, cellHasFocus) : elementListCellRenderer.getListCellRendererComponent(list, value.clazz, index, isSelected, cellHasFocus);
            }
        };
        filtered.add(Item.ALL);
        JBList myList = new JBList(filtered);
        myList.setSelectionMode(2);
        Runnable runnable = () -> {
            Item selectedValue = (Item)myList.getSelectedValue();
            if (selectedValue == Item.ALL) {
                TypeScriptImplementInDerivedTypesIntention.implementInAllClasses(project, (JSNamedElement)classMember, filtered);
            } else {
                TypeScriptImplementInDerivedTypesIntention.implementMember(classMember, selectedValue.clazz, project);
            }
        };
        myList.setCellRenderer((ListCellRenderer)renderer);
        PopupChooserBuilder builder2 = new PopupChooserBuilder((JList)myList);
        builder2.setNamerForFiltering(o -> {
            if (o == Item.ALL) {
                return JavaScriptBundle.message((String)"javascript.fix.implement.chooser.all", (Object[])new Object[0]);
            }
            if (o instanceof Item) {
                String elementText = elementListCellRenderer.getElementText(((Item)o).clazz);
                return elementText + " " + JSQualifiedNamedElementRenderer.getContainerText((PsiElement)((Item)o).clazz);
            }
            return o.toString();
        });
        builder2.setTitle(JavaScriptBundle.message((String)"javascript.fix.implement.chooser.title", (Object[])new Object[0])).setItemChosenCallback(runnable).createPopup().showInBestPositionFor(editor);
    }

    private static void implementInAllClasses(@NotNull Project project, @NotNull JSNamedElement classMember, @NotNull List<Item> filtered) {
        if (project == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(3);
        }
        if (classMember == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(4);
        }
        if (filtered == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(5);
        }
        TypeScriptImplementInDerivedTypesIntention.executeFix(project, () -> {
            for (Item aClass : filtered) {
                if (aClass.clazz == null) continue;
                TypeScriptImplementInDerivedTypesIntention.doImplement(classMember, aClass.clazz, project);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void executeFix(Project project, Runnable action) {
        CommandProcessor.getInstance().executeCommand(project, action, JavaScriptBundle.message((String)"javascript.fix.implement.family", (Object[])new Object[0]), null);
    }

    private static void implementMember(PsiElement member, JSClass target2, Project project) {
        TypeScriptImplementInDerivedTypesIntention.executeFix(project, () -> TypeScriptImplementInDerivedTypesIntention.doImplement((JSNamedElement)member, target2, project));
    }

    private static void doImplement(JSNamedElement member, JSClass target2, Project project) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile virtualFile = target2.getContainingFile().getVirtualFile();
            ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)target2, () -> TypeScriptImplementMemberUtil.implementMembersForMemberOwner((PsiElement)target2, ContainerUtil.createMaybeSingletonSet((Object)member), null, false));
            String memberName = member.getName();
            assert (memberName != null);
            for (Object m : target2.getMembers()) {
                String name;
                if (!(m instanceof TypeScriptField) && !(m instanceof TypeScriptFunction) || !memberName.equals(name = ((JSNamedElement)m).getName())) continue;
                TypeScriptImplementInDerivedTypesIntention.scrollToMember(editor, (JSNamedElement)m);
                break;
            }
        });
    }

    private static void scrollToMember(Editor editor, JSNamedElement m) {
        if (editor != null) {
            editor.getCaretModel().moveToOffset(m.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(7);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        PsiElement classMember = TypeScriptImplementInDerivedTypesIntention.findClassMember(element2);
        if (!(classMember instanceof PsiNamedElement)) {
            return false;
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)classMember);
        if (!TypeScriptImplementInDerivedTypesIntention.isAbstractClassOrInterface(jsClass)) {
            return false;
        }
        Object[] derivedTypes = TypeScriptImplementInDerivedTypesIntention.getDerivedTypes(jsClass);
        String name = ((PsiNamedElement)classMember).getName();
        this.setText(JavaScriptBundle.message((String)"javascript.fix.implement", (Object[])new Object[]{new JSNamedElementPresenter(classMember).describeWithShortName()}));
        return ContainerUtil.exists((Object[])derivedTypes, c -> TypeScriptImplementInDerivedTypesIntention.hasMissingMember(c, name));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.fix.implement.family", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filtered";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptImplementInDerivedTypesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptImplementInDerivedTypesIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassMember";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "implementInAllClasses";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static final class Item {
        private static final Item ALL = new Item(null);
        JSClass clazz;

        private Item(JSClass clazz) {
            this.clazz = clazz;
        }
    }
}

