/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptServiceCompletionSupport;
import com.intellij.lang.typescript.lsp.JSFrameworkLsp4jServer;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServerDescriptor;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServiceKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfo;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoServiceUtilKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCustomization;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsDisabled;
import com.intellij.platform.lsp.api.customization.LspFoldingRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolDisabled;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R \u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u00060\bj\u0002`\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/typescript/lsp/TypeScriptGoLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lsp4jServerClass", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServerClass", "()Ljava/lang/Class;", "lspCustomization", "Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "getLspCustomization", "()Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.javascript.backend"})
public final class TypeScriptGoLspServerDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final Class<? extends LanguageServer> lsp4jServerClass;
    @NotNull
    private final LspCustomization lspCustomization;

    public TypeScriptGoLspServerDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = JavaScriptBundle.message((String)"typescript.go.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(project, string);
        this.lsp4jServerClass = JSFrameworkLsp4jServer.class;
        this.lspCustomization = new LspCustomization(){
            private final lspCustomization.diagnosticsCustomizer.1 diagnosticsCustomizer;
            private final BaseLspTypeScriptServiceCompletionSupport completionCustomizer;
            private final LspFoldingRangeDisabled foldingRangeCustomizer;
            private final LspWorkspaceSymbolCustomizer workspaceSymbolCustomizer;
            private final LspDocumentHighlightsCustomizer documentHighlightsCustomizer;
            {
                this.diagnosticsCustomizer = new LspDiagnosticsSupport(){

                    public void createAnnotation(AnnotationHolder holder, Diagnostic diagnostic, TextRange textRange, List<? extends IntentionAction> quickFixes) {
                        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
                        Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
                    }
                };
                this.completionCustomizer = new BaseLspTypeScriptServiceCompletionSupport();
                this.foldingRangeCustomizer = LspFoldingRangeDisabled.INSTANCE;
                this.workspaceSymbolCustomizer = (LspWorkspaceSymbolCustomizer)LspWorkspaceSymbolDisabled.INSTANCE;
                this.documentHighlightsCustomizer = (LspDocumentHighlightsCustomizer)LspDocumentHighlightsDisabled.INSTANCE;
            }

            public lspCustomization.diagnosticsCustomizer.1 getDiagnosticsCustomizer() {
                return this.diagnosticsCustomizer;
            }

            public BaseLspTypeScriptServiceCompletionSupport getCompletionCustomizer() {
                return this.completionCustomizer;
            }

            public LspFoldingRangeDisabled getFoldingRangeCustomizer() {
                return this.foldingRangeCustomizer;
            }

            public LspWorkspaceSymbolCustomizer getWorkspaceSymbolCustomizer() {
                return this.workspaceSymbolCustomizer;
            }

            public LspDocumentHighlightsCustomizer getDocumentHighlightsCustomizer() {
                return this.documentHighlightsCustomizer;
            }
        };
    }

    @NotNull
    public Class<? extends LanguageServer> getLsp4jServerClass() {
        return this.lsp4jServerClass;
    }

    @NotNull
    public LspCustomization getLspCustomization() {
        return this.lspCustomization;
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptGoLspServiceKt.getTsGoLSPService(this.getProject()).isAcceptable(file);
    }

    @NotNull
    public OSProcessHandler startServerProcess() {
        OSProcessHandler oSProcessHandler = TypeScriptGoServiceUtilKt.tryStartInWsl(this.createCommandLine(), LspServerDescriptor.LOG);
        if (oSProcessHandler == null) {
            oSProcessHandler = super.startServerProcess();
        }
        return oSProcessHandler;
    }

    @NotNull
    public GeneralCommandLine createCommandLine() {
        String serviceDirectory = (String)ReadAction.nonBlocking(() -> TypeScriptGoLspServerDescriptor.createCommandLine$lambda$0(this)).executeSynchronously();
        Intrinsics.checkNotNull((Object)serviceDirectory);
        TypeScriptGoPackageInfo typeScriptGoPackageInfo = TypeScriptGoPackageInfoKt.getTypeScriptGoPackageInfo(serviceDirectory);
        if (typeScriptGoPackageInfo == null) {
            Object[] objectArray = new Object[]{serviceDirectory};
            throw new ExecutionException(JavaScriptBundle.message((String)"typescript.go.bad.package", (Object[])objectArray));
        }
        TypeScriptGoPackageInfo tsGoInfo = typeScriptGoPackageInfo;
        String string = tsGoInfo.getBinaryExecutable().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new GeneralCommandLine(TypeScriptGoServiceUtilKt.getTsGoCommandLine(string));
    }

    private static final String createCommandLine$lambda$0(TypeScriptGoLspServerDescriptor this$0) {
        return TypeScriptServiceDirectoryWatcher.getService(this$0.getProject()).calcServiceDirectoryAndRefresh();
    }
}

