/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dom;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class XHTMLIncompatabilitiesJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("xhtml.incompatabilities.error.string", new Object[0]);
        if (string == null) {
            XHTMLIncompatabilitiesJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dom/XHTMLIncompatabilitiesJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReferenceExpression(@NotNull JSReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSReferenceExpression(referenceExpression);
            JSReferenceExpression qualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSReferenceExpression.class);
            if (qualifier == null || qualifier.getQualifier() != null) {
                return;
            }
            String qualifierText = qualifier.getReferenceName();
            if (!"document".equalsIgnoreCase(qualifierText)) {
                return;
            }
            String methodName = referenceExpression.getReferenceName();
            if (!("images".equalsIgnoreCase(methodName) || "body".equalsIgnoreCase(methodName) || "applets".equalsIgnoreCase(methodName) || "links".equalsIgnoreCase(methodName) || "forms".equalsIgnoreCase(methodName) || "anchors".equalsIgnoreCase(methodName))) {
                return;
            }
            this.registerError((PsiElement)referenceExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/sixrr/inspectjs/dom/XHTMLIncompatabilitiesJSInspection$Visitor", "visitJSReferenceExpression"));
        }
    }
}

