/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifter;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizerKt;
import com.jetbrains.rd.ide.document.RdDocumentVersions;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.string.IPrintableKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0001TBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001f\u0010/\u001a\u00020,2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020$03H\u0082\bJ\u0010\u00104\u001a\u0002012\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u00105\u001a\u00020,J\u0016\u00106\u001a\u00020,2\u0006\u00100\u001a\u0002072\u0006\u00108\u001a\u00020\u0010J\u0018\u00109\u001a\u00020,2\u0006\u00100\u001a\u0002072\b\b\u0002\u0010:\u001a\u00020\u0010J\u0010\u0010;\u001a\u00020,2\u0006\u00100\u001a\u000207H\u0002J\u0010\u0010<\u001a\u00020,2\u0006\u00100\u001a\u000207H\u0002J\u0010\u0010=\u001a\u00020,2\u0006\u00100\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010@\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0002J\u000e\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020CJ\u000e\u0010G\u001a\u00020,H\u0086@\u00a2\u0006\u0002\u0010HJ\u0010\u0010I\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010J\u001a\u00020KH\u0016J\u0010\u0010M\u001a\u00020,2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020QH\u0016J\u0018\u0010R\u001a\u00020,2\u0006\u00100\u001a\u0002072\u0006\u0010S\u001a\u00020CH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010#\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010D\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010B\u001a\u00020C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010F\u00a8\u0006U"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "Lcom/intellij/openapi/editor/ex/PrioritizedDocumentListener;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "versionHolder", "Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "sendDocumentText", "", "forceWrite", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rd/ide/model/RdDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;Lcom/jetbrains/rd/ide/requests/PatchEngine;ZZ)V", "getDocumentLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "backendUpdateInProgressMarker", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "()V", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "uniqueId", "", "getUniqueId", "()Ljava/lang/String;", "uniqueIdOrBlank", "getUniqueIdOrBlank", "isReceivingChange", "()Z", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "onDocumentChange", "change", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "diagnosticData", "Lkotlin/Function0;", "createRdDocumentChange", "sendInitialTextChange", "updateDocumentLog", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "redo", "receiveDocumentChange", "forceRecordPatch", "applyChangeCheckForce", "applyChange", "applyResetDocumentChange", "Lcom/jetbrains/rd/ide/model/RdResetDocumentChange;", "applyDocumentChange", "ensureDocumentVersion", "updateLastKnownVersion", "version", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "lastKnownVersion", "getLastKnownVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "waitForInitialDocumentChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beforeDocumentChange", "getPriority", "", "getVersion", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "createRangeShifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "sendDocumentChange", "prevVersion", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchEngineDocumentSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,399:1\n91#1,9:400\n100#1,11:413\n91#1,9:440\n100#1,11:453\n67#2,4:409\n67#2,4:424\n67#2,4:428\n67#2,4:432\n67#2,4:436\n67#2,4:449\n39#3,2:464\n*S KotlinDebug\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n*L\n85#1:400,9\n85#1:413,11\n329#1:440,9\n329#1:453,11\n85#1:409,4\n99#1:424,4\n103#1:428,4\n154#1:432,4\n204#1:436,4\n329#1:449,4\n366#1:464,2\n*E\n"})
public final class PatchEngineDocumentSynchronizer
implements PrioritizedDocumentListener,
DocumentSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime documentLifetime;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDocumentModel modelDocument;
    @NotNull
    private final RdDocumentId documentId;
    @NotNull
    private final DocumentVersionHolder versionHolder;
    @NotNull
    private final PatchEngine engine;
    private final boolean sendDocumentText;
    private final boolean forceWrite;
    private boolean backendUpdateInProgressMarker;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DocumentLog documentLog;
    private static int debugId;

    public PatchEngineDocumentSynchronizer(@NotNull Lifetime documentLifetime, @NotNull Document document, @NotNull RdDocumentModel modelDocument, @NotNull RdDocumentId documentId, @NotNull DocumentVersionHolder versionHolder, @NotNull PatchEngine engine, boolean sendDocumentText, boolean forceWrite) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)modelDocument, (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)versionHolder, (String)"versionHolder");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.documentLifetime = documentLifetime;
        this.document = document;
        this.modelDocument = modelDocument;
        this.documentId = documentId;
        this.versionHolder = versionHolder;
        this.engine = engine;
        this.sendDocumentText = sendDocumentText;
        this.forceWrite = forceWrite;
        this.documentLog = new DocumentLog(true);
        BuildersKt.launch$default((CoroutineScope)this.getDocumentLifetime().getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PatchEngineDocumentSynchronizer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl16
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        PatchEngineDocumentSynchronizer.access$getDocumentLog$p(this.this$0).updateLastKnownVersion(this.this$0.getLastKnownVersion());
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        String fileName = DocumentExKt.createLogCategory(this.getDocumentId());
        int n = debugId;
        debugId = n + 1;
        Logger logger = Logger.getInstance((String)("#com.jetbrains.rd.ide.document.Document#" + n + "(" + fileName + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.getDocument().addDocumentListener((DocumentListener)this, DisposableEx.createNestedDisposable$default(this.getDocumentLifetime(), null, 1, null));
    }

    @Override
    @NotNull
    public Lifetime getDocumentLifetime() {
        return this.documentLifetime;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    @Override
    @NotNull
    public RdDocumentId getDocumentId() {
        return this.documentId;
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    @Nullable
    public final String getUniqueId() {
        return DocumentExKt.getUniqueRdIdentifier(this.getDocument());
    }

    @NotNull
    public final String getUniqueIdOrBlank() {
        String string = this.getUniqueId();
        if (string == null) {
            PatchEngineDocumentSynchronizer $this$_get_uniqueIdOrBlank__u24lambda_u240 = this;
            boolean bl = false;
            $this$_get_uniqueIdOrBlank__u24lambda_u240.logger.error("Document (documentId=" + $this$_get_uniqueIdOrBlank__u24lambda_u240.getDocumentId() + " uniqueId is null");
            string = "";
        }
        return string;
    }

    @Override
    public boolean isReceivingChange() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.backendUpdateInProgressMarker;
    }

    /*
     * WARNING - void declaration
     */
    public void documentChanged(@NotNull DocumentEvent event) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isReceivingChange()) {
            return;
        }
        RdDocumentChange change = this.createRdDocumentChange(event);
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this;
        RdDocumentChange change$iv = change;
        boolean $i$f$onDocumentChange = false;
        if (!Intrinsics.areEqual((Object)change$iv.getNewVersion(), (Object)this_$iv.versionHolder.getVersion())) {
            this_$iv.logger.error("change versions: " + change$iv.getNewVersion() + " is not synchronized with versionsHolder:" + this_$iv.versionHolder.getVersion());
        }
        DocumentSynchronizerListeners.Companion.getInstance(this_$iv.engine).change(change$iv);
        this_$iv.documentLog.addOrUpdate(change$iv.getNewVersion(), (RdDocumentChangeBase)change$iv);
        if (this_$iv.backendUpdateInProgressMarker) {
            Logger $this$trace$iv$iv = this_$iv.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                logger.trace("Skip processing document change from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(event) + ", Version: " + this_$iv.versionHolder.getVersion());
            }
        } else {
            Logger $this$trace$iv$iv = this_$iv.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv$iv;
                boolean bl = false;
                boolean bl3 = false;
                logger.trace("Document was changed from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(event) + ", Version: " + this_$iv.versionHolder.getVersion() + ", Document length: " + this_$iv.getDocument().getTextLength());
            }
            super.sendDocumentChange((RdDocumentChangeBase)change$iv, change$iv.getOldVersion());
            if (!Intrinsics.areEqual((Object)change$iv.getNewVersion(), (Object)this_$iv.versionHolder.getVersion())) {
                this_$iv.logger.error("change versions: " + change$iv.getNewVersion() + " is not synchronized with versionsHolder:" + this_$iv.versionHolder.getVersion());
            }
        }
    }

    private final void onDocumentChange(RdDocumentChange change, Function0<String> diagnosticData) {
        boolean $i$f$onDocumentChange = false;
        if (!Intrinsics.areEqual((Object)change.getNewVersion(), (Object)this.versionHolder.getVersion())) {
            this.logger.error("change versions: " + change.getNewVersion() + " is not synchronized with versionsHolder:" + this.versionHolder.getVersion());
        }
        DocumentSynchronizerListeners.Companion.getInstance(this.engine).change(change);
        this.documentLog.addOrUpdate(change.getNewVersion(), (RdDocumentChangeBase)change);
        if (this.backendUpdateInProgressMarker) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Skip processing document change from client side. Change event = " + diagnosticData.invoke() + ", Version: " + this.versionHolder.getVersion());
            }
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Document was changed from client side. Change event = " + diagnosticData.invoke() + ", Version: " + this.versionHolder.getVersion() + ", Document length: " + this.getDocument().getTextLength());
        }
        this.sendDocumentChange((RdDocumentChangeBase)change, change.getOldVersion());
        if (!Intrinsics.areEqual((Object)change.getNewVersion(), (Object)this.versionHolder.getVersion())) {
            this.logger.error("change versions: " + change.getNewVersion() + " is not synchronized with versionsHolder:" + this.versionHolder.getVersion());
        }
    }

    private final RdDocumentChange createRdDocumentChange(DocumentEvent event) {
        CharSequence charSequence = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
        RdTextModificationKind modificationSide = charSequence.length() == 0 && event instanceof DocumentEventImpl ? (((DocumentEventImpl)event).getInitialStartOffset() < ((DocumentEventImpl)event).getOffset() ? RdTextModificationKind.RightSide : (((DocumentEventImpl)event).getInitialStartOffset() + ((DocumentEventImpl)event).getInitialOldLength() > ((DocumentEventImpl)event).getOffset() ? RdTextModificationKind.LeftSide : RdTextModificationKind.NotSpecified)) : RdTextModificationKind.NotSpecified;
        int offset = event.getOffset();
        int moveOffset = event.getMoveOffset();
        String newText = ((Object)event.getNewFragment()).toString();
        String oldText = ((Object)event.getOldFragment()).toString();
        int oldDocumentLength = event.getDocument().getTextLength() + event.getOldLength() - event.getNewLength();
        RdDocumentVersions versions = this.versionHolder.incrementVersion(offset, moveOffset, oldText, newText, oldDocumentLength);
        return new RdDocumentChange(offset, moveOffset, newText, oldText, modificationSide, oldDocumentLength, this.sendDocumentText ? event.getDocument().getText() : null, Boolean.valueOf(event.isWholeTextReplaced()), this.getDocumentId(), versions.getNew(), versions.getOld(), this.getUniqueIdOrBlank());
    }

    public final void sendInitialTextChange() {
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        RdDocumentVersions versions = this.versionHolder.incrementVersion(text);
        RdDocumentId rdDocumentId = this.getDocumentId();
        RdDocumentVersion rdDocumentVersion = versions.getNew();
        RdDocumentVersion rdDocumentVersion2 = versions.getOld();
        String string2 = DocumentExKt.getUniqueRdIdentifier(this.getDocument());
        Intrinsics.checkNotNull((Object)string2);
        RdResetDocumentChange change = new RdResetDocumentChange(text, rdDocumentId, rdDocumentVersion, rdDocumentVersion2, string2);
        this.documentLog.addOrUpdate(this.versionHolder.getVersion(), (RdDocumentChangeBase)change);
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] sendInitialTextChange: send RdResetDocumentChange by engine. documentId=" + DocumentExKt.toDebugString(this.getDocumentId()) + ", newVersion=" + this.versionHolder.getVersion());
        }
        this.sendDocumentChange((RdDocumentChangeBase)change, versions.getOld());
    }

    public final void updateDocumentLog(@NotNull RdDocumentChangeBase change, boolean redo) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RdDocumentChangeBase rdDocumentChangeBase = change;
        if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
            RdDocumentVersion oldversion = this.getVersion();
            this.resetVersion((AbstractDocumentVersion)change.getNewVersion());
            if (redo) {
                this.sendDocumentChange(change, oldversion);
                this.documentLog.add(this.getVersion(), change);
            }
        } else if (rdDocumentChangeBase instanceof RdDocumentChange) {
            RdDocumentVersions versions = this.versionHolder.incrementVersion(((RdDocumentChange)change).getOffset(), ((RdDocumentChange)change).getMoveOffset(), ((RdDocumentChange)change).getOldText(), ((RdDocumentChange)change).getNewText(), ((RdDocumentChange)change).getOldDocumentLength());
            if (!(redo || Intrinsics.areEqual((Object)change.getOldVersion(), (Object)versions.getOld()) && Intrinsics.areEqual((Object)change.getNewVersion(), (Object)versions.getNew()))) {
                this.logger.error("Unexpected version: " + this.versionHolder.getVersion() + ", expected: " + change.getOldVersion() + ". change: " + IPrintableKt.printToString((Object)change));
            }
            RdDocumentChange newChange = new RdDocumentChange(((RdDocumentChange)change).getOffset(), ((RdDocumentChange)change).getMoveOffset(), ((RdDocumentChange)change).getNewText(), ((RdDocumentChange)change).getOldText(), ((RdDocumentChange)change).getModificationKind(), ((RdDocumentChange)change).getOldDocumentLength(), ((RdDocumentChange)change).getText(), ((RdDocumentChange)change).isWholeTextReplaced(), change.getDocumentId(), versions.getNew(), versions.getOld(), change.getUniqueId());
            if (redo) {
                this.sendDocumentChange((RdDocumentChangeBase)newChange, versions.getOld());
            }
            if (!Intrinsics.areEqual((Object)this.versionHolder.getVersion(), (Object)newChange.getNewVersion())) {
                this.logger.error("versionHolder.version: " + this.versionHolder.getVersion() + " != " + newChange.getNewVersion());
            }
            this.documentLog.add(this.getVersion(), (RdDocumentChangeBase)newChange);
        } else {
            throw new IllegalStateException(("Unexpected change: " + change).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveDocumentChange(@NotNull RdDocumentChangeBase change, boolean forceRecordPatch) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        try {
            boolean bl = this.backendUpdateInProgressMarker = !forceRecordPatch;
            if (change instanceof RdDocumentChange && this.getDocument().getTextLength() != ((RdDocumentChange)change).getOldDocumentLength()) {
                throw new IllegalStateException(("expected document length: " + ((RdDocumentChange)change).getOldDocumentLength() + ", but actual length: " + this.getDocument().getTextLength()).toString());
            }
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Applying client document change: " + IPrintableKt.printToString((Object)change) + ", document length: " + this.getDocument().getTextLength());
            }
            ApplicationKt.getApplication().runWriteAction(() -> PatchEngineDocumentSynchronizer.receiveDocumentChange$lambda$1(this, change, forceRecordPatch));
        }
        finally {
            this.backendUpdateInProgressMarker = false;
        }
    }

    public static /* synthetic */ void receiveDocumentChange$default(PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer, RdDocumentChangeBase rdDocumentChangeBase, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        patchEngineDocumentSynchronizer.receiveDocumentChange(rdDocumentChangeBase, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyChangeCheckForce(RdDocumentChangeBase change) {
        if (this.forceWrite && !this.getDocument().isWritable()) {
            this.getDocument().setReadOnly(false);
            try {
                this.applyChange(change);
            }
            finally {
                this.getDocument().setReadOnly(true);
            }
        } else {
            this.applyChange(change);
        }
    }

    private final void applyChange(RdDocumentChangeBase change) {
        RdDocumentChangeBase rdDocumentChangeBase = change;
        if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
            this.applyResetDocumentChange((RdResetDocumentChange)change);
        } else if (rdDocumentChangeBase instanceof RdDocumentChange) {
            if (!Intrinsics.areEqual((Object)change.getOldVersion(), (Object)this.versionHolder.getVersion())) {
                this.logger.error("Unexpected version: " + this.versionHolder.getVersion() + ", expected: " + change.getOldVersion() + ". change: " + IPrintableKt.printToString((Object)change));
            }
            this.applyDocumentChange((RdDocumentChange)change);
            this.ensureDocumentVersion((RdDocumentChange)change);
        } else {
            this.logger.error((Throwable)new IllegalStateException("Unknown document change type: " + change));
        }
    }

    private final void applyResetDocumentChange(RdResetDocumentChange change) {
        boolean isTextTheSame;
        boolean bl = isTextTheSame = this.getDocument().getTextLength() == change.getText().length() && Intrinsics.areEqual((Object)this.getDocument().getText(), (Object)change.getText());
        if (this.isReceivingChange() && isTextTheSame) {
            this.versionHolder.resetVersion(change.getNewVersion());
            this.documentLog.addOrUpdate(this.versionHolder.getVersion(), (RdDocumentChangeBase)change);
        } else {
            if (!isTextTheSame) {
                VirtualFile file = Intrinsics.areEqual((Object)this.getVersion(), (Object)DocumentVersionsKt.getInitialDocVersion()) && PlatformUtils.isJetBrainsClient() ? FileDocumentManager.getInstance().getFile(this.getDocument()) : null;
                this.getDocument().setText((CharSequence)change.getText());
                VirtualFile virtualFile = file;
                if (virtualFile != null) {
                    virtualFile.putUserData(IProtocolVirtualFile.Companion.getFORBID_TEXT_GET(), null);
                }
            }
            this.resetVersion((AbstractDocumentVersion)change.getNewVersion());
            if (!this.isReceivingChange()) {
                this.sendDocumentChange((RdDocumentChangeBase)change, change.getOldVersion());
            } else {
                this.documentLog.addOrUpdate(this.versionHolder.getVersion(), (RdDocumentChangeBase)change);
            }
        }
    }

    private final void applyDocumentChange(RdDocumentChange change) {
        int offset = change.getOffset();
        String oldText = change.getOldText();
        String newText = change.getNewText();
        if (Intrinsics.areEqual((Object)change.isWholeTextReplaced(), (Object)true)) {
            String initialNewText = this.getDocument().getText(new TextRange(0, offset)) + newText + this.getDocument().getText(new TextRange(offset + oldText.length(), this.getDocument().getTextLength()));
            this.getDocument().setText((CharSequence)initialNewText);
            return;
        }
        if (((CharSequence)oldText).length() == 0 && change.getModificationKind() == RdTextModificationKind.LeftSide) {
            int initialEnd = Math.min(this.getDocument().getTextLength(), offset + 1);
            String initialNewText = newText + this.getDocument().getText(new TextRange(offset, initialEnd));
            this.getDocument().replaceString(offset, initialEnd, (CharSequence)initialNewText);
            return;
        }
        if (((CharSequence)oldText).length() == 0 && change.getModificationKind() == RdTextModificationKind.RightSide) {
            int initialStart = Math.max(0, offset - 1);
            String initialNewText = this.getDocument().getText(new TextRange(initialStart, offset)) + newText;
            this.getDocument().replaceString(initialStart, offset, (CharSequence)initialNewText);
            return;
        }
        if (this.getDocument() instanceof DocumentImpl) {
            ((DocumentImpl)this.getDocument()).replaceString(offset, offset + oldText.length(), change.getMoveOffset(), (CharSequence)newText, LocalTimeCounter.currentTime(), false);
            return;
        }
        this.getDocument().replaceString(offset, offset + oldText.length(), (CharSequence)newText);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureDocumentVersion(RdDocumentChange change) {
        if (Intrinsics.areEqual((Object)change.getNewVersion(), (Object)this.versionHolder.getVersion())) {
            return;
        }
        this.resetVersion((AbstractDocumentVersion)change.getNewVersion());
        if (change.getNewVersion().getValue() > change.getOldVersion().getValue()) {
            void this_$iv;
            PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this;
            RdDocumentChange change$iv = change;
            boolean $i$f$onDocumentChange = false;
            if (!Intrinsics.areEqual((Object)change$iv.getNewVersion(), (Object)this_$iv.versionHolder.getVersion())) {
                this_$iv.logger.error("change versions: " + change$iv.getNewVersion() + " is not synchronized with versionsHolder:" + this_$iv.versionHolder.getVersion());
            }
            DocumentSynchronizerListeners.Companion.getInstance(this_$iv.engine).change(change$iv);
            this_$iv.documentLog.addOrUpdate(change$iv.getNewVersion(), (RdDocumentChangeBase)change$iv);
            if (this_$iv.backendUpdateInProgressMarker) {
                Logger $this$trace$iv$iv = this_$iv.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    logger.trace("Skip processing document change from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(change) + ", Version: " + this_$iv.versionHolder.getVersion());
                }
            } else {
                Logger $this$trace$iv$iv = this_$iv.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    boolean bl3 = false;
                    logger.trace("Document was changed from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(change) + ", Version: " + this_$iv.versionHolder.getVersion() + ", Document length: " + this_$iv.getDocument().getTextLength());
                }
                super.sendDocumentChange((RdDocumentChangeBase)change$iv, change$iv.getOldVersion());
                if (!Intrinsics.areEqual((Object)change$iv.getNewVersion(), (Object)this_$iv.versionHolder.getVersion())) {
                    this_$iv.logger.error("change versions: " + change$iv.getNewVersion() + " is not synchronized with versionsHolder:" + this_$iv.versionHolder.getVersion());
                }
            }
        } else {
            DocumentSynchronizerListeners.Companion.getInstance(this.engine).change(change);
        }
    }

    public final void updateLastKnownVersion(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.documentLog.updateLastKnownVersion(version);
    }

    @NotNull
    public final RdDocumentVersion getLastKnownVersion() {
        return this.documentLog.getLastKnownVersion();
    }

    @Nullable
    public final Object waitForInitialDocumentChange(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.documentLog.getDeferredNonInitialVersion$intellij_rd_platform().await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public int getPriority() {
        return 39;
    }

    @NotNull
    public RdDocumentVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull AbstractDocumentVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion cfr_ignored_0 = (RdDocumentVersion)v;
        this.versionHolder.resetVersion((RdDocumentVersion)v);
        this.documentLog.rollbackHistoryToVersion((RdDocumentVersion)v);
    }

    @Override
    @NotNull
    public IDocumentRangeShifter createRangeShifter() {
        return new DocumentLogRangeShifter(this.documentLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void sendDocumentChange(RdDocumentChangeBase change, RdDocumentVersion prevVersion) {
        void $this$sendAccumulated$iv;
        PatchEngine patchEngine = this.engine;
        String description$iv = "PatchEngineDocumentSynchronizerKt.sendDocumentChange";
        boolean $i$f$sendAccumulated = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated$iv, true, description$iv, null, 4, null));
        Throwable throwable = null;
        try {
            Pair pair;
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl = false;
            ChangeScope $this$sendDocumentChange_u24lambda_u240 = it$iv.getSession().getChangeScope();
            boolean bl2 = false;
            RdDocumentChangeBase rdDocumentChangeBase = change;
            if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
                pair = new Pair((Object)prevVersion, (Object)change.getNewVersion());
            } else if (rdDocumentChangeBase instanceof RdDocumentChange) {
                pair = new Pair((Object)change.getOldVersion(), (Object)change.getNewVersion());
            } else {
                throw new IllegalStateException(("Unexpected change: " + change).toString());
            }
            Pair pair2 = pair;
            RdDocumentVersion oldVersion = (RdDocumentVersion)pair2.component1();
            RdDocumentVersion newVersion = (RdDocumentVersion)pair2.component2();
            if (!Intrinsics.areEqual((Object)oldVersion, (Object)newVersion)) {
                RdPatchDocumentVersion expectedVersion = new RdPatchDocumentVersion(oldVersion, this.getUniqueIdOrBlank(), (RdPatchItemId)change.getDocumentId());
                $this$sendDocumentChange_u24lambda_u240.pushExpected((RdPatchItemVersion)expectedVersion);
                RdPatchDocumentVersion updatedVersion = new RdPatchDocumentVersion(newVersion, this.getUniqueIdOrBlank(), (RdPatchItemId)change.getDocumentId());
                $this$sendDocumentChange_u24lambda_u240.pushUpdated((RdPatchItemVersion)updatedVersion);
                $this$sendDocumentChange_u24lambda_u240.pushChange((RdPatchItem)change);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void receiveDocumentChange$lambda$1(PatchEngineDocumentSynchronizer this$0, RdDocumentChangeBase $change, boolean $forceRecordPatch) {
        CommandProcessor instance = CommandProcessor.getInstance();
        if (instance.isCommandInProgress()) {
            this$0.applyChangeCheckForce($change);
        } else {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> PatchEngineDocumentSynchronizer.receiveDocumentChange$lambda$1$0(this$0, $change));
        }
        if ($change instanceof RdDocumentChange && ((RdDocumentChange)$change).getText() != null && !Intrinsics.areEqual((Object)this$0.getDocument().getText(), (Object)((RdDocumentChange)$change).getText())) {
            if ($forceRecordPatch) {
                this$0.logger.warn("Not matched document text on version: " + this$0.versionHolder.getVersion().getValue() + ". Probably text was already changed during rebase.");
            } else {
                this$0.logger.error("Not matched document text on version: " + this$0.versionHolder.getVersion().getValue());
            }
        }
    }

    private static final void receiveDocumentChange$lambda$1$0(PatchEngineDocumentSynchronizer this$0, RdDocumentChangeBase $change) {
        this$0.applyChangeCheckForce($change);
    }

    public static final /* synthetic */ DocumentLog access$getDocumentLog$p(PatchEngineDocumentSynchronizer $this) {
        return $this.documentLog;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer$Companion;", "", "<init>", "()V", "debugId", "", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

