/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.configurable;

import com.intellij.ide.DataManager;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterAuthType;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.utils.JupyterUrlUtils;
import com.intellij.jupyter.py.connections.configurable.JupyterServerConfigurable;
import com.intellij.jupyter.py.connections.configurable.ui.JupyterDiscoveredServerChooser;
import com.intellij.jupyter.py.connections.configurable.ui.test.TestConnectionPanelWrapper;
import com.intellij.jupyter.py.connections.configurable.ui.test.status.TestConnectionError;
import com.intellij.jupyter.py.connections.configurable.ui.test.status.TestConnectionStatus;
import com.intellij.jupyter.py.connections.configurable.ui.test.status.TestConnectionSuccessful;
import com.intellij.jupyter.py.connections.configured.JupyterConfiguredUtil;
import com.intellij.jupyter.py.connections.server.discover.DiscoveredServer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.ui.validation.ValidationUtilKt;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignKt;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.net.HttpProxyConfigurable;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0019H\u0014J\b\u0010%\u001a\u00020#H\u0014J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020(H\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0003H\u0002J\b\u0010,\u001a\u00020\u0003H\u0002J\b\u0010-\u001a\u00020#H\u0002J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u0002000/*\b\u0012\u0004\u0012\u0002000/H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u000e2\u0006\u00102\u001a\u00020\u000eH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/py/connections/configurable/JupyterConfiguredServerConfigurable;", "Lcom/intellij/jupyter/py/connections/configurable/JupyterServerConfigurable;", "savedSettings", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;)V", "getSavedSettings$intellij_jupyter_py", "()Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;", "setSavedSettings$intellij_jupyter_py", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "nameProperty", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "urlProperty", "Lcom/intellij/openapi/util/NlsSafe;", "authTypeProperty", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterAuthType;", "getAuthTypeProperty", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "tokenProperty", "passwordProperty", "usernameProperty", "useSystemProxy", "", "testConnectionPanel", "Lcom/intellij/jupyter/py/connections/configurable/ui/test/TestConnectionPanelWrapper;", "formPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getFormPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "formPanel$delegate", "Lkotlin/Lazy;", "reset", "", "isPanelModified", "saveSettings", "getDisplayName", "verifyAndGetStatus", "Lcom/intellij/jupyter/py/connections/configurable/ui/test/status/TestConnectionStatus;", "verifyConnection", "resetFromConfig", "serverConfig", "getConfigFromUI", "discoverLocalServerAndSetToUI", "withNonBlackValidator", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBTextField;", "validateWindowsFileName", "text", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterConfiguredServerConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConfiguredServerConfigurable.kt\ncom/intellij/jupyter/py/connections/configurable/JupyterConfiguredServerConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
public final class JupyterConfiguredServerConfigurable
extends JupyterServerConfigurable {
    @NotNull
    private JupyterConfiguredServerConfig savedSettings;
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicProperty<String> nameProperty;
    @NotNull
    private final AtomicProperty<String> urlProperty;
    @NotNull
    private final AtomicProperty<JupyterAuthType> authTypeProperty;
    @NotNull
    private final AtomicProperty<String> tokenProperty;
    @NotNull
    private final AtomicProperty<String> passwordProperty;
    @NotNull
    private final AtomicProperty<String> usernameProperty;
    @NotNull
    private final AtomicProperty<Boolean> useSystemProxy;
    @NotNull
    private final TestConnectionPanelWrapper testConnectionPanel;
    @NotNull
    private final Lazy formPanel$delegate;

    public JupyterConfiguredServerConfigurable(@NotNull JupyterConfiguredServerConfig savedSettings) {
        Intrinsics.checkNotNullParameter((Object)savedSettings, (String)"savedSettings");
        super(null);
        this.savedSettings = savedSettings;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        this.project = project;
        this.nameProperty = new AtomicProperty((Object)this.getSavedSettings$intellij_jupyter_py().getName());
        this.urlProperty = new AtomicProperty((Object)this.getSavedSettings$intellij_jupyter_py().getUsername());
        this.authTypeProperty = new AtomicProperty((Object)this.getSavedSettings$intellij_jupyter_py().getAuthType());
        this.tokenProperty = new AtomicProperty((Object)this.getSavedSettings$intellij_jupyter_py().getToken());
        this.passwordProperty = new AtomicProperty((Object)this.getSavedSettings$intellij_jupyter_py().getPassword());
        this.usernameProperty = new AtomicProperty((Object)this.getSavedSettings$intellij_jupyter_py().getUsername());
        this.useSystemProxy = new AtomicProperty((Object)this.getSavedSettings$intellij_jupyter_py().getUseSystemProxy());
        this.testConnectionPanel = new TestConnectionPanelWrapper((Function0<? extends TestConnectionStatus>)((Function0)() -> JupyterConfiguredServerConfigurable.testConnectionPanel$lambda$0(this)));
        this.formPanel$delegate = LazyKt.lazy(() -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0(this));
    }

    @NotNull
    public JupyterConfiguredServerConfig getSavedSettings$intellij_jupyter_py() {
        return this.savedSettings;
    }

    public void setSavedSettings$intellij_jupyter_py(@NotNull JupyterConfiguredServerConfig jupyterConfiguredServerConfig) {
        Intrinsics.checkNotNullParameter((Object)jupyterConfiguredServerConfig, (String)"<set-?>");
        this.savedSettings = jupyterConfiguredServerConfig;
    }

    @NotNull
    public final AtomicProperty<JupyterAuthType> getAuthTypeProperty() {
        return this.authTypeProperty;
    }

    @Override
    @NotNull
    public DialogPanel getFormPanel() {
        Lazy lazy = this.formPanel$delegate;
        return (DialogPanel)lazy.getValue();
    }

    public void reset() {
        super.reset();
        this.resetFromConfig(this.getSavedSettings$intellij_jupyter_py());
    }

    @Override
    protected boolean isPanelModified() {
        return !Intrinsics.areEqual((Object)this.getSavedSettings$intellij_jupyter_py(), (Object)this.getConfigFromUI());
    }

    @Override
    protected void saveSettings() {
        JupyterConfiguredServerConfig verified;
        JupyterConfiguredServerConfig jupyterConfiguredServerConfig;
        try {
            jupyterConfiguredServerConfig = this.verifyConnection();
        }
        catch (Throwable t) {
            throw new ConfigurationException(t.getMessage(), JupyterRemoteBundle.message((String)"Jupyter.remote.verify.url.connecting.error.title", (Object[])new Object[0]));
        }
        JupyterConfiguredServerConfig jupyterConfiguredServerConfig2 = verified = jupyterConfiguredServerConfig;
        if (jupyterConfiguredServerConfig2 == null) {
            return;
        }
        this.setSavedSettings$intellij_jupyter_py(jupyterConfiguredServerConfig2);
        JupyterConnectionSettingsManager.Companion.getInstance().addOrUpdateConfig((JupyterServerConfig)this.getSavedSettings$intellij_jupyter_py());
    }

    @NotNull
    public String getDisplayName() {
        CharSequence charSequence;
        CharSequence charSequence2 = (CharSequence)this.nameProperty.get();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = JupyterBundle.message((String)"jupyter.server.list.empty.configured.name", (Object[])new Object[0]);
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private final TestConnectionStatus verifyAndGetStatus() {
        TestConnectionStatus testConnectionStatus;
        try {
            JupyterConfiguredServerConfig newConfig = this.verifyConnection();
            if (newConfig != null) {
                this.resetFromConfig(newConfig);
            }
            testConnectionStatus = new TestConnectionSuccessful(null, 1, null);
        }
        catch (Throwable t) {
            testConnectionStatus = new TestConnectionError(t, null, null, 6, null);
        }
        return testConnectionStatus;
    }

    private final JupyterConfiguredServerConfig verifyConnection() {
        return (JupyterConfiguredServerConfig)TasksKt.runWithModalProgressBlocking((Project)this.project, (String)JupyterRemoteBundle.message((String)"Jupyter.remote.verify.url.connecting.progress", (Object[])new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JupyterConfiguredServerConfig>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ JupyterConfiguredServerConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable $this$firstOrNull$iv = this.this$0.getFormPanel().validateAll();
                        boolean $i$f$firstOrNull = false;
                        Iterator<T> iterator = $this$firstOrNull$iv.iterator();
                        if (iterator.hasNext()) {
                            T element$iv = iterator.next();
                            ValidationInfo info = (ValidationInfo)element$iv;
                            boolean bl = false;
                            throw new ConfigurationException(info.message);
                        }
                        JupyterConfiguredServerConfig newConfig = JupyterConfiguredServerConfigurable.access$getConfigFromUI(this.this$0);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)newConfig);
                        this.label = 1;
                        Object object2 = JupyterConfiguredUtil.INSTANCE.verifyAndGetConfig(newConfig, (Continuation<? super JupyterConfiguredServerConfig>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        JupyterConfiguredServerConfig newConfig = (JupyterConfiguredServerConfig)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JupyterConfiguredServerConfig> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void resetFromConfig(JupyterConfiguredServerConfig serverConfig) {
        this.nameProperty.set((Object)serverConfig.getName());
        String string = serverConfig.getUri().toASCIIString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCIIString(...)");
        this.urlProperty.set((Object)string);
        this.authTypeProperty.set((Object)serverConfig.getAuthType());
        this.tokenProperty.set((Object)serverConfig.getToken());
        this.passwordProperty.set((Object)serverConfig.getPassword());
        this.usernameProperty.set((Object)serverConfig.getUsername());
        this.useSystemProxy.set((Object)serverConfig.getUseSystemProxy());
    }

    private final JupyterConfiguredServerConfig getConfigFromUI() {
        URI uri = JupyterConfiguredUtil.INSTANCE.sanitizeUrlForVerifying((String)this.urlProperty.get());
        JupyterConfiguredServerConfig jupyterConfiguredServerConfig = this.getSavedSettings$intellij_jupyter_py();
        String string = (String)this.nameProperty.get();
        String string2 = (String)this.tokenProperty.get();
        String string3 = (String)this.usernameProperty.get();
        String string4 = (String)this.passwordProperty.get();
        JupyterAuthType jupyterAuthType = (JupyterAuthType)this.authTypeProperty.get();
        boolean bl = (Boolean)this.useSystemProxy.get();
        return JupyterConfiguredServerConfig.copy$default((JupyterConfiguredServerConfig)jupyterConfiguredServerConfig, null, (String)string, (URI)uri, (JupyterAuthType)jupyterAuthType, (String)string2, (String)string4, (String)string3, (boolean)bl, (boolean)false, (int)257, null);
    }

    private final void discoverLocalServerAndSetToUI() {
        String token;
        DiscoveredServer discoveredServer = JupyterDiscoveredServerChooser.INSTANCE.discoverAndChoose(this.project, this.getDisposable());
        if (discoveredServer == null) {
            return;
        }
        DiscoveredServer server2 = discoveredServer;
        String string = server2.getUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.urlProperty.set((Object)string);
        this.authTypeProperty.set((Object)JupyterAuthType.NOTEBOOK);
        String string2 = server2.getToken();
        if (string2 != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = string2;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            v4 = (String)charSequence;
        } else {
            v4 = token = null;
        }
        if (token != null) {
            this.tokenProperty.set((Object)token);
        }
    }

    private final Cell<JBTextField> withNonBlackValidator(Cell<? extends JBTextField> $this$withNonBlackValidator) {
        return $this$withNonBlackValidator.validationOnInput(JupyterConfiguredServerConfigurable::withNonBlackValidator$lambda$0);
    }

    private final String validateWindowsFileName(String text) {
        Regex forbiddenRegex = new Regex("[<>:\"/\\\\|?*]");
        return StringsKt.isBlank((CharSequence)text) || forbiddenRegex.containsMatchIn((CharSequence)text) ? JupyterBundle.message((String)"dialog.message.connection.name.should.not.contain.following.characters", (Object[])new Object[0]) : null;
    }

    private static final TestConnectionStatus testConnectionPanel$lambda$0(JupyterConfiguredServerConfigurable this$0) {
        return this$0.verifyAndGetStatus();
    }

    private static final DialogPanel formPanel_delegate$lambda$0(JupyterConfiguredServerConfigurable this$0) {
        return BuilderKt.panel(arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0(this$0, arg_0));
    }

    private static final Unit formPanel_delegate$lambda$0$0(JupyterConfiguredServerConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$0(this$0, arg_0), (int)1, null).bottomGap(BottomGap.NONE);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$1(this$0, arg_0), (int)1, null).topGap(TopGap.SMALL).bottomGap(BottomGap.NONE);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$2(this$0, arg_0), (int)1, null).bottomGap(BottomGap.NONE).topGap(TopGap.NONE);
        Panel.row$default((Panel)$this$panel, null, JupyterConfiguredServerConfigurable::formPanel_delegate$lambda$0$0$3, (int)1, null).topGap(TopGap.NONE).bottomGap(BottomGap.MEDIUM);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$4(this$0, arg_0), (int)1, null);
        $this$panel.indent(arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$5(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$6(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$7(this$0, arg_0), (int)1, null).topGap(TopGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$0(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(JupyterBundle.message((String)"Jupyter.managed.server.settings.name", (Object[])new Object[0])).widthGroup("Label");
        DialogValidation.WithParameter[] withParameterArray = new DialogValidation.WithParameter[]{ValidationUtilKt.validationErrorFor(arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$0$0(this$0, arg_0))};
        TextFieldKt.trimmedTextValidation((Cell)TextFieldKt.bindText(this$0.withNonBlackValidator((Cell<? extends JBTextField>)$this$row.textField()), (ObservableMutableProperty)((ObservableMutableProperty)this$0.nameProperty)).align(AlignKt.plus((AlignX)((AlignX)AlignX.FILL.INSTANCE), (AlignY)((AlignY)AlignY.TOP.INSTANCE))), (DialogValidation.WithParameter[])withParameterArray);
        return Unit.INSTANCE;
    }

    private static final String formPanel_delegate$lambda$0$0$0$0(JupyterConfiguredServerConfigurable this$0, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this$0.validateWindowsFileName(text);
    }

    private static final Unit formPanel_delegate$lambda$0$0$1(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(JupyterRemoteBundle.message((String)"Jupyter.server.settings.discover.local.servers.link", (Object[])new Object[0]), arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$1$0(this$0, arg_0)).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$1$0(JupyterConfiguredServerConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.discoverLocalServerAndSetToUI();
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$2(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(JupyterBundle.message((String)"jupyter.server.url.label", (Object[])new Object[0])).widthGroup("Label");
        DialogValidation.WithParameter[] withParameterArray = new DialogValidation.WithParameter[]{ValidationUtilKt.validationErrorFor(JupyterConfiguredServerConfigurable::formPanel_delegate$lambda$0$0$2$0)};
        TextFieldKt.trimmedTextValidation((Cell)TextFieldKt.bindText((Cell)$this$row.textField().align(AlignKt.plus((AlignX)((AlignX)AlignX.FILL.INSTANCE), (AlignY)((AlignY)AlignY.TOP.INSTANCE))), (ObservableMutableProperty)((ObservableMutableProperty)this$0.urlProperty)), (DialogValidation.WithParameter[])withParameterArray).applyToComponent(JupyterConfiguredServerConfigurable::formPanel_delegate$lambda$0$0$2$1).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final String formPanel_delegate$lambda$0$0$2$0(String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Throwable throwable = JupyterUrlUtils.INSTANCE.validateUrl(text);
        return throwable != null ? throwable.getMessage() : null;
    }

    private static final Unit formPanel_delegate$lambda$0$0$2$1(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getEmptyText().setText(JupyterBundle.message((String)"jupyter.server.url.prompt", (Object[])new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("").widthGroup("A");
        Row.comment$default((Row)$this$row, (String)JupyterBundle.message((String)"jupyter.server.url.comment", (Object[])new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$4(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(JupyterBundle.message((String)"Jupyter.managed.server.settings.server.type", (Object[])new Object[0])).widthGroup("Label");
        $this$row.segmentedButton((Collection)JupyterAuthType.getEntries(), JupyterConfiguredServerConfigurable::formPanel_delegate$lambda$0$0$4$0).bind((ObservableMutableProperty)this$0.authTypeProperty);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$4$0(SegmentedButton.ItemPresentation $this$segmentedButton, JupyterAuthType it) {
        Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$segmentedButton.setText(it.getTitle());
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$5(JupyterConfiguredServerConfigurable this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Ref.ObjectRef usernameField = new Ref.ObjectRef();
        $this$indent.row(JupyterBundle.message((String)"Jupyter.managed.server.settings.username", (Object[])new Object[0]), arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$5$0(usernameField, this$0, arg_0)).visibleIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this$0.authTypeProperty), (Object)JupyterAuthType.HUB));
        $this$indent.row(JupyterBundle.message((String)"Jupyter.managed.server.settings.password", (Object[])new Object[0]), arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$5$1(this$0, arg_0)).visibleIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this$0.authTypeProperty), (Object)JupyterAuthType.HUB));
        $this$indent.row(JupyterBundle.message((String)"Jupyter.managed.server.settings.token", (Object[])new Object[0]), arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$5$2(this$0, arg_0)).visibleIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this$0.authTypeProperty), (Object)JupyterAuthType.HUB));
        $this$indent.row(JupyterBundle.message((String)"Jupyter.managed.server.settings.tokenOrPassword", (Object[])new Object[0]), arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$5$3(this$0, arg_0)).visibleIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this$0.authTypeProperty), (Object)JupyterAuthType.NOTEBOOK));
        Panel.row$default((Panel)$this$indent, null, JupyterConfiguredServerConfigurable::formPanel_delegate$lambda$0$0$5$4, (int)1, null).visibleIf(PropertyOperationUtil.equalsTo((ObservableProperty)((ObservableProperty)this$0.authTypeProperty), (Object)JupyterAuthType.AWS_SAGE_MAKER));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$5$0(Ref.ObjectRef $usernameField, JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $usernameField.element = $this$row.textField();
        ((JBTextField)((Cell)$usernameField.element).getComponent()).getEmptyText().setText(JupyterBundle.message((String)"jupyter.server.auth.prompt", (Object[])new Object[0]));
        TextFieldKt.bindText((Cell)((Cell)$usernameField.element), (ObservableMutableProperty)((ObservableMutableProperty)this$0.usernameProperty)).align(AlignKt.plus((AlignX)((AlignX)AlignX.FILL.INSTANCE), (AlignY)((AlignY)AlignY.TOP.INSTANCE)));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$5$1(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell passwordField = $this$row.passwordField();
        ((JBPasswordField)passwordField.getComponent()).getEmptyText().setText(JupyterBundle.message((String)"jupyter.server.auth.prompt", (Object[])new Object[0]));
        TextFieldKt.bindText((Cell)passwordField, (ObservableMutableProperty)((ObservableMutableProperty)this$0.passwordProperty)).align(AlignKt.plus((AlignX)((AlignX)AlignX.FILL.INSTANCE), (AlignY)((AlignY)AlignY.TOP.INSTANCE)));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$5$2(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell tokenField = $this$row.textField();
        ((JBTextField)tokenField.getComponent()).getEmptyText().setText(JupyterBundle.message((String)"jupyter.server.auth.prompt", (Object[])new Object[0]));
        TextFieldKt.bindText((Cell)tokenField, (ObservableMutableProperty)((ObservableMutableProperty)this$0.tokenProperty)).align(AlignKt.plus((AlignX)((AlignX)AlignX.FILL.INSTANCE), (AlignY)((AlignY)AlignY.TOP.INSTANCE)));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$5$3(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell tokenField = $this$row.textField();
        ((JBTextField)tokenField.getComponent()).getEmptyText().setText(JupyterBundle.message((String)"jupyter.server.auth.prompt", (Object[])new Object[0]));
        TextFieldKt.bindText((Cell)tokenField, (ObservableMutableProperty)((ObservableMutableProperty)this$0.tokenProperty)).align(AlignKt.plus((AlignX)((AlignX)AlignX.FILL.INSTANCE), (AlignY)((AlignY)AlignY.TOP.INSTANCE)));
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$5$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)JupyterBundle.message((String)"jupyter.server.auth.sagemaker.comment", (Object[])new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$6(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(JupyterBundle.message((String)"Jupyter.configured.server.settings.use.system.proxy.prefix", (Object[])new Object[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.useSystemProxy)).gap(RightGap.SMALL);
        $this$row.link(JupyterBundle.message((String)"Jupyter.configured.server.settings.use.system.proxy.suffix", (Object[])new Object[0]), JupyterConfiguredServerConfigurable::formPanel_delegate$lambda$0$0$6$0);
        return Unit.INSTANCE;
    }

    private static final Unit formPanel_delegate$lambda$0$0$6$0(ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataManager.getInstance().getDataContextFromFocusAsync().then(arg_0 -> JupyterConfiguredServerConfigurable.formPanel_delegate$lambda$0$0$6$0$1(JupyterConfiguredServerConfigurable::formPanel_delegate$lambda$0$0$6$0$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final ActionCallback formPanel_delegate$lambda$0$0$6$0$0(DataContext it) {
        ActionCallback actionCallback;
        Intrinsics.checkNotNull((Object)it);
        Settings settings = (Settings)Settings.KEY.getData(it);
        if (settings != null) {
            Settings settings2 = settings;
            boolean bl = false;
            HttpProxyConfigurable httpProxyConfigurable = (HttpProxyConfigurable)settings2.find(HttpProxyConfigurable.class);
            if (httpProxyConfigurable != null) {
                HttpProxyConfigurable configurable = httpProxyConfigurable;
                boolean bl2 = false;
                actionCallback = settings2.select((Configurable)configurable);
            } else {
                actionCallback = null;
            }
        } else {
            actionCallback = null;
        }
        return actionCallback;
    }

    private static final ActionCallback formPanel_delegate$lambda$0$0$6$0$1(Function1 $tmp0, Object p0) {
        return (ActionCallback)$tmp0.invoke(p0);
    }

    private static final Unit formPanel_delegate$lambda$0$0$7(JupyterConfiguredServerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.testConnectionPanel.getMainComponent()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo withNonBlackValidator$lambda$0(ValidationInfoBuilder $this$validationOnInput, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)string) ? new ValidationInfo(JupyterBundle.message((String)"settings.jupyter.should.not.be.empty", (Object[])new Object[0])) : null;
    }

    public static final /* synthetic */ JupyterConfiguredServerConfig access$getConfigFromUI(JupyterConfiguredServerConfigurable $this) {
        return $this.getConfigFromUI();
    }
}

