/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.managed;

import com.intellij.jupyter.core.jupyter.connections.managed.JupyterRuntimeManagedServerInfo;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerConfigurationProvider;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerExecutionServiceProvider;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.py.helper.JupyterPyExtensionsKt;
import com.intellij.jupyter.py.helper.JupyterPyProjectModulesUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/py/connections/managed/PyManagedJupyterServerRunner;", "", "<init>", "()V", "startServer", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterManagedServerConfig;", "startManaged", "module", "Lcom/intellij/openapi/module/Module;", "intellij.jupyter.py"})
public final class PyManagedJupyterServerRunner {
    @NotNull
    public static final PyManagedJupyterServerRunner INSTANCE = new PyManagedJupyterServerRunner();

    private PyManagedJupyterServerRunner() {
    }

    @Nullable
    public final JupyterServerExecution startServer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull JupyterManagedServerConfig settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!JupyterPyExtensionsKt.isPyNotebook(virtualFile)) {
            return null;
        }
        Module module = JupyterPyProjectModulesUtils.INSTANCE.getSuitableModule(project, virtualFile);
        if (module == null) {
            throw new IllegalStateException("Cannot find module for the server".toString());
        }
        Module module2 = module;
        return this.startManaged(module2, virtualFile, settings);
    }

    private final JupyterServerExecution startManaged(Module module, VirtualFile virtualFile, JupyterManagedServerConfig settings) {
        JupyterRuntimeManagedServerInfo managedServerConfiguration = JupyterManagedServerConfigurationProvider.Companion.getJupyterManagedServerConfiguration(module, virtualFile);
        return JupyterManagedServerExecutionServiceProvider.Companion.getInstance().startManagedServer(managedServerConfiguration, settings);
    }
}

