/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.managed.server;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.ide.ProcessCloseConfirmation;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthParams;
import com.intellij.jupyter.core.jupyter.connections.auth.token.JupyterTokenAuthParams;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterManagedServerExited;
import com.intellij.jupyter.core.jupyter.connections.fus.JupyterConnectionsCollector;
import com.intellij.jupyter.core.jupyter.connections.fus.JupyterManagedStartResult;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterManagedServerProcessHandler;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterRuntimeManagedServerInfo;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarting;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStopped;
import com.intellij.jupyter.core.jupyter.connections.runtime.JupyterHttpParams;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerStateListener;
import com.intellij.jupyter.py.connections.managed.server.JupyterServerCommandsKt;
import com.intellij.jupyter.py.connections.managed.server.JupyterServerExecutionImpl;
import com.intellij.jupyter.py.stat.JupyterPyFeaturesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0014\u0010\u001a\u001a\u00020\u00182\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u000eH\u0002JR\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180,2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00180,JT\u00100\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180,2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00180,2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180,H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J4\u0010-\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*2\u0006\u00105\u001a\u0002062\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180,H\u0002J4\u0010.\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020/2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00180,H\u0002J$\u0010:\u001a\u00020\u00182\n\u0010;\u001a\u00060\u001cj\u0002`\u001d2\u0006\u00107\u001a\u0002082\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010<\u001a\u00020=H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/jupyter/py/connections/managed/server/JupyterServerExecutionImpl;", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "<init>", "()V", "managedConnectionHandler", "Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterManagedServerProcessHandler;", "_connectionFuture", "Lkotlinx/coroutines/CompletableDeferred;", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "connectionDeferred", "Lkotlinx/coroutines/Deferred;", "getConnectionDeferred", "()Lkotlinx/coroutines/Deferred;", "value", "Lcom/intellij/jupyter/core/jupyter/connections/managed/state/JupyterServerState;", "state", "getState", "()Lcom/intellij/jupyter/core/jupyter/connections/managed/state/JupyterServerState;", "setState$intellij_jupyter_py", "(Lcom/intellij/jupyter/core/jupyter/connections/managed/state/JupyterServerState;)V", "stateListeners", "", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerStateListener;", "setJupyterServerStartedState", "", "connectionParameters", "setRetrieveConnectionParametersException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setExceptionallyStoppedState", "handler", "setExceptionallyStartedState", "", "addStateListener", "listener", "notifyStateListeners", "newState", "startServer", "managedServerConfiguration", "Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterRuntimeManagedServerInfo;", "settings", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterManagedServerConfig;", "onBeforeStartNotify", "Lkotlin/Function1;", "onServerInit", "onServerTerminated", "", "internalStartServer", "stopOrDetach", "Lkotlinx/coroutines/Job;", "decision", "Lcom/intellij/ide/ProcessCloseConfirmation;", "pythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "isDestroyed", "onServerError", "exception", "getProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterServerExecutionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerExecutionImpl.kt\ncom/intellij/jupyter/py/connections/managed/server/JupyterServerExecutionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1869#2,2:234\n23#3:236\n23#3:238\n23#3:239\n1#4:237\n*S KotlinDebug\n*F\n+ 1 JupyterServerExecutionImpl.kt\ncom/intellij/jupyter/py/connections/managed/server/JupyterServerExecutionImpl\n*L\n80#1:234,2\n102#1:236\n211#1:238\n224#1:239\n*E\n"})
public final class JupyterServerExecutionImpl
implements JupyterServerExecution {
    @Nullable
    private JupyterManagedServerProcessHandler managedConnectionHandler;
    @NotNull
    private final CompletableDeferred<JupyterConnectionParameters> _connectionFuture = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    @NotNull
    private volatile JupyterServerState state = (JupyterServerState)JupyterServerStopped.INSTANCE;
    @NotNull
    private List<? extends JupyterServerStateListener> stateListeners = CollectionsKt.emptyList();

    @NotNull
    public Deferred<JupyterConnectionParameters> getConnectionDeferred() {
        return (Deferred)this._connectionFuture;
    }

    @NotNull
    public JupyterServerState getState() {
        return this.state;
    }

    public void setState$intellij_jupyter_py(@NotNull JupyterServerState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.state = value;
        this.notifyStateListeners(value);
    }

    private final void setJupyterServerStartedState(JupyterConnectionParameters connectionParameters) {
        this.setState$intellij_jupyter_py((JupyterServerState)new JupyterServerStarted(connectionParameters));
        this._connectionFuture.complete((Object)connectionParameters);
    }

    private final void setRetrieveConnectionParametersException(Exception e) {
        this._connectionFuture.completeExceptionally((Throwable)e);
    }

    private final void setExceptionallyStoppedState(JupyterManagedServerProcessHandler handler) {
        this.setState$intellij_jupyter_py((JupyterServerState)new JupyterServerFinished(true));
        JupyterManagedServerExited error = new JupyterManagedServerExited(handler);
        this._connectionFuture.completeExceptionally((Throwable)error);
    }

    private final void setExceptionallyStartedState(Throwable e) {
        this.setState$intellij_jupyter_py((JupyterServerState)new JupyterServerFinished(true));
        this._connectionFuture.completeExceptionally(e);
    }

    public void addStateListener(@NotNull JupyterServerStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.stateListeners = CollectionsKt.plus((Collection)this.stateListeners, (Object)listener2);
    }

    private final void notifyStateListeners(JupyterServerState newState) {
        Iterable $this$forEach$iv = this.stateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterServerStateListener it = (JupyterServerStateListener)element$iv;
            boolean bl = false;
            it.stateChanged(newState);
        }
    }

    public final void startServer(@NotNull JupyterRuntimeManagedServerInfo managedServerConfiguration, @NotNull JupyterManagedServerConfig settings, @NotNull Function1<? super JupyterManagedServerProcessHandler, Unit> onBeforeStartNotify, @NotNull Function1<? super JupyterConnectionParameters, Unit> onServerInit, @NotNull Function1<? super Boolean, Unit> onServerTerminated) {
        Intrinsics.checkNotNullParameter((Object)managedServerConfiguration, (String)"managedServerConfiguration");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(onBeforeStartNotify, (String)"onBeforeStartNotify");
        Intrinsics.checkNotNullParameter(onServerInit, (String)"onServerInit");
        Intrinsics.checkNotNullParameter(onServerTerminated, (String)"onServerTerminated");
        try {
            this.internalStartServer(managedServerConfiguration, settings, onServerInit, onServerTerminated, onBeforeStartNotify);
        }
        catch (CancellationException e) {
            this.setExceptionallyStartedState(e);
            throw e;
        }
        catch (Throwable e) {
            JupyterConnectionsCollector.INSTANCE.logManagedServerStart(JupyterManagedStartResult.UNKNOWN_ERROR);
            JupyterServerExecutionImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterServerExecutionImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Jupyter server start error.", e);
            this.setExceptionallyStartedState(e);
            return;
        }
    }

    private final void internalStartServer(JupyterRuntimeManagedServerInfo managedServerConfiguration, JupyterManagedServerConfig settings, Function1<? super JupyterConnectionParameters, Unit> onServerInit, Function1<? super Boolean, Unit> onServerTerminated, Function1<? super JupyterManagedServerProcessHandler, Unit> onBeforeStartNotify) {
        JupyterManagedServerProcessHandler processHandler;
        ProgressIndicator startupProgressIndicator = this.getProgressIndicator();
        Module module = managedServerConfiguration.getModule();
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Sdk sdk = PySdkExtKt.getPythonSdk((Module)module);
        if (sdk == null) {
            Sdk sdk2 = PySdkExtKt.getPythonSdk((Project)project2);
            sdk = sdk2;
            Intrinsics.checkNotNull((Object)sdk2);
        }
        Sdk pythonSdk = sdk;
        this.setState$intellij_jupyter_py((JupyterServerState)JupyterServerStarting.INSTANCE);
        TargetEnvironmentRequest request2 = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(pythonSdk, project2).getTargetEnvironmentRequest();
        Pair<TargetEnvironment, TargetedCommandLine> pair = JupyterServerCommandsKt.createJupyterStartCommandLine("jupyterlab", request2, startupProgressIndicator, managedServerConfiguration, settings, project2);
        TargetEnvironment targetEnvironment = (TargetEnvironment)pair.component1();
        TargetedCommandLine targetCommandLine = (TargetedCommandLine)pair.component2();
        this.managedConnectionHandler = processHandler = new JupyterManagedServerProcessHandler(targetEnvironment, targetCommandLine, startupProgressIndicator, arg_0 -> JupyterServerExecutionImpl.internalStartServer$lambda$0(this, settings, pythonSdk, onServerInit, arg_0), (arg_0, arg_1, arg_2) -> JupyterServerExecutionImpl.internalStartServer$lambda$1(this, project2, onServerTerminated, arg_0, arg_1, arg_2), (arg_0, arg_1) -> JupyterServerExecutionImpl.internalStartServer$lambda$2(this, project2, arg_0, arg_1), false, 64, null);
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler), (Project)module.getProject());
        JupyterCoroutineKt.launchEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onBeforeStartNotify, processHandler, null){
            int label;
            final /* synthetic */ Function1<JupyterManagedServerProcessHandler, Unit> $onBeforeStartNotify;
            final /* synthetic */ JupyterManagedServerProcessHandler $processHandler;
            {
                this.$onBeforeStartNotify = $onBeforeStartNotify;
                this.$processHandler = $processHandler;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$onBeforeStartNotify.invoke((Object)this.$processHandler);
                        this.$processHandler.startNotify();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Job stopOrDetach(@NotNull ProcessCloseConfirmation decision) {
        Job job;
        Intrinsics.checkNotNullParameter((Object)decision, (String)"decision");
        Job.DefaultImpls.cancel$default((Job)((Job)this._connectionFuture), null, (int)1, null);
        JupyterManagedServerProcessHandler jupyterManagedServerProcessHandler = this.managedConnectionHandler;
        if (jupyterManagedServerProcessHandler != null) {
            JupyterManagedServerProcessHandler $this$stopOrDetach_u24lambda_u240 = jupyterManagedServerProcessHandler;
            boolean bl = false;
            Deferred deferred = BuildersKt.async$default((CoroutineScope)((CoroutineScope)NotebookDisposable.Companion.getForApp()), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(decision, $this$stopOrDetach_u24lambda_u240, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ ProcessCloseConfirmation $decision;
                final /* synthetic */ JupyterManagedServerProcessHandler $this_run;
                {
                    this.$decision = $decision;
                    this.$this_run = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            switch (stopOrDetach.1.WhenMappings.$EnumSwitchMapping$0[this.$decision.ordinal()]) {
                                case 1: {
                                    void $this$async;
                                    void $this$thisLogger$iv = $this$async;
                                    boolean $i$f$thisLogger = false;
                                    Logger logger = Logger.getInstance(CoroutineScope.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                    logger.error("Should choose terminate or detach, managed server is terminated");
                                    this.$this_run.destroyProcess();
                                    break;
                                }
                                case 2: {
                                    this.$this_run.destroyProcess();
                                    break;
                                }
                                case 3: {
                                    this.$this_run.detachProcess();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            jupyterManagedServerProcessHandler = deferred;
            if (deferred != null) {
                job = (Job)jupyterManagedServerProcessHandler;
                return job;
            }
        }
        job = (Job)CompletableDeferredKt.CompletableDeferred((Object)Unit.INSTANCE);
        return job;
    }

    private final void onServerInit(JupyterManagedServerProcessHandler handler, JupyterManagedServerConfig settings, Sdk pythonSdk, Function1<? super JupyterConnectionParameters, Unit> onServerInit) {
        block8: {
            String string;
            Path serverPath;
            URI uri;
            block10: {
                block9: {
                    CharSequence charSequence;
                    block7: {
                        uri = handler.getLocation();
                        if (uri != null) break block7;
                        this.setRetrieveConnectionParametersException(new IllegalStateException("Managed Jupyter Server url must not be null"));
                        break block8;
                    }
                    String string2 = handler.getServerPath();
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        v1 = Path.of(it, new String[0]);
                    } else {
                        v1 = serverPath = null;
                    }
                    if ((string = handler.getToken()) == null) break block9;
                    CharSequence charSequence2 = string;
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    if ((string = (String)charSequence) != null) break block10;
                }
                string = settings.getPassword();
            }
            String token = string;
            JupyterHttpParams jupyterHttpParams = new JupyterHttpParams(uri, (JupyterAuthParams)new JupyterTokenAuthParams(token), settings.getAuthority(), false);
            String string3 = settings.getId();
            JupyterConnectionParameters connectionParameters = new JupyterConnectionParameters(string3, jupyterHttpParams, serverPath, pythonSdk, null, 16, null);
            onServerInit.invoke((Object)connectionParameters);
            this.setJupyterServerStartedState(connectionParameters);
            JupyterPyFeaturesCollector.INSTANCE.sdkIsUsedForJupyter(pythonSdk);
            JupyterConnectionsCollector.INSTANCE.logManagedServerStart(JupyterManagedStartResult.SUCCESS);
        }
    }

    private final void onServerTerminated(JupyterManagedServerProcessHandler handler, Project project, boolean isDestroyed, Function1<? super Boolean, Unit> onServerTerminated) {
        if (this.getState() instanceof JupyterServerStarting) {
            JupyterConnectionsCollector.INSTANCE.logManagedServerStart(JupyterManagedStartResult.PROCESS_STOPPED_ON_START);
            JupyterServerExecutionImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterServerExecutionImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot start jupyter server. Process stopped before it was started.\nStderr: \n" + handler.collectErrorData());
        }
        this.setExceptionallyStoppedState(handler);
        onServerTerminated.invoke((Object)isDestroyed);
    }

    private final void onServerError(Exception exception, Project project, JupyterManagedServerProcessHandler handler) {
        this.setRetrieveConnectionParametersException(exception);
        JupyterConnectionsCollector.INSTANCE.logManagedServerStart(JupyterManagedStartResult.SERVER_ERROR);
        JupyterServerExecutionImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterServerExecutionImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Jupyter server error.", (Throwable)exception);
        JupyterCoroutineKt.launchEdt((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, handler, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterManagedServerProcessHandler $handler;
            {
                this.$project = $project;
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = JupyterNotification.INSTANCE.showExceptionDialogAsync(this.$project, (Throwable)new JupyterManagedServerExited(this.$handler), false, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        return progressIndicator;
    }

    private static final Unit internalStartServer$lambda$0(JupyterServerExecutionImpl this$0, JupyterManagedServerConfig $settings, Sdk $pythonSdk, Function1 $onServerInit, JupyterManagedServerProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this$0.onServerInit(handler, $settings, $pythonSdk, (Function1<? super JupyterConnectionParameters, Unit>)$onServerInit);
        return Unit.INSTANCE;
    }

    private static final Unit internalStartServer$lambda$1(JupyterServerExecutionImpl this$0, Project $project, Function1 $onServerTerminated, JupyterManagedServerProcessHandler handler, ProcessEvent processEvent, boolean isDestroyed) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)processEvent, (String)"<unused var>");
        this$0.onServerTerminated(handler, $project, isDestroyed, (Function1<? super Boolean, Unit>)$onServerTerminated);
        return Unit.INSTANCE;
    }

    private static final Unit internalStartServer$lambda$2(JupyterServerExecutionImpl this$0, Project $project, Exception exception, JupyterManagedServerProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this$0.onServerError(exception, $project, handler);
        return Unit.INSTANCE;
    }
}

