/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.debugger.common.DebugConnectionNotifier;
import com.intellij.jupyter.core.jupyter.debugger.common.NotebookDebugRunner;
import com.intellij.jupyter.py.debugger.JupyterAutoBreakpointHelper;
import com.intellij.jupyter.py.debugger.JupyterConsoleExecuteActionHandler;
import com.intellij.jupyter.py.debugger.JupyterDebugAction;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.jupyter.py.debugger.JupyterDebugProcessHandler;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.run.PythonCommandLineState;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner;", "Lcom/jetbrains/python/debugger/PyDebugRunner;", "Lcom/intellij/jupyter/core/jupyter/debugger/common/NotebookDebugRunner;", "<init>", "()V", "createDebugSession", "Lcom/intellij/xdebugger/XDebugSession;", "project", "Lcom/intellij/openapi/project/Project;", "jupyterPsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "connectionNotifier", "Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "afterCellExecuted", "Lkotlin/Function0;", "", "getConnectionNotifier", "()Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "Companion", "intellij.jupyter.py"})
public final class JupyterDebugRunner
extends PyDebugRunner
implements NotebookDebugRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JupyterDebugRunner instance = new JupyterDebugRunner();
    @NotNull
    private static final Logger LOG;

    @NotNull
    public XDebugSession createDebugSession(@NotNull Project project, @NotNull JupyterPsiCell jupyterPsiCell, @NotNull NotebookIntervalPointer cellPointer, @NotNull VirtualFile virtualFile, @NotNull DebugConnectionNotifier connectionNotifier2, @NotNull Function0<Unit> afterCellExecuted) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jupyterPsiCell, (String)"jupyterPsiCell");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)connectionNotifier2, (String)"connectionNotifier");
        Intrinsics.checkNotNullParameter(afterCellExecuted, (String)"afterCellExecuted");
        ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        JupyterAutoBreakpointHelper.INSTANCE.addBreakpointToCellIfNeeded$intellij_jupyter_py(cellPointer, project, virtualFile);
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(JupyterDebugRunner.Companion.getFileName(jupyterPsiCell), JupyterCoreIcons.JupyterNotebook, null, false, new XDebugProcessStarter(project, serverSocket, jupyterPsiCell, cellPointer, connectionNotifier2, afterCellExecuted, virtualFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ ServerSocket $serverSocket;
            final /* synthetic */ JupyterPsiCell $jupyterPsiCell;
            final /* synthetic */ NotebookIntervalPointer $cellPointer;
            final /* synthetic */ DebugConnectionNotifier $connectionNotifier;
            final /* synthetic */ Function0<Unit> $afterCellExecuted;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$serverSocket = $serverSocket;
                this.$jupyterPsiCell = $jupyterPsiCell;
                this.$cellPointer = $cellPointer;
                this.$connectionNotifier = $connectionNotifier;
                this.$afterCellExecuted = $afterCellExecuted;
                this.$virtualFile = $virtualFile;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                ConsoleView consoleView = new PyDebugConsoleBuilder(this.$project, null).getConsole();
                Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
                ConsoleView debugConsoleView = consoleView;
                JupyterDebugProcessHandler jupyterDebugProcessHandler = new JupyterDebugProcessHandler(this.$project, session);
                ServerSocket serverSocket = this.$serverSocket;
                Intrinsics.checkNotNull((Object)serverSocket);
                JupyterDebugProcess jupyterDebugProcess = new JupyterDebugProcess(session, serverSocket, (ExecutionConsole)debugConsoleView, jupyterDebugProcessHandler, this.$jupyterPsiCell, this.$cellPointer, this.$connectionNotifier, this.$afterCellExecuted, BackedNotebookVirtualFile.Companion.takeBackend(this.$virtualFile));
                debugConsoleView.attachToProcess((ProcessHandler)jupyterDebugProcessHandler);
                com.intellij.jupyter.py.debugger.JupyterDebugRunner$Companion.access$initDebugConsoleView(JupyterDebugRunner.Companion, this.$project, jupyterDebugProcess, (PythonDebugLanguageConsoleView)debugConsoleView, jupyterDebugProcessHandler, session);
                jupyterDebugProcess.connect(this.$jupyterPsiCell, this.$cellPointer);
                PyConsoleUtil.markIPython((VirtualFile)((PythonDebugLanguageConsoleView)debugConsoleView).getPydevConsoleView().getVirtualFile());
                return (XDebugProcess)jupyterDebugProcess;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSessionAndShowTab(...)");
        return xDebugSession;
    }

    @NotNull
    public DebugConnectionNotifier getConnectionNotifier() {
        return new DebugConnectionNotifier(){

            public Object executeAfterConnection(Project project, JupyterPsiCell jupyterCell, NotebookIntervalPointer cellPointer, XDebugSession debugSession, Continuation<? super Unit> $completion) {
                Object object = JupyterDebugAction.Companion.executeCell(project, jupyterCell, cellPointer, debugSession, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
    }

    public static final /* synthetic */ PythonDebugConsoleCommunication access$initDebugConsoleView$s821162362(PythonConsoleView p0, PydevDebugConsoleExecuteActionHandler p1, PyDebugProcess p2, ProcessHandler p3, PythonDebugConsoleCommunication p4, XDebugSession p5) {
        return PyDebugRunner.initDebugConsoleView((PythonConsoleView)p0, (PydevDebugConsoleExecuteActionHandler)p1, (PyDebugProcess)p2, (ProcessHandler)p3, (PythonDebugConsoleCommunication)p4, (XDebugSession)p5);
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner;", "getInstance", "()Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner;", "initDebugConsoleView", "Lcom/jetbrains/python/console/PythonDebugConsoleCommunication;", "project", "Lcom/intellij/openapi/project/Project;", "debugProcess", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "console", "Lcom/jetbrains/python/console/PythonDebugLanguageConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getFileName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "cell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterDebugRunner getInstance() {
            return instance;
        }

        private final PythonDebugConsoleCommunication initDebugConsoleView(Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, XDebugSession session) {
            PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
            Intrinsics.checkNotNullExpressionValue((Object)pythonConsoleView, (String)"getPydevConsoleView(...)");
            PythonConsoleView pythonConsoleView2 = pythonConsoleView;
            PythonDebugConsoleCommunication debugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess, pythonConsoleView2);
            pythonConsoleView2.setConsoleCommunication((ConsoleCommunication)debugConsoleCommunication);
            JupyterConsoleExecuteActionHandler consoleExecuteActionHandler = new JupyterConsoleExecuteActionHandler(console, processHandler, (ConsoleCommunication)debugConsoleCommunication, debugProcess);
            PythonDebugConsoleCommunication pythonDebugConsoleCommunication = JupyterDebugRunner.access$initDebugConsoleView$s821162362(pythonConsoleView2, consoleExecuteActionHandler, debugProcess, processHandler, debugConsoleCommunication, session);
            Intrinsics.checkNotNullExpressionValue((Object)pythonDebugConsoleCommunication, (String)"access$initDebugConsoleView$s821162362(...)");
            return pythonDebugConsoleCommunication;
        }

        @Nls
        private final String getFileName(JupyterPsiCell cell) {
            String string;
            if (cell.getContainingFile() != null) {
                string = FileUtil.getNameWithoutExtension((String)cell.getContainingFile().getName());
            } else {
                this.getLOG().error("Containing file for cell is null: " + cell);
                string = JupyterBundle.message((String)"Jupyter.debugger.session.default.file.name", (Object[])new Object[0]);
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public static final /* synthetic */ PythonDebugConsoleCommunication access$initDebugConsoleView(Companion $this, Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, XDebugSession session) {
            return $this.initDebugConsoleView(project, debugProcess, console, processHandler, session);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

