/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssConstants;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssLchColorUtils;
import com.intellij.psi.css.impl.util.CssPsiColorAdjustmentUtils;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtilCore;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.MathUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssPsiColorUtil {
    private static final Pattern STARTS_WITH_MS_GRADIENT_FUNCTION = Pattern.compile("\\s*progid\\s*:\\s*DXImageTransform\\s*\\.\\s*Microsoft\\s*\\.\\s*gradient.*", 34);

    @Nullable
    public static PsiElement getColorFunctionElement(@NotNull PsiElement element) {
        ASTNode elementNode;
        if (element == null) {
            CssPsiColorUtil.$$$reportNull$$$0(0);
        }
        PsiElement firstChild = element.getFirstChild();
        if (element instanceof CssTerm && firstChild instanceof CssFunction) {
            element = firstChild;
        }
        if ((elementNode = element.getNode()) != null && CssElementTypes.CSS_FUNCTION == elementNode.getElementType() && elementNode instanceof CssFunction) {
            return element;
        }
        return null;
    }

    @Nullable
    public static Color getColorInClassicCss(@NotNull PsiElement element) {
        PsiElement functionElement;
        if (element == null) {
            CssPsiColorUtil.$$$reportNull$$$0(1);
        }
        if ((functionElement = CssPsiColorUtil.getColorFunctionElement(element)) != null) {
            ASTNode elementNode = functionElement.getNode();
            PsiElement functionNameElement = ((CssFunction)elementNode).getFunctionNameElement();
            if (functionNameElement == null) {
                return null;
            }
            ColorDeclarationType colorDeclarationType = ColorDeclarationType.fromColorTerm(functionNameElement);
            CssTermList termList = (CssTermList)PsiTreeUtil.getChildOfType((PsiElement)functionElement, CssTermList.class);
            if (termList != null) {
                if (colorDeclarationType == ColorDeclarationType.RGB || colorDeclarationType == ColorDeclarationType.RGBA) {
                    return CssPsiColorUtil.getColorInRGBsFunctions(termList.getText());
                }
                if (colorDeclarationType == ColorDeclarationType.HSL || colorDeclarationType == ColorDeclarationType.HSLA) {
                    return CssPsiColorUtil.getColorInHSLsFunctions(termList.getText());
                }
                if (colorDeclarationType == ColorDeclarationType.GRAY) {
                    return CssPsiColorUtil.getColorInGrayFunction(termList.getText());
                }
                if (colorDeclarationType == ColorDeclarationType.HWB) {
                    return CssPsiColorUtil.getColorInHwbFunction(termList.getText());
                }
                if (colorDeclarationType == ColorDeclarationType.LCH) {
                    return CssPsiColorUtil.getColorInLchFunction(termList.getText());
                }
                if (colorDeclarationType == ColorDeclarationType.OKLCH) {
                    return CssPsiColorUtil.getColorInOklchFunction(termList.getText());
                }
                if (colorDeclarationType == ColorDeclarationType.COLOR) {
                    return CssPsiColorUtil.getColorInColorFunction(termList);
                }
            }
        } else {
            return CssPsiColorUtil.getColorInTerm(element);
        }
        return null;
    }

    @Nullable
    private static Color getColorInTerm(@NotNull PsiElement element) {
        if (element == null) {
            CssPsiColorUtil.$$$reportNull$$$0(2);
        }
        String elementText = element.getText();
        try {
            String colorHex = null;
            Object alphaHex = null;
            if (elementText.length() == 9 && elementText.charAt(0) == '#') {
                if (CssPsiColorUtil.isIeSpecific8DigitColor(element)) {
                    colorHex = elementText.substring(3);
                    alphaHex = elementText.substring(1, 3);
                } else {
                    colorHex = elementText.substring(1, 7);
                    alphaHex = elementText.substring(7);
                }
            } else if (elementText.length() == 5 && elementText.charAt(0) == '#') {
                colorHex = elementText.substring(1, 4);
                alphaHex = elementText.substring(4) + elementText.substring(4);
            }
            if (colorHex != null) {
                Color baseColor = ColorUtil.fromHex(colorHex);
                int alpha = Integer.decode("0x" + alphaHex);
                return ColorUtil.toAlpha((Color)baseColor, (int)alpha);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ColorMap.getColor((String)elementText);
    }

    private static boolean isIeSpecific8DigitColor(PsiElement element) {
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
        if (function == null) {
            return false;
        }
        CssTermList termList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)function, CssTermList.class);
        if (termList == null) {
            return false;
        }
        return STARTS_WITH_MS_GRADIENT_FUNCTION.matcher(termList.getText()).find();
    }

    @Nullable
    public static Color getColorInRGBsFunctions(@NotNull String rgbFunctionArguments) {
        String spaceSeparated;
        List terms;
        if (rgbFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(3);
        }
        if ((terms = StringUtil.split((String)(spaceSeparated = StringUtil.replace((String)rgbFunctionArguments, List.of(",", "/"), List.of(" ", " "))), (String)" ")).size() != 3 && terms.size() != 4) {
            return null;
        }
        double opacity = CssPsiColorUtil.getOpacityFromForthTerm(terms);
        if (opacity == -1.0) {
            return null;
        }
        String red = ((String)terms.get(0)).trim();
        String green = ((String)terms.get(1)).trim();
        String blue = ((String)terms.get(2)).trim();
        if (StringUtil.endsWithChar((CharSequence)red, (char)'%')) {
            double r = CssPsiColorUtil.getPercentageValue(red);
            if (r == -1.0) {
                return null;
            }
            double g = CssPsiColorUtil.getPercentageValue(green);
            if (g == -1.0) {
                return null;
            }
            double b = CssPsiColorUtil.getPercentageValue(blue);
            if (b == -1.0) {
                return null;
            }
            return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (double)opacity);
        }
        int r = StringUtil.parseInt((String)red, (int)-1);
        if (r == -1) {
            return null;
        }
        int g = StringUtil.parseInt((String)green, (int)-1);
        if (g == -1) {
            return null;
        }
        int b = StringUtil.parseInt((String)blue, (int)-1);
        if (b == -1) {
            return null;
        }
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (double)opacity);
    }

    @Nullable
    private static Color getColorInHSLsFunctions(@NotNull String hslFunctionArguments) {
        String spaceSeparated;
        List terms;
        if (hslFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(4);
        }
        if ((terms = StringUtil.split((String)(spaceSeparated = StringUtil.replace((String)hslFunctionArguments, List.of(",", "/"), List.of(" ", " "))), (String)" ")).size() != 3 && terms.size() != 4) {
            return null;
        }
        double opacity = CssPsiColorUtil.getOpacityFromForthTerm(terms);
        if (opacity == -1.0) {
            return null;
        }
        String h = ((String)terms.get(0)).trim();
        String s = ((String)terms.get(1)).trim();
        String l = ((String)terms.get(2)).trim();
        double hue = CssPsiColorUtil.getHueValue(h);
        if (hue == -1.0) {
            return null;
        }
        double saturation = CssPsiColorUtil.getPercentageValue(s);
        if (saturation == -1.0) {
            return null;
        }
        double lightness = CssPsiColorUtil.getPercentageValue(l);
        if (lightness == -1.0) {
            return null;
        }
        double[] rgb = CssPsiColorUtil.getRgbByHsl(hue, saturation, lightness);
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]), (double)opacity);
    }

    private static double getOpacityFromForthTerm(@NotNull List<String> terms) {
        if (terms == null) {
            CssPsiColorUtil.$$$reportNull$$$0(5);
        }
        if (terms.size() != 4) {
            return 1.0;
        }
        String alpha = terms.get(3).trim();
        if (StringUtil.endsWithChar((CharSequence)alpha, (char)'%')) {
            return CssPsiColorUtil.getPercentageValue(alpha);
        }
        return CssPsiColorUtil.getProportionValue(alpha);
    }

    public static double @NotNull [] getRgbByHsl(double hue, double saturation, double lightness) {
        double v;
        double r = lightness;
        double g = lightness;
        double b = lightness;
        double d = v = lightness <= 0.5 ? lightness * (1.0 + saturation) : lightness + saturation - lightness * saturation;
        if (v > 0.0) {
            double m = lightness + lightness - v;
            double sv = (v - m) / v;
            double _hue = hue * 6.0;
            int sextant = (int)_hue;
            double fract = _hue - (double)sextant;
            double vsf = v * sv * fract;
            double mid1 = m + vsf;
            double mid2 = v - vsf;
            switch (sextant) {
                case 0: {
                    r = v;
                    g = mid1;
                    b = m;
                    break;
                }
                case 1: {
                    r = mid2;
                    g = v;
                    b = m;
                    break;
                }
                case 2: {
                    r = m;
                    g = v;
                    b = mid1;
                    break;
                }
                case 3: {
                    r = m;
                    g = mid2;
                    b = v;
                    break;
                }
                case 4: {
                    r = mid1;
                    g = m;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = m;
                    b = mid2;
                }
            }
        }
        double[] dArray = new double[]{r, g, b};
        if (dArray == null) {
            CssPsiColorUtil.$$$reportNull$$$0(6);
        }
        return dArray;
    }

    public static double @NotNull [] getHslByRgb(int red, int green, int blue) {
        double S;
        double var_Max;
        double var_Min;
        double var_R = (double)red / 255.0;
        double var_G = (double)green / 255.0;
        double var_B = (double)blue / 255.0;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        double del_Max = var_Max - var_Min;
        double H = 0.0;
        double L = (var_Max + var_Min) / 2.0;
        if (del_Max == 0.0) {
            H = 0.0;
            S = 0.0;
        } else {
            S = L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0 - var_Max - var_Min);
            double del_R = ((var_Max - var_R) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - var_G) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - var_B) / 6.0 + del_Max / 2.0) / del_Max;
            if (var_R == var_Max) {
                H = del_B - del_G;
            } else if (var_G == var_Max) {
                H = 0.3333333333333333 + del_R - del_B;
            } else if (var_B == var_Max) {
                H = 0.6666666666666666 + del_G - del_R;
            }
            if (H < 0.0) {
                H += 1.0;
            }
            if (H > 1.0) {
                H -= 1.0;
            }
        }
        double[] dArray = new double[]{H, S, L};
        if (dArray == null) {
            CssPsiColorUtil.$$$reportNull$$$0(7);
        }
        return dArray;
    }

    @Nullable
    private static Color getColorInGrayFunction(@NotNull String grayFunctionArguments) {
        String[] terms;
        if (grayFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(8);
        }
        if ((terms = grayFunctionArguments.split(",")).length != 1 && terms.length != 2) {
            return null;
        }
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = terms[i].trim();
        }
        double opacity = 1.0;
        if (terms.length == 2) {
            double d = opacity = StringUtil.endsWithChar((CharSequence)terms[1], (char)'%') ? CssPsiColorUtil.getPercentageValue(terms[1]) : CssPsiColorUtil.getProportionValue(terms[1]);
            if (opacity == -1.0) {
                return null;
            }
        }
        if (StringUtil.endsWithChar((CharSequence)terms[0], (char)'%')) {
            double gray = CssPsiColorUtil.getPercentageValue(terms[0]);
            return gray != -1.0 ? ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(gray, gray, gray), (double)opacity) : null;
        }
        int gray = StringUtil.parseInt((String)terms[0], (int)-1);
        return gray != -1 ? ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(gray, gray, gray), (double)opacity) : null;
    }

    @Nullable
    private static Color getColorInHwbFunction(@NotNull String hwbFunctionArguments) {
        String[] terms;
        if (hwbFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(9);
        }
        if ((terms = hwbFunctionArguments.split(",")).length != 3 && terms.length != 4) {
            return null;
        }
        double hue = CssPsiColorUtil.getHueValue(terms[0]);
        if (hue == -1.0) {
            return null;
        }
        double whiteness = CssPsiColorUtil.getPercentageValue(terms[1]);
        if (whiteness == -1.0) {
            return null;
        }
        double blackness = CssPsiColorUtil.getPercentageValue(terms[2]);
        if (blackness == -1.0) {
            return null;
        }
        double opacity = 1.0;
        if (terms.length == 4) {
            double d = opacity = StringUtil.endsWithChar((CharSequence)terms[3].trim(), (char)'%') ? CssPsiColorUtil.getPercentageValue(terms[3]) : CssPsiColorUtil.getProportionValue(terms[3]);
            if (opacity == -1.0) {
                return null;
            }
        }
        double[] rgb = CssPsiColorUtil.getRgbByHwb(hue, whiteness, blackness);
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]), (double)opacity);
    }

    public static double @NotNull [] getRgbByHwb(double hue, double whiteness, double blackness) {
        double white = whiteness;
        double black = blackness;
        double whitePlusBlack = white + black;
        if (whitePlusBlack > 1.0) {
            white *= 1.0 / whitePlusBlack;
            black *= 1.0 / whitePlusBlack;
        }
        double[] rgb = CssPsiColorUtil.getRgbByHsl(hue, 1.0, 0.5);
        int i = 0;
        while (i < rgb.length) {
            int n = i;
            rgb[n] = rgb[n] * (1.0 - white - black);
            int n2 = i++;
            rgb[n2] = rgb[n2] + white;
        }
        if (rgb == null) {
            CssPsiColorUtil.$$$reportNull$$$0(10);
        }
        return rgb;
    }

    @Nullable
    private static Color getColorInColorFunction(@NotNull CssTermList termList) {
        Color baseColor;
        if (termList == null) {
            CssPsiColorUtil.$$$reportNull$$$0(11);
        }
        if (termList.getTerms().length == 0) {
            return null;
        }
        CssTerm baseColorTerm = termList.getTerms()[0];
        double hue = CssPsiColorUtil.getHueValue(baseColorTerm.getText());
        if (hue != -1.0) {
            double[] rgb = CssPsiColorUtil.getRgbByHsl(hue, 1.0, 0.5);
            baseColor = CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]);
        } else {
            baseColor = CssPsiColorUtil.getColorInClassicCss((PsiElement)baseColorTerm);
        }
        if (baseColor == null) {
            return null;
        }
        for (int i = 1; i < termList.getTerms().length; ++i) {
            CssTerm term = termList.getTerms()[i];
            Color color = CssPsiColorAdjustmentUtils.adjustColor(baseColor, term);
            if (color == null) continue;
            baseColor = color;
        }
        return baseColor;
    }

    public static double @NotNull [] getRgbFromLch(double lightness, double chroma, double hue) {
        double[] dArray = CssLchColorUtils.gamSRgb(CssLchColorUtils.xyzToLinSRgb(CssLchColorUtils.d50ToD65(CssLchColorUtils.labToXyz(CssLchColorUtils.lchToLab(lightness, chroma, hue)))));
        if (dArray == null) {
            CssPsiColorUtil.$$$reportNull$$$0(12);
        }
        return dArray;
    }

    @Nullable
    private static Color getColorInLchFunction(@NotNull String lchFunctionArguments) {
        double[] lch;
        if (lchFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(13);
        }
        if ((lch = CssPsiColorUtil.getLch(lchFunctionArguments)) == null) {
            return null;
        }
        double[] rgb = CssPsiColorUtil.getRgbFromLch(lch[0], lch[1] < 0.0 ? 0.0 : lch[1], lch[2]);
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]), (double)lch[3]);
    }

    public static double @NotNull [] getRgbFromOklch(double lightness, double chroma, double hue) {
        double[] dArray = CssLchColorUtils.gamSRgb(CssLchColorUtils.xyzToLinSRgb(CssLchColorUtils.oklabToXyz(CssLchColorUtils.oklchToOklab(lightness, chroma, hue))));
        if (dArray == null) {
            CssPsiColorUtil.$$$reportNull$$$0(14);
        }
        return dArray;
    }

    @Nullable
    private static Color getColorInOklchFunction(@NotNull String lchFunctionArguments) {
        double[] oklch;
        if (lchFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(15);
        }
        if ((oklch = CssPsiColorUtil.getOklch(lchFunctionArguments)) == null) {
            return null;
        }
        double[] rgb = CssPsiColorUtil.getRgbFromOklch(oklch[0], oklch[1] < 0.0 ? 0.0 : oklch[1], oklch[2]);
        return ColorUtil.withAlpha((Color)CssPsiColorUtil.createColor(rgb[0], rgb[1], rgb[2]), (double)oklch[3]);
    }

    public static double @Nullable [] getLch(@NotNull String lchFunctionArguments) {
        String spaceSeparated;
        List terms;
        if (lchFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(16);
        }
        if ((terms = StringUtil.split((String)(spaceSeparated = StringUtil.replace((String)lchFunctionArguments, List.of(",", "/"), List.of(" ", " "))), (String)" ")).size() != 3 && terms.size() != 4) {
            return null;
        }
        double lightness = CssPsiColorUtil.getLchLightnessValue(((String)terms.get(0)).trim());
        double chroma = CssPsiColorUtil.getLchChromaValue(((String)terms.get(1)).trim());
        double hue = CssPsiColorUtil.getHueValue(((String)terms.get(2)).trim()) * 360.0;
        double alpha = CssPsiColorUtil.getOpacityFromForthTerm(terms);
        return new double[]{lightness, chroma, hue, alpha};
    }

    public static double @Nullable [] getOklch(@NotNull String oklchFunctionArguments) {
        String spaceSeparated;
        List terms;
        if (oklchFunctionArguments == null) {
            CssPsiColorUtil.$$$reportNull$$$0(17);
        }
        if ((terms = StringUtil.split((String)(spaceSeparated = StringUtil.replace((String)oklchFunctionArguments, List.of(",", "/"), List.of(" ", " "))), (String)" ")).size() != 3 && terms.size() != 4) {
            return null;
        }
        double lightness = CssPsiColorUtil.getOklchLightnessValue(((String)terms.get(0)).trim());
        double chroma = CssPsiColorUtil.getOklchChromaValue(((String)terms.get(1)).trim());
        double hue = CssPsiColorUtil.getHueValue(((String)terms.get(2)).trim()) * 360.0;
        double alpha = CssPsiColorUtil.getOpacityFromForthTerm(terms);
        return new double[]{lightness, chroma, hue, alpha};
    }

    public static double getPercentageValue(@NotNull String term) {
        int ndx;
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(18);
        }
        if ((ndx = term.indexOf(37)) < 0) {
            return -1.0;
        }
        double value = StringUtil.parseDouble((String)term.substring(0, ndx), (double)-1.0);
        return value != -1.0 ? MathUtil.clamp((double)(value / 100.0), (double)0.0, (double)1.0) : -1.0;
    }

    public static double getPercentageValueWithSign(@NotNull String term) {
        int ndx;
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(19);
        }
        if ((ndx = term.indexOf(37)) < 0) {
            return Double.NaN;
        }
        double value = StringUtil.parseDouble((String)term.substring(0, ndx), (double)Double.NaN);
        return !Double.isNaN(value) ? MathUtil.clamp((double)(value / 100.0), (double)-1.0, (double)1.0) : Double.NaN;
    }

    public static double getProportionValue(@NotNull String term) {
        double value;
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(20);
        }
        return (value = StringUtil.parseDouble((String)term, (double)-1.0)) != -1.0 ? MathUtil.clamp((double)value, (double)0.0, (double)1.0) : -1.0;
    }

    public static double getLchLightnessValue(@NotNull String term) {
        int ndx;
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(21);
        }
        if ((ndx = term.indexOf(37)) >= 0) {
            return StringUtil.parseDouble((String)term.substring(0, ndx), (double)-1.0);
        }
        return StringUtil.parseDouble((String)term, (double)-1.0);
    }

    public static double getLchChromaValue(@NotNull String term) {
        int ndx;
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(22);
        }
        if ((ndx = term.indexOf(37)) >= 0) {
            return StringUtil.parseDouble((String)term.substring(0, ndx), (double)-1.0);
        }
        return StringUtil.parseDouble((String)term, (double)-1.0);
    }

    public static double getOklchLightnessValue(@NotNull String term) {
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(23);
        }
        return CssPsiColorUtil.getOklchChromaValue(term);
    }

    public static double getOklchChromaValue(@NotNull String term) {
        int ndx;
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(24);
        }
        if ((ndx = term.indexOf(37)) >= 0) {
            return StringUtil.parseDouble((String)term.substring(0, ndx), (double)-1.0) / 100.0;
        }
        return StringUtil.parseDouble((String)term, (double)-1.0);
    }

    public static double getHueValue(@NotNull String term) {
        double hue;
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(25);
        }
        return (hue = StringUtil.parseDouble((String)StringUtil.trimEnd((String)term, (String)"deg"), (double)-1.0)) != -1.0 ? (hue % 360.0 + 360.0) % 360.0 / 360.0 : -1.0;
    }

    @Nullable
    public static Color getColor(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)element);
        CssTerm term = CssPsiColorUtil.getColorTerm(element);
        if (term != null) {
            PsiElement firstChild = term.getFirstChild();
            if (firstChild != null) {
                Color color = CssPsiColorUtil.getColorInClassicCss(firstChild);
                if (color != null) {
                    return color;
                }
                String value = firstChild.getText();
                if (value != null && descriptorProvider != null) {
                    return descriptorProvider.getColorByValue(value);
                }
            }
        } else {
            Color color = CssPsiColorUtil.getColorInClassicCss(element);
            if (color != null) {
                return color;
            }
            String value = element.getText();
            if (value != null && descriptorProvider != null) {
                return descriptorProvider.getColorByValue(value);
            }
        }
        return null;
    }

    @Nullable
    public static CssTerm getColorTerm(@Nullable PsiElement element) {
        CssTerm term = null;
        if (element instanceof CssTermList) {
            PsiElement[] children = element.getChildren();
            if (children.length > 0 && children[0] instanceof CssTerm) {
                term = (CssTerm)children[0];
            }
        } else {
            term = CssUtil.getEnclosingTerm(element);
        }
        if (term == null || !term.isValid()) {
            return null;
        }
        if (CssTermTypes.COLOR == term.getTermType()) {
            return term;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)element);
        if (descriptorProvider != null && descriptorProvider.isColorTerm(term)) {
            return term;
        }
        return null;
    }

    public static Color createColor(int r, int g, int b) {
        return new Color(MathUtil.clamp((int)r, (int)0, (int)255), MathUtil.clamp((int)g, (int)0, (int)255), MathUtil.clamp((int)b, (int)0, (int)255));
    }

    public static Color createColor(int r, int g, int b, int a) {
        return ColorUtil.toAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (int)MathUtil.clamp((int)a, (int)0, (int)255));
    }

    public static Color createColor(double r, double g, double b) {
        return new Color(MathUtil.clamp((float)((float)r), (float)0.0f, (float)1.0f), MathUtil.clamp((float)((float)g), (float)0.0f, (float)1.0f), MathUtil.clamp((float)((float)b), (float)0.0f, (float)1.0f));
    }

    public static Color createColor(double r, double g, double b, int a) {
        return ColorUtil.toAlpha((Color)CssPsiColorUtil.createColor(r, g, b), (int)MathUtil.clamp((int)a, (int)0, (int)255));
    }

    @NotNull
    public static String toRgbColor(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(26);
        }
        String string = color.getAlpha() < 255 ? String.format("rgba(%d,%d,%d,%s)", color.getRed(), color.getGreen(), color.getBlue(), CssPsiColorUtil.getAlphaString(color)) : String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static String getAlphaString(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(28);
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));
        String string = color.getAlpha() == 0 ? "0" : decimalFormat.format((double)color.getAlpha() / 255.0);
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String toHexColor(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(30);
        }
        StringBuilder sb = new StringBuilder("#");
        for (int i = 0; i < 3; ++i) {
            String s = Integer.toHexString(i == 0 ? color.getRed() : (i == 1 ? color.getGreen() : color.getBlue()));
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    public static boolean isColorTerm(@NotNull CssTerm term) {
        if (term == null) {
            CssPsiColorUtil.$$$reportNull$$$0(32);
        }
        if (term.getTermType() == CssTermTypes.COLOR && !CssPsiColorUtil.isInsideColorFunction((PsiElement)term)) {
            return true;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)term);
        return descriptorProvider != null && descriptorProvider.isColorTerm(term);
    }

    @Contract(value="null -> false")
    public static boolean isInsideColorFunction(@Nullable PsiElement element) {
        String functionName;
        CssFunction possibleParentFunction = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
        return possibleParentFunction != null && CssConstants.FUNCTIONS_OVER_COLOR.contains(StringUtil.toLowerCase((String)(functionName = possibleParentFunction.getName())));
    }

    @NotNull
    public static String toHslColor(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(33);
        }
        double[] hsl = CssPsiColorUtil.getHslByRgb(color.getRed(), color.getGreen(), color.getBlue());
        long h = Math.round(360.0 * hsl[0]);
        long s = Math.round(hsl[1] * 100.0);
        long l = Math.round(hsl[2] * 100.0);
        String string = color.getAlpha() < 255 ? String.format("hsla(%d,%d%%,%d%%,%s)", h, s, l, CssPsiColorUtil.getAlphaString(color)) : String.format("hsl(%d,%d%%,%d%%)", h, s, l);
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public static String toLchColor(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(35);
        }
        double[] rgb = new double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0};
        double[] lch = CssLchColorUtils.sRGBtoLCH(CssLchColorUtils.xyzToLab(CssLchColorUtils.d65ToD50(CssLchColorUtils.linSRgbToXyz(CssLchColorUtils.linSRgb(rgb)))));
        double alpha = (double)color.getAlpha() / 255.0;
        String string = CssPsiColorUtil.formatLch(lch, (double)Math.round(alpha * 100.0) / 100.0);
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static String convertFromOklchToLch(double @NotNull [] oklch) {
        if (oklch == null) {
            CssPsiColorUtil.$$$reportNull$$$0(37);
        }
        double[] lch = CssLchColorUtils.sRGBtoLCH(CssLchColorUtils.xyzToLab(CssLchColorUtils.d65ToD50(CssLchColorUtils.oklabToXyz(CssLchColorUtils.oklchToOklab(oklch[0], oklch[1], oklch[2])))));
        String string = CssPsiColorUtil.formatLch(lch, oklch[3]);
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public static String toOklchColor(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(39);
        }
        double[] rgb = new double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0};
        double[] oklch = CssLchColorUtils.oklabToOklch(CssLchColorUtils.xyzToOklab(CssLchColorUtils.linSRgbToXyz(CssLchColorUtils.linSRgb(rgb))));
        double alpha = (double)color.getAlpha() / 255.0;
        String string = CssPsiColorUtil.formatOklch(oklch, (double)Math.round(alpha * 100.0) / 100.0);
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public static String convertFromLchToOklch(double @NotNull [] lch) {
        if (lch == null) {
            CssPsiColorUtil.$$$reportNull$$$0(41);
        }
        double[] oklch = CssLchColorUtils.oklabToOklch(CssLchColorUtils.xyzToOklab(CssLchColorUtils.d50ToD65(CssLchColorUtils.labToXyz(CssLchColorUtils.lchToLab(lch[0], lch[1], lch[2])))));
        String string = CssPsiColorUtil.formatOklch(oklch, lch[3]);
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    public static String formatLch(double @NotNull [] lch, double alpha) {
        if (lch == null) {
            CssPsiColorUtil.$$$reportNull$$$0(43);
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));
        Object[] lchFormatted = Arrays.stream(lch).mapToObj(value -> value == 0.0 ? "0" : decimalFormat.format(value)).toArray();
        if (alpha == 1.0) {
            return String.format("lch(%s%% %s %s)", lchFormatted[0].toString(), lchFormatted[1].toString(), lchFormatted[2].toString());
        }
        return String.format("lch(%s%% %s %s / %s)", lchFormatted[0].toString(), lchFormatted[1].toString(), lchFormatted[2].toString(), alpha);
    }

    public static String formatOklch(double @NotNull [] oklch, double alpha) {
        if (oklch == null) {
            CssPsiColorUtil.$$$reportNull$$$0(44);
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.US));
        Object[] oklchFormatted = Arrays.stream(oklch).mapToObj(value -> value == 0.0 ? "0" : decimalFormat.format(value)).toArray();
        if (alpha == 1.0) {
            return String.format("oklch(%s %s %s)", oklchFormatted[0].toString(), oklchFormatted[1].toString(), oklchFormatted[2].toString());
        }
        return String.format("oklch(%s %s %s / %s)", oklchFormatted[0].toString(), oklchFormatted[1].toString(), oklchFormatted[2].toString(), alpha);
    }

    public static String convertTo(@NotNull ColorDeclarationType declarationType, @NotNull Color color) {
        if (declarationType == null) {
            CssPsiColorUtil.$$$reportNull$$$0(45);
        }
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(46);
        }
        return switch (declarationType) {
            case ColorDeclarationType.RGB, ColorDeclarationType.RGBA -> CssPsiColorUtil.toRgbColor(color);
            case ColorDeclarationType.HSL, ColorDeclarationType.HSLA -> CssPsiColorUtil.toHslColor(color);
            case ColorDeclarationType.LCH -> CssPsiColorUtil.toLchColor(color);
            case ColorDeclarationType.OKLCH -> CssPsiColorUtil.toOklchColor(color);
            default -> color.getAlpha() < 255 ? CssPsiColorUtil.toRgbColor(color) : CssPsiColorUtil.toHexColor(color);
        };
    }

    @NotNull
    public static String toGreyColor(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(47);
        }
        String string = color.getAlpha() < 255 ? String.format("gray(%d,%s)", color.getRed(), CssPsiColorUtil.getAlphaString(color)) : String.format("gray(%d)", color.getRed());
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    public static String toHwbColor(@NotNull Color color) {
        if (color == null) {
            CssPsiColorUtil.$$$reportNull$$$0(49);
        }
        double[] hwb = CssPsiColorUtil.getHwbByRgb(color.getRed(), color.getGreen(), color.getBlue());
        long h = Math.round(360.0 * hwb[0]);
        long w = Math.round(hwb[1] * 100.0);
        long b = Math.round(hwb[2] * 100.0);
        String string = color.getAlpha() < 255 ? String.format("hwb(%d,%d%%,%d%%,%s)", h, w, b, CssPsiColorUtil.getAlphaString(color)) : String.format("hwb(%d,%d%%,%d%%)", h, w, b);
        if (string == null) {
            CssPsiColorUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    public static double @NotNull [] getHwbByRgb(int red, int green, int blue) {
        double[] hsl = CssPsiColorUtil.getHslByRgb(red, green, blue);
        double s = hsl[1];
        double l = hsl[2];
        double saturation = 2.0 * (s *= l < 0.5 ? l : 1.0 - l) / (l + s);
        double value = l + s;
        double[] dArray = new double[]{hsl[0], (1.0 - saturation) * value, 1.0 - value};
        if (dArray == null) {
            CssPsiColorUtil.$$$reportNull$$$0(51);
        }
        return dArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 12, 14, 27, 29, 31, 34, 36, 38, 40, 42, 48, 50, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rgbFunctionArguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hslFunctionArguments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terms";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssPsiColorUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grayFunctionArguments";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hwbFunctionArguments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termList";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lchFunctionArguments";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oklchFunctionArguments";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 39: 
            case 46: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oklch";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lch";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssPsiColorUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRgbByHsl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHslByRgb";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRgbByHwb";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRgbFromLch";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRgbFromOklch";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toRgbColor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlphaString";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexColor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "toHslColor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "toLchColor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromOklchToLch";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "toOklchColor";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromLchToOklch";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "toGreyColor";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "toHwbColor";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getHwbByRgb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getColorFunctionElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColorInClassicCss";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColorInTerm";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getColorInRGBsFunctions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getColorInHSLsFunctions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOpacityFromForthTerm";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 50: 
            case 51: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getColorInGrayFunction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getColorInHwbFunction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColorInColorFunction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getColorInLchFunction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getColorInOklchFunction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOklch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPercentageValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPercentageValueWithSign";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProportionValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLchLightnessValue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLchChromaValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOklchLightnessValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getOklchChromaValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getHueValue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toRgbColor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAlphaString";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toHexColor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isColorTerm";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toHslColor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toLchColor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "convertFromOklchToLch";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "toOklchColor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "convertFromLchToOklch";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "formatLch";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "formatOklch";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "convertTo";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "toGreyColor";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "toHwbColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 12, 14, 27, 29, 31, 34, 36, 38, 40, 42, 48, 50, 51 -> new IllegalStateException(string);
        };
    }
}

