/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.ThrowableInfoUtil;
import com.intellij.database.console.ExecutionConcession;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataRequestUi {
    private final ConsoleDataRequest myConsoleDataRequest;
    private static final Accepter SUPPRESSABLE_WARNING = (request, errorInfo) -> ConsoleDataRequestUi.getWarningSuppressAction(errorInfo) != null;
    private static final Accepter WARNING = (request, errorInfo) -> ConsoleDataRequestUi.isWarning(errorInfo);
    private static final Accepter WARNING_NOT_LAST = (request, errorInfo) -> ConsoleDataRequestUi.isWarning(errorInfo) && !request.isLastInChain();
    private static final Accepter ERROR = (request, errorInfo) -> !ConsoleDataRequestUi.isWarning(errorInfo);
    private static final Accepter ERROR_NOT_LAST = (request, errorInfo) -> !ConsoleDataRequestUi.isWarning(errorInfo) && !request.isLastInChain();
    private static final Accepter NOT_LAST = (request, errorInfo) -> !request.isLastInChain();
    private static final Key<ErrorPanelInfo> ERROR_PANEL_KEY = Key.create((String)"ERROR_PANEL_KEY");

    public ConsoleDataRequestUi(ConsoleDataRequest consoleDataRequest) {
        this.myConsoleDataRequest = consoleDataRequest;
    }

    private static boolean isWarning(ErrorInfo errorInfo) {
        return errorInfo instanceof JdbcEngineUtils.EngineWarningExceptionInfo;
    }

    @Nullable
    private static Runnable getWarningSuppressAction(ErrorInfo errorInfo) {
        return errorInfo instanceof JdbcEngineUtils.EngineWarningExceptionInfo ? ((JdbcEngineUtils.EngineWarningExceptionInfo)errorInfo).getSuppressAction() : null;
    }

    private DataContext newDataContextForErrorFix() {
        return SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)this.myConsoleDataRequest.getConsole().getProject()).add(CommonDataKeys.VIRTUAL_FILE, (Object)this.myConsoleDataRequest.getConsole().getVirtualFile()).add(ConsoleDataRequest.CONSOLE_DATA_REQUEST, (Object)this.myConsoleDataRequest).build();
    }

    @NotNull
    private ErrorNotificationPanel createErrorNotificationPanel(final @Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull Editor sourceEditor, @NotNull ErrorInfo errorInfo, @Nullable Consumer<ConsoleDataRequest.Decision> feedbackListener) {
        if (sourceEditor == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(0);
        }
        if (errorInfo == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(1);
        }
        final Editor editor2 = ConsoleDataRequestUi.getErrorPanelEditor(sourceEditor);
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create((String)errorInfo.getMessage(), (Throwable)errorInfo.getOriginalThrowable());
        ConsoleDataRequestUi.appendFixes(builder, this.newDataContextForErrorFix(), ThrowableInfoUtil.getAllFixes((ErrorInfo)errorInfo));
        Iterable<ErrorPanelConfigurator> configurators = ErrorPanelConfigurator.filterFor(this.myConsoleDataRequest, errorInfo);
        configurators.forEach(c2 -> c2.configure(builder, this.myConsoleDataRequest, feedbackListener, errorInfo));
        ErrorNotificationPanel notificationPanel = builder.build();
        notificationPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (navigator != null && navigator.canNavigate()) {
                    navigator.navigate();
                }
                editor2.getContentComponent().requestFocusInWindow();
                ConsoleDataRequestUi.this.updateHighlighting(this);
            }
        });
        ERROR_PANEL_KEY.set((UserDataHolder)editor2, (Object)new ErrorPanelInfo(notificationPanel, feedbackListener));
        ErrorNotificationPanel errorNotificationPanel = notificationPanel;
        if (errorNotificationPanel == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(2);
        }
        return errorNotificationPanel;
    }

    public static void appendFixes(@NotNull ErrorNotificationPanel.Builder builder, @NotNull DataContext context, @NotNull List<ErrorInfo.Fix> fixes) {
        if (builder == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(4);
        }
        if (fixes == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(5);
        }
        if (fixes.isEmpty()) {
            return;
        }
        for (ErrorInfo.Fix fix : fixes) {
            builder.addLink(fix.getName(), fix.getMnemonic(), () -> DataSourceUiUtil.applyFix(fix, context));
        }
        builder.addSpace();
    }

    @NotNull
    private static Editor getErrorPanelEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(6);
        }
        Editor editor3 = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor2);
        if (editor3 == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(7);
        }
        return editor3;
    }

    public static void hideErrorPanel(@NotNull Editor sourceEditor) {
        if (sourceEditor == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(8);
        }
        Project project = sourceEditor.getProject();
        Editor editor2 = ConsoleDataRequestUi.getErrorPanelEditor(sourceEditor);
        ErrorPanelInfo epInfo = (ErrorPanelInfo)ERROR_PANEL_KEY.get((UserDataHolder)editor2);
        if (epInfo == null || project == null) {
            return;
        }
        Document document = sourceEditor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            editorManager.removeBottomComponent(fileEditor, (JComponent)epInfo.errorPanel);
            ERROR_PANEL_KEY.set((UserDataHolder)editor2, null);
            editor2.getContentComponent().requestFocusInWindow();
        }
    }

    private void handleQueryProblem(@Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull ErrorInfo errorInfo, @Nullable Consumer<ConsoleDataRequest.Decision> feedbackListener) {
        if (errorInfo == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(9);
        }
        if (errorInfo.getOriginalThrowable() instanceof ProcessCanceledException) {
            return;
        }
        if (!this.myConsoleDataRequest.getEditor().getContentComponent().isShowing()) {
            return;
        }
        Project project = this.myConsoleDataRequest.getConsole().getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.myConsoleDataRequest.getEditor().getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            ErrorNotificationPanel errorPanel = this.createErrorNotificationPanel(navigator, this.myConsoleDataRequest.getEditor(), errorInfo, feedbackListener);
            editorManager.addBottomComponent(fileEditor, (JComponent)errorPanel);
            Container parent = errorPanel.getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).setBorder((Border)JBUI.Borders.empty());
            }
            this.myConsoleDataRequest.getEditor().getContentComponent().requestFocusInWindow();
            if (navigator != null && navigator.canNavigate()) {
                navigator.navigate();
            }
        }
    }

    @NotNull
    private DataRequest.CoupledWithEditor.ErrorNavigator createErrorNavigator(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(10);
        }
        final int position = this.myConsoleDataRequest.computeErrorPosition(errorInfo);
        return new DataRequest.CoupledWithEditor.ErrorNavigator(){

            public void navigate() {
                ReadAction.run(() -> {
                    int resultOffset = this.getOffset();
                    if (resultOffset != -1) {
                        ConsoleDataRequestUi.this.scrollToRange(TextRange.create((int)resultOffset, (int)resultOffset), true);
                        return;
                    }
                    TextRange range = ConsoleDataRequestUi.this.myConsoleDataRequest.getRange();
                    if (range != null) {
                        ConsoleDataRequestUi.this.scrollToRange(range, false);
                    }
                });
            }

            public boolean canNavigate() {
                return this.getOffset() != -1 || ConsoleDataRequestUi.this.myConsoleDataRequest.getRange() != null;
            }

            private int getOffset() {
                return ConsoleDataRequestUi.this.myConsoleDataRequest.getErrorOffsetInEditor(position);
            }
        };
    }

    public void updateConsoleUI(boolean scrollToQuery) {
        ReadAction.run(() -> {
            TextRange range;
            this.closeErrorPanel();
            if (scrollToQuery && (range = this.myConsoleDataRequest.getRange()) != null) {
                this.scrollToRange(range, false);
            }
            this.updateHighlighting(this);
        });
    }

    @NotNull
    public DataRequest.CoupledWithEditor.ErrorNavigator reportError(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(11);
        }
        ConsoleDataRequest.ErrorsSolver solver = this.myConsoleDataRequest.getErrorSolver();
        solver.newProblem();
        DataRequest.CoupledWithEditor.ErrorNavigator navigator = this.createErrorNavigator(errorInfo);
        SwingUtilities.invokeLater(() -> {
            this.updateConsoleUI(false);
            if (!solver.isEnabled()) {
                return;
            }
            this.handleQueryProblem(navigator, errorInfo, (Consumer<ConsoleDataRequest.Decision>)((Consumer)feedback -> {
                this.closeErrorPanel();
                solver.solve(feedback, this.myConsoleDataRequest);
            }));
        });
        DataRequest.CoupledWithEditor.ErrorNavigator errorNavigator = navigator;
        if (errorNavigator == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(12);
        }
        return errorNavigator;
    }

    public void reportWarning(@NotNull JdbcEngineUtils.EngineWarningExceptionInfo info2) {
        if (info2 == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(13);
        }
        ConsoleDataRequest.WarningsSolver solver = this.myConsoleDataRequest.getWarningSolver();
        ExecutionConcession concession = info2.getConcession();
        solver.newProblem(concession);
        SwingUtilities.invokeLater(() -> {
            this.updateConsoleUI(false);
            if (!solver.isEnabled()) {
                return;
            }
            this.handleQueryProblem(null, (ErrorInfo)info2, (Consumer<ConsoleDataRequest.Decision>)((Consumer)feedback -> {
                this.closeErrorPanel();
                solver.solve(feedback, this.myConsoleDataRequest, concession);
            }));
        });
    }

    public void closeErrorPanel() {
        ConsoleDataRequestUi.hideErrorPanel(this.myConsoleDataRequest.getEditor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRange(@NotNull TextRange range, boolean strict) {
        Editor editor2;
        if (range == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(14);
        }
        if ((editor2 = this.myConsoleDataRequest.getEditor()).isDisposed() || !editor2.getContentComponent().isShowing()) {
            return;
        }
        CaretModel caretModel = editor2.getCaretModel();
        if (!strict && range.contains(caretModel.getOffset())) {
            return;
        }
        int offset = range.getEndOffset();
        caretModel.moveToOffset(offset);
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        scrollingModel.disableAnimation();
        try {
            scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            scrollingModel.enableAnimation();
        }
        TextRange existing = EditorUtil.getSelectionInAnyMode((Editor)editor2);
        if (!existing.containsOffset(offset)) {
            editor2.getSelectionModel().setSelection(offset, offset);
        }
    }

    private void updateHighlighting(Object reason) {
        Project project = this.myConsoleDataRequest.getConsole().getProject();
        if (!project.isOpen() || this.myConsoleDataRequest.getEditor().isDisposed()) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.myConsoleDataRequest.getEditor().getDocument());
        if (file != null) {
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart(file, reason);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataRequestUi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorNotificationPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorPanelEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "reportError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createErrorNotificationPanel";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendFixes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorPanelEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hideErrorPanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryProblem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createErrorNavigator";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportWarning";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scrollToRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 12 -> new IllegalStateException(string);
        };
    }

    private static enum ErrorPanelConfigurator {
        STOP(NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.STOP, DatabaseBundle.message((String)"action.stop.text", (Object[])new Object[0]), 83)),
        RETRY(ERROR_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.RETRY, DatabaseBundle.message((String)"action.retry.text", (Object[])new Object[0]), 82)),
        IGNORE_ERROR(ERROR_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE, DatabaseBundle.message((String)"action.ignore.text", (Object[])new Object[0]), 73)),
        IGNORE_ALL_ERRORS(ERROR_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE_ALL, DatabaseBundle.message((String)"action.ignore.all.text", (Object[])new Object[0]), 71)),
        SKIP(WARNING_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE, DatabaseBundle.message((String)"action.skip.text", (Object[])new Object[0]), 75)),
        SKIP_ALL(WARNING_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE_ALL, DatabaseBundle.message((String)"action.skip.all.text", (Object[])new Object[0]), 65)),
        FORCE_EXECUTE(WARNING, new LinkConfigurator(ConsoleDataRequest.Decision.FORCE_EXECUTE, DatabaseBundle.message((String)"action.execute.text", (Object[])new Object[0]), 69)),
        FORCE_EXECUTE_AND_SUPPRESS(SUPPRESSABLE_WARNING, new LinkConfigurator(ConsoleDataRequest.Decision.FORCE_EXECUTE, DatabaseBundle.message((String)"action.execute.and.suppress.text", (Object[])new Object[0]), 85, true)),
        FORCE_EXECUTE_ALL(WARNING_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.FORCE_EXECUTE_ALL, DatabaseBundle.message((String)"action.execute.all.text", (Object[])new Object[0]), 76)),
        WARNING_MESSAGE_TYPE(WARNING, (b, r, l, e) -> b.messageType(MessageType.WARNING)),
        ERROR_MESSAGE_TYPE(ERROR, (b, r, l, e) -> b.messageType(MessageType.ERROR)),
        FULL_ERROR_MESSAGE((b, r) -> true, (b, r, l, e) -> b.addFullMessageButtonIfNeeded()),
        CLOSE((r, e) -> true, (b, r, l, e) -> b.addCloseButton(() -> ConsoleDataRequestUi.hideErrorPanel(r.getEditor())));

        private final Accepter myAccepter;
        private final Configurator myConfigurator;

        private ErrorPanelConfigurator(Accepter accepter, Configurator configurator) {
            if (accepter == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(0);
            }
            if (configurator == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(1);
            }
            this.myAccepter = accepter;
            this.myConfigurator = configurator;
        }

        boolean isAcceptable(@NotNull ConsoleDataRequest request, @NotNull ErrorInfo errorInfo) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(2);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(3);
            }
            return this.myAccepter.accept(request, errorInfo);
        }

        void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<ConsoleDataRequest.Decision> listener2, @NotNull ErrorInfo errorInfo) {
            if (builder == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(4);
            }
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(5);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(6);
            }
            this.myConfigurator.configure(builder, request, listener2, errorInfo);
        }

        @NotNull
        static Iterable<ErrorPanelConfigurator> filterFor(@NotNull ConsoleDataRequest request, @NotNull ErrorInfo errorInfo) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(7);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(8);
            }
            JBIterable jBIterable = JBIterable.of((Object[])ErrorPanelConfigurator.values()).filter(v -> v.isAcceptable(request, errorInfo));
            if (jBIterable == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accepter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurator";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequestUi$ErrorPanelConfigurator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi$ErrorPanelConfigurator";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "configure";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFor";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9 -> new IllegalStateException(string);
            };
        }
    }

    public static class ErrorPanelInfo {
        public final ErrorNotificationPanel errorPanel;
        public final Consumer<ConsoleDataRequest.Decision> decisionConsumer;

        ErrorPanelInfo(@NotNull ErrorNotificationPanel errorPanel, @Nullable Consumer<ConsoleDataRequest.Decision> decisionConsumer) {
            if (errorPanel == null) {
                ErrorPanelInfo.$$$reportNull$$$0(0);
            }
            this.errorPanel = errorPanel;
            this.decisionConsumer = decisionConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/database/run/ConsoleDataRequestUi$ErrorPanelInfo", "<init>"));
        }
    }

    public static interface Accepter {
        public boolean accept(@NotNull ConsoleDataRequest var1, @NotNull ErrorInfo var2);
    }

    public static final class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public EscapeHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                EscapeHandler.$$$reportNull$$$0(0);
            }
            if (this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor2, caret, dataContext)) {
                this.myOriginalHandler.execute(editor2, caret, dataContext);
            }
            ConsoleDataRequestUi.hideErrorPanel(editor2);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                EscapeHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                EscapeHandler.$$$reportNull$$$0(2);
            }
            return ERROR_PANEL_KEY.get((UserDataHolder)ConsoleDataRequestUi.getErrorPanelEditor(editor2)) != null || this.myOriginalHandler.isEnabled(editor2, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi$EscapeHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LinkConfigurator
    implements Configurator {
        private final ConsoleDataRequest.Decision myDecision;
        private final Integer myMnemonic;
        private final @NlsActions.ActionText String myLinkHtml;
        private final boolean mySuppress;

        LinkConfigurator(@NotNull ConsoleDataRequest.Decision decision, @NlsActions.ActionText @NotNull String link, @Nullable Integer mnemonic) {
            if (decision == null) {
                LinkConfigurator.$$$reportNull$$$0(0);
            }
            if (link == null) {
                LinkConfigurator.$$$reportNull$$$0(1);
            }
            this(decision, link, mnemonic, false);
        }

        LinkConfigurator(@NotNull ConsoleDataRequest.Decision decision, @NlsActions.ActionText @NotNull String link, @Nullable Integer mnemonic, boolean suppress) {
            if (decision == null) {
                LinkConfigurator.$$$reportNull$$$0(2);
            }
            if (link == null) {
                LinkConfigurator.$$$reportNull$$$0(3);
            }
            this.myDecision = decision;
            this.myMnemonic = mnemonic;
            this.myLinkHtml = link;
            this.mySuppress = suppress;
        }

        @Override
        public void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<ConsoleDataRequest.Decision> listener2, @NotNull ErrorInfo errorInfo) {
            if (builder == null) {
                LinkConfigurator.$$$reportNull$$$0(4);
            }
            if (request == null) {
                LinkConfigurator.$$$reportNull$$$0(5);
            }
            if (errorInfo == null) {
                LinkConfigurator.$$$reportNull$$$0(6);
            }
            if (listener2 != null) {
                builder.addLink(this.myLinkHtml, this.myMnemonic, () -> {
                    listener2.consume((Object)this.myDecision);
                    if (this.mySuppress) {
                        Runnable suppressAction = ConsoleDataRequestUi.getWarningSuppressAction(errorInfo);
                        assert (suppressAction != null);
                        suppressAction.run();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decision";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "link";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi$LinkConfigurator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Configurator {
        public void configure(@NotNull ErrorNotificationPanel.Builder var1, @NotNull ConsoleDataRequest var2, @Nullable Consumer<ConsoleDataRequest.Decision> var3, @NotNull ErrorInfo var4);
    }
}

