/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.console.ConsolesMigrationManagerKt;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.QueryFilesOpener;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbVFSUtilsImpl
extends DbVFSUtils {
    @Deprecated
    @Nullable
    public VirtualFile getConsoleVirtualFile(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DbVFSUtilsImpl.$$$reportNull$$$0(0);
        }
        return DatabaseEditorHelper.getConsoleVirtualFile(dataSource);
    }

    @Nullable
    public VirtualFile getQueryVirtualFile(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            DbVFSUtilsImpl.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            DbVFSUtilsImpl.$$$reportNull$$$0(2);
        }
        if (ConsolesMigrationManagerKt.isConsoleMigrationFlagEnabled()) {
            return DatabaseEditorHelper.getQueryFile(project, dataSource);
        }
        return DatabaseEditorHelper.getConsoleVirtualFile((DasDataSource)dataSource);
    }

    public boolean isJSAttachedToMongo(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DbVFSUtilsImpl.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DbVFSUtilsImpl.$$$reportNull$$$0(4);
        }
        if (!ConsolesMigrationManagerKt.isConsoleMigrationFlagEnabled()) {
            DbDataSource dataSource = DbVFSUtilsImpl.getDataSource((Project)project, (VirtualFile)file);
            return dataSource != null && dataSource.getDbms().isMongo();
        }
        String fileExtension = file.getExtension();
        if (fileExtension == null || !fileExtension.equals("js")) {
            return false;
        }
        JdbcConsole console = JdbcConsoleProvider.getConsole(project, file);
        if (console != null) {
            return console.getDataSource().getDbms().isMongo();
        }
        LocalDataSource dataSource = (LocalDataSource)ReadAction.compute(() -> DataSourcePerFileMappingsImpl.getDataSourcePerFileMapping(project, file));
        return dataSource != null && dataSource.getDbms().isMongo();
    }

    public boolean isStoredInQueryFolder(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            DbVFSUtilsImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            DbVFSUtilsImpl.$$$reportNull$$$0(6);
        }
        if (PlatformUtils.isDataGrip()) {
            return true;
        }
        Path rootPath = QueryFilesOpener.getRootPath(project);
        try {
            Path filePath = file.toNioPath();
            return rootPath != null && filePath.startsWith(rootPath);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vfs/DbVFSUtilsImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConsoleVirtualFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getQueryVirtualFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isJSAttachedToMongo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isStoredInQueryFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

