/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.chainedMethods;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.formatter.CompositeBlock;
import com.intellij.lang.javascript.formatter.SpacingStrategy;
import com.intellij.lang.javascript.formatter.chainedMethods.CallChainBlock;
import com.intellij.lang.javascript.formatter.chainedMethods.CompositeParamListBlock;
import com.intellij.lang.javascript.formatter.chainedMethods.ParameterBlock;
import com.intellij.lang.javascript.formatter.chainedMethods.ParameterListBlock;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallChainBlockBuilder {
    @NotNull
    private final ASTNode myRootNode;
    private final SpacingStrategy mySpacingStrategy;
    private final Indent.Type myCallChainIndentType;
    private final int myCallChainWrapType;
    private final int myParameterWrapType;
    private final boolean myPreferParameterWrap;
    private final boolean myAlignParameters;
    private final boolean myChainedCallDotOnNewLine;
    private final boolean myUseGroupIndents;
    private final Alignment myChainedCallsAlignment;
    private Wrap mySharedCallChainWrap;
    private boolean myIsFirsBlockInChain;
    private boolean myIsFirstBlockToWrap;

    public CallChainBlockBuilder(@NotNull ASTNode rootNode, @NotNull SpacingStrategy spacingStrategy, Indent.Type callChainIndentType, int callChainWrapType, int parameterWrapType, boolean preferParameterWrap, boolean alignChainedCalls, boolean alignParameters, boolean chainedCallDotOnNewLine, boolean useGroupIndents) {
        if (rootNode == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(0);
        }
        if (spacingStrategy == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(1);
        }
        this.myIsFirsBlockInChain = true;
        this.myIsFirstBlockToWrap = false;
        this.myRootNode = rootNode;
        this.mySpacingStrategy = spacingStrategy;
        this.myCallChainIndentType = callChainIndentType;
        this.myCallChainWrapType = callChainWrapType;
        this.myParameterWrapType = parameterWrapType;
        this.myPreferParameterWrap = preferParameterWrap;
        this.myAlignParameters = alignParameters;
        this.myChainedCallDotOnNewLine = chainedCallDotOnNewLine;
        this.myUseGroupIndents = useGroupIndents;
        this.myChainedCallsAlignment = alignChainedCalls ? Alignment.createAlignment() : null;
    }

    private void flatten(@NotNull ASTNode rootNode, List<ASTNode> result) {
        if (rootNode == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(2);
        }
        for (ASTNode child = rootNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.shouldFlatten(child.getElementType())) {
                this.flatten(child, result);
                continue;
            }
            result.add(child);
        }
    }

    public List<Block> buildBlocks() {
        this.myIsFirsBlockInChain = true;
        ArrayList<ASTNode> flattenedList = new ArrayList<ASTNode>();
        this.flatten(this.myRootNode, flattenedList);
        ArrayList<Block> result = new ArrayList<Block>();
        ArrayList<Object> currChainBlocks = new ArrayList<Block>();
        ListIterator<ASTNode> listIterator = flattenedList.listIterator();
        Wrap currCallChainWrap = this.getCallChainWrap();
        Wrap currSharedParameterWrap = this.createSharedParameterWrap(currCallChainWrap);
        while (listIterator.hasNext()) {
            Block subBlock;
            ASTNode node = (ASTNode)listIterator.next();
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)node)) continue;
            IElementType nodeElementType = node.getElementType();
            if (this.isDot(nodeElementType) || this.isComment(nodeElementType)) {
                if (!(this.myChainedCallDotOnNewLine || this.isPrecededByLineComment(node) || this.isComment(nodeElementType))) {
                    currChainBlocks.add(this.createSubBlock(node, Indent.getNoneIndent()));
                }
                if (!currChainBlocks.isEmpty()) {
                    result.add(this.createCallChainBlock(currChainBlocks, currCallChainWrap));
                }
                currSharedParameterWrap = this.createSharedParameterWrap(currCallChainWrap);
                currCallChainWrap = this.getCallChainWrap();
                currChainBlocks = new ArrayList();
                if (this.isDot(nodeElementType)) {
                    ContainerUtil.addIfNotNull(currChainBlocks, (Object)this.buildReferenceBlock(node, listIterator, currCallChainWrap));
                    continue;
                }
                result.add(this.createSubBlock(node, this.getCallChainIndent()));
                continue;
            }
            if (this.isLeftParen(nodeElementType)) {
                listIterator.previous();
                subBlock = this.buildParamListBlock(listIterator);
                currChainBlocks.add(subBlock);
            } else {
                subBlock = this.createSubBlock(node, Indent.getNoneIndent());
            }
            if (subBlock instanceof ParameterListBlock) {
                Alignment parameterAlignment = this.myAlignParameters ? Alignment.createAlignment() : null;
                for (ParameterBlock parameterBlock : ((ParameterListBlock)subBlock).getParameterBlocks()) {
                    parameterBlock.setParameterWrap(currSharedParameterWrap);
                    parameterBlock.setAlignment(parameterAlignment);
                }
            }
            currChainBlocks.add(subBlock);
        }
        if (!currChainBlocks.isEmpty()) {
            result.add(this.createCallChainBlock(currChainBlocks, currCallChainWrap));
        }
        return result;
    }

    private boolean isPrecededByLineComment(@NotNull ASTNode node) {
        ASTNode prevNode;
        if (node == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(3);
        }
        if ((prevNode = node.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode != null && this.isEndOfLineComment(prevNode.getElementType());
    }

    @Nullable
    private Wrap createSharedParameterWrap(@Nullable Wrap parentWrap) {
        if (this.myParameterWrapType == 0) {
            return null;
        }
        return this.myPreferParameterWrap || parentWrap == null ? Wrap.createWrap((WrapType)WrapType.byLegacyRepresentation((int)this.myParameterWrapType), (boolean)false) : Wrap.createChildWrap((Wrap)parentWrap, (WrapType)WrapType.byLegacyRepresentation((int)this.myParameterWrapType), (boolean)false);
    }

    @Nullable
    private Wrap getCallChainWrap() {
        if (this.myIsFirstBlockToWrap) {
            return switch (this.myCallChainWrapType) {
                case 1 -> Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                case 2 -> Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
                case 5 -> {
                    if (this.mySharedCallChainWrap == null) {
                        this.mySharedCallChainWrap = Wrap.createWrap((WrapType)WrapType.CHOP_DOWN_IF_LONG, (boolean)true);
                    }
                    yield this.mySharedCallChainWrap;
                }
                default -> null;
            };
        }
        return null;
    }

    private CallChainBlock createCallChainBlock(@NotNull List<Block> childBlocks, @Nullable Wrap callChainWrap) {
        if (childBlocks == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(4);
        }
        CallChainBlock block = new CallChainBlock(childBlocks, this.mySpacingStrategy, this.getCallChainIndent(), this.myPreferParameterWrap ? null : callChainWrap, this.myIsFirsBlockInChain ? null : this.myChainedCallsAlignment);
        this.myIsFirsBlockInChain = false;
        if (CallChainBlockBuilder.containsParamList(childBlocks)) {
            this.myIsFirstBlockToWrap = true;
        }
        return block;
    }

    private Indent getCallChainIndent() {
        if (this.myIsFirsBlockInChain) {
            return Indent.getNoneIndent();
        }
        return this.myUseGroupIndents ? Indent.getSmartIndent((Indent.Type)this.myCallChainIndentType) : Indent.getIndent((Indent.Type)this.myCallChainIndentType, (boolean)false, (boolean)false);
    }

    private static boolean containsParamList(@NotNull List<Block> childBlocks) {
        if (childBlocks == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(5);
        }
        for (Block block : childBlocks) {
            if (!(block instanceof ParameterListBlock)) continue;
            return true;
        }
        return false;
    }

    private CompositeParamListBlock buildParamListBlock(@NotNull ListIterator<ASTNode> listIterator) {
        if (listIterator == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(6);
        }
        ArrayList<Block> childBlocks = new ArrayList<Block>();
        while (listIterator.hasNext()) {
            ASTNode node = listIterator.next();
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)node)) continue;
            childBlocks.add(this.createSubBlock(node, Indent.getContinuationIndent()));
            if (!this.isRightParen(node.getElementType())) continue;
            break;
        }
        return new CompositeParamListBlock(childBlocks, this.mySpacingStrategy);
    }

    protected abstract boolean shouldFlatten(@NotNull IElementType var1);

    protected abstract boolean isLeftParen(@NotNull IElementType var1);

    protected abstract boolean isRightParen(@NotNull IElementType var1);

    protected abstract boolean isDot(@NotNull IElementType var1);

    protected abstract boolean isIdentifier(@NotNull IElementType var1);

    protected abstract boolean isEndOfLineComment(@NotNull IElementType var1);

    protected abstract boolean isComment(@NotNull IElementType var1);

    protected abstract Block createSubBlock(@NotNull ASTNode var1, @NotNull Indent var2);

    @Nullable
    private ReferenceBlock buildReferenceBlock(@NotNull ASTNode dotNode, @NotNull ListIterator<ASTNode> listIterator, @Nullable Wrap callChainWrap) {
        if (dotNode == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(7);
        }
        if (listIterator == null) {
            CallChainBlockBuilder.$$$reportNull$$$0(8);
        }
        ArrayList<Block> childBlocks = new ArrayList<Block>(2);
        if (this.myChainedCallDotOnNewLine || this.isPrecededByLineComment(dotNode)) {
            childBlocks.add(this.createSubBlock(dotNode, Indent.getNoneIndent()));
        }
        if (listIterator.hasNext()) {
            ASTNode next = listIterator.next();
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)next) && listIterator.hasNext()) {
                next = listIterator.next();
            }
            if (this.isIdentifier(next.getElementType())) {
                childBlocks.add(this.createSubBlock(next, Indent.getNoneIndent()));
            } else {
                listIterator.previous();
            }
        }
        return !childBlocks.isEmpty() ? new ReferenceBlock(childBlocks, this.mySpacingStrategy, Indent.getNoneIndent(), (Wrap)(this.myPreferParameterWrap ? callChainWrap : null)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spacingStrategy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBlocks";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listIterator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/chainedMethods/CallChainBlockBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "flatten";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrecededByLineComment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createCallChainBlock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "containsParamList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "buildParamListBlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "buildReferenceBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReferenceBlock
    extends CompositeBlock {
        @Nullable
        private final Wrap myWrap;

        ReferenceBlock(@NotNull List<Block> childBlocks, @NotNull SpacingStrategy spacingStrategy, @Nullable Indent indent, @Nullable Wrap wrap) {
            if (childBlocks == null) {
                ReferenceBlock.$$$reportNull$$$0(0);
            }
            if (spacingStrategy == null) {
                ReferenceBlock.$$$reportNull$$$0(1);
            }
            super(childBlocks, spacingStrategy, indent);
            this.myWrap = wrap;
        }

        @Override
        @Nullable
        public Wrap getWrap() {
            return this.myWrap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "childBlocks";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "spacingStrategy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/formatter/chainedMethods/CallChainBlockBuilder$ReferenceBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

