/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleMapping;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPathMappingsUtil {
    public static JSModuleMapping replaceStarForMapping(@NotNull JSModuleMapping mapping, @Nullable JSModuleMapping matchedStar) {
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(0);
        }
        return matchedStar != null ? mapping.copyWithNewValue(mapping.getMapping().replace("*", matchedStar.getMapping())) : mapping;
    }

    @NotNull
    public static Collection<JSModuleMapping> substituteMappings(@NotNull String path, @NotNull JSModulePathMappings<? extends JSModulePathSubstitution> substitutions) {
        Pair<? extends JSModulePathSubstitution, JSModuleMapping> max;
        if (path == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(1);
        }
        if (substitutions == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(2);
        }
        if ((max = substitutions.findMaxElementByPaths(path)) == null) {
            List<JSModuleMapping> list = Collections.emptyList();
            if (list == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)max.first;
        JSModuleMapping matchedStar = (JSModuleMapping)max.second;
        ArrayList<JSModuleMapping> result = new ArrayList<JSModuleMapping>();
        if (matchedStar == null) {
            Collection<JSModuleMapping> collection = matchedPattern.getMappings();
            if (collection == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(4);
            }
            return collection;
        }
        for (JSModuleMapping mapping : JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false)) {
            result.add(JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar));
        }
        for (JSModuleMapping mapping : JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true)) {
            if (matchedPattern.canStartWith()) {
                result.add(mapping.copyWithNewValue(mapping.getMapping() + matchedStar.getMapping()));
                continue;
            }
            result.add(JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar));
        }
        ArrayList<JSModuleMapping> arrayList = result;
        if (arrayList == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static JSModuleMapping substituteStarForMapping(@NotNull JSModuleMapping path, @NotNull JSModulePathMappings<? extends JSModulePathSubstitution> substitutions) {
        Pair<? extends JSModulePathSubstitution, JSModuleMapping> max;
        if (path == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(6);
        }
        if (substitutions == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(7);
        }
        if ((max = substitutions.findMaxElementByPaths(path.getMapping())) == null) {
            JSModuleMapping jSModuleMapping = path;
            if (jSModuleMapping == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(8);
            }
            return jSModuleMapping;
        }
        JSModulePathSubstitution substitution = (JSModulePathSubstitution)max.first;
        JSModuleMapping matchedStar = (JSModuleMapping)max.second;
        Iterator<JSModuleMapping> iterator2 = substitution.getMappings().iterator();
        if (iterator2.hasNext()) {
            JSModuleMapping mapping = iterator2.next();
            JSModuleMapping jSModuleMapping = JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar);
            if (jSModuleMapping == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(9);
            }
            return jSModuleMapping;
        }
        JSModuleMapping jSModuleMapping = path;
        if (jSModuleMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(10);
        }
        return jSModuleMapping;
    }

    @NotNull
    public static List<String> getPathForExactReferences(@NotNull VirtualFile url, @Nullable JSModuleMapping matchedStar, @NotNull Collection<JSModuleMapping> forExactReference) {
        if (url == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(11);
        }
        if (forExactReference == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(12);
        }
        List<String> list = forExactReference.stream().map(mapping -> JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar)).map(el -> JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(url, el.getMapping())).collect(Collectors.toList());
        if (list == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public static <T extends JSModulePattern> @Nullable Pair<T, @Nullable String> findMaxElementByPaths(@NotNull String textToMatch, @NotNull Collection<? extends T> paths) {
        if (textToMatch == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(14);
        }
        if (paths == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(15);
        }
        Pair matchedElement = null;
        int longestMatchPrefixLength = -1;
        for (JSModulePattern path : paths) {
            String suffix;
            String pattern = path.getPattern();
            int prefixMatchIndex = pattern.indexOf("*");
            int suffixMatchIndex = prefixMatchIndex + 1;
            if (path.canStartWith()) {
                suffixMatchIndex = prefixMatchIndex = pattern.length();
            }
            if (prefixMatchIndex == -1) {
                if (!pattern.equals(textToMatch)) continue;
                return Pair.create((Object)path, null);
            }
            String prefix = pattern.substring(0, prefixMatchIndex);
            if (!JSPathMappingsUtil.checkPrefix(textToMatch, prefix, suffix = pattern.substring(suffixMatchIndex)) || prefix.length() <= longestMatchPrefixLength) continue;
            longestMatchPrefixLength = prefix.length();
            if (textToMatch.endsWith(suffix)) {
                matchedElement = Pair.create((Object)path, (Object)textToMatch.substring(prefix.length(), textToMatch.length() - suffix.length()));
                continue;
            }
            matchedElement = Pair.create((Object)path, (Object)textToMatch.substring(prefix.length(), textToMatch.indexOf(suffix)));
        }
        return matchedElement;
    }

    private static boolean checkPrefix(@NotNull String unquotedRefText, @NotNull String prefix, @NotNull String suffix) {
        if (unquotedRefText == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(16);
        }
        if (prefix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(18);
        }
        return unquotedRefText.length() >= prefix.length() + suffix.length() && unquotedRefText.startsWith(prefix) && unquotedRefText.contains(suffix);
    }

    public static boolean isPatternOrMappingEndsWithStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(19);
        }
        return patternOrMapping.endsWith("/*") || patternOrMapping.endsWith("\\*");
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(20);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(21);
        }
        if (JSPathMappingsUtil.isAbsolutePath(mapping)) {
            return baseUrl.getFileSystem().findFileByPath(mapping);
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
    }

    public static boolean isAbsolutePath(@NotNull String mapping) {
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && mapping.startsWith("/")) {
            return true;
        }
        return FileUtil.isAbsolute((String)mapping);
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrl(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(23);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(24);
        }
        String path = FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)mapping), (char)'/');
        return baseUrl.isValid() ? baseUrl.findFileByRelativePath(path) : null;
    }

    public static String getPatternOrMappingWithoutStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(25);
        }
        int length = patternOrMapping.length();
        return patternOrMapping.endsWith("*") ? patternOrMapping.substring(0, patternOrMapping.length() > 2 ? length - 2 : 1) : patternOrMapping;
    }

    @NotNull
    public static Collection<JSModuleMapping> getMappings(@NotNull JSModulePathSubstitution matchedPattern, @Nullable JSModuleMapping matchedStar, boolean endsWithStar) {
        if (matchedPattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(26);
        }
        return JSPathMappingsUtil.getMappings(matchedPattern, matchedPattern.getMappings(), matchedStar, endsWithStar);
    }

    @NotNull
    public static Collection<JSModuleMapping> getMappings(@NotNull JSModulePathSubstitution matchedPattern, @NotNull Collection<JSModuleMapping> mappings, @Nullable JSModuleMapping matchedStar, boolean endsWithStar) {
        if (matchedPattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(27);
        }
        if (mappings == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(28);
        }
        String pattern = matchedPattern.getPattern();
        boolean patternEndsWithStart = matchedStar != null && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || matchedPattern.canStartWith());
        ArrayList<JSModuleMapping> result = new ArrayList<JSModuleMapping>();
        for (JSModuleMapping mapping : mappings) {
            boolean mappingEndsWithStar = patternEndsWithStart && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(mapping.getMapping()) || matchedPattern.canStartWith());
            if (mappingEndsWithStar != endsWithStar) continue;
            result.add(mapping);
        }
        ArrayList<JSModuleMapping> arrayList = result;
        if (arrayList == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    public static String getStringPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(30);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(31);
        }
        return JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl.getPath(), mapping);
    }

    @NotNull
    public static String getStringPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull String canonicalUrl, @NotNull String mapping) {
        if (canonicalUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(32);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(33);
        }
        if (JSPathMappingsUtil.isAbsolutePath(mapping) || JSUrlImportsUtil.isSupportedRemoteModuleUrl(mapping)) {
            String string = mapping;
            if (string == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        String canonicalMapping = FileUtil.toSystemIndependentName((String)mapping);
        if (!((String)canonicalUrl).isEmpty()) {
            canonicalUrl = (String)canonicalUrl + "/";
        }
        String string = FileUtil.toCanonicalPath((String)((String)canonicalUrl + (canonicalMapping.startsWith("/") ? canonicalMapping.substring(1) : canonicalMapping)), (char)'/');
        if (string == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getRelativeOrAbsoluteFilePath(@NotNull String path, VirtualFile baseDir) {
        if (path == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(36);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return baseDir;
        }
        String normalizedPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path));
        if (StringUtil.isEmpty((String)normalizedPath)) {
            return baseDir;
        }
        if (!JSPathMappingsUtil.isAbsolutePath(path)) {
            return baseDir.findFileByRelativePath(normalizedPath);
        }
        return LocalFileSystem.getInstance().findFileByPath(normalizedPath);
    }

    @NotNull
    public static JSModulePattern createPatternForString(final @NotNull String partOfString, final boolean canStartWith) {
        if (partOfString == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(37);
        }
        return new JSModulePattern(){

            @Override
            @NotNull
            public String getPattern() {
                String string = partOfString;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean canStartWith() {
                return canStartWith;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil$1", "getPattern"));
            }
        };
    }

    public static AsteriskCount hasZeroOrOneAsteriskCharacter(String str) {
        boolean seenAsterisk = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '*') continue;
            if (!seenAsterisk) {
                seenAsterisk = true;
                continue;
            }
            return AsteriskCount.MORE;
        }
        return seenAsterisk ? AsteriskCount.ONE : AsteriskCount.ZERO;
    }

    public static Pair<List<JSModuleMapping>, List<JSModuleMapping>> splitMappings(JSModulePathSubstitution substitution) {
        SmartList relativeMappings = new SmartList();
        SmartList externalPackageMappings = new SmartList();
        for (JSModuleMapping mapping : substitution.getMappings()) {
            if (mapping.getMapping().startsWith("./")) {
                relativeMappings.add((Object)mapping);
                continue;
            }
            externalPackageMappings.add((Object)mapping);
        }
        return Pair.create((Object)relativeMappings, (Object)externalPackageMappings);
    }

    public static Map<String, List<JSModuleMapping>> mapWithExtensions(Collection<JSModuleMapping> mappings) {
        TreeMap<String, List<JSModuleMapping>> result = new TreeMap<String, List<JSModuleMapping>>(Comparator.comparingInt(ext -> {
            int index = ArrayUtil.indexOf((Object[])TypeScriptUtil.TYPESCRIPT_AND_JS_EXTENSIONS, (Object)ext);
            return index >= 0 ? index : Integer.MAX_VALUE;
        }));
        for (JSModuleMapping mapping : mappings) {
            String fileName = mapping.getMapping();
            String extension = JSFileReferencesUtil.findImplicitExtension(fileName);
            if (extension == null) {
                extension = "";
            }
            JSModuleMapping newMapping = mapping;
            if (!extension.isEmpty()) {
                newMapping = mapping.copyWithNewValue(JSFileReferencesUtil.trimExistingExtension(fileName, extension));
            }
            List list = result.computeIfAbsent(extension, e -> new ArrayList());
            list.add(newMapping);
        }
        return result;
    }

    @Nullable
    public static JSModuleMapping findMappingByConditionsAndModuleAndTypes(@NotNull Collection<JSModuleMapping> mappings, @Nullable JSModuleStatusOwner.ModuleStatus moduleStatus, @NotNull Collection<String> customConditions) {
        List conditionsMatches;
        if (mappings == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(38);
        }
        if (customConditions == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(39);
        }
        if (!(conditionsMatches = ContainerUtil.filter(mappings, mapping -> mapping.hasCustomConditions(customConditions))).isEmpty()) {
            List conditionAndModuleMatches = ContainerUtil.filter((Collection)conditionsMatches, mapping -> mapping.suitableFor(moduleStatus));
            if (!conditionAndModuleMatches.isEmpty()) {
                return (JSModuleMapping)conditionAndModuleMatches.getFirst();
            }
            return (JSModuleMapping)conditionsMatches.getFirst();
        }
        List moduleMatches = ContainerUtil.filter(mappings, mapping -> mapping.suitableFor(moduleStatus));
        JSModuleMapping typesInModuleMatches = JSPathMappingsUtil.firstWithTypes(moduleMatches);
        if (typesInModuleMatches != null) {
            return typesInModuleMatches;
        }
        JSModuleMapping typesAnywhere = JSPathMappingsUtil.firstWithTypes(mappings);
        if (typesAnywhere != null) {
            return typesAnywhere;
        }
        return (JSModuleMapping)ContainerUtil.getFirstItem((List)moduleMatches);
    }

    @Nullable
    private static JSModuleMapping firstWithTypes(@NotNull Collection<JSModuleMapping> mappings) {
        if (mappings == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(40);
        }
        return (JSModuleMapping)ContainerUtil.find(mappings, JSModuleMapping::hasTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8, 9, 10, 13, 29, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: 
            case 6: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 29: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forExactReference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToMatch";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternOrMapping";
                break;
            }
            case 20: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedPattern";
                break;
            }
            case 28: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalUrl";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partOfString";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customConditions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteMappings";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteStarForMapping";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForExactReferences";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceStarForMapping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteMappings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 29: 
            case 34: 
            case 35: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteStarForMapping";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPathForExactReferences";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMaxElementByPaths";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPatternOrMappingEndsWithStar";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrMappingWithoutStar";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeOrAbsoluteFilePath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createPatternForString";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findMappingByConditionsAndModuleAndTypes";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "firstWithTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8, 9, 10, 13, 29, 34, 35 -> new IllegalStateException(string);
        };
    }

    public static enum AsteriskCount {
        ZERO,
        ONE,
        MORE;

    }
}

