/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescriptionProcessor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagReferencesHolderImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocDescriptionImpl
extends JSDocTagReferencesHolderImpl
implements JSDocDescription {
    private static final TokenSet INLINE_TYPE_BOUNDS = TokenSet.create((IElementType[])new IElementType[]{JSDocTokenTypes.DOC_LBRACE, JSDocTokenTypes.DOC_RBRACE, JSDocTokenTypes.DOC_COMMENT_DATA, JSDocTokenTypes.DOC_GT, JSDocTokenTypes.DOC_RBRACKET, JSDocTokenTypes.DOC_LPAR, JSDocTokenTypes.DOC_RPAR});

    public JSDocDescriptionImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    @NotNull
    public String getDescriptionText() {
        String string = this.getDescriptionText(JSDocumentationUtils.DEFAULT_DESCRIPTION_PROCESSOR);
        if (string == null) {
            JSDocDescriptionImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescriptionText(@NotNull JSDocDescriptionProcessor descriptionProcessor) {
        String optionalDescription;
        if (descriptionProcessor == null) {
            JSDocDescriptionImpl.$$$reportNull$$$0(1);
        }
        Object description = JSDocumentationUtils.buildDescription((PsiElement)this, descriptionProcessor);
        JSDocTag nextTag = JSDocumentationUtils.getNextJSDocTag((PsiElement)this);
        if (nextTag != null && nextTag.is(JSDocBlockTags.OPTIONAL) && (optionalDescription = nextTag.getDescriptionText(descriptionProcessor)) != null) {
            description = (String)description + "\n" + optionalDescription.trim();
        }
        String string = description;
        if (string == null) {
            JSDocDescriptionImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getLeadingWhitespace() {
        ASTNode treePrev = this.getNode().getTreePrev();
        if (treePrev == null) {
            return "";
        }
        String text = treePrev.getText();
        int lastNewLine = text.lastIndexOf(10);
        if (treePrev.getElementType() == JSDocTokenTypes.DOC_WHITESPACE && lastNewLine >= 0) {
            return text.substring(0, lastNewLine + 1);
        }
        ASTNode prevNonWS = TreeUtil.skipWhitespaceCommentsAndTokens((ASTNode)this.getNode().getTreePrev(), (TokenSet)TokenSet.EMPTY, (boolean)false);
        if (prevNonWS != null && prevNonWS.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
            return "\n";
        }
        return "";
    }

    @Override
    protected PsiReference @NotNull [] createRefs() {
        return this.createInlineTypeRefs();
    }

    private PsiReference @NotNull [] createInlineTypeRefs() {
        String text;
        ASTNode dataEndNode;
        final ArrayList result = new ArrayList();
        JSDocComment comment = (JSDocComment)ObjectUtils.tryCast((Object)this.getParent(), JSDocComment.class);
        if (comment == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JSDocDescriptionImpl.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement dataStart = (PsiElement)ObjectUtils.doIfNotNull((Object)this.findChildByType(INLINE_TYPE_BOUNDS), ASTNode::getPsi);
        PsiElement dataEnd = null;
        ASTNode lastChildNode = this.getNode().getLastChildNode();
        if (lastChildNode != null && (dataEndNode = TreeUtil.findSiblingBackward((ASTNode)lastChildNode, (TokenSet)INLINE_TYPE_BOUNDS)) != null) {
            dataEnd = dataEndNode.getPsi();
        }
        PsiElement parent = comment.getParent();
        if (dataStart != null && dataEnd != null && (parent instanceof JSFunction && PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)comment) instanceof JSParameterList || JSDocDescriptionImpl.mayRelateToArrowFunctionParam(comment) || parent instanceof JSParameterList || parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement || parent instanceof JSDestructuringProperty) && (text = this.getText().substring(dataStart.getStartOffsetInParent(), dataEnd.getStartOffsetInParent() + dataEnd.getTextLength())).indexOf(10) == -1) {
            JSParameterTypeDecorator type;
            final int dataOffsetInParent = dataStart.getStartOffsetInParent();
            int intellijIdeaRulezzz = text.indexOf("IntellijIdeaRulezzz ");
            if (intellijIdeaRulezzz > 0) {
                text = text.substring(0, intellijIdeaRulezzz + "IntellijIdeaRulezzz ".length());
            }
            if ((type = new JSTypeParser(comment.getProject(), text, new JSTypeVisitor(){

                @Override
                public void visitSingleType(int startOffset, @Nullable JSType type, @NotNull String name) {
                    if (name == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!JSCommonTypeNames.NON_REFERENCE_TYPES.contains(name)) {
                        JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)JSDocDescriptionImpl.this, name, dataOffsetInParent + startOffset, false);
                        Collections.addAll(result, set.getReferences());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocDescriptionImpl$1", "visitSingleType"));
                }
            }).parseParameterType()) == null) {
                result.clear();
            }
        }
        PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            JSDocDescriptionImpl.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private static boolean mayRelateToArrowFunctionParam(@NotNull JSDocComment docComment) {
        PsiElement nextSibling;
        PsiElement parent;
        if (docComment == null) {
            JSDocDescriptionImpl.$$$reportNull$$$0(5);
        }
        if (!((parent = docComment.getParent()) instanceof JSFunction) || !((JSFunction)parent).isArrowFunction()) {
            return false;
        }
        for (nextSibling = docComment.getNextSibling(); nextSibling != null && (nextSibling instanceof PsiWhiteSpace || nextSibling.getTextRange().isEmpty()); nextSibling = nextSibling.getNextSibling()) {
        }
        return nextSibling instanceof JSParameterList && nextSibling.getFirstChild() instanceof JSParameter;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocDescriptionImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocTagDescription(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocDescriptionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionText";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocDescriptionImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineTypeRefs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mayRelateToArrowFunctionParam";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

