/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeSourceFactory {
    @NotNull
    public static JSTypeSource createTypeSource(@NotNull PsiElement scope) {
        if (scope == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(0);
        }
        return JSTypeSourceFactory.createTypeSource(scope, true);
    }

    @NotNull
    public static JSTypeSource createTypeSource(@Nullable PsiElement scope, boolean isStrict) {
        return new JSTypeSource(scope, JSTypeSourceFactory.getSourceLanguage(scope), isStrict);
    }

    @NotNull
    public static JSTypeSource copyTypeSource(@NotNull JSTypeSource source, boolean isStrict) {
        if (source == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(1);
        }
        JSTypeSource jSTypeSource = source.copyWithStrict(isStrict);
        if (jSTypeSource == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(2);
        }
        return jSTypeSource;
    }

    @NotNull
    public static JSTypeSource copyTypeSource(@NotNull JSTypeSource source, @NotNull PsiElement sourceElement) {
        if (source == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(4);
        }
        return new JSTypeSource(sourceElement, source.getLanguage(), source.isStrict());
    }

    @NotNull
    public static JSTypeSource.SourceLanguage getSourceLanguage(@Nullable PsiElement scope) {
        JSTypeSource.SourceLanguage sourceLanguage;
        Language language;
        Language language2 = language = scope != null ? DialectDetector.languageOfElement(scope) : null;
        if (language instanceof JSLanguageDialect) {
            JSLanguageDialect dialect = (JSLanguageDialect)language;
            sourceLanguage = JSTypeSourceFactory.ofDialectOptionsHolder(dialect.getOptionHolder());
        } else {
            sourceLanguage = JSTypeSource.SourceLanguage.JS;
        }
        if (sourceLanguage == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(5);
        }
        return sourceLanguage;
    }

    @NotNull
    private static JSTypeSource.SourceLanguage ofDialectOptionsHolder(@NotNull DialectOptionHolder dialect) {
        if (dialect == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(6);
        }
        if (dialect.isECMA4) {
            JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.AS;
            if (sourceLanguage == null) {
                JSTypeSourceFactory.$$$reportNull$$$0(7);
            }
            return sourceLanguage;
        }
        if (dialect.isTypeScript) {
            JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.TS;
            if (sourceLanguage == null) {
                JSTypeSourceFactory.$$$reportNull$$$0(8);
            }
            return sourceLanguage;
        }
        JSTypeSource.SourceLanguage sourceLanguage = JSTypeSource.SourceLanguage.JS;
        if (sourceLanguage == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(9);
        }
        return sourceLanguage;
    }

    @NotNull
    public static JSTypeSource empty(@NotNull JSTypeSource.SourceLanguage language, boolean isStrict) {
        if (language == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(10);
        }
        if (language == JSTypeSource.SourceLanguage.AS) {
            JSTypeSource jSTypeSource = JSTypeSource.EMPTY_AS;
            if (jSTypeSource == null) {
                JSTypeSourceFactory.$$$reportNull$$$0(11);
            }
            return jSTypeSource;
        }
        if (language == JSTypeSource.SourceLanguage.TS) {
            JSTypeSource jSTypeSource = isStrict ? JSTypeSource.EMPTY_TS : JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
            if (jSTypeSource == null) {
                JSTypeSourceFactory.$$$reportNull$$$0(12);
            }
            return jSTypeSource;
        }
        JSTypeSource jSTypeSource = isStrict ? JSTypeSource.EXPLICITLY_DECLARED : JSTypeSource.EMPTY;
        if (jSTypeSource == null) {
            JSTypeSourceFactory.$$$reportNull$$$0(13);
        }
        return jSTypeSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 7, 8, 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSourceFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeSource";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceLanguage";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "ofDialectOptionsHolder";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeSource";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeSource";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ofDialectOptionsHolder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "empty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 7, 8, 9, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

