/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.openapi.util.Trinity;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.inspections.VueExprFunctionSignatureChecker;
import org.jetbrains.vuejs.lang.expr.psi.VueJSFilterExpression;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aY\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"checkFilterParameterLength", "", "Lorg/jetbrains/vuejs/inspections/VueExprFunctionSignatureChecker;", "minMaxParameters", "Lcom/intellij/openapi/util/Trinity;", "", "node", "Lorg/jetbrains/vuejs/lang/expr/psi/VueJSFilterExpression;", "expressions", "", "Lcom/intellij/lang/javascript/psi/JSExpression;", "function", "Lcom/intellij/lang/javascript/psi/JSFunctionItem;", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lorg/jetbrains/vuejs/inspections/VueExprFunctionSignatureChecker;Lcom/intellij/openapi/util/Trinity;Lorg/jetbrains/vuejs/lang/expr/psi/VueJSFilterExpression;[Lcom/intellij/lang/javascript/psi/JSExpression;Lcom/intellij/lang/javascript/psi/JSFunctionItem;Ljava/util/List;)Z", "intellij.vuejs.backend"})
public final class VueExprAnalysisHandlersFactoriesKt {
    private static final boolean checkFilterParameterLength(VueExprFunctionSignatureChecker $this$checkFilterParameterLength, Trinity<Integer, Integer, Boolean> minMaxParameters, VueJSFilterExpression node, JSExpression[] expressions, JSFunctionItem function, List<LocalQuickFix> fixes) {
        Integer min = (Integer)minMaxParameters.first;
        Integer max = (Integer)minMaxParameters.second;
        JSArgumentList argumentList = node.getArgumentList();
        Intrinsics.checkNotNull((Object)min);
        int n = min;
        Intrinsics.checkNotNull((Object)max);
        int n2 = max;
        int n3 = expressions.length;
        boolean bl = n <= n3 ? n3 <= n2 : false;
        if (bl) {
            return true;
        }
        if (function instanceof JSFunction) {
            LocalQuickFix localQuickFix = JSFixFactory.getInstance().changeSignatureFix((JSFunction)function, argumentList);
            Intrinsics.checkNotNullExpressionValue((Object)localQuickFix, (String)"changeSignatureFix(...)");
            fixes.add(localQuickFix);
        }
        if (argumentList != null && argumentList.hasSpreadElement() && expressions.length < min) {
            return false;
        }
        if (min == 0 && max == 0) {
            $this$checkFilterParameterLength.registerProblem((JSCallExpression)node, VueBundle.message((String)"vue.inspection.message.filter.function.with.no.args", (Object[])new Object[0]), fixes);
        } else {
            String s = (min == 0 ? 0 : min - 1) + (String)((Boolean)minMaxParameters.third != false ? " or more" : (!Intrinsics.areEqual((Object)min, (Object)max) ? ".." + (max - 1) : ""));
            Object[] objectArray = new Object[]{s};
            $this$checkFilterParameterLength.registerProblem((JSCallExpression)node, VueBundle.message((String)"vue.inspection.message.filter.invalid.number.of.arguments", (Object[])objectArray), fixes);
        }
        return false;
    }

    public static final /* synthetic */ boolean access$checkFilterParameterLength(VueExprFunctionSignatureChecker $receiver, Trinity minMaxParameters, VueJSFilterExpression node, JSExpression[] expressions, JSFunctionItem function, List fixes) {
        return VueExprAnalysisHandlersFactoriesKt.checkFilterParameterLength($receiver, (Trinity<Integer, Integer, Boolean>)minMaxParameters, node, expressions, function, fixes);
    }
}

