/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.html.elements.HtmlElementSymbolDescriptor;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlElementDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.inspections.quickfixes.VueImportComponentQuickFix;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;
import org.jetbrains.vuejs.web.symbols.VueComponentSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/intentions/VueImportComponentIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "<init>", "()V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "getText", "invoke", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getElementToImport", "Lcom/intellij/polySymbols/PolySymbol;", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueImportComponentIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueImportComponentIntention.kt\norg/jetbrains/vuejs/intentions/VueImportComponentIntention\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n19#2:74\n19#2:75\n19#2:77\n19#2:78\n1#3:76\n*S KotlinDebug\n*F\n+ 1 VueImportComponentIntention.kt\norg/jetbrains/vuejs/intentions/VueImportComponentIntention\n*L\n31#1:74\n32#1:75\n51#1:77\n65#1:78\n*E\n"})
public final class VueImportComponentIntention
extends JavaScriptIntention
implements HighPriorityAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        PolySymbol polySymbol;
        HtmlElementSymbolDescriptor htmlElementSymbolDescriptor;
        XmlTag xmlTag;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)XmlTokenType.XML_NAME)) return false;
        PsiElement $this$asSafely$iv = element.getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof XmlTag)) {
            psiElement = null;
        }
        XmlElementDescriptor $this$asSafely$iv2 = (xmlTag = (XmlTag)psiElement) != null ? xmlTag.getDescriptor() : null;
        boolean $i$f$asSafely2 = false;
        XmlElementDescriptor xmlElementDescriptor = $this$asSafely$iv2;
        if (!(xmlElementDescriptor instanceof HtmlElementSymbolDescriptor)) {
            xmlElementDescriptor = null;
        }
        if ((htmlElementSymbolDescriptor = (HtmlElementSymbolDescriptor)xmlElementDescriptor) == null) return false;
        xmlTag = htmlElementSymbolDescriptor.getSymbol();
        if (xmlTag == null) return false;
        PolySymbol polySymbol2 = VueUtilKt.extractComponentSymbol((PolySymbol)xmlTag);
        if (polySymbol2 == null) return false;
        PolySymbol it = polySymbol = polySymbol2;
        boolean bl = false;
        if (this.getElementToImport(it) == null) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        PolySymbol polySymbol3 = polySymbol;
        PolySymbol polySymbol4 = polySymbol3;
        if (polySymbol4 == null) return false;
        it = polySymbol4;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)it.get(VueSymbolQueryConfiguratorKt.getPROP_VUE_COMPOSITION_COMPONENT()), (Object)true)) return true;
        VueModelVisitor.Proximity proximity = (VueModelVisitor.Proximity)((Object)it.get(VueSymbolQueryConfiguratorKt.getPROP_VUE_PROXIMITY()));
        boolean bl4 = false;
        if (proximity == null) return true;
        if (proximity == VueModelVisitor.Proximity.LOCAL) return false;
        if (proximity == VueModelVisitor.Proximity.OUT_OF_SCOPE) return false;
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return VueBundle.message((String)"vue.template.intention.import.component.family.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return VueBundle.message((String)"vue.template.intention.import.component.family.name", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        PsiElement psiElement;
        PolySymbol polySymbol;
        PolySymbol polySymbol2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement2 = element.getParent();
        XmlTag xmlTag = psiElement2 instanceof XmlTag ? (XmlTag)psiElement2 : null;
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        XmlElementDescriptor $this$asSafely$iv = tag.getDescriptor();
        boolean $i$f$asSafely = false;
        XmlElementDescriptor xmlElementDescriptor = $this$asSafely$iv;
        if (!(xmlElementDescriptor instanceof HtmlElementSymbolDescriptor)) {
            xmlElementDescriptor = null;
        }
        if ((psiElement2 = (HtmlElementSymbolDescriptor)xmlElementDescriptor) == null || (polySymbol2 = psiElement2.getSymbol()) == null || (polySymbol = VueUtilKt.extractComponentSymbol(polySymbol2)) == null || (psiElement = this.getElementToImport(polySymbol)) == null) {
            return;
        }
        PsiElement elementToImport = psiElement;
        String string = tag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        new VueImportComponentQuickFix(element, VueUtilKt.toAsset$default(string, false, 2, null), elementToImport).applyFix();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiElement getElementToImport(PolySymbol $this$getElementToImport) {
        PsiSourcedPolySymbol psiSourcedPolySymbol;
        PolySymbol $this$asSafely$iv = $this$getElementToImport;
        boolean $i$f$asSafely = false;
        PolySymbol polySymbol = $this$asSafely$iv;
        if (!(polySymbol instanceof PsiSourcedPolySymbol)) {
            polySymbol = null;
        }
        if ((psiSourcedPolySymbol = (PsiSourcedPolySymbol)polySymbol) == null) return null;
        PsiSourcedPolySymbol it = psiSourcedPolySymbol;
        boolean bl = false;
        PsiElement psiElement = it instanceof VueComponentSymbol ? ((VueComponentSymbol)it).getRawSource() : it.getSource();
        if (psiElement == null) return null;
        PsiElement psiElement2 = psiElement;
        it = psiElement2;
        boolean bl2 = false;
        if (it instanceof JSLiteralExpression) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        PsiElement psiElement3 = psiElement2;
        return psiElement3;
    }
}

