/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.TaskManagerImpl;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            TaskCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            TaskCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        return new TaskCheckinHandler(panel);
    }

    @Nullable
    private static Task findTaskInRepositories(String message, TaskManager manager) {
        TaskRepository[] repositories;
        for (TaskRepository repository : repositories = manager.getAllRepositories()) {
            String id = repository.extractId(message);
            if (id == null) continue;
            LocalTask localTask = manager.findTask(id);
            if (localTask != null) {
                return localTask;
            }
            try {
                Task task = repository.findTask(id);
                if (task == null) continue;
                return task;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "commitContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/tasks/impl/TaskCheckinHandlerFactory";
        objectArray[2] = "createHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TaskCheckinHandler
    extends CheckinHandler
    implements DumbAware {
        @NotNull
        final CheckinProjectPanel panel;

        private TaskCheckinHandler(@NotNull CheckinProjectPanel panel) {
            if (panel == null) {
                TaskCheckinHandler.$$$reportNull$$$0(0);
            }
            this.panel = panel;
        }

        public void checkinSuccessful() {
            String message = this.panel.getCommitMessage();
            Project project = this.panel.getProject();
            TaskManagerImpl manager = (TaskManagerImpl)TaskManager.getManager((Project)project);
            if (manager.getState().saveContextOnCommit) {
                Task task = TaskCheckinHandlerFactory.findTaskInRepositories(message, (TaskManager)manager);
                if (task == null) {
                    task = manager.createLocalTask(message);
                    ((LocalTaskImpl)task).setClosed(true);
                }
                LocalTask localTask = manager.addTask(task);
                localTask.setUpdated(new Date());
                ApplicationManager.getApplication().invokeLater(() -> WorkingContextManager.getInstance((Project)project).saveContext((Task)localTask), project.getDisposed());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/tasks/impl/TaskCheckinHandlerFactory$TaskCheckinHandler", "<init>"));
        }
    }
}

