/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.network.status.bean;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Version;
import com.intellij.stats.completion.network.status.bean.MajorVersionBorders;
import com.intellij.stats.completion.network.status.bean.ReleaseType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\fH\u00c6\u0003JG\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010#\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\tH\u00d6\u0001J\t\u0010&\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/intellij/stats/completion/network/status/bean/EndpointSettings;", "", "releaseType", "Lcom/intellij/stats/completion/network/status/bean/ReleaseType;", "majorBuildVersionBorders", "Lcom/intellij/stats/completion/network/status/bean/MajorVersionBorders;", "completionLanguage", "Lcom/intellij/lang/Language;", "fromBucket", "", "toBucket", "endpoint", "", "<init>", "(Lcom/intellij/stats/completion/network/status/bean/ReleaseType;Lcom/intellij/stats/completion/network/status/bean/MajorVersionBorders;Lcom/intellij/lang/Language;IILjava/lang/String;)V", "getReleaseType", "()Lcom/intellij/stats/completion/network/status/bean/ReleaseType;", "getMajorBuildVersionBorders", "()Lcom/intellij/stats/completion/network/status/bean/MajorVersionBorders;", "getCompletionLanguage", "()Lcom/intellij/lang/Language;", "getFromBucket", "()I", "getToBucket", "getEndpoint", "()Ljava/lang/String;", "satisfies", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "intellij.statsCollector"})
public final class EndpointSettings {
    @NotNull
    private final ReleaseType releaseType;
    @NotNull
    private final MajorVersionBorders majorBuildVersionBorders;
    @NotNull
    private final Language completionLanguage;
    private final int fromBucket;
    private final int toBucket;
    @Nullable
    private final String endpoint;

    public EndpointSettings(@NotNull ReleaseType releaseType, @NotNull MajorVersionBorders majorBuildVersionBorders, @NotNull Language completionLanguage, int fromBucket, int toBucket, @Nullable String endpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)releaseType), (String)"releaseType");
        Intrinsics.checkNotNullParameter((Object)majorBuildVersionBorders, (String)"majorBuildVersionBorders");
        Intrinsics.checkNotNullParameter((Object)completionLanguage, (String)"completionLanguage");
        this.releaseType = releaseType;
        this.majorBuildVersionBorders = majorBuildVersionBorders;
        this.completionLanguage = completionLanguage;
        this.fromBucket = fromBucket;
        this.toBucket = toBucket;
        this.endpoint = endpoint;
    }

    public /* synthetic */ EndpointSettings(ReleaseType releaseType, MajorVersionBorders majorVersionBorders, Language language, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            releaseType = ReleaseType.ALL;
        }
        if ((n3 & 2) != 0) {
            majorVersionBorders = new MajorVersionBorders(null, null);
        }
        if ((n3 & 4) != 0) {
            Language language2 = Language.ANY;
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"ANY");
            language = language2;
        }
        if ((n3 & 8) != 0) {
            n = 0;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 255;
        }
        if ((n3 & 0x20) != 0) {
            string = null;
        }
        this(releaseType, majorVersionBorders, language, n, n2, string);
    }

    @NotNull
    public final ReleaseType getReleaseType() {
        return this.releaseType;
    }

    @NotNull
    public final MajorVersionBorders getMajorBuildVersionBorders() {
        return this.majorBuildVersionBorders;
    }

    @NotNull
    public final Language getCompletionLanguage() {
        return this.completionLanguage;
    }

    public final int getFromBucket() {
        return this.fromBucket;
    }

    public final int getToBucket() {
        return this.toBucket;
    }

    @Nullable
    public final String getEndpoint() {
        return this.endpoint;
    }

    public final boolean satisfies() {
        ReleaseType currentReleaseType;
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        ReleaseType releaseType = currentReleaseType = ApplicationManager.getApplication().isEAP() ? ReleaseType.EAP : ReleaseType.RELEASE;
        if (this.releaseType != ReleaseType.ALL && this.releaseType != currentReleaseType) {
            return false;
        }
        Version version = Version.parseVersion((String)applicationInfo.getFullVersion());
        if (version == null || !this.majorBuildVersionBorders.satisfies(version)) {
            return false;
        }
        int bucket = EventLogConfiguration.Companion.getInstance().getBucket();
        int n = this.fromBucket;
        return bucket <= this.toBucket ? n <= bucket : false;
    }

    @NotNull
    public final ReleaseType component1() {
        return this.releaseType;
    }

    @NotNull
    public final MajorVersionBorders component2() {
        return this.majorBuildVersionBorders;
    }

    @NotNull
    public final Language component3() {
        return this.completionLanguage;
    }

    public final int component4() {
        return this.fromBucket;
    }

    public final int component5() {
        return this.toBucket;
    }

    @Nullable
    public final String component6() {
        return this.endpoint;
    }

    @NotNull
    public final EndpointSettings copy(@NotNull ReleaseType releaseType, @NotNull MajorVersionBorders majorBuildVersionBorders, @NotNull Language completionLanguage, int fromBucket, int toBucket, @Nullable String endpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)releaseType), (String)"releaseType");
        Intrinsics.checkNotNullParameter((Object)majorBuildVersionBorders, (String)"majorBuildVersionBorders");
        Intrinsics.checkNotNullParameter((Object)completionLanguage, (String)"completionLanguage");
        return new EndpointSettings(releaseType, majorBuildVersionBorders, completionLanguage, fromBucket, toBucket, endpoint);
    }

    public static /* synthetic */ EndpointSettings copy$default(EndpointSettings endpointSettings, ReleaseType releaseType, MajorVersionBorders majorVersionBorders, Language language, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 1) != 0) {
            releaseType = endpointSettings.releaseType;
        }
        if ((n3 & 2) != 0) {
            majorVersionBorders = endpointSettings.majorBuildVersionBorders;
        }
        if ((n3 & 4) != 0) {
            language = endpointSettings.completionLanguage;
        }
        if ((n3 & 8) != 0) {
            n = endpointSettings.fromBucket;
        }
        if ((n3 & 0x10) != 0) {
            n2 = endpointSettings.toBucket;
        }
        if ((n3 & 0x20) != 0) {
            string = endpointSettings.endpoint;
        }
        return endpointSettings.copy(releaseType, majorVersionBorders, language, n, n2, string);
    }

    @NotNull
    public String toString() {
        return "EndpointSettings(releaseType=" + this.releaseType + ", majorBuildVersionBorders=" + this.majorBuildVersionBorders + ", completionLanguage=" + this.completionLanguage + ", fromBucket=" + this.fromBucket + ", toBucket=" + this.toBucket + ", endpoint=" + this.endpoint + ")";
    }

    public int hashCode() {
        int result = this.releaseType.hashCode();
        result = result * 31 + this.majorBuildVersionBorders.hashCode();
        result = result * 31 + this.completionLanguage.hashCode();
        result = result * 31 + Integer.hashCode(this.fromBucket);
        result = result * 31 + Integer.hashCode(this.toBucket);
        result = result * 31 + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EndpointSettings)) {
            return false;
        }
        EndpointSettings endpointSettings = (EndpointSettings)other;
        if (this.releaseType != endpointSettings.releaseType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.majorBuildVersionBorders, (Object)endpointSettings.majorBuildVersionBorders)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.completionLanguage, (Object)endpointSettings.completionLanguage)) {
            return false;
        }
        if (this.fromBucket != endpointSettings.fromBucket) {
            return false;
        }
        if (this.toBucket != endpointSettings.toBucket) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endpoint, (Object)endpointSettings.endpoint);
    }

    public EndpointSettings() {
        this(null, null, null, 0, 0, null, 63, null);
    }
}

