/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementInsertStopper;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionItem;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionItemPresentation;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionItemPresentationKt;
import com.intellij.platform.completion.common.split.protocol.RpcCompletionRequest;
import com.intellij.platform.completion.frontend.split.FrontendInsertHandler;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElementInsertStopper;", "item", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionItem;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionRequest;", "<init>", "(Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionItem;Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionRequest;)V", "getItem", "()Lcom/intellij/platform/completion/common/split/protocol/RpcCompletionItem;", "getLookupString", "", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "handleInsert", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "getAllLookupStrings", "", "requiresCommittedDocuments", "", "getAutoCompletionPolicy", "Lcom/intellij/codeInsight/lookup/AutoCompletionPolicy;", "getExpensiveRenderer", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "isCaseSensitive", "shouldStopLookupInsertion", "intellij.platform.completion.frontend.split"})
public final class FrontendLookupElement
extends LookupElement
implements LookupElementInsertStopper {
    @NotNull
    private final RpcCompletionItem item;
    @NotNull
    private final Project project;
    @NotNull
    private final RpcCompletionRequest request;

    public FrontendLookupElement(@NotNull RpcCompletionItem item, @NotNull Project project, @NotNull RpcCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.item = item;
        this.project = project;
        this.request = request;
        if (this.item.isDirectInsertion()) {
            this.putUserData(CodeCompletionHandlerBase.DIRECT_INSERTION, true);
        }
    }

    @NotNull
    public final RpcCompletionItem getItem() {
        return this.item;
    }

    @NotNull
    public String getLookupString() {
        return this.item.getLookupString();
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        RpcCompletionItemPresentationKt.render((RpcCompletionItemPresentation)this.item.getPresentation(), (LookupElementPresentation)presentation);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        new FrontendInsertHandler(this.request, this.project).handleInsert(context, this);
    }

    @NotNull
    public Set<String> getAllLookupStrings() {
        return this.item.getAllLookupStrings();
    }

    public boolean requiresCommittedDocuments() {
        return this.item.getRequiresCommittedDocuments();
    }

    @NotNull
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return this.item.getAutoCompletionPolicy();
    }

    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return super.getExpensiveRenderer();
    }

    public boolean isCaseSensitive() {
        return this.item.isCaseSensitive();
    }

    public boolean shouldStopLookupInsertion() {
        return this.item.getShouldStopLookupInsertion();
    }
}

