/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.completion.SassScssCompletionContributor;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.SASSSCSSLangUtilCore;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;
import org.jetbrains.plugins.scss.psi.stubs.ScssFunctionsIndex;
import org.jetbrains.plugins.scss.references.SassScssQualifierReference;

public class FunctionNamesProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            FunctionNamesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FunctionNamesProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(2);
        }
        PsiElement originalElement = parameters.getOriginalPosition();
        PsiElement position = parameters.getPosition();
        String qualifier = SassScssCompletionContributor.getQualifier(position);
        if (qualifier != null) {
            FunctionNamesProvider.addFunctionsForQualifier(result, position, qualifier);
            return;
        }
        FunctionNamesProvider.addCompletionsFromProjectFiles(position, originalElement, result);
        FunctionNamesProvider.addCustomFunctionsFromSassExtensions(position, result);
        FunctionNamesProvider.addFunctionExtensionsFromSassExtensions(parameters.getPosition(), result);
        result.restartCompletionOnPrefixChange(SassScssCompletionContributor.RESTART_IDENTIFIER_COMPLETION_CONDITION);
    }

    private static void addFunctionsForQualifier(@NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull String qualifier) {
        PsiElement resolve;
        SassScssUseAtRule useAtRule;
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(3);
        }
        if (position == null) {
            FunctionNamesProvider.$$$reportNull$$$0(4);
        }
        if (qualifier == null) {
            FunctionNamesProvider.$$$reportNull$$$0(5);
        }
        PsiFile[] files = (useAtRule = (SassScssUseAtRule)PsiTreeUtil.getParentOfType((PsiElement)(resolve = SassScssQualifierReference.resolve(position, qualifier)), SassScssUseAtRule.class)) != null ? useAtRule.resolveTargetFiles() : PsiFile.EMPTY_ARRAY;
        HashSet<PsiFile> visited = new HashSet<PsiFile>();
        visited.add(position.getContainingFile().getOriginalFile());
        for (PsiFile file : files) {
            if (!(file instanceof SassScssStylesheetFile)) continue;
            for (SassScssFunctionDeclaration fun : ((SassScssStylesheetFile)file).getTopLevelDeclarations(SassScssFunctionDeclaration.class)) {
                String name = fun.getName();
                if (name.isEmpty() || name.startsWith("-") || name.startsWith("_")) continue;
                result.addElement(SASSSCSSLangUtil.createFunctionLookupItem(null, fun, null, true, result.getPrefixMatcher().getPrefix()));
            }
        }
        for (PsiFile file : files) {
            if (!(file instanceof SassScssStylesheetFile)) continue;
            SASSSCSSLangUtil.processForwardsAndImports((SassScssStylesheetFile)file, "", visited, (PairConsumer<SassScssStylesheetFile, String>)((PairConsumer)(forwardedFile, prefix) -> {
                for (SassScssFunctionDeclaration fun : forwardedFile.getTopLevelDeclarations(SassScssFunctionDeclaration.class)) {
                    String name = fun.getName();
                    if (name.isEmpty() || name.startsWith("-") || name.startsWith("_")) continue;
                    result.addElement(SASSSCSSLangUtil.createFunctionLookupItem(prefix, fun, null, true, result.getPrefixMatcher().getPrefix()));
                }
            }));
        }
    }

    private static void addCompletionsFromProjectFiles(@NotNull PsiElement position, @Nullable PsiElement originalElement, @NotNull CompletionResultSet result) {
        if (position == null) {
            FunctionNamesProvider.$$$reportNull$$$0(6);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(7);
        }
        Project project = position.getProject();
        Map<PsiFile, SASSSCSSLangUtil.QualifierInfo> fileToQualifierInfoMap = SASSSCSSLangUtil.getFileToQualifierInfoMap(position);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)position.getContainingFile().getOriginalFile(), (PsiElement)position, (boolean)false);
        GlobalSearchScope scope = SASSSCSSLangUtil.searchScopeWithSassStdlib(position).union((SearchScope)GlobalSearchScope.filesScope((Project)project, (Collection)importedFiles)).union((SearchScope)GlobalSearchScope.filesScope((Project)project, (Collection)ContainerUtil.mapNotNull(fileToQualifierInfoMap.keySet(), f -> f.getVirtualFile())));
        String prefix = result.getPrefixMatcher().getPrefix();
        for (String name : StubIndex.getInstance().getAllKeys(ScssFunctionsIndex.KEY, project)) {
            if (name.isEmpty()) continue;
            ScssFunctionsIndex.process(name, project, scope, (Processor<? super SassScssFunctionDeclaration>)((Processor)declaration -> {
                if (declaration != originalElement && SASSSCSSLangUtilCore.isVisibleDeclaration((PsiElement)declaration, (PsiElement)position)) {
                    PsiFile declFile = declaration.getContainingFile();
                    SASSSCSSLangUtil.QualifierInfo info = (SASSSCSSLangUtil.QualifierInfo)fileToQualifierInfoMap.get(declFile);
                    if (info != null) {
                        String targetName = declaration.getName();
                        if (!targetName.startsWith("-") && !targetName.startsWith("_")) {
                            LookupElement lookupItem = SASSSCSSLangUtil.createFunctionLookupItem(info.prefixFromForwards, declaration, info.qualifier, true, prefix);
                            result.addElement(lookupItem);
                        }
                    } else {
                        boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                        result.addElement(SASSSCSSLangUtil.createFunctionLookupItem(null, declaration, null, validResult, prefix));
                    }
                }
                return true;
            }));
        }
    }

    private static void addCustomFunctionsFromSassExtensions(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        Module module;
        if (position == null) {
            FunctionNamesProvider.$$$reportNull$$$0(8);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(9);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)position)) != null) {
            String prefix = result.getPrefixMatcher().getPrefix();
            for (SassExtension sassExtension : SassExtension.getAllExtensions(module)) {
                for (SassExtensionFunctionInfo functionInfo : sassExtension.getCustomFunctions()) {
                    result.addElement(SASSSCSSLangUtil.createCustomFunctionLookupItem(functionInfo, prefix));
                }
            }
        }
    }

    private static void addFunctionExtensionsFromSassExtensions(@NotNull PsiElement position, @NotNull CompletionResultSet result) {
        if (position == null) {
            FunctionNamesProvider.$$$reportNull$$$0(10);
        }
        if (result == null) {
            FunctionNamesProvider.$$$reportNull$$$0(11);
        }
        SassExtension.fillCompletionResultWithExtensionFunctions(position, result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/sass/completion/FunctionNamesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addFunctionsForQualifier";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionsFromProjectFiles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomFunctionsFromSassExtensions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addFunctionExtensionsFromSassExtensions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

