/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/DumpProjectFiles;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "dumpProjectFiles", "", "dumpDir", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nDumpProjectFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/DumpProjectFiles\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n*S KotlinDebug\n*F\n+ 1 DumpProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/DumpProjectFiles\n*L\n62#1:80\n*E\n"})
public final class DumpProjectFiles
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%dumpProjectFiles";
    @NotNull
    private static final Logger LOG;

    public DumpProjectFiles(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Path dumpProjectFilesDir = DumpProjectFiles.Companion.getOrCreateDirectoryToDumpFiles();
        LOG.info("DumpFiles will be stored to " + dumpProjectFilesDir);
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> DumpProjectFiles._execute$lambda$0(project2, this, dumpProjectFilesDir, actionCallback));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final void dumpProjectFiles(Path dumpDir, ProgressIndicator indicator, Project project) {
        ActionsKt.runReadAction(DumpProjectFiles::dumpProjectFiles$lambda$0);
        indicator.setIndeterminate(true);
        IndexContentDiagnostic contentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.getIndexContentDiagnosticForProject(project, indicator);
        IndexContentDiagnosticDumper.INSTANCE.writeTo(StoreIndices.Companion.getFileForDiagnostic(dumpDir), contentDiagnostic);
    }

    private static final void _execute$lambda$0(Project $project, DumpProjectFiles this$0, Path $dumpProjectFilesDir, ActionCallbackProfilerStopper $actionCallback) {
        String string = PerformanceTestingBundle.message("dumping.project.files", new Object[0]);
        new Task.Modal($project, this$0, $dumpProjectFilesDir, $actionCallback, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ DumpProjectFiles this$0;
            final /* synthetic */ Path $dumpProjectFilesDir;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$dumpProjectFilesDir = $dumpProjectFilesDir;
                this.$actionCallback = $actionCallback;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    DumpProjectFiles.access$dumpProjectFiles(this.this$0, this.$dumpProjectFilesDir, indicator, this.$project);
                    DumpProjectFiles.access$getLOG$cp().info("Project files has been successfully stored to " + this.$dumpProjectFilesDir);
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    ActionCallback actionCallback = this.$actionCallback.reject(e.getMessage());
                    Intrinsics.checkNotNull((Object)actionCallback);
                }
            }
        }.queue();
    }

    private static final Unit dumpProjectFiles$lambda$0() {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$dumpProjectFiles(DumpProjectFiles $this, Path dumpDir, ProgressIndicator indicator, Project project) {
        $this.dumpProjectFiles(dumpDir, indicator, project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DumpProjectFiles.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/performancePlugin/commands/DumpProjectFiles$Companion;", "", "<init>", "()V", "PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getOrCreateDirectoryToDumpFiles", "Ljava/nio/file/Path;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getOrCreateDirectoryToDumpFiles() {
            Path path;
            String property = System.getProperty("dump.project.files.directory");
            if (property != null) {
                Path path2 = Paths.get(property, new String[0]);
                Intrinsics.checkNotNull((Object)path2);
                path = path2;
            } else {
                Path path3;
                try {
                    path3 = FileUtil.createTempDirectory((String)"projectFiles_dumps", null).toPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Path path4 = path3;
                Intrinsics.checkNotNull((Object)path4);
                path = path4;
            }
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

