/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.renderedDocs;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderItemManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.DocRenderInfo;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.DocRenderInfoKt;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItem;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemKt;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "foldingModel", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "afterBulkAdd", "", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterUpdated", "highlighter", "addFoldings", "newHighlighters", "", "beforeBulkRemove", "addFoldRegion", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "h", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/DocRenderInfo;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocRenderModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocRenderModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n774#2:69\n865#2,2:70\n774#2:72\n865#2,2:73\n13#3:75\n*S KotlinDebug\n*F\n+ 1 FrontendDocRenderModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter\n*L\n22#1:69\n22#1:70,2\n45#1:72\n45#1:73,2\n16#1:75\n*E\n"})
public final class FrontendDocRenderModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final FoldingModelImpl foldingModel;
    @NotNull
    private static final Logger logger;

    public FrontendDocRenderModelAdapter(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        this.foldingModel = (FoldingModelImpl)foldingModel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Iterable $this$filter$iv = highlighters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
            boolean bl = false;
            if (!(DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renderedDocs = (List)destination$iv$iv;
        if (renderedDocs.isEmpty()) {
            return;
        }
        this.foldingModel.runBatchFoldingOperation(() -> FrontendDocRenderModelAdapter.afterBulkAdd$lambda$1(this, renderedDocs));
    }

    @Override
    public void afterUpdated(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        DocRenderInfo docRenderInfo = DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)highlighter);
        if (docRenderInfo == null) {
            return;
        }
        DocRenderInfo info = docRenderInfo;
        CustomFoldRegion customFoldRegion = info.getRegion();
        if (customFoldRegion == null) {
            return;
        }
        CustomFoldRegion region = customFoldRegion;
        GutterIconRenderer gutterIconRenderer = info.getGutterRenderer();
        if (gutterIconRenderer != null) {
            FrontendDocRenderItemKt.setVisible(gutterIconRenderer, false);
        }
        CustomFoldRegionRenderer customFoldRegionRenderer = region.getRenderer();
        Intrinsics.checkNotNull((Object)customFoldRegionRenderer, (String)"null cannot be cast to non-null type com.intellij.codeInsight.documentation.render.DocRenderer");
        DocRenderItem docRenderItem = ((DocRenderer)customFoldRegionRenderer).getItem();
        Intrinsics.checkNotNull((Object)docRenderItem, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItem");
        ((FrontendDocRenderItem)docRenderItem).setRenderer(info.getGutterRenderer());
        region.update();
    }

    private final void addFoldings(Collection<? extends RangeHighlighterEx> newHighlighters) {
        for (RangeHighlighterEx rangeHighlighterEx : newHighlighters) {
            DocRenderInfo info;
            if (DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)rangeHighlighterEx) == null) continue;
            CustomFoldRegion customFoldRegion = this.addFoldRegion(rangeHighlighterEx, info);
            if (customFoldRegion == null) continue;
            info.setRegion(customFoldRegion);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Iterable $this$filter$iv = highlighters;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighterEx it = (RangeHighlighterEx)element$iv$iv;
            boolean bl = false;
            if (!(DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renderedDocs = (List)destination$iv$iv;
        if (renderedDocs.isEmpty()) {
            return;
        }
        this.foldingModel.runBatchFoldingOperation(() -> FrontendDocRenderModelAdapter.beforeBulkRemove$lambda$1(renderedDocs, this));
    }

    private final CustomFoldRegion addFoldRegion(RangeHighlighterEx h, DocRenderInfo info) {
        DocRenderItemManager docRenderItemManager = DocRenderItemManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)docRenderItemManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemManager");
        FrontendDocRenderItemManager manager = (FrontendDocRenderItemManager)docRenderItemManager;
        CustomFoldRegion newRegion = manager.addFolding(this.editor, info, h);
        if (newRegion == null) {
            logger.warn("Unable to insert (" + h + ".startOffset, " + h + ".endOffset) in the folding tree");
            return null;
        }
        return newRegion;
    }

    private static final void afterBulkAdd$lambda$1(FrontendDocRenderModelAdapter this$0, List $renderedDocs) {
        this$0.addFoldings($renderedDocs);
    }

    private static final void beforeBulkRemove$lambda$1(List $renderedDocs, FrontendDocRenderModelAdapter this$0) {
        for (RangeHighlighterEx h : $renderedDocs) {
            FrontendDocRenderItem it;
            DocRenderInfo info;
            if (DocRenderInfoKt.getDocRenderInfo((RangeHighlighter)h) == null) continue;
            CustomFoldRegion customFoldRegion = info.getRegion();
            if (customFoldRegion == null) continue;
            this$0.foldingModel.removeFoldRegion((FoldRegion)customFoldRegion);
            DocRenderItemManager docRenderItemManager = DocRenderItemManager.Companion.getInstance();
            Intrinsics.checkNotNull((Object)docRenderItemManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemManager");
            if (((FrontendDocRenderItemManager)docRenderItemManager).getItem(this$0.editor, info.getId()) == null) continue;
            boolean bl = false;
            it.setFoldRegion(null);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendDocRenderModelAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendDocRenderModelAdapter.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderModelAdapter$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

