/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.configuration;

import com.jetbrains.fus.reporting.configuration.ConfigurationClient;
import com.jetbrains.fus.reporting.model.config.v4.Configuration;
import com.jetbrains.fus.reporting.model.config.v4.ConfigurationVersion;
import com.jetbrains.fus.reporting.model.serialization.Serializer;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/configuration/LocalConfigurationClient;", "Lcom/jetbrains/fus/reporting/configuration/ConfigurationClient;", "reader", "Ljava/io/Reader;", "productCode", "", "productVersion", "serializer", "Lcom/jetbrains/fus/reporting/model/serialization/Serializer;", "(Ljava/io/Reader;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/fus/reporting/model/serialization/Serializer;)V", "cashedConfiguration", "Lcom/jetbrains/fus/reporting/model/config/v4/Configuration;", "configurationUrl", "getConfigurationUrl", "()Ljava/lang/String;", "isRead", "", "getProductCode", "calculateConfigurationVersion", "Lcom/jetbrains/fus/reporting/model/config/v4/ConfigurationVersion;", "loadConfiguration", "configuration"})
public final class LocalConfigurationClient
extends ConfigurationClient {
    @NotNull
    private final Reader reader;
    @NotNull
    private final String productCode;
    @NotNull
    private final String productVersion;
    @NotNull
    private final Serializer serializer;
    @Nullable
    private final String configurationUrl;
    @Nullable
    private Configuration cashedConfiguration;
    private boolean isRead;

    public LocalConfigurationClient(@NotNull Reader reader, @NotNull String productCode, @NotNull String productVersion, @NotNull Serializer serializer2) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)productVersion, (String)"productVersion");
        Intrinsics.checkNotNullParameter((Object)serializer2, (String)"serializer");
        this.reader = reader;
        this.productCode = productCode;
        this.productVersion = productVersion;
        this.serializer = serializer2;
    }

    @Override
    @NotNull
    public String getProductCode() {
        return this.productCode;
    }

    @Override
    @Nullable
    public String getConfigurationUrl() {
        return this.configurationUrl;
    }

    @Override
    @Nullable
    public ConfigurationVersion calculateConfigurationVersion() {
        return this.loadConfiguration();
    }

    private final ConfigurationVersion loadConfiguration() {
        if (this.cashedConfiguration == null && !this.isRead) {
            this.isRead = true;
            this.cashedConfiguration = this.serializer.deserializeConfiguration(TextStreamsKt.readText((Reader)this.reader));
        }
        Configuration configuration = this.cashedConfiguration;
        return configuration != null ? configuration.findProductVersion(this.productVersion) : null;
    }
}

