/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.dynatrace.hash4j.hashing.HashValue128;
import com.dynatrace.hash4j.hashing.Hashing;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyCustomType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstParameter;
import com.jetbrains.python.ast.PyAstTypeParameter;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotation;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyFunctionTypeAnnotationFile;
import com.jetbrains.python.codeInsight.typeHints.PyTypeHintFile;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.codeInsight.typing.PyTypeHintProvider;
import com.jetbrains.python.codeInsight.typing.PyTypeProviderWithCustomContext;
import com.jetbrains.python.codeInsight.typing.PyTypedDictTypeProvider;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDoubleStarExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyEllipsisLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKnownDecorator;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterList;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithAncestors;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.PyClassElementType;
import com.jetbrains.python.psi.impl.stubs.PyTypingAliasStubType;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableParameterListType;
import com.jetbrains.python.psi.types.PyCallableParameterListTypeImpl;
import com.jetbrains.python.psi.types.PyCallableParameterVariadicType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PyPositionalVariadicType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParameterMapping;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarTupleTypeImpl;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypeVarTypeImpl;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyVariadicType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypingTypeProvider
extends PyTypeProviderWithCustomContext<Context> {
    @NlsSafe
    public static final String TYPING = "typing";
    public static final String GENERATOR = "typing.Generator";
    public static final String ASYNC_GENERATOR = "typing.AsyncGenerator";
    public static final String COROUTINE = "typing.Coroutine";
    public static final String AWAITABLE = "typing.Awaitable";
    public static final String NAMEDTUPLE = "typing.NamedTuple";
    public static final String TYPED_DICT = "typing.TypedDict";
    public static final String TYPED_DICT_EXT = "typing_extensions.TypedDict";
    public static final String TYPE_GUARD = "typing.TypeGuard";
    public static final String TYPE_GUARD_EXT = "typing_extensions.TypeGuard";
    public static final String TYPE_IS = "typing.TypeIs";
    public static final String TYPE_IS_EXT = "typing_extensions.TypeIs";
    public static final String GENERIC = "typing.Generic";
    public static final String PROTOCOL = "typing.Protocol";
    public static final String PROTOCOL_EXT = "typing_extensions.Protocol";
    public static final String TYPE = "typing.Type";
    public static final String ANY = "typing.Any";
    public static final String NEW_TYPE = "typing.NewType";
    public static final String CALLABLE = "typing.Callable";
    public static final String CALLABLE_EXT = "typing_extensions.Callable";
    public static final String MAPPING = "typing.Mapping";
    public static final String MAPPING_GET = "typing.Mapping.get";
    private static final String LIST = "typing.List";
    private static final String DICT = "typing.Dict";
    private static final String DEFAULT_DICT = "typing.DefaultDict";
    private static final String ORDERED_DICT = "typing.OrderedDict";
    private static final String SET = "typing.Set";
    private static final String FROZEN_SET = "typing.FrozenSet";
    private static final String COUNTER = "typing.Counter";
    private static final String DEQUE = "typing.Deque";
    private static final String TUPLE = "typing.Tuple";
    public static final String CLASS_VAR = "typing.ClassVar";
    public static final String TYPE_VAR = "typing.TypeVar";
    public static final String TYPE_VAR_EXT = "typing_extensions.TypeVar";
    public static final String TYPE_VAR_TUPLE = "typing.TypeVarTuple";
    public static final String TYPE_VAR_TUPLE_EXT = "typing_extensions.TypeVarTuple";
    public static final String PARAM_SPEC = "typing.ParamSpec";
    public static final String PARAM_SPEC_EXT = "typing_extensions.ParamSpec";
    private static final String CHAIN_MAP = "typing.ChainMap";
    public static final String UNION = "typing.Union";
    public static final String CONCATENATE = "typing.Concatenate";
    public static final String CONCATENATE_EXT = "typing_extensions.Concatenate";
    public static final String OPTIONAL = "typing.Optional";
    public static final String NO_RETURN = "typing.NoReturn";
    public static final String NEVER = "typing.Never";
    public static final String NO_RETURN_EXT = "typing_extensions.NoReturn";
    public static final String NEVER_EXT = "typing_extensions.Never";
    public static final String FINAL = "typing.Final";
    public static final String FINAL_EXT = "typing_extensions.Final";
    public static final String LITERAL = "typing.Literal";
    public static final String LITERAL_EXT = "typing_extensions.Literal";
    public static final String LITERALSTRING = "typing.LiteralString";
    public static final String LITERALSTRING_EXT = "typing_extensions.LiteralString";
    public static final String ANNOTATED = "typing.Annotated";
    public static final String ANNOTATED_EXT = "typing_extensions.Annotated";
    public static final String TYPE_ALIAS = "typing.TypeAlias";
    public static final String TYPE_ALIAS_EXT = "typing_extensions.TypeAlias";
    public static final String TYPE_ALIAS_TYPE = "typing.TypeAliasType";
    private static final String SPECIAL_FORM = "typing._SpecialForm";
    private static final String SPECIAL_FORM_EXT = "typing_extensions._SpecialForm";
    public static final String REQUIRED = "typing.Required";
    public static final String REQUIRED_EXT = "typing_extensions.Required";
    public static final String NOT_REQUIRED = "typing.NotRequired";
    public static final String NOT_REQUIRED_EXT = "typing_extensions.NotRequired";
    public static final String READONLY = "typing.ReadOnly";
    public static final String READONLY_EXT = "typing_extensions.ReadOnly";
    public static final Set<String> TYPE_PARAMETER_FACTORIES = Set.of("typing.TypeVar", "typing_extensions.TypeVar", "typing.ParamSpec", "typing_extensions.ParamSpec", "typing.TypeVarTuple", "typing_extensions.TypeVarTuple");
    public static final Set<String> TYPE_DICT_QUALIFIERS = Set.of("typing.Required", "typing_extensions.Required", "typing.NotRequired", "typing_extensions.NotRequired", "typing.ReadOnly", "typing_extensions.ReadOnly");
    public static final String UNPACK = "typing.Unpack";
    public static final String UNPACK_EXT = "typing_extensions.Unpack";
    public static final String SELF = "typing.Self";
    public static final String SELF_EXT = "typing_extensions.Self";
    public static final Pattern TYPE_IGNORE_PATTERN = Pattern.compile("#\\s*type:\\s*ignore\\s*(\\[[^]#]*])?($|(\\s.*))", 2);
    public static final String ASSERT_TYPE = "typing.assert_type";
    public static final String REVEAL_TYPE = "typing.reveal_type";
    public static final String REVEAL_TYPE_EXT = "typing_extensions.reveal_type";
    public static final String CAST = "typing.cast";
    public static final String CAST_EXT = "typing_extensions.cast";
    public static final ImmutableMap<String, String> BUILTIN_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"typing.List", (Object)"list").put((Object)"typing.Dict", (Object)"dict").put((Object)"typing.Set", (Object)"set").put((Object)"typing.FrozenSet", (Object)"frozenset").put((Object)"typing.Tuple", (Object)"tuple").build();
    private static final ImmutableMap<String, String> COLLECTIONS_CLASSES = ImmutableMap.builder().put((Object)"typing.DefaultDict", (Object)"collections.defaultdict").put((Object)"typing.OrderedDict", (Object)"collections.OrderedDict").put((Object)"typing.Counter", (Object)"collections.Counter").put((Object)"typing.Deque", (Object)"collections.deque").put((Object)"typing.ChainMap", (Object)"collections.ChainMap").build();
    public static final ImmutableMap<String, @NlsSafe String> TYPING_COLLECTION_CLASSES = ImmutableMap.builder().put((Object)"list", (Object)"List").put((Object)"dict", (Object)"Dict").put((Object)"set", (Object)"Set").put((Object)"frozenset", (Object)"FrozenSet").build();
    public static final ImmutableMap<String, String> TYPING_BUILTINS_GENERIC_ALIASES = ImmutableMap.builder().putAll((Iterable)TYPING_COLLECTION_CLASSES.entrySet()).put((Object)"type", (Object)"Type").put((Object)"tuple", (Object)"Tuple").build();
    public static final ImmutableSet<String> GENERIC_CLASSES = ImmutableSet.builder().add((Object[])new String[]{"typing.Tuple", "typing.Generic", "typing.Protocol", "typing.Callable", "typing_extensions.Callable", "typing.Type", "typing.ClassVar", "typing.Final", "typing.Literal", "typing.Annotated", "typing.Required", "typing.NotRequired", "typing.ReadOnly"}).add((Object[])new String[]{"typing.Union", "typing.Optional", "typing.List", "typing.Dict", "typing.DefaultDict", "typing.OrderedDict", "typing.Set", "typing.FrozenSet", "typing.Counter", "typing.Deque", "typing.ChainMap"}).add((Object[])new String[]{"typing_extensions.Protocol", "typing_extensions.Final", "typing_extensions.Literal", "typing_extensions.Annotated", "typing_extensions.Required", "typing_extensions.NotRequired", "typing_extensions.ReadOnly"}).build();
    public static final ImmutableSet<String> OPAQUE_NAMES = ImmutableSet.builder().add((Object)PyKnownDecorator.TYPING_OVERLOAD.getQualifiedName().toString()).add((Object)"typing.Any").add((Object)"typing.TypeVar").add((Object)"typing_extensions.TypeVar").add((Object)"typing.TypeVarTuple").add((Object)"typing_extensions.TypeVarTuple").add((Object)"typing.Generic").add((Object)"typing.ParamSpec").add((Object)"typing_extensions.ParamSpec").add((Object)"typing.Concatenate").add((Object)"typing_extensions.Concatenate").add((Object)"typing.Tuple").add((Object)"typing.Callable").add((Object)"typing_extensions.Callable").add((Object)"typing.Type").add((Object)PyKnownDecorator.TYPING_NO_TYPE_CHECK.getQualifiedName().toString()).add((Object)PyKnownDecorator.TYPING_NO_TYPE_CHECK_EXT.getQualifiedName().toString()).add((Object)"typing.Union").add((Object)"typing.Optional").add((Object)"typing.List").add((Object)"typing.Dict").add((Object)"typing.DefaultDict").add((Object)"typing.OrderedDict").add((Object)"typing.Set").add((Object)"typing.FrozenSet").add((Object[])new String[]{"typing.Protocol", "typing_extensions.Protocol"}).add((Object)"typing.ClassVar").add((Object)"typing.Counter").add((Object)"typing.Deque").add((Object)"typing.ChainMap").add((Object[])new String[]{"typing.NoReturn", "typing_extensions.NoReturn"}).add((Object[])new String[]{"typing.Never", "typing_extensions.Never"}).add((Object[])new String[]{"typing.Final", "typing_extensions.Final"}).add((Object[])new String[]{"typing.Literal", "typing_extensions.Literal"}).add((Object[])new String[]{"typing.TypedDict", "typing_extensions.TypedDict"}).add((Object[])new String[]{"typing.Annotated", "typing_extensions.Annotated"}).add((Object[])new String[]{"typing.TypeAlias", "typing_extensions.TypeAlias"}).add((Object[])new String[]{"typing.Required", "typing_extensions.Required"}).add((Object[])new String[]{"typing.NotRequired", "typing_extensions.NotRequired"}).add((Object[])new String[]{"typing.ReadOnly", "typing_extensions.ReadOnly"}).add((Object[])new String[]{"typing.Self", "typing_extensions.Self"}).add((Object[])new String[]{"typing.LiteralString", "typing_extensions.LiteralString"}).build();
    private static final Key<PsiElement> FRAGMENT_OWNER = Key.create((String)"PY_FRAGMENT_OWNER");
    private static final Key<Context> TYPE_HINT_EVAL_CONTEXT = Key.create((String)"TYPE_HINT_EVAL_CONTEXT");

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull Context context) {
        if (referenceExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(1);
        }
        if ("Generic".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolvesToQualifiedNames((PyExpression)referenceExpression, context.myContext, GENERIC)) {
            return PyTypingTypeProvider.createTypingGenericType((PsiElement)referenceExpression);
        }
        if ("Protocol".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolvesToQualifiedNames((PyExpression)referenceExpression, context.myContext, PROTOCOL, PROTOCOL_EXT)) {
            return PyTypingTypeProvider.createTypingProtocolType((PsiElement)referenceExpression);
        }
        if ("Callable".equals(referenceExpression.getName()) && PyTypingTypeProvider.resolvesToQualifiedNames((PyExpression)referenceExpression, context.myContext, CALLABLE, CALLABLE_EXT)) {
            return PyTypingTypeProvider.createTypingCallableType((PsiElement)referenceExpression);
        }
        return null;
    }

    @Override
    @Nullable
    public Ref<PyType> getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull Context context) {
        PyReferenceExpression ref;
        PyType type;
        PyFunctionTypeAnnotation annotation;
        String paramTypeCommentHint;
        PyExpression typeHint;
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(2);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(4);
        }
        if ((typeHint = PyTypingTypeProvider.getAnnotationValue((PyAnnotationOwner)param, context.myContext)) == null && (paramTypeCommentHint = param.getTypeCommentAnnotation()) != null) {
            typeHint = PyTypingTypeProvider.toExpression(paramTypeCommentHint, (PsiElement)param);
        }
        if (typeHint == null && (annotation = PyTypingTypeProvider.getFunctionTypeAnnotation(func)) != null) {
            PyExpression funcTypeCommentParamHint = PyTypingTypeProvider.findParamTypeHintInFunctionTypeComment(annotation, param, func);
            if (funcTypeCommentParamHint == null) {
                return Ref.create();
            }
            typeHint = funcTypeCommentParamHint;
        }
        if (typeHint == null) {
            return null;
        }
        if (param.isKeywordContainer() && (type = PyTypingTypeProvider.getTypeFromUnpackOperator((PsiElement)typeHint, context.myContext)) != null) {
            return type.get() instanceof PyTypedDictType ? type : null;
        }
        if (typeHint instanceof PyReferenceExpression && (ref = (PyReferenceExpression)typeHint).isQualified() && (param.isPositionalContainer() && "args".equals(ref.getReferencedName()) || param.isKeywordContainer() && "kwargs".equals(ref.getReferencedName()))) {
            typeHint = Objects.requireNonNull(ref.getQualifier());
        }
        type = (PyType)Ref.deref(PyTypingTypeProvider.getType(typeHint, context));
        if (param.isPositionalContainer() && !(type instanceof PyParamSpecType)) {
            return Ref.create((Object)PyTypeUtil.toPositionalContainerType((PsiElement)param, type));
        }
        if (param.isKeywordContainer() && !(type instanceof PyParamSpecType)) {
            return Ref.create((Object)PyTypeUtil.toKeywordContainerType((PsiElement)param, type));
        }
        if ("None".equals(param.getDefaultValueText())) {
            return Ref.create((Object)PyUnionType.union(type, (PyType)PyBuiltinCache.getInstance((PsiElement)param).getNoneType()));
        }
        return Ref.create((Object)type);
    }

    @Nullable
    private static PyExpression findParamTypeHintInFunctionTypeComment(@NotNull PyFunctionTypeAnnotation annotation, @NotNull PyNamedParameter param, @NotNull PyFunction func) {
        List<PyExpression> paramTypes;
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(5);
        }
        if (param == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(6);
        }
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(7);
        }
        if ((paramTypes = annotation.getParameterTypeList().getParameterTypes()).size() == 1 && paramTypes.get(0) instanceof PyEllipsisLiteralExpression) {
            return null;
        }
        int startOffset = PyTypingTypeProvider.omitFirstParamInTypeComment(func, annotation) ? 1 : 0;
        List<PyParameter> funcParams = Arrays.asList(func.getParameterList().getParameters());
        int i = funcParams.indexOf(param) - startOffset;
        if (i >= 0 && i < paramTypes.size()) {
            PyExpression paramTypeHint = paramTypes.get(i);
            if (paramTypeHint instanceof PyStarExpression) {
                PyStarExpression starExpression = (PyStarExpression)paramTypeHint;
                return starExpression.getExpression();
            }
            if (paramTypeHint instanceof PyDoubleStarExpression) {
                PyDoubleStarExpression doubleStarExpression = (PyDoubleStarExpression)paramTypeHint;
                return doubleStarExpression.getExpression();
            }
            return paramTypeHint;
        }
        return null;
    }

    public static boolean isGenerator(@NotNull PyType type) {
        PyCollectionType genericType;
        if (type == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(8);
        }
        return type instanceof PyCollectionType && GENERATOR.equals((genericType = (PyCollectionType)type).getClassQName());
    }

    @NotNull
    private static PyType createTypingGenericType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(9);
        }
        return new PyCustomType(GENERIC, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance(anchor).getObjectType()});
    }

    @NotNull
    private static PyType createTypingProtocolType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(10);
        }
        return new PyCustomType(PROTOCOL, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance(anchor).getObjectType()});
    }

    @NotNull
    public static PyType createTypingCallableType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(11);
        }
        return new PyCustomType(CALLABLE, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance(anchor).getObjectType()});
    }

    private static boolean omitFirstParamInTypeComment(@NotNull PyFunction func, @NotNull PyFunctionTypeAnnotation annotation) {
        if (func == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(12);
        }
        if (annotation == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(13);
        }
        return func.getContainingClass() != null && func.getModifier() != PyAstFunction.Modifier.STATICMETHOD && annotation.getParameterTypeList().getParameterTypes().size() < func.getParameterList().getParameters().length;
    }

    @Override
    @Nullable
    public Ref<PyType> getReturnType(@NotNull PyCallable callable, @NotNull Context context) {
        PyFunction function;
        PyExpression returnTypeAnnotation;
        if (callable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(15);
        }
        if (callable instanceof PyFunction && (returnTypeAnnotation = PyTypingTypeProvider.getReturnTypeAnnotation(function = (PyFunction)callable, context.myContext)) != null) {
            Ref<PyType> typeRef = PyTypingTypeProvider.getType(returnTypeAnnotation, context);
            if (typeRef != null) {
                if (function.isAsync() && function.isAsyncAllowed() && !function.isGenerator()) {
                    return Ref.create((Object)PyTypingTypeProvider.wrapInCoroutineType((PyType)typeRef.get(), (PsiElement)function));
                }
                return typeRef;
            }
            return Ref.create();
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyExpression getReturnTypeAnnotation(@NotNull PyFunction function, TypeEvalContext context) {
        PyExpression returnAnnotation;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(16);
        }
        if ((returnAnnotation = PyTypingTypeProvider.getAnnotationValue((PyAnnotationOwner)function, context)) != null) {
            return returnAnnotation;
        }
        PyFunctionTypeAnnotation functionAnnotation = PyTypingTypeProvider.getFunctionTypeAnnotation(function);
        if (functionAnnotation != null) {
            return functionAnnotation.getReturnType();
        }
        return null;
    }

    @Nullable
    public static PyFunctionTypeAnnotation getFunctionTypeAnnotation(@NotNull PyFunction function) {
        String comment;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(17);
        }
        if ((comment = function.getTypeCommentAnnotation()) == null) {
            return null;
        }
        PyFunctionTypeAnnotationFile file = (PyFunctionTypeAnnotationFile)((Object)CachedValuesManager.getCachedValue((PsiElement)function, () -> CachedValueProvider.Result.create((Object)((Object)new PyFunctionTypeAnnotationFile(function.getTypeCommentAnnotation(), (PsiElement)function)), (Object[])new Object[]{function})));
        return file.getAnnotation();
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull Context context) {
        String functionQName;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(18);
        }
        if (callSite == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(20);
        }
        if (CAST.equals(functionQName = function.getQualifiedName()) || CAST_EXT.equals(functionQName)) {
            return Optional.ofNullable(PyUtil.as(callSite, PyCallExpression.class)).map(PyCallExpression::getArguments).filter(args -> ((PyExpression[])args).length > 0).map(args -> PyTypingTypeProvider.getType(args[0], context)).orElse(null);
        }
        if (PyTypingTypeProvider.functionReturningCallSiteAsAType(function)) {
            return PyTypingTypeProvider.getAsClassObjectType((PyExpression)callSite, context);
        }
        return null;
    }

    private static boolean functionReturningCallSiteAsAType(@NotNull PyFunction function) {
        PyClass cls;
        String name;
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(21);
        }
        if ("__class_getitem__".equals(name = function.getName())) {
            return true;
        }
        if ("__getitem__".equals(name) && (cls = function.getContainingClass()) != null) {
            String qualifiedName = cls.getQualifiedName();
            return SPECIAL_FORM.equals(qualifiedName) || SPECIAL_FORM_EXT.equals(qualifiedName);
        }
        return false;
    }

    @Nullable
    private static PyType getTypedDictTypeForTarget(@NotNull PyTargetExpression referenceTarget, @NotNull TypeEvalContext context) {
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(23);
        }
        if (PyTypedDictTypeProvider.Companion.isTypedDict((PyExpression)referenceTarget, context)) {
            return new PyCustomType(TYPED_DICT, null, false, true, new PyClassLikeType[]{PyBuiltinCache.getInstance((PsiElement)referenceTarget).getDictType()});
        }
        return null;
    }

    @Override
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull Context context, @Nullable PsiElement anchor) {
        PyCollectionType parameterizedType;
        PyClass pyClass;
        if (referenceTarget == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(25);
        }
        if (referenceTarget instanceof PyTargetExpression) {
            Ref<PyType> annotatedType;
            PyTargetExpression resolvedTarget;
            PsiElement resolved;
            PyClass pyClass2;
            PyCallExpression callExpression;
            PyTargetExpression target = (PyTargetExpression)referenceTarget;
            String targetQName = target.getQualifiedName();
            if (GENERIC.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingGenericType((PsiElement)target));
            }
            if (PROTOCOL.equals(targetQName) || PROTOCOL_EXT.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingProtocolType((PsiElement)target));
            }
            if (CALLABLE.equals(targetQName) || CALLABLE_EXT.equals(targetQName)) {
                return Ref.create((Object)PyTypingTypeProvider.createTypingCallableType(referenceTarget));
            }
            PyType collection = PyTypingTypeProvider.getCollection((PsiElement)target, context.myContext);
            if (collection instanceof PyInstantiableType) {
                return Ref.create((Object)((PyInstantiableType)collection).toClass());
            }
            PyType typedDictType = PyTypingTypeProvider.getTypedDictTypeForTarget(target, context.myContext);
            if (typedDictType != null) {
                return Ref.create((Object)typedDictType);
            }
            PyExpression assignedValue = PyTypingAliasStubType.getAssignedValueStubLike(target);
            if (assignedValue instanceof PyCallExpression && (callExpression = (PyCallExpression)assignedValue).isCalleeText(new String[]{"TypeVar", "TypeVarTuple", "ParamSpec"})) {
                for (PsiElement element : PyTypingTypeProvider.tryResolving(Objects.requireNonNull(callExpression.getCallee()), context.myContext)) {
                    PyType pyType;
                    if (!(element instanceof PyClass) || !TYPE_PARAMETER_FACTORIES.contains(ObjectUtils.notNull((Object)(pyClass2 = (PyClass)element).getQualifiedName(), (Object)"")) || !((pyType = context.myContext.getType((PyTypedElement)pyClass2)) instanceof PyClassType)) continue;
                    PyClassType pyClassType = (PyClassType)pyType;
                    return Ref.create((Object)pyClassType.toInstance());
                }
            }
            if (target.isQualified() && context.myContext.maySwitchToAST((PsiElement)target) && (resolved = target.getReference(PyResolveContext.defaultContext((TypeEvalContext)context.myContext)).resolve()) instanceof PyTargetExpression && PyUtil.isAttribute(resolvedTarget = (PyTargetExpression)resolved)) {
                target = resolvedTarget;
            }
            if ((annotatedType = PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(target, context)) != null) {
                return annotatedType;
            }
            String name = target.getReferencedName();
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)target);
            if (name == null || scopeOwner == null) {
                return null;
            }
            pyClass2 = target.getContainingClass();
            if (target.isQualified()) {
                if (pyClass2 != null && scopeOwner instanceof PyFunction) {
                    PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context.myContext);
                    boolean isInstanceAttribute = context.myContext.maySwitchToAST((PsiElement)target) ? ((StreamEx)StreamEx.of(PyUtil.multiResolveTopPriority((PsiElement)target.getQualifier(), resolveContext)).select(PyParameter.class).filter(PyAstParameter::isSelf)).anyMatch(p -> PsiTreeUtil.getParentOfType((PsiElement)p, PyFunction.class) == scopeOwner) : PyUtil.isInstanceAttribute((PyExpression)target);
                    if (!isInstanceAttribute) {
                        return null;
                    }
                    Ref<PyType> memberType = PyTypingTypeProvider.getMemberTypeForClassType(context, target, name, resolveContext, false, new PyClassTypeImpl(pyClass2, true));
                    if (memberType != null) {
                        return memberType;
                    }
                    for (PyClass ancestor : pyClass2.getAncestorClasses(resolveContext.getTypeEvalContext())) {
                        Ref<PyType> ancestorMemberType = PyTypingTypeProvider.getMemberTypeForClassType(context, target, name, resolveContext, true, new PyClassTypeImpl(ancestor, false));
                        if (ancestorMemberType == null) continue;
                        return ancestorMemberType;
                    }
                    return null;
                }
            } else {
                StreamEx candidates = null;
                if (context.myContext.maySwitchToAST((PsiElement)target)) {
                    Scope scope = ControlFlowCache.getScope(scopeOwner);
                    candidates = StreamEx.of(scope.getNamedElements(name, false)).select(PyTargetExpression.class);
                } else if (scopeOwner instanceof PyFile) {
                    candidates = (StreamEx)StreamEx.of((Collection)((PyFile)scopeOwner).getTopLevelAttributes()).filter(t -> name.equals(t.getName()));
                } else if (scopeOwner instanceof PyClass) {
                    candidates = (StreamEx)StreamEx.of((Collection)((PyClass)scopeOwner).getClassAttributes()).filter(t -> name.equals(t.getName()));
                }
                if (candidates != null) {
                    return candidates.map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).nonNull().findFirst().orElse(null);
                }
            }
        }
        if (anchor instanceof PyExpression && referenceTarget instanceof PyClass && PyTypingTypeProvider.isGeneric((PyWithAncestors)(pyClass = (PyClass)referenceTarget), context.myContext) && (parameterizedType = PyTypingTypeProvider.parameterizeClassDefaultAware(pyClass, List.of(), context)) != null) {
            return Ref.create((Object)parameterizedType.toClass());
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getMemberTypeForClassType(@NotNull Context context, PyTargetExpression target, String name, PyResolveContext resolveContext, boolean isInherited, PyClassTypeImpl classType) {
        List<? extends RatedResolveResult> classAttrs;
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(26);
        }
        if ((classAttrs = classType.resolveMember(name, (PyExpression)target, AccessDirection.READ, resolveContext, isInherited)) == null) {
            return null;
        }
        return (Ref)((StreamEx)StreamEx.of(classAttrs).map(RatedResolveResult::getElement).select(PyTargetExpression.class).filter(x -> {
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)x);
            return owner instanceof PyClass || owner instanceof PyFunction;
        })).map(x -> PyTypingTypeProvider.getTypeFromTargetExpressionAnnotation(x, context)).collect(PyTypeUtil.toUnionFromRef());
    }

    @Nullable
    private static Ref<PyType> getTypeFromTargetExpressionAnnotation(@NotNull PyTargetExpression target, @NotNull Context context) {
        PyExpression annotation;
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(27);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(28);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue((PyAnnotationOwner)target, context.myContext)) != null) {
            return PyTypingTypeProvider.getType(annotation, context);
        }
        String comment = target.getTypeCommentAnnotation();
        if (comment != null) {
            return PyTypingTypeProvider.getVariableTypeCommentType(comment, target, context);
        }
        return null;
    }

    @Nullable
    public static String getTypeCommentValue(@NotNull String text) {
        if (text == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(29);
        }
        return PyUtilCore.getTypeCommentValue((String)text);
    }

    @Nullable
    public static TextRange getTypeCommentValueRange(@NotNull String text) {
        if (text == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(30);
        }
        return PyUtilCore.getTypeCommentValueRange((String)text);
    }

    @Override
    @Nullable
    public PyType getGenericType(@NotNull PyClass cls, @NotNull Context context) {
        List<PyTypeParameterType> typeParameters;
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(32);
        }
        return (typeParameters = PyTypingTypeProvider.collectTypeParameters(cls, context)).isEmpty() ? null : new PyCollectionTypeImpl(cls, false, typeParameters);
    }

    @Override
    @NotNull
    public Map<PyType, PyType> getGenericSubstitutions(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(34);
        }
        Map map = (Map)PyUtil.getParameterizedCachedValue((PsiElement)cls, context, c -> this.calculateGenericSubstitutions(cls, (Context)c));
        if (map == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(35);
        }
        return map;
    }

    @NotNull
    private Map<PyType, PyType> calculateGenericSubstitutions(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(37);
        }
        if (!PyTypingTypeProvider.isGeneric((PyWithAncestors)cls, context.myContext)) {
            Map<PyType, PyType> map = Collections.emptyMap();
            if (map == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(38);
            }
            return map;
        }
        HashMap<PyType, PyType> results = new HashMap<PyType, PyType>();
        for (PyClassType superClassType : PyTypingTypeProvider.evaluateSuperClassesAsTypeHints(cls, context.myContext)) {
            PyTypeParameterMapping mapping;
            List superTypeArguments;
            Map superSubstitutions = (Map)RecursionManager.doPreventingRecursion((Object)superClassType.getPyClass(), (boolean)false, () -> this.getGenericSubstitutions(superClassType.getPyClass(), context));
            if (superSubstitutions != null) {
                results.putAll(superSubstitutions);
            }
            List<PyTypeParameterType> superTypeParameters = PyTypingTypeProvider.collectTypeParameters(superClassType.getPyClass(), context);
            if (superClassType instanceof PyCollectionType) {
                PyCollectionType parameterized = (PyCollectionType)superClassType;
                v1 = parameterized.getElementTypes();
            } else {
                v1 = superTypeArguments = Collections.emptyList();
            }
            if ((mapping = PyTypeParameterMapping.mapByShape(superTypeParameters, superTypeArguments, PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY, PyTypeParameterMapping.Option.USE_DEFAULTS)) == null) continue;
            for (Couple<PyType> pair : mapping.getMappedTypes()) {
                PyType actualType;
                PyType expectedType = (PyType)pair.getFirst();
                if (expectedType.equals((Object)(actualType = (PyType)pair.getSecond()))) continue;
                results.put(expectedType, actualType);
            }
        }
        HashMap<PyType, PyType> hashMap = results;
        if (hashMap == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(39);
        }
        return hashMap;
    }

    @NotNull
    private static List<PyClassType> evaluateSuperClassesAsTypeHints(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(40);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(41);
        }
        ArrayList<PyClassType> results = new ArrayList<PyClassType>();
        for (PyExpression superClassExpression : PyClassElementType.getSuperClassExpressions(pyClass)) {
            PyType type;
            PsiFile containingFile = superClassExpression.getContainingFile();
            if (containingFile instanceof PyExpressionCodeFragment) {
                containingFile.putUserData(FRAGMENT_OWNER, (Object)pyClass);
            }
            if (!((type = (PyType)Ref.deref(PyTypingTypeProvider.getType(superClassExpression, context))) instanceof PyClassType)) continue;
            PyClassType classType = (PyClassType)type;
            results.add(classType);
        }
        ArrayList<PyClassType> arrayList = results;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyTypeParameterType> collectTypeParameters(@NotNull PyClass cls, @NotNull Context context) {
        if (cls == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(43);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(44);
        }
        if (!PyTypingTypeProvider.isGeneric((PyWithAncestors)cls, context.getTypeContext())) {
            List<PyTypeParameterType> list = Collections.emptyList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(45);
            }
            return list;
        }
        if (cls.getTypeParameterList() != null) {
            List typeParameters = cls.getTypeParameterList().getTypeParameters();
            List list = StreamEx.of((Collection)typeParameters).map(typeParameter -> PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter((PsiElement)typeParameter, context)).nonNull().toList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(46);
            }
            return list;
        }
        List<PySubscriptionExpression> parameterizedSuperClassExpressions = ContainerUtil.filterIsInstance(PyClassElementType.getSuperClassExpressions(cls), PySubscriptionExpression.class);
        PySubscriptionExpression genericAsSuperClass = (PySubscriptionExpression)ContainerUtil.find((Iterable)parameterizedSuperClassExpressions, s -> PyTypingTypeProvider.resolvesToQualifiedNames(s.getOperand(), context.myContext, GENERIC));
        List list = ((StreamEx)((StreamEx)StreamEx.of(genericAsSuperClass != null ? Collections.singletonList(genericAsSuperClass) : parameterizedSuperClassExpressions).peek(expr -> {
            PsiFile containingFile = expr.getContainingFile();
            if (containingFile instanceof PyExpressionCodeFragment) {
                containingFile.putUserData(FRAGMENT_OWNER, (Object)cls);
            }
        })).map(PySubscriptionExpression::getIndexExpression).flatMap(e -> {
            PyTupleExpression tupleExpr = PyUtil.as(e, PyTupleExpression.class);
            return tupleExpr != null ? StreamEx.of((Object[])tupleExpr.getElements()) : StreamEx.of((Object)e);
        }).nonNull().map(e -> PyTypingTypeProvider.getType(e, context)).map(Ref::deref).flatMap(type -> {
            PyTypeChecker.Generics typeParams = PyTypeChecker.collectGenerics(type, context.myContext);
            return StreamEx.of(typeParams.getTypeVars()).append(typeParams.getTypeVarTuples()).append((Stream)StreamEx.of(typeParams.getParamSpecs()));
        }).select(PyTypeParameterType.class).distinct()).toList();
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    private static List<PyTypeParameterType> collectTypeParametersFromTypeAliasStatement(@NotNull PyTypeAliasStatement typeAliasStatement, @NotNull Context context) {
        PyTypeParameterList typeParameterList;
        if (typeAliasStatement == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(48);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(49);
        }
        if ((typeParameterList = typeAliasStatement.getTypeParameterList()) != null) {
            List typeParameters = typeParameterList.getTypeParameters();
            List list = StreamEx.of((Collection)typeParameters).map(typeParameter -> PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter((PsiElement)typeParameter, context)).nonNull().toList();
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(50);
            }
            return list;
        }
        List<PyTypeParameterType> list = Collections.emptyList();
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(51);
        }
        return list;
    }

    public static boolean isGeneric(@NotNull PyWithAncestors descendant, @NotNull TypeEvalContext context) {
        PyClassType pyClassType;
        PyClass pyClass;
        if (descendant == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(52);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(53);
        }
        if (descendant instanceof PyClass && (pyClass = (PyClass)descendant).getTypeParameterList() != null || descendant instanceof PyClassType && (pyClassType = (PyClassType)descendant).getPyClass().getTypeParameterList() != null) {
            return true;
        }
        for (PyClassLikeType ancestor : descendant.getAncestorTypes(context)) {
            PyClassType classType;
            if (ancestor == null) continue;
            if (GENERIC_CLASSES.contains((Object)ancestor.getClassQName())) {
                return true;
            }
            if (!(ancestor instanceof PyClassType) || (classType = (PyClassType)ancestor).getPyClass().getTypeParameterList() == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(54);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(55);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, customContext -> PyTypingTypeProvider.getType(expression, customContext));
    }

    @Nullable
    private static Ref<PyType> getType(@NotNull PyExpression expression, @NotNull Context context) {
        PyType type;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(56);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(57);
        }
        if ((type = context.getKnownType(expression)) != null) {
            return Ref.create((Object)type);
        }
        for (Pair<PyQualifiedNameOwner, PsiElement> pair : PyTypingTypeProvider.tryResolvingWithAliases(expression, context.getTypeContext())) {
            Ref<PyType> typeRef = PyTypingTypeProvider.getTypeForResolvedElement(expression, (PyQualifiedNameOwner)pair.getFirst(), (PsiElement)pair.getSecond(), context);
            if (typeRef == null) continue;
            if (typeRef.get() != null) {
                context.assumeType(expression, (PyType)typeRef.get());
            }
            return typeRef;
        }
        return null;
    }

    private static boolean typeHasOverloadedBitwiseOr(@NotNull PyType type, @NotNull PyExpression expression, @NotNull Context context) {
        if (type == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(58);
        }
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(59);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(60);
        }
        if (!(type instanceof PyClassType)) {
            return false;
        }
        PyClassType classType = (PyClassType)type;
        TypeEvalContext typeContext = context.getTypeContext();
        PyClassLikeType metaClassType = classType.getMetaClassType(typeContext, true);
        if (metaClassType == null) {
            return false;
        }
        List resolved = metaClassType.resolveMember("__or__", expression, AccessDirection.READ, PyResolveContext.defaultContext((TypeEvalContext)typeContext));
        if (resolved == null || resolved.isEmpty()) {
            return false;
        }
        return StreamEx.of((Collection)resolved).map(it -> it.getElement()).nonNull().noneMatch(it -> PyBuiltinCache.getInstance(it).isBuiltin((PsiElement)it));
    }

    public static boolean isBitwiseOrUnionAvailable(@NotNull TypeEvalContext context) {
        PsiFile originFile;
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(61);
        }
        return (originFile = context.getOrigin()) == null || PyTypingTypeProvider.isBitwiseOrUnionAvailable((PsiElement)originFile);
    }

    public static boolean isBitwiseOrUnionAvailable(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(62);
        }
        if (LanguageLevel.forElement((PsiElement)element).isAtLeast(LanguageLevel.PYTHON310)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile && ((PyFile)file).hasImportFromFuture(FutureFeature.ANNOTATIONS)) {
            return file == element || PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Ref<PyType> getTypeForResolvedElement(@NotNull PyExpression typeHint, @Nullable PyQualifiedNameOwner alias, @NotNull PsiElement resolved, @NotNull Context context) {
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(63);
        }
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(64);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(65);
        }
        if (alias != null) {
            if (context.containsTypeAlias(alias)) {
                return null;
            }
            context.addTypeAlias(alias);
        }
        try {
            Ref<PyType> typeFromTypeAlias;
            Ref<PyType> typeHintFromProvider = PyTypeHintProvider.Companion.parseTypeHint(typeHint, alias, resolved, context.getTypeContext());
            if (typeHintFromProvider != null) {
                Ref<PyType> ref = typeHintFromProvider;
                return ref;
            }
            Ref<PyType> typeFromParenthesizedExpression = PyTypingTypeProvider.getTypeFromParenthesizedExpression(resolved, context);
            if (typeFromParenthesizedExpression != null) {
                Ref<PyType> ref = typeFromParenthesizedExpression;
                return ref;
            }
            if (alias != null && (typeFromTypeAlias = PyTypingTypeProvider.getTypeFromTypeAlias(alias, (PsiElement)typeHint, resolved, context)) != null) {
                Ref<PyType> ref = typeFromTypeAlias;
                return ref;
            }
            PyType neverType = PyTypingTypeProvider.getNeverType(resolved);
            if (neverType != null) {
                Ref ref = Ref.create((Object)neverType);
                return ref;
            }
            Ref<PyType> unionType = PyTypingTypeProvider.getUnionType(resolved, context);
            if (unionType != null) {
                Ref<PyType> ref = unionType;
                return ref;
            }
            PyType concatenateType = PyTypingTypeProvider.getConcatenateType(resolved, context);
            if (concatenateType != null) {
                Ref ref = Ref.create((Object)concatenateType);
                return ref;
            }
            Ref<PyType> optionalType = PyTypingTypeProvider.getOptionalType(resolved, context);
            if (optionalType != null) {
                Ref<PyType> ref = optionalType;
                return ref;
            }
            PyType callableType = PyTypingTypeProvider.getCallableType(resolved, context);
            if (callableType != null) {
                Ref ref = Ref.create((Object)callableType);
                return ref;
            }
            Ref<PyType> classVarType = PyTypingTypeProvider.unwrapTypeModifier(resolved, context, CLASS_VAR);
            if (classVarType != null) {
                Ref<PyType> ref = classVarType;
                return ref;
            }
            Ref<PyType> classObjType = PyTypingTypeProvider.getClassObjectType(resolved, context);
            if (classObjType != null) {
                Ref<PyType> ref = classObjType;
                return ref;
            }
            Ref<PyType> finalType = PyTypingTypeProvider.unwrapTypeModifier(resolved, context, FINAL, FINAL_EXT);
            if (finalType != null) {
                Ref<PyType> ref = finalType;
                return ref;
            }
            Ref<PyType> annotatedType = PyTypingTypeProvider.getAnnotatedType(resolved, context);
            if (annotatedType != null) {
                Ref<PyType> ref = annotatedType;
                return ref;
            }
            Ref<PyType> requiredOrNotRequiredType = PyTypingTypeProvider.getTypedDictSpecialItemType(resolved, context);
            if (requiredOrNotRequiredType != null) {
                Ref<PyType> ref = requiredOrNotRequiredType;
                return ref;
            }
            Ref<PyType> literalStringType = PyTypingTypeProvider.getLiteralStringType(resolved, context);
            if (literalStringType != null) {
                Ref<PyType> ref = literalStringType;
                return ref;
            }
            Ref<PyType> literalType = PyTypingTypeProvider.getLiteralType(resolved, context);
            if (literalType != null) {
                Ref<PyType> ref = literalType;
                return ref;
            }
            Ref<PyType> typeAliasType = PyTypingTypeProvider.getExplicitTypeAliasType(resolved);
            if (typeAliasType != null) {
                Ref<PyType> ref = typeAliasType;
                return ref;
            }
            Ref<PyType> narrowedType = PyTypingTypeProvider.getNarrowedType(resolved, context);
            if (narrowedType != null) {
                Ref<PyType> ref = narrowedType;
                return ref;
            }
            PyType parameterizedType = PyTypingTypeProvider.getParameterizedType(resolved, context);
            if (parameterizedType != null) {
                Ref ref = Ref.create((Object)parameterizedType);
                return ref;
            }
            PyType collection = PyTypingTypeProvider.getCollection(resolved, context.getTypeContext());
            if (collection != null) {
                Ref ref = Ref.create((Object)collection);
                return ref;
            }
            PyTypeParameterType typeParameter = PyTypingTypeProvider.getTypeParameterTypeFromDeclaration(resolved, context);
            if (typeParameter != null) {
                Ref ref = Ref.create((Object)PyTypingTypeProvider.anchorTypeParameter(typeHint, (PyType)typeParameter, context));
                return ref;
            }
            PyPositionalVariadicType unpackedType = PyTypingTypeProvider.getUnpackedType(resolved, context.getTypeContext());
            if (unpackedType != null) {
                Ref ref = Ref.create((Object)unpackedType);
                return ref;
            }
            PyTypeParameterType typeParameterType = PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter(resolved, context);
            if (typeParameterType != null) {
                Ref ref = Ref.create((Object)typeParameterType);
                return ref;
            }
            PyType callableParameterListType = PyTypingTypeProvider.getCallableParameterListType(resolved, context);
            if (callableParameterListType != null) {
                Ref ref = Ref.create((Object)callableParameterListType);
                return ref;
            }
            PyType stringBasedType = PyTypingTypeProvider.getStringLiteralType(resolved, context);
            if (stringBasedType != null) {
                Ref ref = Ref.create((Object)stringBasedType);
                return ref;
            }
            Ref<PyType> anyType = PyTypingTypeProvider.getAnyType(resolved);
            if (anyType != null) {
                Ref<PyType> ref = anyType;
                return ref;
            }
            PyTypedDictType typedDictType = PyTypedDictTypeProvider.Companion.getTypedDictTypeForResolvedElement(resolved, context.getTypeContext());
            if (typedDictType != null) {
                Ref ref = Ref.create((Object)((Object)typedDictType));
                return ref;
            }
            Ref<PyType> selfType = PyTypingTypeProvider.getSelfType(resolved, typeHint, context);
            if (selfType != null) {
                Ref<PyType> ref = selfType;
                return ref;
            }
            Ref<PyType> noneType = PyTypingTypeProvider.getNoneType(typeHint, resolved);
            if (noneType != null) {
                Ref<PyType> ref = noneType;
                return ref;
            }
            Ref<PyType> classType = PyTypingTypeProvider.getClassType(typeHint, resolved, context);
            if (classType != null) {
                Ref<PyType> ref = classType;
                return ref;
            }
            Ref<PyType> ref = null;
            return ref;
        }
        finally {
            if (alias != null) {
                context.removeTypeAlias(alias);
            }
        }
    }

    @Nullable
    private static Ref<PyType> getNoneType(@NotNull PyExpression typeHint, @NotNull PsiElement resolved) {
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(66);
        }
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(67);
        }
        if (typeHint instanceof PyNoneLiteralExpression || typeHint instanceof PyReferenceExpression && "None".equals(typeHint.getText())) {
            return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getNoneType());
        }
        return null;
    }

    @Nullable
    private static PyType getCallableParameterListType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(68);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(69);
        }
        if (resolved instanceof PyListLiteralExpression) {
            PyListLiteralExpression listLiteral = (PyListLiteralExpression)resolved;
            List argumentTypes = ContainerUtil.map((Object[])listLiteral.getElements(), defExpr -> (PyType)Ref.deref(PyTypingTypeProvider.getType(defExpr, context)));
            return new PyCallableParameterListTypeImpl(ContainerUtil.map((Collection)argumentTypes, PyCallableParameterImpl::nonPsi));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getNarrowedType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(71);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PyNarrowedType narrowedType;
            List<PyType> indexTypes;
            boolean isTypeGuard;
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)resolved;
            Collection<String> names = PyTypingTypeProvider.resolveToQualifiedNames(subscriptionExpr.getOperand(), context.getTypeContext());
            boolean isTypeIs = names.contains(TYPE_IS) || names.contains(TYPE_IS_EXT);
            boolean bl = isTypeGuard = names.contains(TYPE_GUARD) || names.contains(TYPE_GUARD_EXT);
            if ((isTypeIs || isTypeGuard) && (indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context)).size() == 1 && (narrowedType = PyNarrowedType.Companion.create((PyElement)subscriptionExpr, isTypeIs, indexTypes.get(0))) != null) {
                return Ref.create((Object)((Object)narrowedType));
            }
        }
        return null;
    }

    private static Ref<PyType> getSelfType(@NotNull PsiElement resolved, @NotNull PyExpression typeHint, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(72);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(73);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(74);
        }
        if (resolved instanceof PyQualifiedNameOwner && (SELF.equals(((PyQualifiedNameOwner)resolved).getQualifiedName()) || SELF_EXT.equals(((PyQualifiedNameOwner)resolved).getQualifiedName()))) {
            PyClass containingClass;
            PsiElement typeHintContext = PyTypingTypeProvider.getStubRetainedTypeHintContext((PsiElement)typeHint);
            PyClass pyClass = containingClass = typeHintContext instanceof PyClass ? (PyClass)typeHintContext : (PyClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)typeHintContext, PyClass.class);
            if (containingClass == null) {
                return null;
            }
            PyClassType scopeClassType = PyUtil.as(containingClass.getType(context.getTypeContext()), PyClassType.class);
            if (scopeClassType == null) {
                return null;
            }
            return Ref.create((Object)new PySelfType(scopeClassType));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromParenthesizedExpression(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(75);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(76);
        }
        if (resolved instanceof PyParenthesizedExpression) {
            PyExpression containedExpression = PyPsiUtils.flattenParens((PyExpression)((PyExpression)resolved));
            return containedExpression != null ? PyTypingTypeProvider.getType(containedExpression, context) : null;
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getExplicitTypeAliasType(@NotNull PsiElement resolved) {
        String qualifiedName;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(77);
        }
        if (resolved instanceof PyQualifiedNameOwner && (TYPE_ALIAS.equals(qualifiedName = ((PyQualifiedNameOwner)resolved).getQualifiedName()) || TYPE_ALIAS_EXT.equals(qualifiedName))) {
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static PyType anchorTypeParameter(@NotNull PyExpression typeHint, @Nullable PyType type, @NotNull Context context) {
        PyQualifiedNameOwner typeParamDefinitionFromStack;
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(78);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(79);
        }
        PyQualifiedNameOwner pyQualifiedNameOwner = typeParamDefinitionFromStack = context.isTypeAliasStackEmpty() ? null : context.peekTypeAlias();
        assert (typeParamDefinitionFromStack == null || typeParamDefinitionFromStack instanceof PyTargetExpression);
        PyTargetExpression targetExpr = (PyTargetExpression)typeParamDefinitionFromStack;
        if (type instanceof PyTypeVarTypeImpl) {
            PyTypeVarTypeImpl typeVar = (PyTypeVarTypeImpl)type;
            return typeVar.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(typeVar.getName(), typeHint, context)).withDeclarationElement((PyQualifiedNameOwner)targetExpr);
        }
        if (type instanceof PyParamSpecType) {
            PyParamSpecType paramSpec = (PyParamSpecType)type;
            return paramSpec.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(paramSpec.getName(), typeHint, context)).withDeclarationElement((PyQualifiedNameOwner)targetExpr);
        }
        if (type instanceof PyTypeVarTupleTypeImpl) {
            PyTypeVarTupleTypeImpl typeVarTuple = (PyTypeVarTupleTypeImpl)type;
            return typeVarTuple.withScopeOwner(PyTypingTypeProvider.getTypeParameterScope(typeVarTuple.getName(), typeHint, context)).withDeclarationElement((PyQualifiedNameOwner)targetExpr);
        }
        return type;
    }

    @Nullable
    private static Ref<PyType> getClassObjectType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(80);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(81);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PySubscriptionExpression subsExpr = (PySubscriptionExpression)resolved;
            PyExpression operand = subsExpr.getOperand();
            if (PyTypingTypeProvider.resolvesToQualifiedNames(operand, context.getTypeContext(), TYPE, "type")) {
                PyExpression indexExpr = subsExpr.getIndexExpression();
                if (indexExpr != null) {
                    if (PyTypingTypeProvider.resolvesToQualifiedNames(indexExpr, context.getTypeContext(), ANY)) {
                        return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
                    }
                    return PyTypingTypeProvider.getAsClassObjectType(indexExpr, context);
                }
                return Ref.create();
            }
        } else if (TYPE.equals(PyTypingTypeProvider.getQualifiedName(resolved))) {
            return Ref.create((Object)PyBuiltinCache.getInstance(resolved).getTypeType());
        }
        return null;
    }

    @NotNull
    private static Ref<PyType> getAsClassObjectType(@NotNull PyExpression expression, @NotNull Context context) {
        PyUnionType unionType;
        PyType type;
        PyClassType classType;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(82);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(83);
        }
        if ((classType = PyUtil.as(type = (PyType)Ref.deref(PyTypingTypeProvider.getType(expression, context)), PyClassType.class)) != null && !classType.isDefinition()) {
            Ref ref = Ref.create((Object)classType.toClass());
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(84);
            }
            return ref;
        }
        PyTypeVarType typeVar = PyUtil.as(type, PyTypeVarType.class);
        if (typeVar != null && !typeVar.isDefinition()) {
            Ref ref = Ref.create((Object)typeVar.toClass());
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(85);
            }
            return ref;
        }
        if (type instanceof PyUnionType && ContainerUtil.all((unionType = (PyUnionType)type).getMembers(), t -> {
            PyClassType clsType;
            return t instanceof PyClassType && !(clsType = (PyClassType)t).isDefinition();
        })) {
            Ref ref = Ref.create((Object)unionType.map(clsType -> ((PyClassType)clsType).toClass()));
            if (ref == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(86);
            }
            return ref;
        }
        Ref ref = Ref.create();
        if (ref == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(87);
        }
        return ref;
    }

    @Nullable
    private static Ref<PyType> getAnyType(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(88);
        }
        return ANY.equals(PyTypingTypeProvider.getQualifiedName(element)) ? Ref.create() : null;
    }

    @Nullable
    private static Ref<PyType> getClassType(@NotNull PyExpression typeHint, @NotNull PsiElement element, @NotNull Context context) {
        PyClassLikeType classLikeType;
        TypeEvalContext typeContext;
        PyType type;
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(89);
        }
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(90);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(91);
        }
        if (typeHint instanceof PyReferenceExpression && element instanceof PyTypedElement && (type = (typeContext = context.getTypeContext()).getType((PyTypedElement)element)) instanceof PyClassLikeType && (classLikeType = (PyClassLikeType)type).isDefinition()) {
            PsiElement stubRetainedContext = PyTypingTypeProvider.getStubRetainedTypeHintContext((PsiElement)typeHint);
            if (classLikeType instanceof PyClassType) {
                PyCollectionType parameterized;
                PySubscriptionExpression se;
                PsiElement psiElement;
                PyClassType classType = (PyClassType)classLikeType;
                if (!(stubRetainedContext instanceof PyClass || PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)stubRetainedContext, ScopeOwner.class) instanceof PyClass || (psiElement = typeHint.getParent()) instanceof PySubscriptionExpression && typeHint.equals((Object)(se = (PySubscriptionExpression)psiElement).getOperand()) || !PyTypingTypeProvider.isGeneric((PyWithAncestors)classType, context.myContext) || (parameterized = PyTypingTypeProvider.parameterizeClassDefaultAware(classType.getPyClass(), List.of(), context)) == null)) {
                    return Ref.create((Object)parameterized.toInstance());
                }
            }
            PyInstantiableType instanceType = classLikeType.toInstance();
            return Ref.create((Object)instanceType);
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getOptionalType(@NotNull PsiElement element, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(92);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(93);
        }
        if (element instanceof PySubscriptionExpression && PyTypingTypeProvider.resolvesToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context.getTypeContext(), OPTIONAL)) {
            Ref<PyType> typeRef;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null && (typeRef = PyTypingTypeProvider.getType(indexExpr, context)) != null) {
                return Ref.create((Object)PyUnionType.union((PyType)typeRef.get(), (PyType)PyBuiltinCache.getInstance(element).getNoneType()));
            }
            return Ref.create();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getLiteralStringType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(94);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(95);
        }
        if (resolved instanceof PyTargetExpression) {
            PyTargetExpression referenceExpression = (PyTargetExpression)resolved;
            if (PyTypingTypeProvider.resolvesToQualifiedNames((PyExpression)referenceExpression, context.getTypeContext(), LITERALSTRING, LITERALSTRING_EXT)) {
                return Ref.create((Object)PyLiteralStringType.Companion.create(resolved));
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getLiteralType(@NotNull PsiElement resolved, @NotNull Context context) {
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(96);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(97);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)resolved;
            if (PyTypingTypeProvider.resolvesToQualifiedNames(subscriptionExpr.getOperand(), context.getTypeContext(), LITERAL, LITERAL_EXT)) {
                return Optional.ofNullable(subscriptionExpr.getIndexExpression()).map(index -> PyLiteralType.Companion.fromLiteralParameter((PyExpression)index, context.getTypeContext())).map(Ref::create).orElse(null);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getAnnotatedType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(98);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(99);
        }
        if (resolved instanceof PySubscriptionExpression && PyTypingTypeProvider.resolvesToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext(), ANNOTATED, ANNOTATED_EXT)) {
            PyExpression type;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyExpression pyExpression = type = indexExpr instanceof PyTupleExpression ? ((PyTupleExpression)indexExpr).getElements()[0] : indexExpr;
            if (type != null) {
                return PyTypingTypeProvider.getType(type, context);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypedDictSpecialItemType(@NotNull PsiElement resolved, @NotNull Context context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(100);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(101);
        }
        if (resolved instanceof PySubscriptionExpression && PyTypingTypeProvider.resolvesToQualifiedNames(operand = (subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext(), REQUIRED, REQUIRED_EXT, NOT_REQUIRED, NOT_REQUIRED_EXT, READONLY, READONLY_EXT)) {
            PyExpression type;
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyExpression pyExpression = type = indexExpr instanceof PyTupleExpression ? ((PyTupleExpression)indexExpr).getElements()[0] : indexExpr;
            if (type != null) {
                return PyTypingTypeProvider.getType(type, context);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> unwrapTypeModifier(@NotNull PsiElement resolved, @NotNull Context context, String ... type) {
        PyExpression indexExpr;
        PySubscriptionExpression subscriptionExpr;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(102);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(103);
        }
        if (resolved instanceof PySubscriptionExpression && PyTypingTypeProvider.resolvesToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)resolved).getOperand(), context.getTypeContext(), type) && (indexExpr = subscriptionExpr.getIndexExpression()) != null) {
            return PyTypingTypeProvider.getType(indexExpr, context);
        }
        return null;
    }

    private static <T extends PyTypeCommentOwner & PyAnnotationOwner> boolean typeHintedWithName(@NotNull T owner, @NotNull TypeEvalContext context, String ... names) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(104);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(105);
        }
        return ContainerUtil.exists((Object[])names, PyTypingTypeProvider.resolveTypeHintsToQualifiedNames(owner, context)::contains);
    }

    private static <T extends PyTypeCommentOwner & PyAnnotationOwner> Collection<String> resolveTypeHintsToQualifiedNames(@NotNull T owner, @NotNull TypeEvalContext context) {
        PyExpression typeComment;
        PyStringLiteralExpression stringLiteralExpression;
        String annotationText;
        PyExpression annotation;
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(106);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(107);
        }
        if ((annotation = PyTypingTypeProvider.getAnnotationValue(owner, context)) instanceof PyStringLiteralExpression && (annotation = PyTypingTypeProvider.toExpression(annotationText = (stringLiteralExpression = (PyStringLiteralExpression)annotation).getStringValue(), owner)) == null) {
            return Collections.emptyList();
        }
        if (annotation instanceof PySubscriptionExpression) {
            PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)annotation;
            return PyTypingTypeProvider.resolveToQualifiedNames(pySubscriptionExpression.getOperand(), context);
        }
        if (annotation instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolveToQualifiedNames(annotation, context);
        }
        String typeCommentValue = owner.getTypeCommentAnnotation();
        PyExpression pyExpression = typeComment = typeCommentValue == null ? null : PyTypingTypeProvider.toExpression(typeCommentValue, owner);
        if (typeComment instanceof PySubscriptionExpression) {
            PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)typeComment;
            return PyTypingTypeProvider.resolveToQualifiedNames(pySubscriptionExpression.getOperand(), context);
        }
        if (typeComment instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolveToQualifiedNames(typeComment, context);
        }
        return Collections.emptyList();
    }

    public static boolean isFinal(@NotNull PyDecoratable decoratable, @NotNull TypeEvalContext context) {
        if (decoratable == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(108);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(109);
        }
        return ContainerUtil.exists(PyKnownDecoratorUtil.getKnownDecorators(decoratable, context), d -> d == PyKnownDecorator.TYPING_FINAL || d == PyKnownDecorator.TYPING_FINAL_EXT);
    }

    public static <T extends PyTypeCommentOwner & PyAnnotationOwner> boolean isFinal(@NotNull T owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(110);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(111);
        }
        return (Boolean)PyUtil.getParameterizedCachedValue(owner, context, p -> PyTypingTypeProvider.typeHintedWithName(owner, context, FINAL, FINAL_EXT));
    }

    public static <T extends PyAnnotationOwner & PyTypeCommentOwner> boolean isClassVar(@NotNull T owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(112);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(113);
        }
        return (Boolean)PyUtil.getParameterizedCachedValue(owner, context, p -> PyTypingTypeProvider.typeHintedWithName(owner, context, CLASS_VAR));
    }

    private static boolean resolvesToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context, String ... names) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(114);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(115);
        }
        Collection<String> qualifiedNames = PyTypingTypeProvider.resolveToQualifiedNames(expression, context);
        return ContainerUtil.exists((Object[])names, qualifiedNames::contains);
    }

    @ApiStatus.Internal
    @Nullable
    public static PyExpression getAnnotationValue(@NotNull PyAnnotationOwner owner, @NotNull TypeEvalContext context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(116);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(117);
        }
        if (context.maySwitchToAST((PsiElement)owner)) {
            PyAnnotation annotation = owner.getAnnotation();
            if (annotation != null) {
                return annotation.getValue();
            }
        } else {
            String annotationText = owner.getAnnotationValue();
            if (annotationText != null) {
                return PyTypingTypeProvider.toExpression(annotationText, (PsiElement)owner);
            }
        }
        return null;
    }

    @Nullable
    private static PyExpression toExpression(@NotNull String contents, @NotNull PsiElement anchor) {
        PsiFile file;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(118);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(119);
        }
        if ((file = FileContextUtil.getContextFile((PsiElement)anchor)) == null) {
            return null;
        }
        PyExpression fragment = PyUtil.createExpressionFromFragment(contents, (PsiElement)file);
        if (fragment != null) {
            fragment.getContainingFile().putUserData(FRAGMENT_OWNER, (Object)anchor);
        }
        return fragment;
    }

    @Nullable
    public static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(120);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(121);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(122);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, c -> PyTypingTypeProvider.getStringBasedType(contents, anchor, c));
    }

    @Nullable
    private static Ref<PyType> getStringBasedType(@NotNull String contents, @NotNull PsiElement anchor, @NotNull Context context) {
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(123);
        }
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(124);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(125);
        }
        return (Ref)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)anchor, (Object)contents), (boolean)true, () -> {
            PyExpression expr = PyTypingTypeProvider.toExpression(contents, anchor);
            return expr != null ? PyTypingTypeProvider.getType(expr, context) : null;
        });
    }

    @Nullable
    private static PyType getStringLiteralType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(126);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(127);
        }
        if (element instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)element;
            String contents = stringLiteral.getStringValue();
            return (PyType)Ref.deref(PyTypingTypeProvider.getStringBasedType((String)(contents.contains("\n") ? "(" + contents + ")" : contents), element, context));
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getVariableTypeCommentType(@NotNull String contents, @NotNull PyTargetExpression target, @NotNull Context context) {
        PyExpression expr;
        if (contents == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(128);
        }
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(129);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(130);
        }
        if ((expr = PyPsiUtils.flattenParens((PyExpression)PyTypingTypeProvider.toExpression(contents, (PsiElement)target))) != null) {
            if (expr instanceof PyTupleExpression) {
                Map<PyTargetExpression, PyExpression> targetToExpr;
                PyExpression typeExpr;
                PyExpression topmostTarget = PyTypingTypeProvider.findTopmostTarget(target);
                if (topmostTarget != null && (typeExpr = (targetToExpr = PyTypingTypeProvider.mapTargetsToAnnotations(topmostTarget, expr)).get(target)) != null) {
                    return PyTypingTypeProvider.getType(typeExpr, context);
                }
            } else {
                return PyTypingTypeProvider.getType(expr, context);
            }
        }
        return null;
    }

    @Nullable
    private static PyExpression findTopmostTarget(@NotNull PyTargetExpression target) {
        PyElement validTargetParent;
        if (target == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(131);
        }
        if ((validTargetParent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)target, (Class[])new Class[]{PyForPart.class, PyWithItem.class, PyAssignmentStatement.class})) == null) {
            return null;
        }
        PyExpression topmostTarget = PyUtil.as(PsiTreeUtil.findPrevParent((PsiElement)validTargetParent, (PsiElement)target), PyExpression.class);
        if (validTargetParent instanceof PyForPart && topmostTarget != ((PyForPart)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyWithItem && topmostTarget != ((PyWithItem)validTargetParent).getTarget()) {
            return null;
        }
        if (validTargetParent instanceof PyAssignmentStatement && ArrayUtil.indexOf((Object[])((PyAssignmentStatement)validTargetParent).getRawTargets(), (Object)topmostTarget) < 0) {
            return null;
        }
        return topmostTarget;
    }

    @NotNull
    public static Map<PyTargetExpression, PyExpression> mapTargetsToAnnotations(@NotNull PyExpression targetExpr, @NotNull PyExpression typeExpr) {
        if (targetExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(132);
        }
        if (typeExpr == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(133);
        }
        PyExpression targetsNoParen = PyPsiUtils.flattenParens((PyExpression)targetExpr);
        PyExpression typesNoParen = PyPsiUtils.flattenParens((PyExpression)typeExpr);
        if (targetsNoParen == null || typesNoParen == null) {
            Map<PyTargetExpression, PyExpression> map = Collections.emptyMap();
            if (map == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(134);
            }
            return map;
        }
        if (targetsNoParen instanceof PySequenceExpression && typesNoParen instanceof PySequenceExpression) {
            Ref result = new Ref(new LinkedHashMap());
            PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)targetsNoParen, (PySequenceExpression)typesNoParen, (Ref<Map<PyTargetExpression, PyExpression>>)result);
            Map<Object, Object> map = result.isNull() ? Collections.emptyMap() : Collections.unmodifiableMap((Map)result.get());
            if (map == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(135);
            }
            return map;
        }
        if (targetsNoParen instanceof PyTargetExpression && !(typesNoParen instanceof PySequenceExpression)) {
            ImmutableMap immutableMap = ImmutableMap.of((Object)((PyTargetExpression)targetsNoParen), (Object)typesNoParen);
            if (immutableMap == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(136);
            }
            return immutableMap;
        }
        Map<PyTargetExpression, PyExpression> map = Collections.emptyMap();
        if (map == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(137);
        }
        return map;
    }

    private static void mapTargetsToExpressions(@NotNull PySequenceExpression targetSequence, @NotNull PySequenceExpression valueSequence, @NotNull Ref<Map<PyTargetExpression, PyExpression>> result) {
        PyExpression[] values;
        PyExpression[] targets;
        if (targetSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(138);
        }
        if (valueSequence == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(139);
        }
        if (result == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(140);
        }
        if ((targets = targetSequence.getElements()).length != (values = valueSequence.getElements()).length) {
            result.set(null);
            return;
        }
        for (int i = 0; i < targets.length; ++i) {
            PyExpression target = PyPsiUtils.flattenParens((PyExpression)targets[i]);
            PyExpression value = PyPsiUtils.flattenParens((PyExpression)values[i]);
            if (target == null || value == null) {
                result.set(null);
                return;
            }
            if (target instanceof PySequenceExpression && value instanceof PySequenceExpression) {
                PyTypingTypeProvider.mapTargetsToExpressions((PySequenceExpression)target, (PySequenceExpression)value, result);
                if (!result.isNull()) continue;
                return;
            }
            if (target instanceof PyTargetExpression && !(value instanceof PySequenceExpression)) {
                Map map = (Map)result.get();
                assert (map != null);
                map.put((PyTargetExpression)target, value);
                continue;
            }
            result.set(null);
            return;
        }
    }

    @Nullable
    private static PyType getCallableType(@NotNull PsiElement resolved, @NotNull Context context) {
        PyTargetExpression targetExpression;
        if (resolved == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(141);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(142);
        }
        if (resolved instanceof PySubscriptionExpression) {
            PyTupleExpression tupleExpr;
            PyExpression[] elements;
            PyExpression indexExpr;
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)resolved;
            if (PyTypingTypeProvider.resolvesToQualifiedNames(subscriptionExpr.getOperand(), context.getTypeContext(), CALLABLE, CALLABLE_EXT) && (indexExpr = subscriptionExpr.getIndexExpression()) instanceof PyTupleExpression && (elements = (tupleExpr = (PyTupleExpression)indexExpr).getElements()).length == 2) {
                PyExpression parametersExpr = elements[0];
                PyExpression returnTypeExpr = elements[1];
                PyType returnType = (PyType)Ref.deref(PyTypingTypeProvider.getType(returnTypeExpr, context));
                if (returnType instanceof PyVariadicType) {
                    returnType = null;
                }
                if (parametersExpr instanceof PyEllipsisLiteralExpression) {
                    return new PyCallableTypeImpl(null, returnType);
                }
                PyType parametersType = (PyType)Ref.deref(PyTypingTypeProvider.getType(parametersExpr, context));
                if (parametersType instanceof PyCallableParameterListType) {
                    PyCallableParameterListType paramList = (PyCallableParameterListType)parametersType;
                    return new PyCallableTypeImpl(paramList.getParameters(), returnType);
                }
                if (parametersType instanceof PyParamSpecType || parametersType instanceof PyConcatenateType) {
                    PyCallableParameter paramSpecParam = PyCallableParameterImpl.nonPsi(parametersType);
                    return new PyCallableTypeImpl(Collections.singletonList(paramSpecParam), returnType);
                }
            }
        } else if (resolved instanceof PyTargetExpression && PyTypingTypeProvider.resolvesToQualifiedNames((PyExpression)(targetExpression = (PyTargetExpression)resolved), context.getTypeContext(), CALLABLE, CALLABLE_EXT)) {
            return new PyCallableTypeImpl(null, null);
        }
        return null;
    }

    @Nullable
    private static PyType getNeverType(@NotNull PsiElement element) {
        String qName;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(143);
        }
        if ((qName = PyTypingTypeProvider.getQualifiedName(element)) == null) {
            return null;
        }
        if (List.of(NEVER, NEVER_EXT).contains(qName)) {
            return PyNeverType.NEVER;
        }
        if (List.of(NO_RETURN, NO_RETURN_EXT).contains(qName)) {
            return PyNeverType.NO_RETURN;
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getUnionType(@NotNull PsiElement element, @NotNull Context context) {
        PyBinaryExpression expression;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(144);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(145);
        }
        if (element instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
            if (PyTypingTypeProvider.resolvesToQualifiedNames(subscriptionExpr.getOperand(), context.getTypeContext(), UNION)) {
                PyType union = PyUnionType.union(PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context));
                return union != null ? Ref.create((Object)union) : null;
            }
        } else if (element instanceof PyBinaryExpression && (expression = (PyBinaryExpression)element).getOperator() == PyTokenTypes.OR) {
            PyExpression left = expression.getLeftExpression();
            PyExpression right = expression.getRightExpression();
            if (left == null || right == null) {
                return null;
            }
            Ref<PyType> leftTypeRef = PyTypingTypeProvider.getType(left, context);
            Ref<PyType> rightTypeRef = PyTypingTypeProvider.getType(right, context);
            if (leftTypeRef == null || rightTypeRef == null) {
                return null;
            }
            PyType leftType = (PyType)leftTypeRef.get();
            if (leftType != null && PyTypingTypeProvider.typeHasOverloadedBitwiseOr(leftType, left, context)) {
                return null;
            }
            PyType union = PyUnionType.union(leftType, (PyType)rightTypeRef.get());
            return union != null ? Ref.create((Object)union) : null;
        }
        return null;
    }

    @Nullable
    private static PyType getConcatenateType(@NotNull PsiElement element, @NotNull Context context) {
        PyParamSpecType paramSpecType;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(146);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(147);
        }
        if (!(element instanceof PySubscriptionExpression)) {
            return null;
        }
        PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
        if (!PyTypingTypeProvider.resolvesToQualifiedNames(subscriptionExpr.getOperand(), context.myContext, CONCATENATE, CONCATENATE_EXT)) {
            return null;
        }
        PyExpression pyExpression = subscriptionExpr.getIndexExpression();
        if (!(pyExpression instanceof PyTupleExpression)) {
            return null;
        }
        PyTupleExpression tupleExpression = (PyTupleExpression)pyExpression;
        List<PyExpression> arguments = Arrays.asList(tupleExpression.getElements());
        if (arguments.size() < 2) {
            return null;
        }
        List<PyExpression> prefixTypeExprs = arguments.subList(0, arguments.size() - 1);
        List prefixTypes = ContainerUtil.map(prefixTypeExprs, it -> (PyType)Ref.deref(PyTypingTypeProvider.getType(it, context.myContext)));
        PyExpression lastTypeExpr = arguments.get(arguments.size() - 1);
        if (lastTypeExpr instanceof PyEllipsisLiteralExpression) {
            paramSpecType = null;
        } else {
            Object object = Ref.deref(PyTypingTypeProvider.getType(lastTypeExpr, context.myContext));
            if (object instanceof PyParamSpecType) {
                PyParamSpecType ps;
                paramSpecType = ps = (PyParamSpecType)object;
            } else {
                return null;
            }
        }
        return new PyConcatenateType(prefixTypes, paramSpecType);
    }

    @Nullable
    private static PyTypeParameterType getTypeParameterTypeFromDeclaration(@NotNull PsiElement element, @NotNull Context context) {
        PyExpression pyExpression;
        PyExpression[] arguments;
        PyCallExpression assignedCall;
        PyAstTypeParameter.Kind typeParameterKind;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(148);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(149);
        }
        if (element instanceof PyCallExpression && (typeParameterKind = PyTypingTypeProvider.getTypeParameterKindFromDeclaration(assignedCall = (PyCallExpression)element, context.getTypeContext())) != null && (arguments = assignedCall.getArguments()).length > 0 && (pyExpression = arguments[0]) instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression nameArgument = (PyStringLiteralExpression)pyExpression;
            String name = nameArgument.getStringValue();
            PyExpression defaultExpression = assignedCall.getKeywordArgument("default");
            Ref<PyType> defaultType = defaultExpression != null ? PyTypingTypeProvider.getType(defaultExpression, context) : null;
            switch (typeParameterKind) {
                case TypeVarTuple: {
                    Ref ref;
                    Object object;
                    PyTypeVarTupleTypeImpl pyTypeVarTupleTypeImpl = new PyTypeVarTupleTypeImpl(name);
                    if (defaultType != null && (object = Ref.deref(defaultType)) instanceof PyPositionalVariadicType) {
                        PyPositionalVariadicType posVariadic = (PyPositionalVariadicType)object;
                        ref = Ref.create((Object)posVariadic);
                    } else {
                        ref = null;
                    }
                    return pyTypeVarTupleTypeImpl.withDefaultType(ref);
                }
                case TypeVar: {
                    List<PyType> constraints = Stream.of(arguments).skip(1L).takeWhile(expr -> !(expr instanceof PyKeywordArgument)).map(expr -> (PyType)Ref.deref(PyTypingTypeProvider.getType(expr, context))).toList();
                    PyExpression boundExpression = assignedCall.getKeywordArgument("bound");
                    PyType bound = boundExpression == null ? null : (PyType)Ref.deref(PyTypingTypeProvider.getType(boundExpression, context));
                    PyTypeVarType.Variance variance = PyTypingTypeProvider.getTypeVarVarianceFromDeclaration(assignedCall);
                    return new PyTypeVarTypeImpl(name, constraints, bound, defaultType, variance);
                }
                case ParamSpec: {
                    Ref ref;
                    Object object;
                    PyParamSpecType pyParamSpecType = new PyParamSpecType(name);
                    if (defaultType != null && (object = Ref.deref(defaultType)) instanceof PyCallableParameterVariadicType) {
                        PyCallableParameterVariadicType paramVariadic = (PyCallableParameterVariadicType)object;
                        ref = Ref.create((Object)paramVariadic);
                    } else {
                        ref = null;
                    }
                    return pyParamSpecType.withDefaultType(ref);
                }
            }
        }
        return null;
    }

    @NotNull
    private static PyTypeVarType.Variance getTypeVarVarianceFromDeclaration(@NotNull PyCallExpression assignedCall) {
        if (assignedCall == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(150);
        }
        boolean covariant = PyEvaluator.evaluateAsBooleanNoResolve(assignedCall.getKeywordArgument("covariant"), false);
        boolean contravariant = PyEvaluator.evaluateAsBooleanNoResolve(assignedCall.getKeywordArgument("contravariant"), false);
        boolean inferVariance = PyEvaluator.evaluateAsBooleanNoResolve(assignedCall.getKeywordArgument("infer_variance"), false);
        if (covariant && !contravariant) {
            PyTypeVarType.Variance variance = PyTypeVarType.Variance.COVARIANT;
            if (variance == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(151);
            }
            return variance;
        }
        if (contravariant && !covariant) {
            PyTypeVarType.Variance variance = PyTypeVarType.Variance.CONTRAVARIANT;
            if (variance == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(152);
            }
            return variance;
        }
        if (inferVariance) {
            PyTypeVarType.Variance variance = PyTypeVarType.Variance.INFER_VARIANCE;
            if (variance == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(153);
            }
            return variance;
        }
        PyTypeVarType.Variance variance = PyTypeVarType.Variance.INVARIANT;
        if (variance == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(154);
        }
        return variance;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyAstTypeParameter.Kind getTypeParameterKindFromDeclaration(@NotNull PyCallExpression callExpression, @NotNull TypeEvalContext context) {
        PyExpression callee;
        if (callExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(155);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(156);
        }
        if ((callee = callExpression.getCallee()) != null) {
            Collection<String> calleeQNames = PyTypingTypeProvider.resolveToQualifiedNames(callee, context);
            if (calleeQNames.contains(TYPE_VAR_TUPLE) || calleeQNames.contains(TYPE_VAR_TUPLE_EXT)) {
                return PyAstTypeParameter.Kind.TypeVarTuple;
            }
            if (calleeQNames.contains(TYPE_VAR) || calleeQNames.contains(TYPE_VAR_EXT)) {
                return PyAstTypeParameter.Kind.TypeVar;
            }
            if (calleeQNames.contains(PARAM_SPEC) || calleeQNames.contains(PARAM_SPEC_EXT)) {
                return PyAstTypeParameter.Kind.ParamSpec;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyTypeParameterType getTypeParameterTypeFromTypeParameter(@NotNull PyTypeParameter typeParameter, @NotNull TypeEvalContext context) {
        if (typeParameter == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(157);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(158);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, c -> PyTypingTypeProvider.getTypeParameterTypeFromTypeParameter((PsiElement)typeParameter, c));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    private static PyTypeParameterType getTypeParameterTypeFromTypeParameter(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(159);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(160);
        }
        if (element instanceof PyTypeParameter) {
            PyQualifiedNameOwner qualifiedNameOwner;
            PyTypeParameter typeParameter = (PyTypeParameter)element;
            String name = typeParameter.getName();
            if (name == null) {
                return null;
            }
            ScopeOwner typeParameterOwner = ScopeUtil.getScopeOwner((PsiElement)typeParameter);
            PyQualifiedNameOwner scopeOwner = typeParameterOwner instanceof PyQualifiedNameOwner ? (qualifiedNameOwner = (PyQualifiedNameOwner)typeParameterOwner) : null;
            String defaultExpressionText = typeParameter.getDefaultExpressionText();
            PyExpression defaultExpression = defaultExpressionText != null ? PyUtil.createExpressionFromFragment(defaultExpressionText, (PsiElement)typeParameter) : null;
            Ref<PyType> defaultType = null;
            if (defaultExpression != null) {
                PyExpression defaultExprWithoutParens = PyPsiUtils.flattenParens((PyExpression)defaultExpression);
                defaultType = defaultExprWithoutParens != null ? PyTypingTypeProvider.getTypePreventingRecursion(defaultExprWithoutParens, context) : Ref.create();
            }
            PyQualifiedNameOwner declarationElement = PyUtil.as(element, PyQualifiedNameOwner.class);
            switch (typeParameter.getKind()) {
                case TypeVar: {
                    PyExpression boundExpression;
                    @Nullable List constraints = List.of();
                    PyType boundType = null;
                    String boundExpressionText = typeParameter.getBoundExpressionText();
                    PyExpression pyExpression = boundExpression = boundExpressionText != null ? PyPsiUtils.flattenParens((PyExpression)PyUtil.createExpressionFromFragment(boundExpressionText, (PsiElement)typeParameter)) : null;
                    if (boundExpression instanceof PyTupleExpression) {
                        PyTupleExpression tupleExpression = (PyTupleExpression)boundExpression;
                        constraints = ContainerUtil.map((Object[])tupleExpression.getElements(), expr -> (PyType)Ref.deref(PyTypingTypeProvider.getTypePreventingRecursion(expr, context)));
                    } else if (boundExpression != null) {
                        boundType = (PyType)Ref.deref(PyTypingTypeProvider.getTypePreventingRecursion(boundExpression, context));
                    }
                    return new PyTypeVarTypeImpl(name, constraints, boundType, defaultType, PyTypeVarType.Variance.INFER_VARIANCE).withScopeOwner(scopeOwner).withDeclarationElement(declarationElement);
                }
                case ParamSpec: {
                    Ref ref;
                    PyParamSpecType pyParamSpecType = new PyParamSpecType(name).withScopeOwner(scopeOwner);
                    Object object = Ref.deref(defaultType);
                    if (object instanceof PyCallableParameterVariadicType) {
                        PyCallableParameterVariadicType variadicType = (PyCallableParameterVariadicType)object;
                        ref = Ref.create((Object)variadicType);
                    } else {
                        ref = null;
                    }
                    return pyParamSpecType.withDefaultType(ref).withDeclarationElement(declarationElement);
                }
                case TypeVarTuple: {
                    Ref ref;
                    PyTypeVarTupleTypeImpl pyTypeVarTupleTypeImpl = new PyTypeVarTupleTypeImpl(name).withScopeOwner(scopeOwner);
                    Object object = Ref.deref(defaultType);
                    if (object instanceof PyPositionalVariadicType) {
                        PyPositionalVariadicType variadicType = (PyPositionalVariadicType)object;
                        ref = Ref.create((Object)variadicType);
                    } else {
                        ref = null;
                    }
                    return pyTypeVarTupleTypeImpl.withDefaultType(ref).withDeclarationElement(declarationElement);
                }
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypePreventingRecursion(@NotNull PyExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(161);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(162);
        }
        return (Ref)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, () -> PyTypingTypeProvider.getType(expression, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PyQualifiedNameOwner getTypeParameterScope(@NotNull String name, @NotNull PyExpression typeHint, @NotNull Context context) {
        PyExpression pyExpression;
        PyExpression assignedValue;
        Optional typeParameterType;
        if (name == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(163);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(164);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(165);
        }
        if (!context.isComputeTypeParameterScopeEnabled()) {
            return null;
        }
        PsiElement typeHintContext = PyTypingTypeProvider.getStubRetainedTypeHintContext((PsiElement)typeHint);
        List typeParamOwnerCandidates = ((StreamEx)StreamEx.iterate((Object)typeHintContext, Objects::nonNull, owner -> PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)owner, ScopeOwner.class)).filter(owner -> owner instanceof PyFunction || owner instanceof PyClass)).select(PyQualifiedNameOwner.class).toList();
        PyQualifiedNameOwner closestOwner = (PyQualifiedNameOwner)ContainerUtil.getFirstItem((List)typeParamOwnerCandidates);
        if (closestOwner instanceof PyFunction && (typeParameterType = ((StreamEx)StreamEx.of((Collection)typeParamOwnerCandidates).skip(1L)).map(owner -> PyTypingTypeProvider.findSameTypeParameterInDefinition(owner, name, context)).nonNull().findFirst()).isPresent()) {
            return ((PyTypeParameterType)typeParameterType.get()).getScopeOwner();
        }
        if (closestOwner != null) {
            boolean prevComputeTypeParameterScope = context.setComputeTypeParameterScopeEnabled(false);
            try {
                PyQualifiedNameOwner pyQualifiedNameOwner = PyTypingTypeProvider.findSameTypeParameterInDefinition(closestOwner, name, context) != null ? closestOwner : null;
                return pyQualifiedNameOwner;
            }
            finally {
                context.setComputeTypeParameterScopeEnabled(prevComputeTypeParameterScope);
            }
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)typeHintContext, PyAssignmentStatement.class, (boolean)false, (Class[])new Class[]{PyStatement.class});
        if (assignment != null && PsiTreeUtil.isAncestor((PsiElement)(assignedValue = PyPsiUtils.flattenParens((PyExpression)assignment.getAssignedValue())), (PsiElement)typeHintContext, (boolean)false) && (pyExpression = PyPsiUtils.flattenParens((PyExpression)assignment.getLeftHandSideExpression())) instanceof PyTargetExpression) {
            PyCallExpression callExpr;
            boolean isTypeParamDeclaration;
            PyTargetExpression target = (PyTargetExpression)pyExpression;
            boolean bl = isTypeParamDeclaration = assignedValue instanceof PyCallExpression && PyTypingTypeProvider.getTypeParameterKindFromDeclaration(callExpr = (PyCallExpression)assignedValue, context.getTypeContext()) != null;
            if (!isTypeParamDeclaration && PyTypingAliasStubType.looksLikeTypeHint(assignedValue)) {
                return target;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PyTypeParameterType findSameTypeParameterInDefinition(@NotNull PyQualifiedNameOwner owner, @NotNull String name, @NotNull Context context) {
        if (owner == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(166);
        }
        if (name == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(167);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(168);
        }
        if (context.isTypeAliasStackEmpty()) {
            return null;
        }
        PyQualifiedNameOwner typeVarDeclaration = context.popTypeAlias();
        assert (typeVarDeclaration instanceof PyTargetExpression);
        try {
            Iterable<Object> typeParameters;
            if (owner instanceof PyClass) {
                PyClass cls = (PyClass)owner;
                typeParameters = PyTypingTypeProvider.collectTypeParameters(cls, context);
            } else if (owner instanceof PyFunction) {
                PyFunction function = (PyFunction)owner;
                typeParameters = PyTypingTypeProvider.collectTypeParameters(function, context.getTypeContext());
            } else {
                typeParameters = List.of();
            }
            PyTypeParameterType pyTypeParameterType = (PyTypeParameterType)ContainerUtil.find(typeParameters, type -> name.equals(type.getName()));
            return pyTypeParameterType;
        }
        finally {
            context.pushTypeAlias(typeVarDeclaration);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Iterable<PyTypeParameterType> collectTypeParameters(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(169);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(170);
        }
        StreamEx streamEx = StreamEx.of((Object[])function.getParameterList().getParameters()).select(PyNamedParameter.class).map(parameter -> ((PyTypeProviderWithCustomContext)new PyTypingTypeProvider()).getParameterType((PyNamedParameter)parameter, function, context)).append(((PyTypeProviderWithCustomContext)new PyTypingTypeProvider()).getReturnType((PyCallable)function, context)).map(Ref::deref).map(paramType -> PyTypeChecker.collectGenerics(paramType, context)).flatMap(generics -> StreamEx.of(generics.getTypeVars()).append(generics.getParamSpecs()).append(generics.getTypeVarTuples()));
        if (streamEx == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(171);
        }
        return streamEx;
    }

    @NotNull
    private static PsiElement getStubRetainedTypeHintContext(@NotNull PsiElement typeHintExpression) {
        PsiFile containingFile;
        PsiElement fragmentOwner;
        if (typeHintExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(172);
        }
        if ((fragmentOwner = (PsiElement)(containingFile = typeHintExpression.getContainingFile()).getUserData(FRAGMENT_OWNER)) != null) {
            PsiElement psiElement = fragmentOwner;
            if (psiElement == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(173);
            }
            return psiElement;
        }
        if (containingFile instanceof PyFunctionTypeAnnotationFile || containingFile instanceof PyTypeHintFile) {
            PsiElement psiElement = PyPsiUtils.getRealContext((PsiElement)typeHintExpression);
            if (psiElement == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(174);
            }
            return psiElement;
        }
        PsiElement psiElement = typeHintExpression;
        if (psiElement == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(175);
        }
        return psiElement;
    }

    @Nullable
    public static PyPositionalVariadicType getUnpackedType(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        Ref<PyType> typeRef;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(176);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(177);
        }
        if ((typeRef = PyTypingTypeProvider.getTypeFromStarExpression(element, context)) == null) {
            typeRef = PyTypingTypeProvider.getTypeFromUnpackOperator(element, context);
        }
        if (typeRef == null) {
            return null;
        }
        PyType expressionType = (PyType)typeRef.get();
        if (expressionType instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)expressionType;
            return new PyUnpackedTupleTypeImpl(tupleType.getElementTypes(), tupleType.isHomogeneous());
        }
        if (expressionType instanceof PyTypeVarTupleType) {
            PyTypeVarTupleType typeVarTupleType = (PyTypeVarTupleType)expressionType;
            return typeVarTupleType;
        }
        return null;
    }

    @Nullable
    private static @Nullable Ref<@Nullable PyType> getTypeFromUnpackOperator(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PySubscriptionExpression subscriptionExpr;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(178);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(179);
        }
        if (!(element instanceof PySubscriptionExpression) || !PyTypingTypeProvider.resolvesToQualifiedNames((subscriptionExpr = (PySubscriptionExpression)element).getOperand(), context, UNPACK, UNPACK_EXT)) {
            return null;
        }
        PyExpression indexExpression = subscriptionExpr.getIndexExpression();
        if (!(indexExpression instanceof PyReferenceExpression) && !(indexExpression instanceof PySubscriptionExpression)) {
            return null;
        }
        return Ref.create((Object)((PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpression, context))));
    }

    @Nullable
    private static @Nullable Ref<@Nullable PyType> getTypeFromStarExpression(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(180);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(181);
        }
        if (!(element instanceof PyStarExpression)) {
            return null;
        }
        PyStarExpression starExpression = (PyStarExpression)element;
        PyExpression starredExpression = starExpression.getExpression();
        if (!(starredExpression instanceof PyReferenceExpression) && !(starredExpression instanceof PySubscriptionExpression)) {
            return null;
        }
        return Ref.create((Object)((PyType)Ref.deref(PyTypingTypeProvider.getType(starredExpression, context))));
    }

    @NotNull
    private static List<PyType> getIndexTypes(@NotNull PySubscriptionExpression expression, @NotNull Context context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(182);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(183);
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        PyExpression indexExpr = expression.getIndexExpression();
        if (indexExpr instanceof PyTupleExpression) {
            PyTupleExpression tupleExpr = (PyTupleExpression)indexExpr;
            for (PyExpression expr : tupleExpr.getElements()) {
                types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(expr, context)));
            }
        } else if (indexExpr != null) {
            types.add((PyType)Ref.deref(PyTypingTypeProvider.getType(indexExpr, context)));
        }
        ArrayList<PyType> arrayList = types;
        if (arrayList == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(184);
        }
        return arrayList;
    }

    @Nullable
    private static PyCollectionType parameterizeClassDefaultAware(@NotNull PyClass pyClass, @NotNull List<PyType> actualTypeParams, @NotNull Context context) {
        PyType parameterizedType;
        PyCollectionType genericDefinitionType;
        if (pyClass == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(185);
        }
        if (actualTypeParams == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(186);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(187);
        }
        if ((genericDefinitionType = (PyCollectionType)RecursionManager.doPreventingRecursion((Object)pyClass, (boolean)false, () -> PyTypeChecker.findGenericDefinitionType(pyClass, context.getTypeContext()))) != null && ContainerUtil.exists(genericDefinitionType.getElementTypes(), t -> {
            PyTypeParameterType typeParameterType;
            return t instanceof PyTypeParameterType && (typeParameterType = (PyTypeParameterType)t).getDefaultType() != null;
        }) && (parameterizedType = PyTypeChecker.parameterizeType((PyType)genericDefinitionType, actualTypeParams, context.myContext)) instanceof PyCollectionType) {
            PyCollectionType collectionType = (PyCollectionType)parameterizedType;
            return collectionType;
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromTypeAlias(@NotNull PyQualifiedNameOwner alias, @NotNull PsiElement typeHint, @NotNull PsiElement element, @NotNull Context context) {
        if (alias == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(188);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(189);
        }
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(190);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(191);
        }
        if (element instanceof PyExpression) {
            PyExpression assignedExpression = (PyExpression)element;
            if (alias instanceof PyTypeAliasStatement) {
                PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)alias;
                return PyTypingTypeProvider.getTypeFromTypeAliasStatement(typeAliasStatement, typeHint, assignedExpression, context);
            }
            @Nullable Ref<PyType> assignedTypeRef = PyTypingTypeProvider.getType(assignedExpression, context);
            if (assignedTypeRef != null) {
                @Nullable PyType assignedType = (PyType)assignedTypeRef.get();
                if (assignedType == null) {
                    return assignedTypeRef;
                }
                if (typeHint instanceof PySubscriptionExpression) {
                    PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)typeHint;
                    List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                    return Ref.create((Object)PyTypeChecker.parameterizeType(assignedType, indexTypes, context.myContext));
                }
                if (typeHint instanceof PyReferenceExpression && !(assignedType instanceof PyTypeParameterType)) {
                    List<PyTypeParameterType> typeAliasTypeParams = PyTypeChecker.collectGenerics(assignedType, context.getTypeContext()).getAllTypeParameters();
                    if (!typeAliasTypeParams.isEmpty()) {
                        return Ref.create((Object)PyTypeChecker.parameterizeType(assignedType, List.of(), context.myContext));
                    }
                    return Ref.create((Object)assignedType);
                }
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getTypeFromTypeAliasStatement(@NotNull PyTypeAliasStatement typeAliasStatement, @NotNull PsiElement typeHint, @NotNull PyExpression assignedExpression, @NotNull Context context) {
        Ref<PyType> assignedTypeRef;
        if (typeAliasStatement == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(192);
        }
        if (typeHint == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(193);
        }
        if (assignedExpression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(194);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(195);
        }
        if ((assignedTypeRef = PyTypingTypeProvider.getType(assignedExpression, context)) != null) {
            List<Object> list;
            PyType assignedType = (PyType)assignedTypeRef.get();
            if (assignedType == null) {
                return assignedTypeRef;
            }
            if (typeHint instanceof PySubscriptionExpression) {
                PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)typeHint;
                list = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
            } else {
                list = Collections.emptyList();
            }
            List indexTypes = list;
            List<PyTypeParameterType> typeAliasTypeParams = PyTypingTypeProvider.collectTypeParametersFromTypeAliasStatement(typeAliasStatement, context);
            if (!typeAliasTypeParams.isEmpty()) {
                PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.mapTypeParametersToSubstitutions(typeAliasTypeParams, indexTypes, PyTypeParameterMapping.Option.USE_DEFAULTS, PyTypeParameterMapping.Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY);
                return substitutions != null ? Ref.create((Object)PyTypeChecker.substitute(assignedType, substitutions, context.myContext)) : null;
            }
            return assignedTypeRef;
        }
        return null;
    }

    @Nullable
    private static PyType getParameterizedType(@NotNull PsiElement element, @NotNull Context context) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(196);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(197);
        }
        if (element instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)element;
            PyExpression operand = subscriptionExpr.getOperand();
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            if (indexExpr != null) {
                PyType operandType = (PyType)Ref.deref(PyTypingTypeProvider.getType(operand, context));
                List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                if (operandType != null) {
                    if (operandType instanceof PyClassType) {
                        PyClassType classType = (PyClassType)operandType;
                        if (!(operandType instanceof PyTupleType) && "tuple".equals(classType.getPyClass().getQualifiedName())) {
                            PyExpression[] elements;
                            if (indexExpr instanceof PyTupleExpression && (elements = ((PyTupleExpression)indexExpr).getElements()).length == 2 && elements[1] instanceof PyEllipsisLiteralExpression) {
                                return PyTupleType.createHomogeneous(element, indexTypes.get(0));
                            }
                            return PyTupleType.create(element, indexTypes);
                        }
                        if (PyTypingTypeProvider.isGeneric((PyWithAncestors)classType, context.myContext)) {
                            PyCollectionType parameterizedType = PyTypingTypeProvider.parameterizeClassDefaultAware(classType.getPyClass(), indexTypes, context);
                            if (parameterizedType != null) {
                                return parameterizedType.toInstance();
                            }
                        } else {
                            return null;
                        }
                    }
                    return PyTypeChecker.parameterizeType(operandType, indexTypes, context.getTypeContext());
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getCollection(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        String typingName;
        String builtinName;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(198);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(199);
        }
        if ((builtinName = (String)BUILTIN_COLLECTION_CLASSES.get((Object)(typingName = PyTypingTypeProvider.getQualifiedName(element)))) != null) {
            return PyTypeParser.getTypeByName(element, builtinName, context);
        }
        String collectionName = (String)COLLECTIONS_CLASSES.get((Object)typingName);
        if (collectionName != null) {
            return PyTypeParser.getTypeByName(element, collectionName, context);
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> tryResolving(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(200);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(201);
        }
        List list = ContainerUtil.map(PyTypingTypeProvider.tryResolvingWithAliases(expression, context), x -> (PsiElement)x.getSecond());
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(202);
        }
        return list;
    }

    @NotNull
    private static List<Pair<PyQualifiedNameOwner, PsiElement>> tryResolvingWithAliases(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(203);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(204);
        }
        ArrayList<Pair<PyQualifiedNameOwner, PsiElement>> elements = new ArrayList<Pair<PyQualifiedNameOwner, PsiElement>>();
        if (expression instanceof PyReferenceExpression) {
            List<PsiElement> results;
            if (context.maySwitchToAST((PsiElement)expression)) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
                results = PyUtil.multiResolveTopPriority((PsiElement)expression, resolveContext);
            } else {
                results = PyTypingTypeProvider.tryResolvingOnStubs((PyReferenceExpression)expression, context);
            }
            for (PsiElement element : results) {
                PyTargetExpression targetExpr;
                PyExpression assignedValue;
                String name;
                PyClass cls = PyUtil.turnConstructorIntoClass(PyUtil.as(element, PyFunction.class));
                if (cls != null) {
                    elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create(null, (Object)cls));
                    continue;
                }
                String string = name = element != null ? PyTypingTypeProvider.getQualifiedName(element) : null;
                if (name != null && OPAQUE_NAMES.contains((Object)name)) {
                    elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create(null, (Object)element));
                    continue;
                }
                if (element instanceof PyTargetExpression && (assignedValue = context.maySwitchToAST((PsiElement)(targetExpr = (PyTargetExpression)element)) ? targetExpr.findAssignedValue() : PyTypingAliasStubType.getAssignedValueStubLike(targetExpr)) != null) {
                    elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create((Object)targetExpr, (Object)assignedValue));
                    continue;
                }
                if (element instanceof PyTypeAliasStatement) {
                    PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)element;
                    if (context.maySwitchToAST((PsiElement)typeAliasStatement)) {
                        assignedValue = typeAliasStatement.getTypeExpression();
                    } else {
                        String assignedTypeText = typeAliasStatement.getTypeExpressionText();
                        PyExpression pyExpression = assignedValue = assignedTypeText != null ? PyTypingTypeProvider.toExpression(assignedTypeText, (PsiElement)typeAliasStatement) : null;
                    }
                    if (assignedValue != null) {
                        elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create((Object)typeAliasStatement, (Object)assignedValue));
                        continue;
                    }
                }
                if (element == null) continue;
                elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create(null, (Object)element));
            }
        }
        if (expression instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)expression;
            PyExpression operandExpression = subscriptionExpr.getOperand();
            List<Pair<PyQualifiedNameOwner, PsiElement>> results = PyTypingTypeProvider.tryResolvingWithAliases(operandExpression, context);
            for (Pair<PyQualifiedNameOwner, PsiElement> pair : results) {
                if (pair.getFirst() == null || pair.getSecond() == null) continue;
                elements.add((Pair<PyQualifiedNameOwner, PsiElement>)Pair.create((Object)((PyQualifiedNameOwner)pair.getFirst()), (Object)((PsiElement)pair.getSecond())));
            }
        }
        List<Object> list = !elements.isEmpty() ? elements : Collections.singletonList(Pair.create(null, (Object)expression));
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(205);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> tryResolvingOnStubs(@NotNull PyReferenceExpression expression, @NotNull TypeEvalContext context) {
        PyFile scopeOwner;
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(206);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(207);
        }
        QualifiedName qualifiedName = expression.asQualifiedName();
        PyFile pyFile = PyUtil.as(FileContextUtil.getContextFile((PsiElement)expression), PyFile.class);
        PsiElement anchor = (PsiElement)expression.getContainingFile().getUserData(FRAGMENT_OWNER);
        if (anchor == null) {
            scopeOwner = pyFile;
        } else if (anchor instanceof ScopeOwner) {
            ScopeOwner anchorAsScope = (ScopeOwner)anchor;
            scopeOwner = anchorAsScope;
        } else {
            scopeOwner = ScopeUtil.getScopeOwner(anchor);
        }
        if (scopeOwner != null && qualifiedName != null) {
            List<PsiElement> list = PyResolveUtil.resolveQualifiedNameInScope(qualifiedName, (ScopeOwner)scopeOwner, context);
            if (list == null) {
                PyTypingTypeProvider.$$$reportNull$$$0(208);
            }
            return list;
        }
        List<PyReferenceExpression> list = Collections.singletonList(expression);
        if (list == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(209);
        }
        return list;
    }

    @NotNull
    public static Collection<String> resolveToQualifiedNames(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(210);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(211);
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PsiElement resolved : PyTypingTypeProvider.tryResolving(expression, context)) {
            String name = PyTypingTypeProvider.getQualifiedName(resolved);
            if (name == null) continue;
            names.add(name);
        }
        LinkedHashSet<String> linkedHashSet = names;
        if (linkedHashSet == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(212);
        }
        return linkedHashSet;
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(213);
        }
        if (element instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)element;
            return qualifiedNameOwner.getQualifiedName();
        }
        return null;
    }

    @Nullable
    public static PyType toAsyncIfNeeded(@NotNull PyFunction function, @Nullable PyType returnType) {
        if (function == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(214);
        }
        if (function.isAsync() && function.isAsyncAllowed()) {
            if (!function.isGenerator()) {
                return PyTypingTypeProvider.wrapInCoroutineType(returnType, (PsiElement)function);
            }
            GeneratorTypeDescriptor desc = GeneratorTypeDescriptor.fromGenerator(returnType);
            if (desc != null) {
                PyClass classType = PyPsiFacade.getInstance((Project)function.getProject()).createClassByQName(ASYNC_GENERATOR, (PsiElement)function);
                List<PyType> generics = Arrays.asList(desc.yieldType, desc.sendType);
                return classType != null ? new PyCollectionTypeImpl(classType, false, generics) : null;
            }
        }
        return returnType;
    }

    @Nullable
    public static PyType removeNarrowedTypeIfNeeded(@Nullable PyType type) {
        PyNarrowedType pyNarrowedType;
        if (type instanceof PyNarrowedType && (pyNarrowedType = (PyNarrowedType)type).isBound()) {
            return PyBuiltinCache.getInstance((PsiElement)pyNarrowedType.getOriginal()).getBoolType();
        }
        return type;
    }

    @Nullable
    private static PyType wrapInCoroutineType(@Nullable PyType returnType, @NotNull PsiElement resolveAnchor) {
        PyClass coroutine;
        if (resolveAnchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(215);
        }
        return (coroutine = PyPsiFacade.getInstance((Project)resolveAnchor.getProject()).createClassByQName(COROUTINE, resolveAnchor)) != null ? new PyCollectionTypeImpl(coroutine, false, Arrays.asList(null, null, returnType)) : null;
    }

    @Nullable
    public static PyType wrapInGeneratorType(@Nullable PyType elementType, @Nullable PyType sendType, @Nullable PyType returnType, @NotNull PsiElement anchor) {
        PyClass generator;
        if (anchor == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(216);
        }
        return (generator = PyPsiFacade.getInstance((Project)anchor.getProject()).createClassByQName(GENERATOR, anchor)) != null ? new PyCollectionTypeImpl(generator, false, Arrays.asList(elementType, sendType, returnType)) : null;
    }

    @Nullable
    public static Ref<PyType> unwrapCoroutineReturnType(@Nullable PyType coroutineType) {
        PyCollectionType genericType = PyUtil.as(coroutineType, PyCollectionType.class);
        if (genericType != null) {
            String qName = genericType.getClassQName();
            if (AWAITABLE.equals(qName)) {
                return Ref.create((Object)((PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)0, null)));
            }
            if (COROUTINE.equals(qName)) {
                return Ref.create((Object)((PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)2, null)));
            }
        }
        return null;
    }

    @Nullable
    public static Ref<PyType> coroutineOrGeneratorElementType(@Nullable PyType coroutineOrGeneratorType) {
        PyCollectionType genericType = PyUtil.as(coroutineOrGeneratorType, PyCollectionType.class);
        PyClassType classType = PyUtil.as(coroutineOrGeneratorType, PyClassType.class);
        if (genericType != null && classType != null) {
            String qName = classType.getClassQName();
            if (AWAITABLE.equals(qName)) {
                return Ref.create((Object)((PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)0, null)));
            }
            if (ArrayUtil.contains((String)qName, (String[])new String[]{COROUTINE, GENERATOR})) {
                return Ref.create((Object)((PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)2, null)));
            }
        }
        return null;
    }

    public static boolean isExplicitTypeAlias(@NotNull PyAssignmentStatement assignment, @NotNull TypeEvalContext context) {
        PyExpression commentValue;
        String typeCommentAnnotation;
        PyExpression annotationValue;
        if (assignment == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(217);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(218);
        }
        if ((annotationValue = PyTypingTypeProvider.getAnnotationValue((PyAnnotationOwner)assignment, context)) instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolvesToQualifiedNames(annotationValue, context, TYPE_ALIAS, TYPE_ALIAS_EXT);
        }
        PyTargetExpression target = PyUtil.as(ArrayUtil.getFirstElement((Object[])assignment.getTargets()), PyTargetExpression.class);
        if (target != null && (typeCommentAnnotation = target.getTypeCommentAnnotation()) != null && (commentValue = PyTypingTypeProvider.toExpression(typeCommentAnnotation, (PsiElement)assignment)) instanceof PyReferenceExpression) {
            return PyTypingTypeProvider.resolvesToQualifiedNames(commentValue, context, TYPE_ALIAS, TYPE_ALIAS_EXT);
        }
        return false;
    }

    public static boolean isInsideTypeHint(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        PsiElement realContext;
        if (element == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(219);
        }
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(220);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)(realContext = PyPsiUtils.getRealContext((PsiElement)element)), PyAnnotation.class, (boolean)false, (Class[])new Class[]{PyStatement.class}) != null) {
            return true;
        }
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)realContext, PsiComment.class, (boolean)false, (Class[])new Class[]{PyStatement.class});
        if (comment != null && PyTypingTypeProvider.getTypeCommentValue(comment.getText()) != null) {
            return true;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)realContext, PyAssignmentStatement.class, (boolean)false, (Class[])new Class[]{PyStatement.class});
        if (assignment != null && PsiTreeUtil.isAncestor((PsiElement)assignment.getAssignedValue(), (PsiElement)realContext, (boolean)false) && PyTypingTypeProvider.isExplicitTypeAlias(assignment, context)) {
            return true;
        }
        PyTypeAliasStatement typeAlias = (PyTypeAliasStatement)PsiTreeUtil.getParentOfType((PsiElement)realContext, PyTypeAliasStatement.class, (boolean)false, (Class[])new Class[]{PyStatement.class});
        return typeAlias != null && PsiTreeUtil.isAncestor((PsiElement)typeAlias.getTypeExpression(), (PsiElement)realContext, (boolean)false);
    }

    @Override
    protected <T> T withCustomContext(@NotNull TypeEvalContext context, @NotNull @NotNull Function<@NotNull Context, T> delegate) {
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(221);
        }
        if (delegate == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(222);
        }
        return PyTypingTypeProvider.staticWithCustomContext(context, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T staticWithCustomContext(@NotNull TypeEvalContext context, @NotNull @NotNull Function<@NotNull Context, T> delegate) {
        Context customContext;
        boolean firstEntrance;
        if (context == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(223);
        }
        if (delegate == null) {
            PyTypingTypeProvider.$$$reportNull$$$0(224);
        }
        boolean bl = firstEntrance = (customContext = (Context)context.getProcessingContext().get(TYPE_HINT_EVAL_CONTEXT)) == null;
        if (firstEntrance) {
            customContext = new Context(context);
            context.getProcessingContext().put(TYPE_HINT_EVAL_CONTEXT, (Object)customContext);
        }
        try {
            T t = delegate.apply(customContext);
            return t;
        }
        finally {
            if (firstEntrance) {
                context.getProcessingContext().put(TYPE_HINT_EVAL_CONTEXT, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 35, 38, 39, 42, 45, 46, 47, 50, 51, 84, 85, 86, 87, 134, 135, 136, 137, 151, 152, 153, 154, 171, 173, 174, 175, 184, 202, 205, 208, 209, 212 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 37: 
            case 41: 
            case 44: 
            case 49: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 61: 
            case 65: 
            case 69: 
            case 71: 
            case 74: 
            case 76: 
            case 79: 
            case 81: 
            case 83: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 117: 
            case 122: 
            case 125: 
            case 127: 
            case 130: 
            case 142: 
            case 145: 
            case 147: 
            case 149: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 165: 
            case 168: 
            case 170: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 187: 
            case 191: 
            case 195: 
            case 197: 
            case 199: 
            case 201: 
            case 204: 
            case 207: 
            case 211: 
            case 218: 
            case 220: 
            case 221: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 8: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 119: 
            case 121: 
            case 124: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 169: 
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 27: 
            case 129: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 35: 
            case 38: 
            case 39: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 171: 
            case 173: 
            case 174: 
            case 175: 
            case 184: 
            case 202: 
            case 205: 
            case 208: 
            case 209: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 40: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 48: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAliasStatement";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 54: 
            case 56: 
            case 59: 
            case 82: 
            case 114: 
            case 161: 
            case 182: 
            case 200: 
            case 203: 
            case 206: 
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 62: 
            case 88: 
            case 90: 
            case 92: 
            case 126: 
            case 143: 
            case 144: 
            case 146: 
            case 148: 
            case 159: 
            case 176: 
            case 178: 
            case 180: 
            case 190: 
            case 196: 
            case 198: 
            case 213: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 63: 
            case 66: 
            case 73: 
            case 78: 
            case 89: 
            case 164: 
            case 189: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHint";
                break;
            }
            case 64: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 77: 
            case 80: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 104: 
            case 106: 
            case 110: 
            case 112: 
            case 116: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 118: 
            case 120: 
            case 123: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetExpr";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpr";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSequence";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSequence";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedCall";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 163: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHintExpression";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParams";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedExpression";
                break;
            }
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveAnchor";
                break;
            }
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 222: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericSubstitutions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateGenericSubstitutions";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSuperClassesAsTypeHints";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeParameters";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeParametersFromTypeAliasStatement";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsClassObjectType";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "mapTargetsToAnnotations";
                break;
            }
            case 151: 
            case 152: 
            case 153: 
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVarVarianceFromDeclaration";
                break;
            }
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubRetainedTypeHintContext";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexTypes";
                break;
            }
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolving";
                break;
            }
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingWithAliases";
                break;
            }
            case 208: 
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolvingOnStubs";
                break;
            }
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToQualifiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findParamTypeHintInFunctionTypeComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGenerator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTypingGenericType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTypingProtocolType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTypingCallableType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "omitFirstParamInTypeComment";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeAnnotation";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "functionReturningCallSiteAsAType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypedDictTypeForTarget";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMemberTypeForClassType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTargetExpressionAnnotation";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValue";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentValueRange";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getGenericType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSubstitutions";
                break;
            }
            case 35: 
            case 38: 
            case 39: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 171: 
            case 173: 
            case 174: 
            case 175: 
            case 184: 
            case 202: 
            case 205: 
            case 208: 
            case 209: 
            case 212: {
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "calculateGenericSubstitutions";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSuperClassesAsTypeHints";
                break;
            }
            case 43: 
            case 44: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeParameters";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeParametersFromTypeAliasStatement";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isGeneric";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "typeHasOverloadedBitwiseOr";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isBitwiseOrUnionAvailable";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForResolvedElement";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getNoneType";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getCallableParameterListType";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getSelfType";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromParenthesizedExpression";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeAliasType";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "anchorTypeParameter";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectType";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getAsClassObjectType";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getAnyType";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralStringType";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralType";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedType";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getTypedDictSpecialItemType";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "unwrapTypeModifier";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "typeHintedWithName";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeHintsToQualifiedNames";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isClassVar";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToQualifiedNames";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "toExpression";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getStringBasedType";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralType";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeCommentType";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostTarget";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToAnnotations";
                break;
            }
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "mapTargetsToExpressions";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getCallableType";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "getNeverType";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenateType";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterTypeFromDeclaration";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVarVarianceFromDeclaration";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterKindFromDeclaration";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterTypeFromTypeParameter";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "getTypePreventingRecursion";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterScope";
                break;
            }
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "findSameTypeParameterInDefinition";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "getStubRetainedTypeHintContext";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "getUnpackedType";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromUnpackOperator";
                break;
            }
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromStarExpression";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "getIndexTypes";
                break;
            }
            case 185: 
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "parameterizeClassDefaultAware";
                break;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeAlias";
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeAliasStatement";
                break;
            }
            case 196: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedType";
                break;
            }
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "getCollection";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "tryResolving";
                break;
            }
            case 203: 
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingWithAliases";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "tryResolvingOnStubs";
                break;
            }
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "resolveToQualifiedNames";
                break;
            }
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "toAsyncIfNeeded";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCoroutineType";
                break;
            }
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "wrapInGeneratorType";
                break;
            }
            case 217: 
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitTypeAlias";
                break;
            }
            case 219: 
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "isInsideTypeHint";
                break;
            }
            case 221: 
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "withCustomContext";
                break;
            }
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "staticWithCustomContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 35, 38, 39, 42, 45, 46, 47, 50, 51, 84, 85, 86, 87, 134, 135, 136, 137, 151, 152, 153, 154, 171, 173, 174, 175, 184, 202, 205, 208, 209, 212 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class Context {
        @NotNull
        private final TypeEvalContext myContext;
        @NotNull
        private final Stack<PyQualifiedNameOwner> myTypeAliasStack;
        private boolean myComputeTypeParameterScope;
        @NotNull
        private HashValue128 myContextStrongHashValue;

        private Context(@NotNull TypeEvalContext context) {
            if (context == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myTypeAliasStack = new Stack();
            this.myComputeTypeParameterScope = true;
            this.myContext = context;
            this.recomputeStrongHashValue();
        }

        @NotNull
        public TypeEvalContext getTypeContext() {
            TypeEvalContext typeEvalContext = this.myContext;
            if (typeEvalContext == null) {
                Context.$$$reportNull$$$0(1);
            }
            return typeEvalContext;
        }

        @NotNull
        public Stack<PyQualifiedNameOwner> getTypeAliasStack() {
            Stack<PyQualifiedNameOwner> stack = this.myTypeAliasStack;
            if (stack == null) {
                Context.$$$reportNull$$$0(2);
            }
            return stack;
        }

        public boolean containsTypeAlias(@NotNull PyQualifiedNameOwner alias) {
            if (alias == null) {
                Context.$$$reportNull$$$0(3);
            }
            return this.myTypeAliasStack.contains((Object)alias);
        }

        public void addTypeAlias(@NotNull PyQualifiedNameOwner alias) {
            if (alias == null) {
                Context.$$$reportNull$$$0(4);
            }
            this.myTypeAliasStack.add((Object)alias);
            this.recomputeStrongHashValue();
        }

        public void removeTypeAlias(@NotNull PyQualifiedNameOwner alias) {
            if (alias == null) {
                Context.$$$reportNull$$$0(5);
            }
            this.myTypeAliasStack.remove((Object)alias);
            this.recomputeStrongHashValue();
        }

        public boolean isTypeAliasStackEmpty() {
            return this.myTypeAliasStack.isEmpty();
        }

        @Nullable
        public PyQualifiedNameOwner peekTypeAlias() {
            return this.myTypeAliasStack.isEmpty() ? null : (PyQualifiedNameOwner)this.myTypeAliasStack.peek();
        }

        public void pushTypeAlias(@NotNull PyQualifiedNameOwner alias) {
            if (alias == null) {
                Context.$$$reportNull$$$0(6);
            }
            this.myTypeAliasStack.push((Object)alias);
            this.recomputeStrongHashValue();
        }

        @Nullable
        public PyQualifiedNameOwner popTypeAlias() {
            PyQualifiedNameOwner res = this.myTypeAliasStack.isEmpty() ? null : (PyQualifiedNameOwner)this.myTypeAliasStack.pop();
            this.recomputeStrongHashValue();
            return res;
        }

        public boolean isComputeTypeParameterScopeEnabled() {
            return this.myComputeTypeParameterScope;
        }

        public boolean setComputeTypeParameterScopeEnabled(boolean value) {
            boolean prev = this.myComputeTypeParameterScope;
            this.myComputeTypeParameterScope = value;
            this.recomputeStrongHashValue();
            return prev;
        }

        @Nullable
        public PyType getKnownType(@NotNull PyExpression expression) {
            if (expression == null) {
                Context.$$$reportNull$$$0(7);
            }
            return (PyType)this.myContext.getContextTypeCache().get(new Pair((Object)expression, (Object)this.getContextStrongHashValue()));
        }

        public void assumeType(@NotNull PyExpression expression, @NotNull PyType type) {
            if (expression == null) {
                Context.$$$reportNull$$$0(8);
            }
            if (type == null) {
                Context.$$$reportNull$$$0(9);
            }
            this.myContext.getContextTypeCache().put(new Pair((Object)expression, (Object)this.getContextStrongHashValue()), type);
        }

        private void recomputeStrongHashValue() {
            this.myContextStrongHashValue = Hashing.xxh3_128().hashCharsTo128Bits((CharSequence)Stream.concat(Stream.of(this.myComputeTypeParameterScope ? "1" : "0"), this.myTypeAliasStack.stream().map(it -> it.getQualifiedName())).collect(Collectors.joining("#")));
        }

        @NotNull
        private HashValue128 getContextStrongHashValue() {
            HashValue128 hashValue128 = this.myContextStrongHashValue;
            if (hashValue128 == null) {
                Context.$$$reportNull$$$0(10);
            }
            return hashValue128;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            return Objects.equals(this.myContext, context.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alias";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeAliasStack";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextStrongHashValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 10: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "containsTypeAlias";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addTypeAlias";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeTypeAlias";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "pushTypeAlias";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getKnownType";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "assumeType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 10 -> new IllegalStateException(string);
            };
        }
    }

    public record GeneratorTypeDescriptor(@Nullable PyType yieldType, @Nullable PyType sendType, @Nullable PyType returnType, boolean isAsync) {
        @Nullable
        public static GeneratorTypeDescriptor fromGenerator(@Nullable PyType type) {
            PyClassType returnType;
            if (!(type instanceof PyClassType)) {
                return null;
            }
            PyClassType classType = (PyClassType)type;
            String qName = classType.getClassQName();
            if (qName == null) {
                return null;
            }
            boolean isAsync = PyTypingTypeProvider.ASYNC_GENERATOR.equals(qName);
            if (!isAsync && !PyTypingTypeProvider.GENERATOR.equals(qName)) {
                return null;
            }
            PyClassType noneType = PyBuiltinCache.getInstance((PsiElement)classType.getPyClass()).getNoneType();
            PyType yieldType = null;
            PyClassType sendType = noneType;
            PyClassType pyClassType = returnType = isAsync ? null : noneType;
            if (type instanceof PyCollectionType) {
                PyCollectionType genericType = (PyCollectionType)type;
                yieldType = (PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)0, yieldType);
                sendType = (PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)1, (Object)sendType);
                returnType = (PyType)ContainerUtil.getOrElse(genericType.getElementTypes(), (int)2, (Object)returnType);
            }
            return new GeneratorTypeDescriptor(yieldType, (PyType)sendType, (PyType)returnType, isAsync);
        }

        @Nullable
        public static GeneratorTypeDescriptor fromGeneratorOrProtocol(@Nullable PyType type, @NotNull TypeEvalContext context) {
            if (context == null) {
                GeneratorTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (!(type instanceof PyClassType)) {
                return null;
            }
            PyClassType classType = (PyClassType)type;
            GeneratorTypeDescriptor desc = GeneratorTypeDescriptor.fromGenerator(type);
            if (desc != null) {
                return desc;
            }
            if (PyProtocolsKt.isProtocol((PyClassLikeType)classType, context)) {
                PyType syncUpcast = PyTypeUtil.convertToType((PyType)classType, "typing.Iterable", (PsiElement)classType.getPyClass(), context);
                if (syncUpcast instanceof PyCollectionType) {
                    PyCollectionType collectionType = (PyCollectionType)syncUpcast;
                    PyType yieldType = collectionType.getIteratedItemType();
                    return new GeneratorTypeDescriptor(yieldType, null, null, false);
                }
                PyType asyncUpcast = PyTypeUtil.convertToType((PyType)classType, "typing.AsyncIterable", (PsiElement)classType.getPyClass(), context);
                if (asyncUpcast instanceof PyCollectionType) {
                    PyCollectionType asyncCollectionType = (PyCollectionType)asyncUpcast;
                    PyType yieldType = asyncCollectionType.getIteratedItemType();
                    return new GeneratorTypeDescriptor(yieldType, null, null, true);
                }
                PyFunction next = classType.getPyClass().findMethodByName("__next__", true, context);
                if (next != null) {
                    PyType yieldType = context.getReturnType((PyCallable)next);
                    yieldType = PyTypeChecker.substitute(yieldType, PyTypeChecker.unifyReceiver((PyType)classType, context), context);
                    return new GeneratorTypeDescriptor(yieldType, null, null, false);
                }
                PyFunction anext = classType.getPyClass().findMethodByName("__anext__", true, context);
                if (anext != null) {
                    PyType yieldType = (PyType)Ref.deref(PyTypingTypeProvider.unwrapCoroutineReturnType(context.getReturnType((PyCallable)anext)));
                    yieldType = PyTypeChecker.substitute(yieldType, PyTypeChecker.unifyReceiver((PyType)classType, context), context);
                    return new GeneratorTypeDescriptor(yieldType, null, null, true);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/typing/PyTypingTypeProvider$GeneratorTypeDescriptor", "fromGeneratorOrProtocol"));
        }
    }
}

