/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.LambdaInLineVisitor;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.javascript.debugger.breakpoints.JavaScriptLineBreakpointProperties;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.SourceInfo;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n\u001a!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0007\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"getFirstBreakableElement", "Lcom/intellij/psi/PsiElement;", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "getPositionsInLine", "", "Lorg/jetbrains/debugger/SourceInfo;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "computeInNBRA", "T", "callable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)Ljava/lang/Object;", "intellij.javascript.debugger.backend"})
public final class PsiVisitorKt {
    private static final PsiElement getFirstBreakableElement(JSFunction function) {
        for (PsiElement psiChild = function.getFirstChild(); psiChild != null; psiChild = psiChild.getNextSibling()) {
            if (!(psiChild instanceof JSExpression)) continue;
            return psiChild;
        }
        return null;
    }

    @NotNull
    public static final List<SourceInfo> getPositionsInLine(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Project project) {
        Integer myOrdinal;
        List result;
        XSourcePosition position;
        block7: {
            Integer offsetInLine;
            block6: {
                Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
                if (xSourcePosition == null) {
                    return CollectionsKt.emptyList();
                }
                position = xSourcePosition;
                result = new ArrayList();
                XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
                JavaScriptLineBreakpointProperties javaScriptLineBreakpointProperties = xBreakpointProperties instanceof JavaScriptLineBreakpointProperties ? (JavaScriptLineBreakpointProperties)xBreakpointProperties : null;
                Integer n = myOrdinal = javaScriptLineBreakpointProperties != null ? javaScriptLineBreakpointProperties.lambdaOrdinal : null;
                if (myOrdinal == null) break block6;
                int n2 = -1;
                if (myOrdinal != n2) break block7;
            }
            if (!(breakpoint.getType() instanceof JavaScriptBreakpointType) && !(breakpoint.getProperties() instanceof JavaScriptLineBreakpointProperties) && (offsetInLine = (Integer)ApplicationManager.getApplication().runReadAction(() -> PsiVisitorKt.getPositionsInLine$lambda$0(position))) != null && offsetInLine >= 0) {
                VirtualFile virtualFile = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                result.add(new SourceInfo(virtualFile, position.getLine(), offsetInLine.intValue(), 0, null, null, 56, null));
                return result;
            }
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            result.add(new SourceInfo(virtualFile, position.getLine(), 0, 0, null, null, 60, null));
        }
        if (myOrdinal == null || myOrdinal >= 0) {
            List list = PsiVisitorKt.computeInNBRA(() -> PsiVisitorKt.getPositionsInLine$lambda$1(position, project, myOrdinal));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeInNBRA(...)");
            result.addAll(list);
        }
        return result;
    }

    @Contract(pure=true)
    public static final <T> T computeInNBRA(@NotNull Callable<T> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        return (T)ReadAction.nonBlocking(callable).executeSynchronously();
    }

    private static final Integer getPositionsInLine$lambda$0(XSourcePosition $position) {
        Document document = FileDocumentManager.getInstance().getDocument($position.getFile());
        if (document != null) {
            return $position.getOffset() - document.getLineStartOffset($position.getLine());
        }
        return null;
    }

    private static final List getPositionsInLine$lambda$1(XSourcePosition $position, Project $project, Integer $myOrdinal) {
        List currentResult = new ArrayList();
        LambdaInLineVisitor visitor2 = new LambdaInLineVisitor($myOrdinal, currentResult){
            final /* synthetic */ Integer $myOrdinal;
            final /* synthetic */ List<SourceInfo> $currentResult;
            {
                this.$myOrdinal = $myOrdinal;
                this.$currentResult = $currentResult;
            }

            protected void process(JSFunction element, PsiElement firstBreakable) {
                int n;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)firstBreakable, (String)"firstBreakable");
                        if (this.$myOrdinal == null) break block4;
                        Integer n2 = this.$myOrdinal;
                        n = this.lambdaOrdinal;
                        if (n2 == null || n2 != n) break block5;
                    }
                    SourceInfo lambdaPosition = this.createSourcePosition(firstBreakable);
                    Integer n3 = this.$myOrdinal;
                    int n4 = this.lambdaOrdinal;
                    if (n3 != null && n3 == n4) {
                        this.isStopped = true;
                    }
                    this.$currentResult.add(lambdaPosition);
                }
                n = this.lambdaOrdinal;
                this.lambdaOrdinal = n + 1;
            }
        };
        PsiVisitors.visit((XSourcePosition)$position, (Project)$project, null, (PsiVisitors.Visitor)visitor2);
        return currentResult;
    }

    public static final /* synthetic */ PsiElement access$getFirstBreakableElement(JSFunction function) {
        return PsiVisitorKt.getFirstBreakableElement(function);
    }
}

