/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.StylesConversionKt;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0018\u001a\u00020\u0003H&J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001aH\u0016J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001aH\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\"\u001a\u00020\u0017H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/console/PrintableEntity;", "", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "userStyle", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/ui/SimpleColoredText;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getContentType", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "getColoredText", "()Lcom/intellij/ui/SimpleColoredText;", "setColoredText", "(Lcom/intellij/ui/SimpleColoredText;)V", "getUserStyle", "cachedHash", "", "getJSType", "getJSProps", "", "addText", "", "printable", "jsProps", "equals", "", "other", "hashCode", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nEntities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Entities.kt\ncom/intellij/javascript/debugger/console/PrintableEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,318:1\n1878#2,3:319\n*S KotlinDebug\n*F\n+ 1 Entities.kt\ncom/intellij/javascript/debugger/console/PrintableEntity\n*L\n76#1:319,3\n*E\n"})
public abstract class PrintableEntity {
    @NotNull
    private String text;
    @NotNull
    private final ConsoleViewContentType contentType;
    @Nullable
    private SimpleColoredText coloredText;
    @Nullable
    private final String userStyle;
    private int cachedHash;

    public PrintableEntity(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable SimpleColoredText coloredText, @Nullable String userStyle) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.text = text;
        this.contentType = contentType;
        this.coloredText = coloredText;
        this.userStyle = userStyle;
    }

    public /* synthetic */ PrintableEntity(String string, ConsoleViewContentType consoleViewContentType, SimpleColoredText simpleColoredText, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            simpleColoredText = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(string, consoleViewContentType, simpleColoredText, string2);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    @NotNull
    public final ConsoleViewContentType getContentType() {
        return this.contentType;
    }

    @Nullable
    public final SimpleColoredText getColoredText() {
        return this.coloredText;
    }

    public final void setColoredText(@Nullable SimpleColoredText simpleColoredText) {
        this.coloredText = simpleColoredText;
    }

    @Nullable
    public final String getUserStyle() {
        return this.userStyle;
    }

    @NotNull
    public abstract String getJSType();

    @NotNull
    public Map<String, Object> getJSProps() {
        Map jsProps = new LinkedHashMap();
        jsProps.put("type", this.getJSType());
        String string = this.userStyle;
        if (string != null) {
            String it = string;
            boolean bl = false;
            jsProps.put("userStyle", this.userStyle);
        }
        jsProps.put("text", (List)new ArrayList());
        jsProps.put("inlineStyles", (List)new ArrayList());
        this.addText(this, jsProps);
        return jsProps;
    }

    /*
     * WARNING - void declaration
     */
    private final void addText(PrintableEntity printable, Map<String, Object> jsProps) {
        if (printable.coloredText != null) {
            SimpleColoredText simpleColoredText = printable.coloredText;
            Intrinsics.checkNotNull((Object)simpleColoredText);
            ArrayList arrayList = simpleColoredText.getTexts();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"getTexts(...)");
            Iterable $this$forEachIndexed$iv = arrayList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void txt;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                SimpleColoredText simpleColoredText2 = printable.coloredText;
                Intrinsics.checkNotNull((Object)simpleColoredText2);
                SimpleTextAttributes attrs = (SimpleTextAttributes)simpleColoredText2.getAttributes().get(i);
                Object object = jsProps.get("text");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
                List list = TypeIntrinsics.asMutableList((Object)object);
                String string2 = StringUtil.escapeStringCharacters((String)txt);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeStringCharacters(...)");
                list.add(string2);
                Object object2 = jsProps.get("inlineStyles");
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
                List list2 = TypeIntrinsics.asMutableList((Object)object2);
                TextAttributes textAttributes = attrs.toTextAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"toTextAttributes(...)");
                list2.add(StylesConversionKt.textAttributesToInlineCss(textAttributes));
            }
        } else {
            Object object = jsProps.get("text");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            List list = TypeIntrinsics.asMutableList((Object)object);
            String string = StringUtil.escapeStringCharacters((String)printable.text);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeStringCharacters(...)");
            list.add(string);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.console.PrintableEntity");
        PrintableEntity cfr_ignored_0 = (PrintableEntity)object2;
        if (!Intrinsics.areEqual((Object)this.getJSType(), (Object)((PrintableEntity)other).getJSType())) {
            return false;
        }
        return Intrinsics.areEqual(this.getJSProps(), ((PrintableEntity)other).getJSProps());
    }

    public int hashCode() {
        if (this.cachedHash == 0) {
            Object[] objectArray = new Object[]{this.getJSType(), this.getJSProps()};
            this.cachedHash = Objects.hash(objectArray);
        }
        return this.cachedHash;
    }
}

