/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.jetbrains.debugger.wip.WipLocalVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipWithExclusiveWebsocketChannelVmConnection;
import com.jetbrains.nodeJs.NodeChromeDebugProcess;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import java.io.IOException;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a,\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a8\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0007\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0010"}, d2={"computeDebugAddress", "Ljava/net/InetSocketAddress;", "configuration", "Lcom/intellij/execution/configurations/RunProfile;", "createDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lcom/jetbrains/nodeJs/NodeJSDebuggableConfiguration;", "socketAddress", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "intellij.javascript.debugger.backend"})
public final class NodeDebugProgramRunnerKt {
    @NotNull
    public static final InetSocketAddress computeDebugAddress(@NotNull RunProfile configuration) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        try {
            int debugPort;
            NodeDebugRunConfiguration nodeDebugRunConfiguration = configuration instanceof NodeDebugRunConfiguration ? (NodeDebugRunConfiguration)configuration : null;
            int n = debugPort = nodeDebugRunConfiguration != null ? nodeDebugRunConfiguration.getConfiguredDebugPort() : -1;
            if (debugPort == -1) {
                debugPort = NetUtils.findAvailableSocketPort();
            }
            return new InetSocketAddress(NodeCommandLineUtil.getNodeLoopbackAddress(), debugPort);
        }
        catch (IOException e) {
            throw new ExecutionException(XDebuggerBundle.message((String)"error.message.cannot.find.available.port", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @NotNull
    public static final JavaScriptDebugProcess<?> createDebugProcess(@NotNull NodeJSDebuggableConfiguration configuration, @NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Project project = session2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DebuggableFileFinder fileFinder2 = configuration.createFileFinder(project);
        return NodeDebugProgramRunnerKt.createDebugProcess(socketAddress, configuration.getInterpreter(), session2, fileFinder2, executionResult);
    }

    private static final JavaScriptDebugProcess<?> createDebugProcess(InetSocketAddress socketAddress, NodeJsInterpreter interpreter, XDebugSession session2, DebuggableFileFinder fileFinder2, ExecutionResult executionResult) {
        ExecutionResult executionResult2 = executionResult;
        ProcessHandler processHandler = executionResult2 != null ? executionResult2.getProcessHandler() : null;
        NodeJsLocalInterpreter nodeJsLocalInterpreter = interpreter instanceof NodeJsLocalInterpreter ? (NodeJsLocalInterpreter)interpreter : null;
        boolean useExclusiveWebSocketChannel = nodeJsLocalInterpreter != null ? nodeJsLocalInterpreter.isElectron() : false;
        WipRemoteVmConnection connection2 = useExclusiveWebSocketChannel ? (WipRemoteVmConnection)new WipWithExclusiveWebsocketChannelVmConnection() : (WipRemoteVmConnection)new WipLocalVmConnection(null, 1, null);
        NodeChromeDebugProcess process = new NodeChromeDebugProcess(session2, fileFinder2, (RemoteVmConnection<? extends WipVm>)((RemoteVmConnection)connection2), executionResult);
        if (processHandler == null || processHandler.isStartNotified()) {
            RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)socketAddress, null, (int)2, null);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(connection2, socketAddress){
                final /* synthetic */ WipRemoteVmConnection $connection;
                final /* synthetic */ InetSocketAddress $socketAddress;
                {
                    this.$connection = $connection;
                    this.$socketAddress = $socketAddress;
                }

                public void startNotified(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    RemoteVmConnection.open$default((RemoteVmConnection)this.$connection, (InetSocketAddress)this.$socketAddress, null, (int)2, null);
                }
            });
        }
        return process;
    }

    public static final /* synthetic */ JavaScriptDebugProcess access$createDebugProcess(InetSocketAddress socketAddress, NodeJsInterpreter interpreter, XDebugSession session2, DebuggableFileFinder fileFinder2, ExecutionResult executionResult) {
        return NodeDebugProgramRunnerKt.createDebugProcess(socketAddress, interpreter, session2, fileFinder2, executionResult);
    }
}

