/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.actions.FileSaveUtils;
import com.intellij.jupyter.core.jupyter.editor.actions.JupyterSvgOutputUtils;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterSaveSvgOutputAsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "e", "intellij.jupyter.core"})
public final class JupyterSaveSvgOutputAsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        BackedNotebookVirtualFile file = JupyterAnActionEventExtensionsKt.getNotebookFile(event);
        event.getPresentation().setEnabledAndVisible(file != null && JupyterSvgOutputUtils.INSTANCE.getSelectedSvgAsText(event, file) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile(e);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile file = backedNotebookVirtualFile;
        String string = JupyterSvgOutputUtils.INSTANCE.getSelectedSvgAsText(e, file);
        if (string == null) {
            return;
        }
        String svg = string;
        VirtualFileWrapper wrapper = FileSaveUtils.INSTANCE.createSaveFile(e.getProject(), JupyterBundle.message("notebook.save.svg.output.default.name", new Object[0]), JupyterBundle.message("notebook.save.svg.output.title", new Object[0]), JupyterBundle.message("notebook.save.svg.output.extension", new Object[0]));
        String string2 = svg;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FileSaveUtils.INSTANCE.saveToFile(wrapper, byArray);
    }
}

