/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs;

import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterOutputDataKeyExtractor;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"getOutputsForIndex", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;", "editor", "Lcom/intellij/openapi/editor/Editor;", "index", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterOutputDataKeyExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterOutputDataKeyExtractor.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterOutputDataKeyExtractorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,235:1\n13#2:236\n*S KotlinDebug\n*F\n+ 1 JupyterOutputDataKeyExtractor.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/JupyterOutputDataKeyExtractorKt\n*L\n230#1:236\n*E\n"})
public final class JupyterOutputDataKeyExtractorKt {
    @Nullable
    public static final JupyterOutputs getOutputsForIndex(@NotNull Editor editor, int index) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull(editor);
        if (jupyterNotebook == null) {
            return null;
        }
        JupyterNotebook notebook = jupyterNotebook;
        if (index < 0 || index >= notebook.cellsCount()) {
            String msg = "cell index is invalid: " + index + ", cells size: " + notebook.cellsCount() + ", intervals size: " + NotebookCellLines.Companion.get(editor).getIntervals().size();
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JupyterOutputDataKeyExtractor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(msg);
            return null;
        }
        JupyterCell jupyterCell = notebook.getCellOrNull(index);
        return jupyterCell != null ? jupyterCell.getOutputs() : null;
    }
}

