/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.validation;

import com.intellij.stats.completion.LogEventVisitor;
import com.intellij.stats.completion.LookupEntryDiff;
import com.intellij.stats.completion.LookupEntryInfo;
import com.intellij.stats.completion.events.BackspaceEvent;
import com.intellij.stats.completion.events.CompletionCancelledEvent;
import com.intellij.stats.completion.events.CompletionStartedEvent;
import com.intellij.stats.completion.events.DownPressedEvent;
import com.intellij.stats.completion.events.ExplicitSelectEvent;
import com.intellij.stats.completion.events.LogEvent;
import com.intellij.stats.completion.events.LookupStateLogData;
import com.intellij.stats.completion.events.TypeEvent;
import com.intellij.stats.completion.events.TypedSelectEvent;
import com.intellij.stats.completion.events.UpPressedEvent;
import com.intellij.stats.validation.InvalidSessionType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u001d\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0006\u0010\u001f\u001a\u00020\u0015J\u0006\u0010 \u001a\u00020\u0015J\u0016\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\bH\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020)H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020*H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020+H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020,H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020-H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020.H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020/H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/stats/validation/CompletionValidationState;", "Lcom/intellij/stats/completion/LogEventVisitor;", "event", "Lcom/intellij/stats/completion/events/CompletionStartedEvent;", "(Lcom/intellij/stats/completion/events/CompletionStartedEvent;)V", "bucket", "", "completionList", "", "", "currentId", "currentPosition", "errorType", "Lcom/intellij/stats/validation/InvalidSessionType;", "events", "", "Lcom/intellij/stats/completion/events/LogEvent;", "idToFactorNames", "", "", "isFinished", "", "isValid", "accept", "", "nextEvent", "checkDiffValid", "diff", "Lcom/intellij/stats/completion/LookupEntryDiff;", "getSafeCurrentId", "position", "isCurrentlyValid", "isSessionValid", "updateFactors", "diffs", "updateState", "Lcom/intellij/stats/completion/events/LookupStateLogData;", "updateValid", "value", "error", "visit", "Lcom/intellij/stats/completion/events/BackspaceEvent;", "Lcom/intellij/stats/completion/events/CompletionCancelledEvent;", "Lcom/intellij/stats/completion/events/DownPressedEvent;", "Lcom/intellij/stats/completion/events/ExplicitSelectEvent;", "Lcom/intellij/stats/completion/events/TypeEvent;", "Lcom/intellij/stats/completion/events/TypedSelectEvent;", "Lcom/intellij/stats/completion/events/UpPressedEvent;", "completion-log-events"})
public final class CompletionValidationState
extends LogEventVisitor {
    private int currentPosition;
    private List<Integer> completionList;
    private String bucket;
    private int currentId;
    private Map<Integer, Set<String>> idToFactorNames;
    private boolean isValid;
    private boolean isFinished;
    private InvalidSessionType errorType;
    private List<LogEvent> events;

    private final void updateState(LookupStateLogData nextEvent) {
        this.currentPosition = nextEvent.currentPosition;
        Iterable $this$forEach$iv = nextEvent.newCompletionListItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LookupEntryInfo it = (LookupEntryInfo)element$iv;
            boolean bl = false;
            Map<Integer, Set<String>> map = this.idToFactorNames;
            Integer n = it.getId();
            CompletionValidationState completionValidationState = this;
            boolean bl2 = false;
            Map<Integer, Set<String>> map2 = map;
            boolean bl3 = false;
            boolean bl4 = map2.containsKey(n);
            completionValidationState.updateValid(!bl4, InvalidSessionType.REPEATED_ELEMENT);
            Map<String, String> map3 = it.getRelevance();
            if (map3 == null || (map3 = map3.keySet()) == null) {
                map3 = SetsKt.emptySet();
            }
            Map<String, String> factorNames = map3;
            this.idToFactorNames.put(it.getId(), CollectionsKt.toMutableSet((Iterable)((Iterable)((Object)factorNames))));
        }
        this.completionList = nextEvent.completionListIds;
        this.updateFactors(nextEvent.itemsDiff);
        this.updateValid(Intrinsics.areEqual((Object)nextEvent.getBucket(), (Object)this.bucket), InvalidSessionType.INCONSISTENT_BUCKET);
        this.currentId = this.getSafeCurrentId(this.completionList, this.currentPosition);
    }

    private final int getSafeCurrentId(List<Integer> completionList, int position) {
        int n;
        if (completionList.isEmpty()) {
            n = -1;
        } else if (position < completionList.size() && position >= 0) {
            n = ((Number)completionList.get(position)).intValue();
        } else {
            this.updateValid(false, InvalidSessionType.INCORRECT_POSITION);
            n = -2;
        }
        return n;
    }

    private final void updateFactors(List<LookupEntryDiff> diffs) {
        for (LookupEntryDiff diff : diffs) {
            String name;
            int id = diff.getId();
            Set<String> knownFactors = this.idToFactorNames.get(id);
            if (knownFactors == null) {
                this.updateValid(false, InvalidSessionType.UNKNOWN_ABSENT_FACTORS);
                return;
            }
            this.checkDiffValid(diff);
            Iterable $this$forEach$iv = diff.getAdded().keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                name = (String)element$iv;
                boolean bl = false;
                this.updateValid(!knownFactors.contains(name), InvalidSessionType.INCONSISTENT_FACTOR_CHANGE);
                knownFactors.add(name);
            }
            $this$forEach$iv = diff.getChanged().keySet();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                name = (String)element$iv;
                boolean bl = false;
                this.updateValid(knownFactors.contains(name), InvalidSessionType.INCONSISTENT_FACTOR_CHANGE);
            }
            $this$forEach$iv = diff.getRemoved();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                name = (String)element$iv;
                boolean bl = false;
                this.updateValid(knownFactors.contains(name), InvalidSessionType.INCONSISTENT_FACTOR_CHANGE);
                knownFactors.remove(name);
            }
        }
    }

    private final void checkDiffValid(LookupEntryDiff diff) {
        Function2<Set<? extends String>, Iterable<? extends String>, Unit> $fun$checkIntersection$1 = new Function2<Set<? extends String>, Iterable<? extends String>, Unit>(this){
            final /* synthetic */ CompletionValidationState this$0;

            public final void invoke(@NotNull Set<String> first, @NotNull Iterable<String> second) {
                Intrinsics.checkParameterIsNotNull(first, (String)"first");
                Intrinsics.checkParameterIsNotNull(second, (String)"second");
                Set intersection = CollectionsKt.intersect((Iterable)first, second);
                Collection collection = intersection;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    CompletionValidationState.access$updateValid(this.this$0, false, InvalidSessionType.INCONSISTENT_FACTOR_CHANGE);
                }
            }
            {
                this.this$0 = completionValidationState;
                super(2);
            }
        };
        $fun$checkIntersection$1.invoke(diff.getAdded().keySet(), (Iterable<String>)diff.getChanged().keySet());
        $fun$checkIntersection$1.invoke(diff.getAdded().keySet(), (Iterable<String>)diff.getRemoved());
        $fun$checkIntersection$1.invoke(diff.getChanged().keySet(), (Iterable<String>)diff.getRemoved());
    }

    public final void accept(@NotNull LogEvent nextEvent) {
        Intrinsics.checkParameterIsNotNull((Object)nextEvent, (String)"nextEvent");
        this.events.add(nextEvent);
        if (this.isFinished) {
            this.updateValid(false, InvalidSessionType.WRONG_EVENTS_ORDER);
        } else if (this.isValid) {
            nextEvent.accept(this);
        }
    }

    @Override
    public void visit(@NotNull DownPressedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
    }

    private final void updateValid(boolean value, InvalidSessionType error) {
        boolean wasValidBefore = this.isValid;
        boolean bl = this.isValid = this.isValid && value;
        if (wasValidBefore && !this.isValid) {
            this.errorType = error;
        }
    }

    @Override
    public void visit(@NotNull UpPressedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
    }

    @Override
    public void visit(@NotNull TypeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
        this.updateValid(this.idToFactorNames.keySet().containsAll((Collection)this.completionList), InvalidSessionType.UNREGISTERED_ELEMENT);
    }

    @Override
    public void visit(@NotNull BackspaceEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
        this.updateValid(this.idToFactorNames.keySet().containsAll((Collection)this.completionList), InvalidSessionType.UNREGISTERED_ELEMENT);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visit(@NotNull ExplicitSelectEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        selectedIdBefore = this.currentId;
        this.updateState(event);
        v0 = this;
        if (selectedIdBefore != this.currentId) ** GOTO lbl-1000
        var3_3 = this.idToFactorNames;
        var4_4 = this.currentId;
        var8_5 = v0;
        var5_6 = false;
        var6_7 = var3_3;
        var7_8 = false;
        var9_9 = var6_7.containsKey(var4_4);
        v0 = var8_5;
        if (var9_9) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        v0.updateValid(v1, InvalidSessionType.UNREGISTERED_ELEMENT);
        this.isFinished = true;
    }

    @Override
    public void visit(@NotNull CompletionCancelledEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.isFinished = true;
    }

    @Override
    public void visit(@NotNull TypedSelectEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.updateState(event);
        int id = event.selectedId;
        this.updateValid(((Number)this.completionList.get(this.currentPosition)).intValue() == id, InvalidSessionType.UNREGISTERED_ELEMENT);
        this.isFinished = true;
    }

    public final boolean isSessionValid() {
        return this.isValid && this.isFinished;
    }

    public final boolean isCurrentlyValid() {
        return this.isValid;
    }

    @NotNull
    public final InvalidSessionType errorType() {
        return this.isValid && !this.isFinished ? InvalidSessionType.WRONG_EVENTS_ORDER : this.errorType;
    }

    /*
     * WARNING - void declaration
     */
    public CompletionValidationState(@NotNull CompletionStartedEvent event) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.currentPosition = event.currentPosition;
        this.completionList = event.completionListIds;
        this.bucket = event.getBucket();
        this.currentId = this.getSafeCurrentId(this.completionList, this.currentPosition);
        Iterable iterable = event.newCompletionListItems;
        CompletionValidationState completionValidationState = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            LookupEntryInfo it = (LookupEntryInfo)element$iv$iv;
            boolean bl = false;
            Integer n = it.getId();
            Map<String, String> map2 = it.getRelevance();
            if (map2 == null || (map2 = map2.keySet()) == null || (map2 = CollectionsKt.toMutableSet((Iterable)((Iterable)((Object)map2)))) == null) {
                Integer n2 = n;
                boolean bl2 = false;
                Set set = new LinkedHashSet();
                n = n2;
                map2 = set;
            }
            Pair pair = TuplesKt.to((Object)n, (Object)map2);
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        completionValidationState.idToFactorNames = MapsKt.toMutableMap((Map)map);
        this.isValid = true;
        this.errorType = InvalidSessionType.OTHER;
        this.events = CollectionsKt.mutableListOf((Object[])new LogEvent[]{event});
    }

    public static final /* synthetic */ void access$updateValid(CompletionValidationState $this, boolean value, InvalidSessionType error) {
        $this.updateValid(value, error);
    }
}

