/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.Checks;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.GraphListener;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.impl.GraphBase;
import com.intellij.openapi.graph.impl.GraphGroupingUtil;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.GraphZoomManager;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.impl.popups.GraphPopupMode;
import com.intellij.openapi.graph.impl.threading.EdtActionExecutor;
import com.intellij.openapi.graph.impl.threading.GraphThreadActionExecutor;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphEdgeRealizerService;
import com.intellij.openapi.graph.services.GraphGroupingService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphNodeRealizerService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.threading.GraphActionExecutor;
import com.intellij.openapi.graph.threading.GraphThreadingType;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DUndoManager;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Graph2DViewActions;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.StandardGraphViewControllerBuilder;
import com.intellij.openapi.graph.view.View;
import com.intellij.openapi.graph.view.View2DConstants;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(GraphBuilderImpl.class);
    @Nullable
    private volatile Project myProject;
    @NotNull
    private final GraphActionExecutor myActionExecutor;
    @NotNull
    private final Graph2DView myView;
    @NotNull
    private final Graph2D myGraph;
    @NotNull
    private HierarchyManager myHierarchyManager;
    @NotNull
    private final Graph2DUndoManager myUndoManager;
    @NotNull
    private final Map<GraphIdentifiable.Node.Identity, NodeRealizer> myNodeRealizers;
    @NotNull
    private final Map<GraphIdentifiable.Edge.Identity, EdgeRealizer> myEdgeRealizers;
    @NotNull
    private final GraphDataMaps<N, E> myGraphDataMaps;
    @NotNull
    private final GraphUpdateModel myGraphUpdateModel;
    @NotNull
    private final GraphDataModel<N, E> myGraphDataModel;
    @NotNull
    private final GraphPresentationModel<N, E> myGraphPresentationModel;
    @NotNull
    private final MergingUpdateQueue myMergingUpdateQueue;
    @NotNull
    private final AtomicBoolean myIsInitialized;
    @NotNull
    private final AtomicBoolean myIsDisposed;
    @NotNull
    private final AtomicReference<Promise<Void>> myUpdatingPromise;
    @NotNull
    private final Set<CustomGraphUpdater> myUpdaters;
    @GuardedBy(value="this")
    @NotNull
    private final EventDispatcher<GraphBuilderListener> myGraphBuilderDispatcher;
    @Nullable
    private EditMode myEditMode;
    @Nullable
    private ViewMode myActiveMode;

    public GraphBuilderImpl(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel, @NotNull GraphThreadingType threadingType, @Nullable EditMode editMode) {
        if (project == null) {
            GraphBuilderImpl.P(0);
        }
        if (graph == null) {
            GraphBuilderImpl.P(1);
        }
        if (view == null) {
            GraphBuilderImpl.P(2);
        }
        if (graphDataModel == null) {
            GraphBuilderImpl.P(3);
        }
        if (graphPresentationModel == null) {
            GraphBuilderImpl.P(4);
        }
        if (threadingType == null) {
            GraphBuilderImpl.P(5);
        }
        this.myNodeRealizers = new HashMap<GraphIdentifiable.Node.Identity, NodeRealizer>();
        this.myEdgeRealizers = new HashMap<GraphIdentifiable.Edge.Identity, EdgeRealizer>();
        this.myIsInitialized = new AtomicBoolean(false);
        this.myIsDisposed = new AtomicBoolean(false);
        this.myUpdatingPromise = new AtomicReference();
        this.myUpdaters = new HashSet<CustomGraphUpdater>();
        this.myGraphBuilderDispatcher = EventDispatcher.create(GraphBuilderListener.class);
        this.myProject = project;
        this.myGraph = graph;
        this.myGraph.setCurrentView((View)view);
        this.myView = view;
        this.myActionExecutor = threadingType == GraphThreadingType.GRAPH_THREAD_BASED ? new GraphThreadActionExecutor(project) : new EdtActionExecutor();
        this.myGraphDataMaps = new GraphDataMaps(this.getActionExecutor());
        this.myHierarchyManager = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.myUndoManager = GraphUndoService.getInstance().setupUndoManagerFor((GraphBuilder)this);
        this.myGraphDataModel = graphDataModel;
        this.myGraphPresentationModel = graphPresentationModel;
        this.myGraphUpdateModel = new GraphUpdateModel((Graph)graph);
        this.myMergingUpdateQueue = new MergingUpdateQueue("YFiles", 100, true, this.myView.getJComponent(), (Disposable)this, null, true);
        this.x();
        Disposer.register((Disposable)this, this.myGraphDataModel);
        Disposer.register((Disposable)this, this.myGraphPresentationModel);
        Disposer.register((Disposable)this, (Disposable)this.myMergingUpdateQueue);
        this.myEditMode = editMode;
        this.myActiveMode = this.myEditMode;
    }

    @NotNull
    public GraphActionExecutor getActionExecutor() {
        String string = "GraphBuilder has been already disposed";
        if (this.myIsDisposed.get()) {
            throw new CancellationException(string);
        }
        GraphActionExecutor graphActionExecutor = this.myActionExecutor;
        if (graphActionExecutor == null) {
            GraphBuilderImpl.P(6);
        }
        return graphActionExecutor;
    }

    public void initialize() {
        if (!this.myIsInitialized.compareAndSet(false, true)) {
            return;
        }
        if (this.myIsDisposed.get()) {
            return;
        }
        this.m();
    }

    private void m() {
        if (this.myIsDisposed.get()) {
            return;
        }
        this.myView.setGraph2D(this.getGraph());
        this.myView.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.myView.getCanvasComponent().putClientProperty(GraphDataKeys.GRAPH_BUILDER, (Object)this);
        GraphBuilderImpl.M(this.myView);
        GraphBuilderImpl.P(this.myView);
        this.myView.addViewMode(new GraphPopupMode(this));
        if (this.myEditMode == null) {
            this.myEditMode = this.createDefaultEditMode();
            this.myActiveMode = this.myEditMode;
        }
        this.setupViewControllers(this.myEditMode);
        this.getGraphPresentationModel().customizeSettings((GraphBuilder)this);
    }

    protected void setupViewControllers(@NotNull EditMode editMode) {
        if (editMode == null) {
            GraphBuilderImpl.P(7);
        }
        MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
        magnifierViewMode.setMagnifierRadius(200);
        ((StandardGraphViewControllerBuilder)((StandardGraphViewControllerBuilder)StandardGraphViewControllerBuilder.beginSetupFor((GraphBuilder)this, this.myGraphBuilderDispatcher).setEditMode(editMode)).setMagnifierViewMode(magnifierViewMode)).endSetup();
    }

    @NotNull
    protected EditMode createDefaultEditMode() {
        EditMode editMode = GraphEditModeFactory.getInstance((Project)this.getProject()).createEditMode((GraphBuilder)this);
        editMode.assignNodeLabel(false);
        editMode.allowResizeNodes(true);
        editMode.allowNodeCreation(false);
        editMode.allowEdgeCreation(true);
        editMode.allowMoveLabels(true);
        editMode.allowMovePorts(true);
        editMode.allowMoveSelection(true);
        editMode.allowMovingWithPopup(true);
        editMode.showNodeTips(true);
        editMode.showEdgeTips(true);
        EditMode editMode2 = editMode;
        if (editMode2 == null) {
            GraphBuilderImpl.P(8);
        }
        return editMode2;
    }

    public void updateGraph(boolean doLayout) {
        this.getActionExecutor().assertGraphThread();
        if (this.myIsDisposed.get()) {
            return;
        }
        this.updateGraph(doLayout, Collections.emptyList());
    }

    protected void updateGraph(boolean doLayout, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.P(9);
        }
        try {
            this.updateDataModel();
            this.updateView(doLayout ? this.getGraphPresentationModel().getSettings().getCurrentLayouter() : null, nodesForSizeUpdate);
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    @NotNull
    protected CompletableFuture<Void> updateGraphAsync(@Nullable Layouter layouter, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.P(10);
        }
        CompletionStage completionStage = ((CompletableFuture)this.getActionExecutor().runGraphActionAsync(() -> this.updateGraph(false, nodesForSizeUpdate)).thenComposeAsync(ThreadContext.captureThreadContext(void_ -> layouter != null ? this.P(layouter) : CompletableFuture.completedFuture(null)))).thenRunAsync(() -> this.getGraph().updateViews(), Futures.inEdt());
        if (completionStage == null) {
            GraphBuilderImpl.P(11);
        }
        return completionStage;
    }

    @NotNull
    public GraphBuilder.GraphUpdateQueryParams<N, E> queryGraphUpdate() {
        return new GraphUpdateQueryParamsImpl();
    }

    protected void runGraphUpdate(@NotNull GraphUpdateQueryParamsImpl params) {
        if (params == null) {
            GraphBuilderImpl.P(12);
        }
        if (params.P()) {
            this.updateGraph(params.P() != null);
        } else {
            this.updateView(params.P(), params.P());
        }
    }

    @NotNull
    protected CompletableFuture<Void> runGraphUpdateAsync(@NotNull GraphUpdateQueryParamsImpl params) {
        if (params == null) {
            GraphBuilderImpl.P(13);
        }
        if (params.P()) {
            CompletableFuture<Void> completableFuture = this.updateGraphAsync(params.P(), params.P());
            if (completableFuture == null) {
                GraphBuilderImpl.P(14);
            }
            return completableFuture;
        }
        CompletableFuture<Void> completableFuture = this.updateViewAsync(params.P(), params.P());
        if (completableFuture == null) {
            GraphBuilderImpl.P(15);
        }
        return completableFuture;
    }

    public void updateDataModel() {
        this.getActionExecutor().assertGraphThread();
        this.updateDataModelWithCustomMapping(null, null);
    }

    public void updateDataModelWithCustomMapping(@Nullable Function<? super N, ? extends Node> nodeMapping, @Nullable Function<? super E, ? extends Edge> edgeMapping) {
        this.getActionExecutor().assertGraphThread();
        if (!this.P()) {
            this.initialize();
        }
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        HashSet hashSet = new HashSet(graphDataModel.getNodes());
        HashSet hashSet2 = new HashSet(graphDataModel.getEdges());
        for (Object e2 : hashSet) {
            this.P(graphDataModel.getNodeName(e2), e2, new Object[]{e2}, nodeMapping);
        }
        for (Object e2 : hashSet2) {
            this.addEdge(graphDataModel.getSourceNode(e2), graphDataModel.getTargetNode(e2), graphDataModel.getEdgeName(e2), e2, new Object[]{e2}, edgeMapping);
        }
        this.P((Graph)this.getGraph(), hashSet);
        this.P((Graph)this.getGraph(), hashSet2);
    }

    private void P(@NotNull Graph graph, @NotNull Set<N> set) {
        if (graph == null) {
            GraphBuilderImpl.P(16);
        }
        if (set == null) {
            GraphBuilderImpl.P(17);
        }
        this.getActionExecutor().assertGraphThread();
        List list = Stream.of(Arrays.stream(graph.getNodeArray()), this.getDataMaps().getNodeObjectDataBiMap().keySet().stream(), this.getDataMaps().getNodeNameDataMap().keySet().stream(), this.getDataMaps().getNodeEqualityDataMap().keySet().stream(), this.getDataMaps().getDraggedNodesList().stream()).flatMap(stream -> stream).collect(Collectors.toList());
        list.removeIf(node -> set.contains(this.getNodeObject((Node)node)) || this.getGroupNodeObject((Node)node) != null);
        this.getActionExecutor().runWriteAction(() -> {
            this.getDataMaps().removeNodes(list);
            for (Node node : list) {
                Graph graph = node.getGraph();
                if (graph == null || !graph.contains(node)) continue;
                graph.removeNode(node);
            }
        });
    }

    private void P(@NotNull Graph graph, @NotNull HashSet<E> hashSet) {
        if (graph == null) {
            GraphBuilderImpl.P(18);
        }
        if (hashSet == null) {
            GraphBuilderImpl.P(19);
        }
        this.getActionExecutor().assertGraphThread();
        List list = Stream.of(Arrays.stream(graph.getEdgeArray()), this.getDataMaps().getEdgeObjectDataBiMap().keySet().stream(), this.getDataMaps().getEdgeNameDataMap().keySet().stream(), this.getDataMaps().getEdgeEqualityDataMap().keySet().stream()).flatMap(stream -> stream).collect(Collectors.toList());
        list.removeIf(edge -> hashSet.contains(this.getEdgeObject((Edge)edge)) || this.getCollapsedEdgeObject((Edge)edge) != null);
        this.getActionExecutor().runWriteAction(() -> {
            this.getDataMaps().removeEdges(list);
            for (Edge edge : list) {
                Graph graph = edge.getGraph();
                if (graph == null || !graph.contains(edge)) continue;
                graph.removeEdge(edge);
            }
        });
    }

    public void updateView() {
        this.getActionExecutor().assertGraphThread();
        this.updateView(null, Collections.emptyList());
    }

    protected void updateView(@Nullable Layouter layouter, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.P(20);
        }
        this.getActionExecutor().assertGraphThread();
        this.updateGroups();
        Futures.runInEdtAsync(() -> this.updateRealizers(false, nodesForSizeUpdate));
        this.updateBridges();
        this.updateGrid();
        for (CustomGraphUpdater customGraphUpdater : this.myUpdaters) {
            customGraphUpdater.update(this.getGraph(), this.getView(), nodesForSizeUpdate);
        }
        if (layouter != null) {
            this.P(layouter);
        }
        this.getGraph().updateViews();
    }

    @NotNull
    protected CompletableFuture<Void> updateViewAsync(@Nullable Layouter layouter, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.P(21);
        }
        CompletionStage completionStage = ((CompletableFuture)this.getActionExecutor().runGraphActionAsync(() -> {
            this.updateGroups();
            Futures.runInEdtAsync(() -> this.updateRealizers(false, nodesForSizeUpdate));
            this.updateBridges();
            this.updateGrid();
            for (CustomGraphUpdater customGraphUpdater : this.myUpdaters) {
                customGraphUpdater.update(this.getGraph(), this.getView(), nodesForSizeUpdate);
            }
        }).thenComposeAsync(ThreadContext.captureThreadContext(void_ -> layouter != null ? this.P(layouter) : CompletableFuture.completedFuture(null)))).thenRunAsync(() -> this.getGraph().updateViews(), Futures.inEdt());
        if (completionStage == null) {
            GraphBuilderImpl.P(22);
        }
        return completionStage;
    }

    public void setNodeRealizer(@NotNull Node node, @NotNull NodeRealizer newNodeRealizer) {
        if (node == null) {
            GraphBuilderImpl.P(23);
        }
        if (newNodeRealizer == null) {
            GraphBuilderImpl.P(24);
        }
        this.getGraph().setRealizer(node, newNodeRealizer);
        this.myNodeRealizers.put((GraphIdentifiable.Node.Identity)this.getActionExecutor().computeReadAction(() -> this.getNodeIdentity(node)), newNodeRealizer);
    }

    @Nullable
    public NodeRealizer getNodeRealizer(@NotNull Node node) {
        if (node == null) {
            GraphBuilderImpl.P(25);
        }
        return this.myNodeRealizers.get(this.getActionExecutor().computeReadAction(() -> this.getNodeIdentity(node)));
    }

    public void setEdgeRealizer(@NotNull Edge edge, @NotNull EdgeRealizer newEdgeRealizer) {
        if (edge == null) {
            GraphBuilderImpl.P(26);
        }
        if (newEdgeRealizer == null) {
            GraphBuilderImpl.P(27);
        }
        this.getGraph().setRealizer(edge, newEdgeRealizer);
        this.myEdgeRealizers.put((GraphIdentifiable.Edge.Identity)this.getActionExecutor().computeReadAction(() -> this.getEdgeIdentity(edge)), newEdgeRealizer);
    }

    @Nullable
    public EdgeRealizer getEdgeRealizer(@NotNull Edge edge) {
        if (edge == null) {
            GraphBuilderImpl.P(28);
        }
        return this.myEdgeRealizers.get(this.getActionExecutor().computeReadAction(() -> this.getEdgeIdentity(edge)));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateRealizers(boolean bl) {
        void updateAllNodes;
        ThreadingAssertions.assertEventDispatchThread();
        this.updateRealizers((boolean)updateAllNodes, Collections.emptyList());
    }

    @RequiresEdt
    protected void updateRealizers(boolean updateAllNodes, @NotNull Collection<? extends N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.P(29);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.getActionExecutor().suppressRunnableReadLockAssertion(() -> {
            Object object2;
            Set set = (Set)this.getActionExecutor().computeReadAction(() -> ContainerUtil.map2SetNotNull((Collection)nodesForSizeUpdate, this::getNode));
            List list = (List)this.getActionExecutor().computeReadAction(() -> Collections.unmodifiableCollection(this.getDataMaps().getCollapsedEdgeDataMap().values()));
            for (Object object2 : list) {
                this.updateNodeRealizer((Node)object2, set.contains(object2));
            }
            List list2 = (List)this.getActionExecutor().computeReadAction(() -> Collections.unmodifiableCollection(this.getDataMaps().getGroupNodeDataMap().values()));
            object2 = list2.iterator();
            while (object2.hasNext()) {
                Edge edge = (Edge)object2.next();
                this.updateEdgeRealizer(edge);
            }
        });
    }

    protected void updateNodeRealizer(@NotNull Node node, boolean doNodeSizeUpdate) {
        if (node == null) {
            GraphBuilderImpl.P(30);
        }
        NodeRealizer nodeRealizer = this.getNodeRealizer(node);
        NodeRealizer nodeRealizer2 = this.P(node);
        this.setNodeRealizer(node, nodeRealizer2);
        if (nodeRealizer != null) {
            this.setRenderedNodeSizes(node, doNodeSizeUpdate ? null : nodeRealizer);
            nodeRealizer2.setX(nodeRealizer.getX());
            nodeRealizer2.setY(nodeRealizer.getY());
            nodeRealizer2.setSelected(nodeRealizer.isSelected());
            this.getActionExecutor().runGraphActionAsync(() -> this.updateNodeLabels(node, nodeRealizer, nodeRealizer2));
        } else {
            this.setRenderedNodeSizes(node, null);
            this.getActionExecutor().runGraphActionAsync(() -> this.updateNodeLabels(node, null, nodeRealizer2));
        }
    }

    @NotNull
    private NodeRealizer P(@NotNull Node node) {
        Object object;
        if (node == null) {
            GraphBuilderImpl.P(31);
        }
        if (GraphGroupingService.getInstance().isGroupOrFolderNode((GraphBuilder)this, node) && (object = (NodeGroupDescriptor)this.getActionExecutor().computeReadAction(() -> GraphGroupingService.getInstance().getGroupDescriptor((GraphBuilder)this, node))) != null) {
            NodeRealizer nodeRealizer = (NodeRealizer)Objects.requireNonNullElseGet(object.createGroupNodeRealizer(), () -> GraphBuilderImpl.P((NodeGroupDescriptor)object));
            if (nodeRealizer == null) {
                GraphBuilderImpl.P(32);
            }
            return nodeRealizer;
        }
        object = this.getActionExecutor().computeReadAction(() -> this.getNodeObject(node));
        NodeRealizer nodeRealizer = this.getGraphPresentationModel().getNodeRealizer(object);
        if (nodeRealizer == null) {
            GraphBuilderImpl.P(33);
        }
        return nodeRealizer;
    }

    protected void setRenderedNodeSizes(@NotNull Node node, @Nullable NodeRealizer oldRealizer) {
        if (node == null) {
            GraphBuilderImpl.P(34);
        }
        Graph2D graph2D = this.getGraph();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        if (oldRealizer != null) {
            graph2D.setSize(node, GraphManager.getGraphManager().createYDimension(oldRealizer.getWidth(), oldRealizer.getHeight()));
        } else {
            Object object;
            NodeCellRenderer nodeCellRenderer = GraphNodeRealizerService.getInstance().getNodeCellRenderer(nodeRealizer);
            Object object2 = this.getActionExecutor().computeReadAction(() -> this.getNodeObject(node));
            if (nodeCellRenderer != null && object2 != null) {
                object = nodeCellRenderer.getNodeCellRendererComponent(this.getView(), nodeRealizer, object2, nodeRealizer.isSelected()).getPreferredSize();
                graph2D.setSize(node, GraphManager.getGraphManager().createYDimension((double)object.width, (double)object.height));
            }
            if (nodeRealizer instanceof GroupNodeRealizer) {
                object = (GroupNodeRealizer)nodeRealizer;
                if (object.isGroupClosed()) {
                    NodeLabel nodeLabel = object.getLabel();
                    if (nodeLabel != null) {
                        graph2D.setSize(node, nodeLabel.getWidth(), 2.0 * nodeLabel.getHeight());
                    }
                } else {
                    object.updateAutoSizeBounds();
                }
            }
        }
    }

    public void updateEdgeRealizer(@NotNull Edge edge) {
        if (edge == null) {
            GraphBuilderImpl.P(35);
        }
        EdgeRealizer edgeRealizer = this.getEdgeRealizer(edge);
        EdgeRealizer edgeRealizer2 = this.getGraphPresentationModel().getEdgeRealizer(this.getActionExecutor().computeReadAction(() -> this.getEdgeObject(edge)));
        this.setEdgeRealizer(edge, edgeRealizer2);
        if (edgeRealizer != null) {
            GraphEdgeRealizerService.getInstance().copyEdgeLayout(edgeRealizer, edgeRealizer2);
            edgeRealizer2.setSelected(edgeRealizer.isSelected());
            this.getActionExecutor().runGraphActionAsync(() -> this.updateEdgeLabels(edge, edgeRealizer, edgeRealizer2));
        } else {
            this.getActionExecutor().runGraphActionAsync(() -> this.updateEdgeLabels(edge, null, edgeRealizer2));
        }
    }

    protected void updateNodeLabels(@NotNull Node node, @Nullable NodeRealizer oldNodeRealizer, @NotNull NodeRealizer newNodeRealizer) {
        if (node == null) {
            GraphBuilderImpl.P(36);
        }
        if (newNodeRealizer == null) {
            GraphBuilderImpl.P(37);
        }
        NodeLabel[] nodeLabelArray = this.getGraphPresentationModel().getNodeLabels(this.getNodeObject(node), GraphImplUtil.getNodeName(this.getDataMaps(), node));
        Map<String, List<NodeLabel>> map = GraphImplUtil.getNodeLabels(oldNodeRealizer).stream().collect(Collectors.groupingBy(nodeLabel -> nodeLabel.getText()));
        for (NodeLabel nodeLabel2 : nodeLabelArray) {
            List<NodeLabel> list = map.get(nodeLabel2.getText());
            if (list != null && !list.isEmpty()) {
                NodeLabel nodeLabel3 = list.remove(list.size() - 1);
                nodeLabel2.setLabelModel(nodeLabel3.getLabelModel(), nodeLabel3.getModelParameter());
            }
            newNodeRealizer.addLabel(nodeLabel2);
        }
    }

    protected void updateEdgeLabels(@NotNull Edge edge, @Nullable EdgeRealizer oldEdgeRealizer, @NotNull EdgeRealizer newEdgeRealizer) {
        if (edge == null) {
            GraphBuilderImpl.P(38);
        }
        if (newEdgeRealizer == null) {
            GraphBuilderImpl.P(39);
        }
        if (!this.getGraphPresentationModel().getSettings().isShowEdgeLabels()) {
            return;
        }
        EdgeLabel[] edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge));
        Map<String, List<EdgeLabel>> map = GraphImplUtil.getEdgeLabels(oldEdgeRealizer).stream().collect(Collectors.groupingBy(edgeLabel -> edgeLabel.getText()));
        for (EdgeLabel edgeLabel2 : edgeLabelArray) {
            List<EdgeLabel> list = map.get(edgeLabel2.getText());
            if (list != null && !list.isEmpty()) {
                EdgeLabel edgeLabel3 = list.remove(list.size() - 1);
                edgeLabel2.setLabelModel(edgeLabel3.getLabelModel(), edgeLabel3.getModelParameter());
            }
            newEdgeRealizer.addLabel(edgeLabel2);
        }
    }

    public void updateBridges() {
        GraphPresentationModel<N, E> graphPresentationModel = this.getGraphPresentationModel();
        if (graphPresentationModel instanceof BasicGraphPresentationModel) {
            BasicGraphPresentationModel basicGraphPresentationModel = (BasicGraphPresentationModel)graphPresentationModel;
            basicGraphPresentationModel.setupBridgesFor(this.getView().getGraph2DRenderer());
        }
    }

    public void updateGrid() {
        this.getView().setGridVisible(this.getGraphPresentationModel().getSettings().isShowGrid());
    }

    @Deprecated
    private void P(@Nullable Layouter layouter) {
        if (this.getGraph().nodeCount() > 0) {
            GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter != null ? layouter : this.getGraphPresentationModel().getSettings().getCurrentLayouter()).run();
        }
    }

    @NotNull
    private CompletableFuture<Void> P(@Nullable Layouter layouter) {
        CompletableFuture completableFuture = GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter != null ? layouter : this.getGraphPresentationModel().getSettings().getCurrentLayouter()).runAsync();
        if (completableFuture == null) {
            GraphBuilderImpl.P(40);
        }
        return completableFuture;
    }

    public final boolean isUpdating() {
        return this.myUpdatingPromise.get() != null;
    }

    public final void queueUpdate() {
        this.doQueueUpdate(new GraphUpdateQueryParamsImpl().withDataReload().withRelayout());
    }

    @NotNull
    protected Promise<Void> doQueueUpdate(final @NotNull GraphUpdateQueryParamsImpl params) {
        AsyncPromise asyncPromise;
        Promise<Void> promise;
        if (params == null) {
            GraphBuilderImpl.P(41);
        }
        if ((promise = this.myUpdatingPromise.compareAndExchange(null, (Promise<Void>)(asyncPromise = new AsyncPromise()))) == asyncPromise) {
            ApplicationManager.getApplication().invokeLater(() -> {
                final Cursor cursor = this.myView.getJComponent().getCursor();
                this.myView.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
                this.myMergingUpdateQueue.queue(new Update("Update"){

                    public void run() {
                        GraphBuilderImpl.this.runGraphUpdate(params);
                        GraphBuilderImpl.this.myView.getJComponent().setCursor(cursor);
                        ((AsyncPromise)promise).setResult(null);
                        GraphBuilderImpl.this.myUpdatingPromise.set(null);
                    }
                });
            });
        }
        Promise<Void> promise2 = promise;
        if (promise2 == null) {
            GraphBuilderImpl.P(42);
        }
        return promise2;
    }

    @NotNull
    public GraphDataModel<N, E> getGraphDataModel() {
        GraphDataModel<N, E> graphDataModel = this.myGraphDataModel;
        if (graphDataModel == null) {
            GraphBuilderImpl.P(43);
        }
        return graphDataModel;
    }

    @NotNull
    public String getNodeName(@NotNull Node node) {
        if (node == null) {
            GraphBuilderImpl.P(44);
        }
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node);
        if (string == null) {
            GraphBuilderImpl.P(45);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(@Nullable Node node) {
        return (N)(node != null ? this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getNodeObject(this.getDataMaps(), node)) : null);
    }

    @Nullable
    public E getEdgeObject(@Nullable Edge edge) {
        return (E)(edge != null ? this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getEdgeObject(this.getDataMaps(), edge)) : null);
    }

    @Nullable
    public NodeGroupDescriptor getGroupNodeObject(@Nullable Node node) {
        return node != null ? (NodeGroupDescriptor)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getGroupNodeObject(this.getDataMaps(), node)) : null;
    }

    @Nullable
    public CollapsedEdge getCollapsedEdgeObject(@Nullable Edge edge) {
        return edge != null ? (CollapsedEdge)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getCollapsedEdgeObject(this.getDataMaps(), edge)) : null;
    }

    protected void updateGroups() {
        this.getActionExecutor().assertGraphThread();
        this.getActionExecutor().runWriteAction(() -> GraphGroupingService.getInstance().updateGroups((GraphBuilder)this, this.myGraphPresentationModel.getSettings().isCollapseEdgesOnGrouping()));
    }

    public void addNode(N nodeObject) {
        this.addNode(this.getGraphDataModel().getNodeName(nodeObject), nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject) {
        if (name == null) {
            GraphBuilderImpl.P(46);
        }
        this.P(name, nodeObject, new Object[]{nodeObject}, null);
    }

    private void P(@NotNull String string, N n2, Object[] objectArray, @Nullable Function<? super N, ? extends Node> function) {
        if (string == null) {
            GraphBuilderImpl.P(47);
        }
        this.getActionExecutor().assertGraphThread();
        Function<N, Node> function2 = function != null ? function : object2 -> Objects.requireNonNullElseGet((Node)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getExistedNode(this.getDataMaps(), string, objectArray)), () -> (Node)this.getActionExecutor().computeWriteAction(() -> GraphImplUtil.createNode((Graph)this.getGraph(), this.P(n2), this.getDataMaps(), string, objectArray)));
        Node node = Objects.requireNonNull(function2.apply(n2));
        this.getActionExecutor().runWriteAction(() -> {
            GraphImplUtil.setNodeName(this.getDataMaps(), node, string);
            GraphImplUtil.setNodeObject(this.getDataMaps(), node, n2);
        });
    }

    @Nullable
    private Graph P(N n2) {
        NodeGroupDescriptor nodeGroupDescriptor = this.getGraphDataModel().getGroup(n2);
        if (nodeGroupDescriptor != null) {
            Node node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodeGroupDescriptor, this.getDataMaps(), this.getGraphDataModel());
            return this.P(node);
        }
        return null;
    }

    @Nullable
    private Graph P(@NotNull Node node) {
        HierarchyManager hierarchyManager;
        if (node == null) {
            GraphBuilderImpl.P(48);
        }
        if ((hierarchyManager = this.getHierarchyManager()).getRootGraph().contains(node) && hierarchyManager.isFolderNode(node)) {
            return hierarchyManager.getInnerGraph(node);
        }
        return null;
    }

    @NotNull
    protected Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name, E edgeObject, Object[] equalityObjects, @Nullable Function<? super E, ? extends Edge> edgeMapping) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.P(49);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.P(50);
        }
        if (name == null) {
            GraphBuilderImpl.P(51);
        }
        return this.P(this.M(nodeObject1), this.M(nodeObject2), name, edgeObject, equalityObjects, edgeMapping);
    }

    @NotNull
    private Edge P(@NotNull Node node, @NotNull Node node2, @NotNull String string, E e2, Object[] objectArray, @Nullable Function<? super E, ? extends Edge> function) {
        if (node == null) {
            GraphBuilderImpl.P(52);
        }
        if (node2 == null) {
            GraphBuilderImpl.P(53);
        }
        if (string == null) {
            GraphBuilderImpl.P(54);
        }
        this.getActionExecutor().assertGraphThread();
        Function<E, Edge> function2 = function != null ? function : object -> Objects.requireNonNullElseGet((Edge)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getExistedEdge(this.getDataMaps(), node, node2, string, objectArray)), () -> (Edge)this.getActionExecutor().computeWriteAction(() -> GraphImplUtil.createEdge(this.getHierarchyManager(), this.getDataMaps(), node, node2, string, objectArray)));
        Edge edge = Objects.requireNonNull(function2.apply(e2));
        this.getActionExecutor().runWriteAction(() -> GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e2));
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphBuilderImpl.P(55);
        }
        return edge2;
    }

    @NotNull
    private Node M(N n2) {
        Node node = this.getNode(n2);
        if (node == null) {
            this.addNode(n2);
            node = this.getNode(n2);
        }
        if (node == null) {
            LOG.error("null node for " + String.valueOf(n2) + " in " + String.valueOf(this.myGraphDataModel));
        }
        Node node2 = node;
        if (node2 == null) {
            GraphBuilderImpl.P(56);
        }
        return node2;
    }

    public void dispose() {
        if (this.myIsDisposed.compareAndSet(false, true)) {
            this.myProject = null;
            if (this.myEditMode != null) {
                Disposer.dispose((Disposable)this.myEditMode);
            }
            this.myMergingUpdateQueue.cancelAllUpdates();
            Disposer.dispose((Disposable)this.myMergingUpdateQueue);
            this.myGraphDataMaps.dispose();
            this.myHierarchyManager.dispose();
            this.myUndoManager.dispose();
            this.clearUserData();
            GraphSelectionService.getInstance().onGraphBuilderDispose((GraphBuilder)this);
            GraphBuilderImpl.M(this.myGraph);
            GraphBuilderImpl.P(this.myGraph);
            GraphBuilderImpl.x(this.myGraph);
            this.myGraph.clear();
        }
    }

    private static void M(@NotNull Graph2D graph2D) {
        if (graph2D == null) {
            GraphBuilderImpl.P(57);
        }
        for (Object object : ArrayUtil.copyOf((Object[])graph2D.getDataProviderKeys())) {
            graph2D.removeDataProvider(object);
        }
    }

    private static void P(@NotNull Graph2D graph2D) {
        if (graph2D == null) {
            GraphBuilderImpl.P(58);
        }
        ArrayList arrayList = new ArrayList();
        graph2D.getGraphListeners().forEachRemaining(object -> {
            Object object2;
            Object object3 = object2 = object instanceof GraphListener ? object : GraphBase.unwrap(object, null);
            if (object2 instanceof GraphListener) {
                arrayList.add((GraphListener)object2);
            }
        });
        for (GraphListener graphListener : arrayList) {
            graph2D.removeGraphListener(graphListener);
        }
    }

    private static void x(@NotNull Graph2D graph2D) {
        if (graph2D == null) {
            GraphBuilderImpl.P(59);
        }
        ArrayList arrayList = new ArrayList();
        graph2D.getGraph2DSelectionListeners().forEachRemaining(object -> {
            Object object2 = object instanceof Graph2DSelectionListener ? object : GraphBase.unwrap(object, null);
            arrayList.add((Graph2DSelectionListener)object2);
        });
        for (Graph2DSelectionListener graph2DSelectionListener : arrayList) {
            graph2D.removeGraph2DSelectionListener(graph2DSelectionListener);
        }
    }

    @Nullable
    public String getNodeName(@Nullable N nodeObject) {
        Node node = this.getNode(nodeObject);
        return node == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node);
    }

    @Nullable
    public String getEdgeName(@Nullable E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(@Nullable N nodeObject) {
        return nodeObject == null ? null : (Node)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getNode(this.getDataMaps(), nodeObject));
    }

    @Nullable
    public Edge getEdge(@Nullable E edgeObject) {
        return edgeObject == null ? null : (Edge)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getEdge(this.getDataMaps(), edgeObject));
    }

    @Nullable
    public Node getGroupNode(@Nullable NodeGroupDescriptor groupNodeObject) {
        return groupNodeObject == null ? null : (Node)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getGroupNode(this.getDataMaps(), groupNodeObject));
    }

    @Nullable
    public Edge getCollapsedEdge(@Nullable CollapsedEdge collapsedEdgeObject) {
        return collapsedEdgeObject == null ? null : (Edge)this.getActionExecutor().computeReadAction(() -> GraphImplUtil.getCollapsedEdge(this.getDataMaps(), collapsedEdgeObject));
    }

    @NotNull
    public final Graph2D getGraph() {
        Graph2D graph2D = this.myGraph;
        if (graph2D == null) {
            GraphBuilderImpl.P(60);
        }
        return graph2D;
    }

    @NotNull
    public Graph2DView getView() {
        Graph2DView graph2DView = this.myView;
        if (graph2DView == null) {
            GraphBuilderImpl.P(61);
        }
        return graph2DView;
    }

    @NotNull
    public Project getProject() {
        String string = "GraphBuilder has been already disposed";
        if (this.myIsDisposed.get()) {
            throw new CancellationException(string);
        }
        Project project = Objects.requireNonNull(this.myProject, string);
        if (project == null) {
            GraphBuilderImpl.P(62);
        }
        return project;
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public GraphUpdateModel getGraphUpdateModel() {
        GraphUpdateModel graphUpdateModel = this.myGraphUpdateModel;
        if (graphUpdateModel == null) {
            GraphBuilderImpl.P(63);
        }
        return graphUpdateModel;
    }

    @NotNull
    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        GraphPresentationModel<N, E> graphPresentationModel = this.myGraphPresentationModel;
        if (graphPresentationModel == null) {
            GraphBuilderImpl.P(64);
        }
        return graphPresentationModel;
    }

    public double getZoom() {
        return this.getView().getZoom();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setZoom(double d2) {
        void zoom;
        ThreadingAssertions.assertEventDispatchThread();
        this.setZoom((double)zoom, true);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setZoom(double d2, boolean bl) {
        void fireEvents;
        void zoom;
        ThreadingAssertions.assertEventDispatchThread();
        this.setZoom((double)zoom, (boolean)fireEvents, () -> {});
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setZoom(double d2, boolean bl, GraphBuilder.ZoomChangedEvent zoomChangedEvent) {
        void zoomChangedEvent2;
        void fireEvents;
        void zoom;
        ThreadingAssertions.assertEventDispatchThread();
        double d3 = MathUtil.clamp((double)zoom, (double)1.4E-45f, (double)20.0);
        GraphZoomManager.getInstance(this.myProject).setZoom(this, d3, (Function0<Unit>)((Function0)() -> this.P((boolean)fireEvents)), (Function0<Unit>)((Function0)() -> this.P((boolean)fireEvents, (GraphBuilder.ZoomChangedEvent)zoomChangedEvent2)));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void fitContent(boolean bl) {
        void animated;
        ThreadingAssertions.assertEventDispatchThread();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        Graph2DView graph2DView = this.getView();
        GraphAnimationService.getInstance().fitContent(graph2DView, (boolean)animated);
        graph2DView.updateView();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(@NotNull GraphBuilderEvent event, boolean before) {
        if (event == null) {
            GraphBuilderImpl.P(65);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        synchronized (eventDispatcher) {
            if (before) {
                ((GraphBuilderListener)this.myGraphBuilderDispatcher.getMulticaster()).beforeActionPerformed((GraphBuilder)this, event);
            } else {
                ((GraphBuilderListener)this.myGraphBuilderDispatcher.getMulticaster()).actionPerformed((GraphBuilder)this, event);
            }
        }
    }

    private boolean P() {
        return this.myIsInitialized.get();
    }

    private void x() {
        GraphDataKeys.addDataProvider((Graph2DView)this.getView(), string -> {
            if (DeleteProvider.DELETE_PROVIDER.is(string)) {
                return this.getGraphPresentationModel().getDeleteProvider();
            }
            if (GraphDataKeys.GRAPH_BUILDER.is(string)) {
                return this;
            }
            return null;
        });
    }

    @NotNull
    public HierarchyManager getHierarchyManager() {
        HierarchyManager hierarchyManager = this.myHierarchyManager;
        if (hierarchyManager == null) {
            GraphBuilderImpl.P(66);
        }
        return hierarchyManager;
    }

    public void setHierarchyManager(@NotNull HierarchyManager hierarchyManager) {
        if (hierarchyManager == null) {
            GraphBuilderImpl.P(67);
        }
        this.myHierarchyManager = hierarchyManager;
    }

    @NotNull
    public Graph2DUndoManager getUndoManager() {
        Graph2DUndoManager graph2DUndoManager = this.myUndoManager;
        if (graph2DUndoManager == null) {
            GraphBuilderImpl.P(68);
        }
        return graph2DUndoManager;
    }

    public void addCustomUpdater(@NotNull CustomGraphUpdater updater) {
        if (updater == null) {
            GraphBuilderImpl.P(69);
        }
        this.myUpdaters.add(updater);
    }

    public void removeCustomUpdater(@NotNull CustomGraphUpdater updater) {
        if (updater == null) {
            GraphBuilderImpl.P(70);
        }
        this.myUpdaters.remove(updater);
    }

    @NotNull
    public EditMode getEditMode() {
        EditMode editMode = this.myEditMode;
        if (editMode == null) {
            GraphBuilderImpl.P(71);
        }
        return editMode;
    }

    @NotNull
    public ViewMode getActiveMode() {
        assert (this.myActiveMode != null);
        ViewMode viewMode = this.myActiveMode;
        if (viewMode == null) {
            GraphBuilderImpl.P(72);
        }
        return viewMode;
    }

    public void setActiveMode(@NotNull ViewMode activeMode) {
        if (activeMode == null) {
            GraphBuilderImpl.P(73);
        }
        this.myActiveMode = activeMode;
    }

    public boolean isCellEditing() {
        assert (this.myEditMode != null);
        ViewMode viewMode = this.myEditMode.getEditNodeMode();
        return viewMode instanceof CellEditorMode && ((CellEditorMode)viewMode).isCellEditing();
    }

    @ApiStatus.Internal
    @NotNull
    public EventDispatcher<GraphBuilderListener> getGraphBuilderDispatcher() {
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        if (eventDispatcher == null) {
            GraphBuilderImpl.P(74);
        }
        return eventDispatcher;
    }

    @NotNull
    public GraphDataMaps<N, E> getDataMaps() {
        GraphDataMaps<N, E> graphDataMaps = this.myGraphDataMaps;
        if (graphDataMaps == null) {
            GraphBuilderImpl.P(75);
        }
        return graphDataMaps;
    }

    @NotNull
    public Collection<N> getNodeObjects() {
        Collection collection = (Collection)this.getActionExecutor().computeReadAction(() -> Collections.unmodifiableCollection(this.getDataMaps().getNodeObjectDataBiMap().values()));
        if (collection == null) {
            GraphBuilderImpl.P(76);
        }
        return collection;
    }

    @NotNull
    public Collection<E> getEdgeObjects() {
        Collection collection = (Collection)this.getActionExecutor().computeReadAction(() -> Collections.unmodifiableCollection(this.getDataMaps().getEdgeObjectDataBiMap().values()));
        if (collection == null) {
            GraphBuilderImpl.P(77);
        }
        return collection;
    }

    @NotNull
    public Collection<NodeGroupDescriptor> getGroupNodeObjects() {
        Collection collection = (Collection)this.getActionExecutor().computeReadAction(() -> Collections.unmodifiableCollection(this.getDataMaps().getGroupNodeDataMap().values()));
        if (collection == null) {
            GraphBuilderImpl.P(78);
        }
        return collection;
    }

    @NotNull
    public Collection<CollapsedEdge> getCollapsedEdgeObjects() {
        Collection collection = (Collection)this.getActionExecutor().computeReadAction(() -> Collections.unmodifiableCollection(this.getDataMaps().getCollapsedEdgeDataMap().values()));
        if (collection == null) {
            GraphBuilderImpl.P(79);
        }
        return collection;
    }

    public boolean removeNode(@Nullable N n2) {
        this.getActionExecutor().assertGraphThread();
        Node node = this.getNode(n2);
        if (node != null) {
            node.getGraph().removeNode(node);
            this.getDataMaps().removeNode(node);
            return true;
        }
        return false;
    }

    public boolean removeEdge(@Nullable E e2) {
        this.getActionExecutor().assertGraphThread();
        Edge edge = this.getEdge(e2);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphBuilderListener(@NotNull GraphBuilderListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            GraphBuilderImpl.P(80);
        }
        if (parent == null) {
            GraphBuilderImpl.P(81);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        synchronized (eventDispatcher) {
            this.myGraphBuilderDispatcher.addListener((EventListener)listener, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphBuilderListener(@NotNull GraphBuilderListener listener) {
        if (listener == null) {
            GraphBuilderImpl.P(82);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        synchronized (eventDispatcher) {
            this.myGraphBuilderDispatcher.removeListener((EventListener)listener);
        }
    }

    private static void P(@NotNull Graph2DView graph2DView) {
        if (graph2DView == null) {
            GraphBuilderImpl.P(83);
        }
        Graph2DViewActions graph2DViewActions = GraphManager.getGraphManager().createGraph2DViewActions(graph2DView);
        graph2DViewActions.install(graph2DView, 1);
    }

    private static void M(@NotNull Graph2DView graph2DView) {
        if (graph2DView == null) {
            GraphBuilderImpl.P(84);
        }
        graph2DView.setAntialiasedPainting(Registry.is((String)"diagrams.rendering.antialiasing"));
        graph2DView.setFitContentOnResize(true);
        graph2DView.setBackgroundRenderer((BackgroundRenderer)GraphManager.getGraphManager().createDefaultBackgroundRenderer(graph2DView));
        graph2DView.setGridVisible(false);
        graph2DView.setGridResolution(20.0);
        graph2DView.setGridColor((Color)Gray._239);
        graph2DView.setGridType(View2DConstants.GRID_NONE);
    }

    private /* synthetic */ Unit P(boolean bl, GraphBuilder.ZoomChangedEvent zoomChangedEvent) {
        if (bl) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
            zoomChangedEvent.execute();
        }
        return Unit.INSTANCE;
    }

    private /* synthetic */ Unit P(boolean bl) {
        if (bl) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        }
        return Unit.INSTANCE;
    }

    private static /* synthetic */ GroupNodeRealizer P(NodeGroupDescriptor nodeGroupDescriptor) {
        return GraphGroupingUtil.createDefaultGroupNodeRealizer(nodeGroupDescriptor.getGroupName(), EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground(), null, nodeGroupDescriptor.isClosed());
    }

    private /* synthetic */ List M() throws Throwable {
        return GraphImplUtil.getEdges((Graph)this.getGraph());
    }

    private /* synthetic */ List P() throws Throwable {
        return GraphImplUtil.getNodes((Graph)this.getGraph());
    }

    static {
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void P(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6, 8, 11, 14, 15, 22, 32, 33, 40, 42, 43, 45, 55, 56, 60, 61, 62, 63, 64, 66, 68, 71, 72, 74, 75, 76, 77, 78, 79 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: 
            case 18: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphPresentationModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadingType";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 22: 
            case 32: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 9: 
            case 10: 
            case 20: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForSizeUpdate";
                break;
            }
            case 12: 
            case 13: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNodes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEdges";
                break;
            }
            case 23: 
            case 25: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNodeRealizer";
                break;
            }
            case 26: 
            case 28: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEdgeRealizer";
                break;
            }
            case 46: 
            case 47: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyManager";
                break;
            }
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeMode";
                break;
            }
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionExecutor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultEditMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "updateGraphAsync";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "runGraphUpdateAsync";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "updateViewAsync";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewNodeRealizer";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "doLayoutAsync";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "doQueueUpdate";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphDataModel";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNode";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphUpdateModel";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphPresentationModel";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyManager";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoManager";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditMode";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveMode";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilderDispatcher";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataMaps";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeObjects";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjects";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupNodeObjects";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapsedEdgeObjects";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 22: 
            case 32: 
            case 33: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupViewControllers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateGraph";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateGraphAsync";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runGraphUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runGraphUpdateAsync";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedNodes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedEdges";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateView";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateViewAsync";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setNodeRealizer";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRealizer";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeRealizer";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeRealizer";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateRealizers";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeRealizer";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createNewNodeRealizer";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setRenderedNodeSizes";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateEdgeRealizer";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeLabels";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateEdgeLabels";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "doQueueUpdate";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getInnerGraph";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeAllGraphDataProviders";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "removeAllGraphListeners";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "removeAllGraphSelectionListeners";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "setHierarchyManager";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addCustomUpdater";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomUpdater";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setActiveMode";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addGraphBuilderListener";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "removeGraphBuilderListener";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "setupDefaultKeyBindingsForYFilesPredefinedActions";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultViewSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 11, 14, 15, 22, 32, 33, 40, 42, 43, 45, 55, 56, 60, 61, 62, 63, 64, 66, 68, 71, 72, 74, 75, 76, 77, 78, 79 -> new IllegalStateException(string);
        };
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class GraphUpdateQueryParamsImpl
    implements GraphBuilder.GraphUpdateQueryParams<N, E> {
        @NotNull
        private final List<N> myNodesForSizeUpdate = new ArrayList();
        private boolean myDoReloadData = false;
        @Nullable
        private Layouter myLayouter;
        private boolean mySealed = false;

        private GraphUpdateQueryParamsImpl() {
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withDataReload() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoReloadData = true;
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.P(0);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withRelayout() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = GraphBuilderImpl.this.getGraphPresentationModel().getSettings().getCurrentLayouter();
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.P(1);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withRelayout(@NotNull Layouter layouter) {
            if (layouter == null) {
                GraphUpdateQueryParamsImpl.P(2);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = layouter;
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.P(3);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withAllNodeSizeUpdate() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, GraphBuilderImpl.this.getNodeObjects());
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.P(4);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withNodeSizeUpdate(N ... nodes) {
            if (nodes == null) {
                GraphUpdateQueryParamsImpl.P(5);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Object[])nodes);
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.P(6);
            }
            return graphUpdateQueryParamsImpl;
        }

        private boolean P() {
            return this.myDoReloadData;
        }

        @NotNull
        private List<N> P() {
            List list = this.myNodesForSizeUpdate;
            if (list == null) {
                GraphUpdateQueryParamsImpl.P(7);
            }
            return list;
        }

        @Nullable
        private Layouter P() {
            return this.myLayouter;
        }

        public void run() {
            this.mySealed = true;
            GraphBuilderImpl.this.runGraphUpdate(this);
        }

        @NotNull
        public CompletableFuture<Void> runAsync() {
            this.mySealed = true;
            CompletionStage completionStage = GraphBuilderImpl.this.runGraphUpdateAsync(this).whenComplete(Futures.logIfFailed(GraphBuilderImpl.class));
            if (completionStage == null) {
                GraphUpdateQueryParamsImpl.P(8);
            }
            return completionStage;
        }

        private static /* synthetic */ void P(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 2;
                case 2, 5 -> 3;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl$GraphUpdateQueryParamsImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layouter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataReload";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelayout";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl$GraphUpdateQueryParamsImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllNodeSizeUpdate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodeSizeUpdate";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodesForSizeUpdate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runAsync";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelayout";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withNodeSizeUpdate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalStateException(string);
                case 2, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

