/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.navigation;

import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.lsp.impl.navigation.LspNavigatableSymbolKt;
import com.intellij.platform.lsp.impl.navigation.LspNavigationTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000f\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/lsp/impl/navigation/LspNavigatableSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "targetFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetSelectionRange", "Lorg/eclipse/lsp4j/Range;", "LspNavigatableSymbol", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/eclipse/lsp4j/Range;)V", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentationHint", "", "Lcom/intellij/openapi/util/NlsContexts$HintText;", "getNavigationTargets", "", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lsp.impl"})
public final class LspNavigatableSymbol
implements NavigatableSymbol,
DocumentationTarget {
    @NotNull
    private final VirtualFile targetFileOrDir;
    @Nullable
    private final Range targetSelectionRange;

    public LspNavigatableSymbol(@NotNull VirtualFile targetFileOrDir, @Nullable Range targetSelectionRange) {
        Intrinsics.checkNotNullParameter((Object)targetFileOrDir, (String)"targetFileOrDir");
        this.targetFileOrDir = targetFileOrDir;
        this.targetSelectionRange = targetSelectionRange;
    }

    @NotNull
    public Pointer<LspNavigatableSymbol> createPointer() {
        return () -> LspNavigatableSymbol.P(this);
    }

    @NotNull
    public TargetPresentation computePresentation() {
        return LspNavigatableSymbolKt.access$computeTargetPresentation(this.targetFileOrDir, this.targetSelectionRange);
    }

    @Nullable
    public String computeDocumentationHint() {
        return this.targetFileOrDir.getPath();
    }

    @NotNull
    public List<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)new LspNavigationTarget(project, this.targetFileOrDir, this.targetSelectionRange));
    }

    private static final LspNavigatableSymbol P(LspNavigatableSymbol lspNavigatableSymbol) {
        return lspNavigatableSymbol.targetFileOrDir.isValid() ? new LspNavigatableSymbol(lspNavigatableSymbol.targetFileOrDir, lspNavigatableSymbol.targetSelectionRange) : null;
    }
}

