/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;

public final class JSOptimizeImportUtil {
    private static final Comparator<String> SUPPRESS_COMMENTS_COMPARATOR = (o1, o2) -> {
        if (JSOptimizeImportUtil.hasSuppressInComment(o1)) {
            return 1;
        }
        if (JSOptimizeImportUtil.hasSuppressInComment(o2)) {
            return -1;
        }
        return 0;
    };
    private static final Set<JavaResourceRootType> RESOURCE_ROOT_TYPES = Set.of(JavaResourceRootType.TEST_RESOURCE);

    private static boolean hasSuppressInComment(@Nullable String text) {
        if (text == null) {
            return false;
        }
        Matcher matcherLeft = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text);
        return matcherLeft.matches();
    }

    public static void addSameLineComments(@Nullable Document document, @NotNull PsiElement context2, @NotNull StringBuilder importBody) {
        if (context2 == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(0);
        }
        if (importBody == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(1);
        }
        JSOptimizeImportUtil.addSameLineComments(importBody, JSOptimizeImportUtil.getPsiElementsAsStrings(ContainerUtil.createMaybeSingletonList((Object)JSOptimizeImportUtil.getLineComment(document, context2))));
    }

    public static void addSameLineComments(@NotNull StringBuilder importBody, @NotNull Collection<String> sameLineComments) {
        if (importBody == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(2);
        }
        if (sameLineComments == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(3);
        }
        if (!sameLineComments.isEmpty()) {
            importBody.append(" ");
            importBody.append(StringUtil.join(sameLineComments, (String)" "));
        }
    }

    public static void fillImportsWithNewLines(@NotNull List<? super String> importsResult, @NotNull PsiElement contextForWhitespace, @NotNull List<String> elements) {
        if (importsResult == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(4);
        }
        if (contextForWhitespace == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(6);
        }
        if (elements.isEmpty()) {
            return;
        }
        if (!importsResult.isEmpty()) {
            List<PsiElement> whitespaces = JSOptimizeImportUtil.getWhitespacesBeforePrevImport(contextForWhitespace);
            if (!whitespaces.isEmpty()) {
                importsResult.addAll(JSOptimizeImportUtil.getPsiElementsAsStrings(whitespaces));
            } else {
                importsResult.add("\n");
            }
        }
        for (int i = 0; i < elements.size(); ++i) {
            String current = elements.get(i);
            if (i > 0) {
                importsResult.add("\n");
            }
            importsResult.add(current);
        }
    }

    public static boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(7);
        }
        Project project = file.getProject();
        if (!file.isValid() || DumbService.getInstance((Project)project).isDumb()) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return !ProjectFileIndex.getInstance((Project)project).isUnderSourceRootOfType(virtualFile, RESOURCE_ROOT_TYPES);
    }

    public static void deleteSiblingWhitespaceBetweenImports(PsiElement beforeElement, PsiElement after, boolean deleteBefore) {
        PsiElement sibling;
        if (deleteBefore) {
            sibling = beforeElement;
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                PsiElement prev = sibling.getPrevSibling();
                if (!JSOptimizeImportUtil.prevIsAcceptable(prev)) continue;
                sibling.delete();
            }
        }
        sibling = after;
        while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
            PsiElement nextSibling = sibling.getNextSibling();
            if (!JSOptimizeImportUtil.nextIsAcceptable(nextSibling)) continue;
            sibling.delete();
        }
    }

    public static boolean prevIsAcceptable(PsiElement prev) {
        return prev == null || JSOptimizeImportUtil.isImport(prev) || prev instanceof PsiWhiteSpace || prev instanceof PsiComment;
    }

    public static boolean isImport(@Nullable PsiElement prev) {
        return prev instanceof ES6ImportDeclaration || prev instanceof TypeScriptImportStatement || prev instanceof JSImportStatement;
    }

    @NotNull
    public static List<String> getPrevCommentsAsStrings(@NotNull List<? extends PsiElement> toProcess) {
        if (toProcess == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(8);
        }
        if (toProcess.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSOptimizeImportUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = toProcess.stream().map(process2 -> {
            String indent = JSOptimizeImportUtil.getCommentIndent(process2);
            return indent + process2.getText();
        }).sorted(SUPPRESS_COMMENTS_COMPARATOR).collect(Collectors.toList());
        if (list == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static String getCommentIndent(@NotNull PsiElement process2) {
        PsiElement sibling;
        if (process2 == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(11);
        }
        if ((sibling = process2.getPrevSibling()) instanceof PsiWhiteSpace) {
            String prevWhitespace = sibling.getText();
            int newLine = prevWhitespace.lastIndexOf("\n");
            if (newLine >= 0) {
                if (newLine + 1 < prevWhitespace.length()) {
                    String string = prevWhitespace.substring(newLine + 1);
                    if (string == null) {
                        JSOptimizeImportUtil.$$$reportNull$$$0(12);
                    }
                    return string;
                }
            } else {
                String string = prevWhitespace;
                if (string == null) {
                    JSOptimizeImportUtil.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        return "";
    }

    public static List<String> getPsiElementsAsStrings(@NotNull Collection<? extends PsiElement> toProcess) {
        if (toProcess == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(14);
        }
        return ContainerUtil.map(toProcess, el -> el.getText());
    }

    public static List<PsiElement> getWhitespacesBeforePrevImport(@NotNull PsiElement importDeclaration) {
        if (importDeclaration == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(15);
        }
        PsiElement sibling = importDeclaration;
        ArrayList<PsiElement> siblings = new ArrayList<PsiElement>();
        while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
            siblings.add(0, sibling);
            PsiElement prev = sibling.getPrevSibling();
            if (!JSOptimizeImportUtil.isImport(prev)) continue;
            return siblings;
        }
        return ContainerUtil.emptyList();
    }

    public static boolean nextIsAcceptable(PsiElement next) {
        return next == null || JSOptimizeImportUtil.isImport(next) || next instanceof PsiWhiteSpace;
    }

    public static boolean isSameLineElement(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement, int offsetLine) {
        if (document == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(16);
        }
        if (startElement == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(17);
        }
        if (endElement == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(18);
        }
        int startElementEndOffset = document.getLineNumber(startElement.getTextRange().getEndOffset());
        int endElementStartOffset = document.getLineNumber(endElement.getTextRange().getStartOffset());
        return endElementStartOffset == offsetLine + startElementEndOffset;
    }

    public static PsiElement getLineComment(@Nullable Document document, @NotNull PsiElement declaration) {
        if (declaration == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(19);
        }
        if (document == null) {
            return null;
        }
        PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)declaration);
        if (next instanceof PsiComment) {
            boolean isSameLineElements = JSOptimizeImportUtil.isSameLineElement(document, declaration, next, 0);
            return isSameLineElements ? next : null;
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> getPrevComments(@Nullable Document document, @NotNull PsiElement declaration) {
        PsiElement nextPrev;
        if (declaration == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(20);
        }
        if (document == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSOptimizeImportUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        PsiElement prevImportCandidate = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)declaration);
        if (JSOptimizeImportUtil.isImport(prevImportCandidate)) {
            return JSOptimizeImportUtil.getCommentsBetweenImports(document, prevImportCandidate);
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)declaration);
        if (prev == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSOptimizeImportUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (!JSOptimizeImportUtil.isSameLineElement(document, prev, declaration, 1) && !JSOptimizeImportUtil.isSameLineElement(document, prev, declaration, 0)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSOptimizeImportUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        ArrayList<PsiElement> comments = new ArrayList<PsiElement>();
        while (prev instanceof PsiComment && !JSOptimizeImportUtil.isHeaderComment(prev) && !JSOptimizeImportUtil.isLineCommentForNextStatement(document, prev, nextPrev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)prev))) {
            comments.add(0, prev);
            if (JSOptimizeImportUtil.hasMoreThanOneNewLineBetweenComments(document, prev, nextPrev)) break;
            prev = nextPrev;
        }
        ArrayList<PsiElement> arrayList = comments;
        if (arrayList == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiElement> getCommentsBetweenImports(@NotNull Document document, PsiElement prevImportCandidate) {
        if (document == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(25);
        }
        PsiElement sibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)prevImportCandidate);
        while (sibling instanceof PsiComment && JSOptimizeImportUtil.isSameLineElement(document, prevImportCandidate, sibling, 0)) {
            sibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)sibling);
        }
        if (sibling instanceof PsiComment) {
            ArrayList<PsiElement> comments = new ArrayList<PsiElement>();
            while (sibling instanceof PsiComment) {
                comments.add(sibling);
                sibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)sibling);
            }
            ArrayList<PsiElement> arrayList = comments;
            if (arrayList == null) {
                JSOptimizeImportUtil.$$$reportNull$$$0(26);
            }
            return arrayList;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static boolean isHeaderComment(@NotNull PsiElement comment) {
        PsiElement beforePrev;
        if (comment == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(28);
        }
        return (beforePrev = comment.getPrevSibling()) == null && comment.getParent() instanceof PsiFile && !JSOptimizeImportUtil.hasSuppressInComment(comment.getText());
    }

    public static boolean isLineCommentForNextStatement(@NotNull Document document, PsiElement prev, PsiElement nextPrev) {
        if (document == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(29);
        }
        return nextPrev != null && !(nextPrev instanceof PsiComment) && JSOptimizeImportUtil.isSameLineElement(document, prev, nextPrev, 0);
    }

    public static boolean hasMoreThanOneNewLineBetweenComments(@NotNull Document document, PsiElement prev, PsiElement nextPrev) {
        if (document == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(30);
        }
        return nextPrev instanceof PsiComment && !JSOptimizeImportUtil.isSameLineElement(document, nextPrev, prev, 1) && !JSOptimizeImportUtil.isSameLineElement(document, nextPrev, prev, 0);
    }

    @Nullable
    public static FormatFixer addNewImportTexts(@NotNull PsiElement firstChild, @NotNull PsiElement lastChild, @Nullable Document document, @NotNull PsiElement anchorCandidate) {
        PsiElement firstAdded;
        PsiElement anchor;
        PsiElement elementBeforeAnchor;
        if (firstChild == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(31);
        }
        if (lastChild == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(32);
        }
        if (anchorCandidate == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(33);
        }
        if ((elementBeforeAnchor = (anchor = JSOptimizeImportUtil.getAnchor(document, anchorCandidate)).getPrevSibling()) instanceof PsiWhiteSpace) {
            elementBeforeAnchor.delete();
        }
        if ((firstAdded = SharedImplUtil.addRange((PsiElement)anchor.getParent(), (PsiElement)firstChild, (PsiElement)lastChild, (ASTNode)anchor.getNode(), (Boolean)true)) != null && firstAdded.isValid()) {
            int startOffset = firstAdded.getTextRange().getStartOffset();
            int endOffset = anchor.getTextRange().getStartOffset() + 1;
            TextRange range = new TextRange(startOffset, endOffset);
            return FormatFixer.create((PsiFile)firstAdded.getContainingFile(), (TextRange)range, (FormatFixer.Mode)FormatFixer.Mode.Reformat);
        }
        return null;
    }

    private static PsiElement getAnchor(@Nullable Document document, @NotNull PsiElement context2) {
        List<PsiElement> comments;
        if (context2 == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(34);
        }
        return !(comments = JSOptimizeImportUtil.getPrevComments(document, context2)).isEmpty() ? comments.get(0) : context2;
    }

    @NotNull
    public static PsiFile createFileWithImports(@NotNull Project project, Document document, @NotNull String text, @NotNull PsiElement context2) {
        PsiElement anchor;
        PsiElement elementBeforeAnchor;
        if (project == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(35);
        }
        if (text == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(36);
        }
        if (context2 == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(37);
        }
        if (JSOptimizeImportUtil.elementRequiresNewLine(elementBeforeAnchor = (anchor = JSOptimizeImportUtil.getAnchor(document, context2)).getPrevSibling()) && !((String)text).startsWith("\n")) {
            text = "\n" + (String)text;
        } else if (elementBeforeAnchor instanceof PsiWhiteSpace) {
            text = elementBeforeAnchor.getText() + (String)text;
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)context2);
        if (dialect == null) {
            dialect = JavascriptLanguage.INSTANCE;
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (Language)dialect, (CharSequence)text, true, true);
        if (psiFile == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(38);
        }
        return psiFile;
    }

    private static boolean elementRequiresNewLine(@Nullable PsiElement siblingBeforeAnchor) {
        return !(siblingBeforeAnchor instanceof PsiWhiteSpace) && siblingBeforeAnchor != null;
    }

    public static boolean endsWithNewLine(@NotNull PsiElement element2) {
        PsiElement lastChild;
        if (element2 == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(39);
        }
        return (lastChild = element2.getLastChild()) instanceof PsiWhiteSpace && lastChild.textContains('\n');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 12, 13, 21, 22, 23, 24, 26, 27, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBody";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameLineComments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextForWhitespace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/JSOptimizeImportUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 16: 
            case 25: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastChild";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorCandidate";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/JSOptimizeImportUtil";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevCommentsAsStrings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentIndent";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevComments";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentsBetweenImports";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileWithImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSameLineComments";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillImportsWithNewLines";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPrevCommentsAsStrings";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 38: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommentIndent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementsAsStrings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWhitespacesBeforePrevImport";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSameLineElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLineComment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPrevComments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsBetweenImports";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isHeaderComment";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommentForNextStatement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasMoreThanOneNewLineBetweenComments";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addNewImportTexts";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createFileWithImports";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "endsWithNewLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 12, 13, 21, 22, 23, 24, 26, 27, 38 -> new IllegalStateException(string);
        };
    }

    public static class CommentHolder {
        public final List<PsiElement> prevComments;
        public final PsiElement lineComment;

        public CommentHolder(List<PsiElement> prevComments, PsiElement lineComment) {
            this.prevComments = prevComments;
            this.lineComment = lineComment;
        }
    }
}

