/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6RedundantNestingInTemplateLiteralInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                PsiElement parent;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ES6RedundantNestingInTemplateLiteralInspection.canInline(node, parent = node.getParent())) {
                    this.inspectLiteral(node, (JSStringTemplateExpression)parent);
                }
                super.visitJSLiteralExpression(node);
            }

            private void inspectLiteral(JSLiteralExpression argument, JSStringTemplateExpression parent) {
                Pair<TextRange, TextRange> ranges = ES6RedundantNestingInTemplateLiteralInspection.getRangesInParent(argument);
                if (ranges == null) {
                    return;
                }
                this.report(parent, argument, (TextRange)ranges.first);
                this.report(parent, argument, (TextRange)ranges.second);
            }

            private void report(JSStringTemplateExpression parent, JSLiteralExpression argument, TextRange range) {
                holder.registerProblem((PsiElement)parent, JavaScriptBundle.message((String)"js.nested.template.literal.inspection", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{new InlineNestedTemplateFix(argument)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/ES6RedundantNestingInTemplateLiteralInspection$1", "visitJSLiteralExpression"));
            }
        };
    }

    public static boolean canInline(@NotNull JSLiteralExpression literalExpression, @Nullable PsiElement parent) {
        if (literalExpression == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(2);
        }
        return parent instanceof JSStringTemplateExpression && (literalExpression instanceof JSStringTemplateExpression || literalExpression.isStringLiteral()) && !(parent.getParent() instanceof ES6TaggedTemplateExpression);
    }

    @Nullable
    private static Pair<TextRange, TextRange> getRangesInParent(@NotNull JSLiteralExpression argument) {
        PsiElement backward1;
        if (argument == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(3);
        }
        if ((backward1 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)argument)) == null) {
            return null;
        }
        PsiElement backward2 = backward1.getPrevSibling();
        if (backward2 == null) {
            return null;
        }
        PsiElement forward = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)argument);
        if (forward == null) {
            return null;
        }
        return Pair.create((Object)new TextRange(backward2.getStartOffsetInParent(), argument.getStartOffsetInParent() + 1), (Object)new TextRange(argument.getTextRangeInParent().getEndOffset() - 1, forward.getTextRangeInParent().getEndOffset()));
    }

    @Nullable
    public static JSExpression inlineArgument(@NotNull JSLiteralExpression literal, @NotNull JSStringTemplateExpression templateParent) {
        Pair<TextRange, TextRange> ranges;
        if (literal == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(4);
        }
        if (templateParent == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(5);
        }
        if ((ranges = ES6RedundantNestingInTemplateLiteralInspection.getRangesInParent(literal)) == null) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        String templateText = templateParent.getText();
        builder2.append(templateText, 0, ((TextRange)ranges.first).getStartOffset());
        builder2.append(ES6RedundantNestingInTemplateLiteralInspection.getLiteralTextWithoutQuotes(literal));
        builder2.append(templateText.substring(((TextRange)ranges.second).getEndOffset()));
        return templateParent.replace(JSPsiElementFactory.createJSExpression((String)builder2.toString(), (PsiElement)literal));
    }

    @NotNull
    private static String getLiteralTextWithoutQuotes(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(6);
        }
        String text = literal.getText();
        if (literal instanceof JSStringTemplateExpression && text.length() > 1) {
            int end = text.indexOf(96, 1);
            String string = end > 0 ? text.substring(1, end) : text.substring(1);
            if (string == null) {
                ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = JSStringUtil.unquoteStringLiteralValue((String)text);
        if (string == null) {
            ES6RedundantNestingInTemplateLiteralInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateParent";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6RedundantNestingInTemplateLiteralInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6RedundantNestingInTemplateLiteralInspection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralTextWithoutQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canInline";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRangesInParent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inlineArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralTextWithoutQuotes";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class InlineNestedTemplateFix
    extends LocalQuickFixOnPsiElement {
        protected InlineNestedTemplateFix(@NotNull JSLiteralExpression element2) {
            if (element2 == null) {
                InlineNestedTemplateFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element2);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.nested.template.literal.fix", (Object[])new Object[0]);
            if (string == null) {
                InlineNestedTemplateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message((String)"js.nested.template.literal.fix", (Object[])new Object[0]);
            if (string == null) {
                InlineNestedTemplateFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            JSLiteralExpression literal;
            if (project == null) {
                InlineNestedTemplateFix.$$$reportNull$$$0(3);
            }
            if (psiFile == null) {
                InlineNestedTemplateFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                InlineNestedTemplateFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                InlineNestedTemplateFix.$$$reportNull$$$0(6);
            }
            if ((literal = (JSLiteralExpression)ObjectUtils.tryCast((Object)startElement, JSLiteralExpression.class)) == null) {
                return;
            }
            JSStringTemplateExpression templateParent = (JSStringTemplateExpression)ObjectUtils.tryCast((Object)literal.getParent(), JSStringTemplateExpression.class);
            if (templateParent == null) {
                return;
            }
            ES6RedundantNestingInTemplateLiteralInspection.inlineArgument(literal, templateParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6RedundantNestingInTemplateLiteralInspection$InlineNestedTemplateFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6RedundantNestingInTemplateLiteralInspection$InlineNestedTemplateFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

